% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-pipeline-registry.R
\name{module_registry}
\alias{module_registry}
\alias{module_registry2}
\alias{get_modules_registries}
\alias{add_module_registry}
\title{'RAVE' module registry}
\usage{
module_registry(
  title,
  repo,
  modules,
  authors,
  url = sprintf("https://github.com/\%s", repo)
)

module_registry2(repo, description)

get_modules_registries(update = NA)

add_module_registry(title, repo, modules, authors, url, dry_run = FALSE)
}
\arguments{
\item{title}{title of the registry, usually identical to the description
title in \code{'DESCRIPTION'} or \code{RAVE-CONFIG} file}

\item{repo}{'Github' repository}

\item{modules}{characters of module ID, must only contain letters, digits,
underscore, dash; must not be duplicated with existing registered modules}

\item{authors}{a list of module authors; there must be one and only one
author with \code{'cre'} role (see \code{\link[utils]{person}}). This
author will be considered maintainer, who will be in charge if editing the
registry}

\item{url}{the web address of the repository}

\item{description}{path to \code{'DESCRIPTION'} or \code{RAVE-CONFIG} file}

\item{update}{whether to force updating the registry}

\item{dry_run}{whether to generate and preview message content instead of
opening an email link}
}
\value{
a registry object, or a list of registries
}
\description{
Create, view, or reserve the module registry
}
\details{
A 'RAVE' registry contains the following data entries: repository
title, name, 'URL', authors, and a list of module IDs. 'RAVE' requires
that each module must use a unique module ID. It will cause an issue if two
modules share the same ID. Therefore 'RAVE' maintains a public registry
list such that the module maintainers can register their own module ID
and prevent other people from using it.

To register your own module ID, please use \code{add_module_registry} to
validate and send an email to the 'RAVE' development team.
}
\examples{

library(raveio)

# get current registries
get_modules_registries(FALSE)

# create your own registry
module_registry(
  repo = "rave-ieeg/rave-pipelines",
  title = "A Collection of 'RAVE' Builtin Pipelines",
  authors = list(
    list("Zhengjia", "Wang", role = c("cre", "aut"),
         email = "dipterix@rave.wiki")
  ),
  modules = "brain_viewer"
)

# If your repository is on Github and RAVE-CONFIG file exists
module_registry2("rave-ieeg/rave-pipelines")

# send a request to add your registry
if(interactive()) {

reg <- module_registry2("rave-ieeg/rave-pipelines")
add_module_registry(reg)

}


}
