% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{safe_read_csv}
\alias{safe_read_csv}
\title{Read comma separated value files with given column classes}
\usage{
safe_read_csv(
  file,
  header = TRUE,
  sep = ",",
  colClasses = NA,
  skip = 0,
  quote = "\\"",
  ...,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{file, header, sep, colClasses, skip, quote, stringsAsFactors, ...}{passed to \code{read.csv}}
}
\value{
A data frame
}
\description{
Read comma separated value files with given column classes
}
\details{
Reading a comma separated value file using builtin function
\code{read.csv} might result in some unexpected
behavior. \code{safe_read_csv} does some preprocessing on the
format so that it take cares of the following cases.

1. If \code{skip} exceeds the maximum rows of the data, return
a blank data frame instead of raising error.

2. If row names are included in the file, \code{colClasses}
automatically skip that column and starts from the second column

3. If length of \code{colClasses} does not equal to the number of
columns, instead of cycling the class types, we set those columns
to be \code{NA} type and let \code{read.csv} decide
the default types.

4. \code{stringsAsFactors} is by default \code{FALSE} to be
consistent with R 4.0, if the function is called in R 3.x.
}
\examples{

f <- tempfile()
x <- data.frame(a = letters[1:10], b = 1:10, c = 2:11)

# ------------------ Auto-detect row names ------------------
# Write with rownames
utils::write.csv(x, f, row.names = LETTERS[2:11])

# read csv with base library utils
table1 <- utils::read.csv(f, colClasses = c('character', 'character'))

# 4 columns including row names
str(table1)

# read csv via safe_read_csv
table2 <- safe_read_csv(f, colClasses = c('character', 'character'))

# row names are automatically detected, hence 3 columns
# Only first columns are characters, the third column is auto
# detected as numeric
str(table2)

# read table without row names
utils::write.csv(x, f, row.names = FALSE)
table2 <- safe_read_csv(f, colClasses = c('character', 'character'))

# still 3 columns, and row names are 1:nrow
str(table2)

# --------------- Blank data frame when nrow too large ---------------
# instead of raising errors, return blank data frame
safe_read_csv(f, skip = 1000)


}
