% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-3dAlineate.R, R/cmd-aaa.R,
%   R/cmd-dcm2niix.R, R/cmd-flirt.R, R/cmd-recon-all.R
\name{cmd_run_3dAllineate}
\alias{cmd_run_3dAllineate}
\alias{cmd-external}
\alias{cmd_execute}
\alias{cmd_run_dcm2niix}
\alias{cmd_run_flirt}
\alias{cmd_run_recon_all}
\title{External shell commands for 'RAVE'}
\usage{
cmd_run_3dAllineate(
  subject,
  mri_path,
  ct_path,
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)

cmd_execute(
  script,
  script_path,
  command = "bash",
  dry_run = FALSE,
  backup = TRUE,
  ...
)

cmd_run_dcm2niix(
  subject,
  src_path,
  type = c("MRI", "CT"),
  merge = c("Auto", "No", "Yes"),
  float = c("Yes", "No"),
  crop = c("No", "Yes", "Ignore"),
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)

cmd_run_flirt(
  subject,
  mri_path,
  ct_path,
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)

cmd_run_recon_all(
  subject,
  mri_path,
  args = c("-all", "-autorecon1", "-autorecon2", "-autorecon3", "-autorecon2-cp",
    "-autorecon2-wm", "-autorecon2-pial"),
  work_path = NULL,
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)
}
\arguments{
\item{subject}{characters or a \code{\link{RAVESubject}} instance}

\item{mri_path}{the absolute to 'MRI' volume; must in 'Nifti' format}

\item{ct_path}{the absolute to 'CT' volume; must in 'Nifti' format}

\item{overwrite}{whether to overwrite existing files; default is false}

\item{command_path}{command line path if 'RAVE' cannot find the command
binary files}

\item{dry_run}{whether to run in dry-run mode; under such mode, the shell
command will not execute. This is useful for debugging scripts; default is
false}

\item{verbose}{whether to print out the command script; default is true under
dry-run mode, and false otherwise}

\item{script}{the shell script}

\item{script_path}{path to run the script}

\item{command}{which command to invoke; default is \code{'bash'}}

\item{backup}{whether to back up the script file immediately; default is true}

\item{...}{passed to \code{\link{system2}}}

\item{src_path}{source of the 'DICOM' or 'Nifti' image (absolute path)}

\item{type}{type of the 'DICOM' or 'Nifti' image; choices are \code{'MRI'}
and \code{'CT'}}

\item{merge, float, crop}{\code{'dcm2niix'} conversion arguments; ignored when
the source is in 'Nifti' format}

\item{args}{further arguments in the shell command, especially the
'FreeSurfer' reconstruction command}

\item{work_path}{work path for 'FreeSurfer' command;}
}
\value{
A list of data containing the script details:
\describe{
\item{\code{script}}{script details}
\item{\code{script_path}}{where the script should/will be saved}
\item{\code{dry_run}}{whether dry-run mode is turned on}
\item{\code{log_file}}{path to the log file}
\item{\code{execute}}{a function to execute the script}
}
}
\description{
These shell commands are for importing 'DICOM' images to
'Nifti' format, reconstructing cortical surfaces, and align' the CT' to
'MRI'. The commands are only tested on 'MacOS' and 'Linux'. On 'Windows'
machines, please use the 'WSL2' system.
}
