% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-cat-functions.R
\name{abs_read_tss}
\alias{abs_read_tss}
\title{Read ABS time series data file(s)}
\usage{
abs_read_tss(files, type = "tss")
}
\arguments{
\item{files}{Names of one or more ABS data files}

\item{type}{One of either 'tss'  -- ABS Time Series  Spreadsheet (the Default) or  'css' -- Data
Cube.R}
}
\value{
data frame in long format
}
\description{
This function extracts time series data from ABS data files.
}
\examples{
  \donttest{
    ## Read specified ABS Excel time series files
    tables <- abs_cat_tables("5206.0", releases="Latest", include_urls=TRUE);
    downloaded_tables <- abs_cat_download(tables$path_2[1], exdir=tempdir())
    extracted_files <- abs_cat_unzip(downloaded_tables)
    x <- abs_read_tss(extracted_files);
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
