% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_rasterly.R
\name{plotly.rasterly}
\alias{plotly.rasterly}
\title{`rasterly` to `plotly`}
\usage{
plotly.rasterly(rastObj, as_heatmap = FALSE, scaling = NULL,
  sizing = c("stretch", "fill", "contain"), ...)
}
\arguments{
\item{rastObj}{A rasterly object}

\item{as_heatmap}{Draw `plotly` by adding heatmap layer. See \code{add_rasterly_heatmap}}

\item{scaling}{It could be an artificial function or a scaling way ("log", "origin")}

\item{sizing}{Specifies which dimension of the image to constrain. One of "stretch" "fill", "contain"}

\item{...}{Arguments to the layout object. For documentation, 
see https://plot.ly/r/reference/#Layout_and_layout_style_objects}
}
\description{
Display raster image via `plotly`
}
\examples{
\dontrun{
   library(rasterly)
   if(requireNamespace("plotly") && 
      requireNamespace("data.table") && 
      requireNamespace("lubridate")) {
     # Load data
     ridesRaw_1 <- "https://raw.githubusercontent.com/plotly/datasets/
     master/uber-rides-data1.csv" \%>\%
       data.table::fread(stringsAsFactors = FALSE)
     ridesRaw_2 <- "https://raw.githubusercontent.com/plotly/datasets/
     master/uber-rides-data2.csv" \%>\% 
       data.table::fread(stringsAsFactors = FALSE)
     ridesRaw_3 <- "https://raw.githubusercontent.com/plotly/datasets/
     master/uber-rides-data3.csv"  \%>\% 
       data.table::fread(stringsAsFactors = FALSE)
     ridesDf <- list(ridesRaw_1, ridesRaw_2, ridesRaw_3) \%>\% 
       data.table::rbindlist()
       
     time <- ymd_hms(ridesDf$`Date/Time`)
     ridesDf <-  
     ridesDf[, 'Date/Time':=NULL][, list(Lat, 
                Lon,                                               
                hour = hour(time),                                                
                month = month(time),
                day = day(time))]
     
     max_x <- max(ridesDf$Lat)
     min_x <- min(ridesDf$Lat)
     max_y <- max(ridesDf$Lon)
     min_y <- min(ridesDf$Lon)
     ridesDf \%>\% 
       rasterly(background = "black") \%>\%
       rasterize_points(xlim = c(min_x, (min_x+max_x)/2), 
                        ylim = c(min_y, max_y),
                        mapping = aes(x = Lat, y = Lon),
                        color_map = fire_map) \%>\% 
       rasterize_points(xlim = c((min_x+max_x)/2, max_x), 
         ylim = c(min_y, max_y),
         mapping = aes(x = Lat, y = Lon, color = hour),
         color_key = hourColours) \%>\% 
    rasterize_build() \%>\%
    plotly.rasterly(title = "New York Uber Rides")
   }
}
}
