% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_metadata.R
\name{aqs_metadata}
\alias{aqs_metadata}
\alias{metadata_isavailable}
\alias{metadata_revisionhistory}
\alias{metadata_fieldsbyservice}
\alias{metadata_issues}
\title{AQS API Meta Data service}
\usage{
aqs_metadata(
  aqs_filter = c("isAvailable", "revisionHistory", "fieldsByService", "issues"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

metadata_isavailable(...)

metadata_revisionhistory(
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

metadata_fieldsbyservice(
  service,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

metadata_issues(
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{service}{A string specifying one of the services available (e.g.,
sampleData)}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch information about the AQS API. The main
purpose of this service is to let you know the system is up before you run a
long job.
}
\details{
\link{aqs_metadata} sends a request to the AQS API based on a user-provided
filter using the following underlying functions:
\itemize{
\item \link{metadata_isavailable} checks if the API is up and running.
\item \link{metadata_revisionhistory} returns a complete list of revisions to the API
in reverse chronological order.
\item \link{metadata_fieldsbyservice} returns a list and definitions of fields in a
user-provided service.
\item \link{metadata_issues} returns a list of any known issues with system
functionality or the data.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

aqs_metadata(aqs_filter = "isAvailable")
metadata_isavailable() # equivalent to above

aqs_metadata("revisionHistory")
metadata_revisionhistory()

aqs_metadata("fieldsByService", aqs_variables = list(service = "annualData"))
metadata_fieldsbyservice(service = "annualData")

aqs_metadata("issues")
metadata_issues()
}

}
