/** 
 * @file  primes.h
 * @brief halves of differences between prime numbers
 *
 * @author Petr Savicky 
 *
 *
 * Copyright (C) 2009, Petr Savicky, Academy of Sciences of the Czech Republic. 
 * All rights reserved.
 *
 * The new BSD License is applied to this software.
 * Copyright (c) 2009 Petr Savicky, Academy of Sciences of the Czech Republic. 
 * All rights reserved.
 *
 *      Redistribution and use in source and binary forms, with or without
 *      modification, are permitted provided that the following conditions are
 *      met:
 *      
 *          - Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *          - Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *          - Neither the name of the Academy of Sciences of the Czech Republic
 *          nor the names of its contributors may be used to endorse or promote 
 *          products derived from this software without specific prior written
 *          permission.
 *     
 *      THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *      "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *      LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *      A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *      OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *      SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *      LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *      DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *      THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *      (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *      OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 */
/*****************************************************************************
 *  halves of differences between prime numbers
 *    
 *      header file
 *
 */
 
// The first 100 000 prime numbers.
// Starting from 5, the source code contains only the half-difference from the previous prime.
// The original primes are reconstructed when the package is loaded by the code at the end of
// this file.

static int primeNumber[100000] = {
2,3,1,1,2,1,2,1,2,3,1,3,2,1,2,3,3,1,3,2,1,3,2,3,4,2,1,2,1,2,7,2,3,1,5,1,3,3,2,3,3,1,5,1,2,1,6,6,2,1,
2,3,1,5,3,3,3,1,3,2,1,5,7,2,1,2,7,3,5,1,2,3,4,3,3,2,3,4,2,4,5,1,5,1,3,2,3,4,2,1,2,6,4,2,4,2,3,6,1,9,
3,5,3,3,1,3,5,3,3,1,3,3,2,1,6,5,1,2,3,3,1,6,2,3,4,5,4,5,4,3,3,2,4,3,2,4,2,7,5,6,1,5,1,2,1,5,7,2,1,2,
7,2,1,2,10,2,4,5,4,2,3,3,7,2,3,3,4,3,6,2,3,1,5,1,3,5,1,5,1,3,9,2,1,2,3,3,4,3,3,11,1,5,4,5,3,3,4,6,2,
3,3,1,3,6,5,9,1,2,3,1,3,2,1,2,6,1,3,17,3,3,4,9,5,7,2,1,2,3,4,2,1,3,6,5,1,2,1,2,3,6,6,4,6,3,2,3,4,2,
4,2,7,2,3,1,2,3,1,3,5,10,3,2,1,12,2,1,5,6,1,5,4,3,3,3,9,3,2,1,6,5,6,4,8,7,3,2,1,2,1,5,6,3,3,9,1,8,1,
11,3,4,3,2,1,2,4,3,5,1,5,7,5,3,6,1,2,1,5,6,1,8,1,3,2,1,5,4,9,12,2,3,4,8,1,2,4,8,1,2,4,3,3,2,6,1,11,
3,1,3,2,3,7,3,2,1,3,2,3,6,3,3,7,2,3,6,4,3,2,13,9,5,4,2,3,1,3,11,6,1,8,4,2,6,7,5,1,2,4,3,3,2,1,2,3,4,
2,1,3,5,1,5,4,2,7,5,6,1,3,2,1,8,7,2,3,4,3,2,9,4,5,3,3,4,5,6,7,2,3,3,1,14,1,5,4,2,7,2,4,6,3,6,2,3,10,
5,1,8,13,2,1,6,3,2,6,3,4,2,4,11,1,2,1,6,14,1,3,3,3,2,3,1,6,2,6,1,5,1,8,1,8,3,10,8,4,2,1,2,1,11,4,6,
3,5,1,2,3,1,3,5,1,6,5,1,5,7,3,2,3,4,3,3,8,6,1,2,7,3,2,4,5,4,3,3,11,3,1,5,7,2,3,9,1,5,7,2,1,5,7,2,4,
9,2,3,1,2,3,1,6,2,10,11,6,1,2,3,3,1,3,11,1,3,8,3,6,1,3,6,8,1,2,3,7,2,1,9,12,5,3,1,5,1,5,1,5,3,1,5,1,
5,3,4,15,5,1,5,4,3,5,9,3,6,6,1,9,3,2,3,3,9,1,5,7,3,2,1,2,12,1,6,3,8,4,3,3,9,8,1,2,3,1,3,3,5,3,6,6,9,
1,3,2,9,4,12,2,1,2,3,1,6,2,7,15,5,3,6,7,3,5,6,1,2,3,4,3,5,1,2,7,3,3,2,3,1,5,1,8,6,4,9,2,3,6,1,3,3,3,
14,3,7,2,4,5,4,6,9,2,1,2,12,6,3,1,8,3,3,7,5,7,2,15,3,3,3,4,3,2,1,6,3,2,1,3,11,3,1,2,9,1,2,6,1,3,2,
13,3,3,2,4,5,16,8,1,3,2,1,2,1,5,7,3,2,4,5,3,10,2,1,3,15,2,4,5,3,3,4,3,6,2,3,1,3,2,3,1,5,1,8,3,10,2,
6,7,14,3,10,2,9,4,3,2,3,7,3,3,5,1,5,6,4,5,1,5,4,6,5,12,1,2,4,3,2,4,9,5,3,3,1,3,5,6,1,5,3,3,3,4,3,5,
3,1,3,3,3,5,4,12,3,11,1,9,2,4,5,15,4,9,2,1,5,3,1,3,2,9,4,6,9,8,3,1,6,3,5,1,5,1,3,5,7,2,12,1,8,1,5,1,
5,10,2,1,2,4,8,3,3,1,6,8,4,2,3,15,1,5,1,3,2,3,3,4,3,2,6,3,4,6,2,7,6,5,12,3,6,3,1,11,4,9,5,3,7,2,1,3,
5,4,3,2,3,15,7,5,1,6,5,1,8,1,9,12,9,3,8,9,3,1,9,2,3,1,5,4,5,3,3,4,2,3,1,5,1,6,2,3,3,1,6,2,7,9,2,3,
10,2,4,3,2,4,2,7,3,2,7,6,2,1,15,2,12,3,3,6,6,7,3,2,1,2,9,3,6,4,3,2,6,1,6,15,8,1,3,11,7,3,5,6,3,1,2,
4,5,3,3,12,7,3,2,4,6,9,5,1,5,1,2,3,10,3,2,7,2,1,2,7,3,6,12,5,3,4,5,1,15,2,3,1,6,2,7,3,17,6,4,3,5,1,
2,10,5,4,8,1,5,7,2,1,6,3,8,3,4,2,4,2,3,4,3,3,6,3,2,3,3,4,9,2,10,2,6,1,5,3,1,5,6,1,2,10,3,15,3,2,4,5,
6,3,1,14,1,3,2,1,8,6,1,3,5,4,12,6,3,9,3,2,7,3,2,6,4,3,6,2,3,6,3,6,1,8,10,2,1,5,9,4,2,7,2,1,3,11,3,7,
3,3,5,3,1,5,1,2,1,11,1,2,3,3,6,3,7,5,6,3,4,2,18,7,6,3,2,3,1,6,3,6,8,1,5,4,11,1,6,3,2,3,9,1,6,3,2,6,
4,3,6,2,3,6,3,1,6,6,2,7,3,8,3,1,5,4,9,3,17,1,14,1,11,3,1,5,6,1,3,2,4,11,3,1,5,4,2,3,4,2,6,9,6,10,2,
3,3,4,2,1,8,6,1,5,4,5,1,2,3,7,6,11,4,14,1,2,10,2,1,2,7,5,6,1,6,8,1,14,4,11,4,2,3,3,7,2,4,6,3,3,2,10,
2,9,1,6,3,2,3,7,9,5,4,5,16,3,5,3,3,1,3,8,3,1,6,3,14,1,5,4,8,3,4,3,5,12,10,5,1,5,1,6,2,3,10,2,1,6,9,
5,1,5,1,2,10,8,13,2,4,3,2,6,3,4,6,6,3,2,4,11,1,8,7,5,3,6,6,7,3,2,10,2,6,3,1,3,3,8,4,11,1,14,4,3,2,
10,2,6,12,10,2,4,5,1,8,1,6,6,17,1,2,3,6,3,3,4,3,2,1,3,12,2,10,5,3,3,7,2,3,3,1,6,3,5,1,5,3,10,2,13,2,
1,3,11,1,12,2,3,1,2,3,12,3,4,2,1,17,3,4,8,6,1,5,1,5,3,4,2,4,6,11,3,7,2,13,2,1,6,5,4,2,4,6,2,7,3,8,3,
4,2,3,3,4,3,5,6,1,3,3,8,4,3,3,6,5,1,3,9,2,3,3,3,6,9,4,3,5,4,9,2,7,3,9,5,4,5,6,1,3,6,6,18,2,3,4,2,3,
1,2,9,6,3,4,3,3,2,9,1,2,1,12,2,3,3,7,15,3,2,3,6,3,10,2,4,2,4,3,3,2,15,1,5,6,4,5,4,12,3,6,2,7,2,3,1,
14,7,8,1,6,3,2,10,5,3,3,3,4,5,6,7,5,7,8,7,5,7,3,8,3,4,3,8,10,5,1,3,2,1,2,6,1,5,1,3,11,3,1,2,9,4,5,4,
11,1,5,9,7,2,1,2,9,1,2,3,4,5,1,15,2,15,1,5,1,9,2,9,3,7,5,1,2,10,18,3,2,3,7,2,10,5,7,11,3,1,15,6,5,9,
1,2,7,3,11,9,1,6,3,2,4,2,4,3,5,1,6,9,5,7,8,7,2,3,3,1,3,2,1,14,1,14,3,1,2,3,7,2,6,7,8,7,2,3,4,3,2,3,
3,3,4,2,4,2,7,8,4,3,2,6,4,8,1,5,4,2,3,13,3,5,4,2,3,6,7,15,2,7,11,4,6,2,3,4,5,3,7,5,3,1,5,6,6,7,3,3,
9,5,3,4,9,2,3,1,3,5,1,5,4,3,3,5,1,9,5,1,6,2,3,4,5,6,7,6,2,4,5,3,3,10,2,7,8,7,5,4,5,6,1,9,3,6,5,6,1,
2,1,6,3,2,4,2,22,2,1,2,1,5,6,3,3,7,2,3,3,3,4,3,18,9,2,3,1,6,3,3,3,2,7,11,6,1,9,5,3,13,12,2,1,2,1,2,
7,2,3,3,4,8,6,1,21,2,1,2,12,3,3,1,9,2,7,3,14,9,7,3,5,6,1,3,6,15,3,2,3,3,7,2,1,12,2,3,3,13,5,9,3,4,3,
3,15,2,6,6,1,8,1,3,2,6,9,1,3,2,13,6,3,6,2,12,12,6,3,1,6,14,4,2,3,6,1,9,3,2,3,3,10,8,1,3,3,9,5,3,1,2,
4,3,3,12,8,3,4,5,3,7,11,4,8,3,1,6,2,1,11,4,9,17,1,3,9,2,3,3,4,5,4,9,3,2,1,2,4,8,1,6,6,3,9,2,3,3,3,1,
3,6,5,10,6,9,2,3,1,8,1,5,7,2,15,1,5,6,1,12,3,8,4,5,1,6,11,3,1,8,10,5,1,6,6,9,5,6,3,1,5,1,3,5,9,1,6,
3,2,3,1,12,14,1,2,1,5,1,8,6,4,11,1,3,2,1,5,3,10,6,5,4,6,3,3,3,2,9,1,2,6,9,1,6,3,2,1,8,6,6,7,2,4,9,2,
6,7,3,3,2,4,3,2,10,6,5,7,2,1,8,1,6,15,2,3,12,10,12,5,4,6,5,6,3,6,6,3,4,8,7,3,2,3,18,10,5,15,6,1,2,1,
14,6,7,3,11,4,2,9,3,7,9,2,3,1,3,17,9,1,8,3,9,1,12,2,1,3,6,3,6,5,4,3,8,6,4,5,7,20,3,1,3,2,6,7,2,1,2,
1,2,4,3,5,3,3,1,3,3,3,6,3,12,5,1,5,3,6,3,3,7,3,3,26,10,3,5,1,5,4,5,6,6,1,3,2,7,8,4,6,3,11,1,5,4,3,
11,1,11,3,4,5,6,6,1,5,3,6,1,2,7,5,1,3,9,2,6,4,9,6,3,3,2,3,3,7,2,1,6,6,2,3,9,9,6,1,8,6,4,9,5,13,2,3,
4,3,3,2,1,5,10,2,3,4,2,10,5,1,17,1,2,12,1,6,6,5,3,1,6,15,3,6,8,6,1,11,9,6,7,5,1,6,6,2,1,2,3,6,1,8,9,
1,20,4,8,3,4,5,1,2,9,4,5,4,6,2,9,1,9,5,1,2,1,2,4,14,1,3,11,6,3,7,9,2,3,4,3,3,5,4,2,1,9,5,3,10,11,4,
3,15,2,1,2,9,3,15,1,2,4,3,2,3,6,7,17,7,3,2,1,3,2,7,2,1,3,14,1,2,3,4,5,1,5,1,5,1,2,15,1,6,6,5,9,6,7,
5,1,6,3,5,3,7,6,2,7,2,9,1,5,4,2,4,5,6,9,9,4,3,9,8,7,3,3,5,7,2,3,1,6,6,2,3,3,6,1,8,1,6,3,2,7,3,2,1,6,
9,2,18,9,6,6,1,2,1,2,4,6,2,18,3,9,1,6,5,3,6,12,4,3,3,8,6,1,9,5,10,5,1,3,9,2,1,20,3,1,8,1,2,4,9,5,6,
3,1,5,4,2,3,6,1,5,9,4,3,2,10,2,3,18,3,1,5,3,12,3,7,8,3,9,1,5,10,5,4,3,2,3,1,5,1,6,2,1,2,4,5,3,6,9,7,
6,8,4,3,8,4,2,1,3,9,12,9,5,6,1,2,7,5,3,3,3,9,6,1,14,9,7,8,6,7,12,6,11,3,1,5,4,2,1,2,7,6,3,2,3,7,2,1,
2,15,3,1,3,5,1,15,11,1,2,3,4,3,3,8,6,6,3,4,2,1,12,6,2,3,4,3,3,5,1,3,6,14,7,3,2,6,4,3,6,2,3,7,3,6,5,
3,3,4,3,3,2,1,2,4,6,2,7,9,5,1,8,3,10,3,5,4,2,15,18,6,4,11,6,1,3,6,8,3,3,1,9,2,13,2,4,9,5,4,5,3,7,2,
10,11,9,6,4,14,6,3,3,4,3,6,12,8,7,2,7,6,3,5,6,10,3,2,4,9,6,9,5,1,2,10,5,7,2,3,1,5,12,9,1,2,10,8,7,5,
7,3,2,3,10,3,5,3,1,6,3,15,5,4,3,2,3,4,20,1,2,1,6,9,2,3,4,5,3,9,9,1,6,8,4,3,2,3,3,1,26,7,2,10,8,1,2,
3,6,1,3,6,6,3,2,7,5,3,3,7,5,7,8,4,3,6,2,4,11,3,1,9,11,3,1,9,3,8,7,5,3,6,1,3,2,4,9,6,8,1,2,7,2,4,6,6,
15,8,4,2,1,3,11,6,4,5,3,3,3,7,3,9,5,6,1,5,1,2,13,2,6,4,2,9,4,5,7,8,3,3,4,5,3,4,3,6,5,10,5,4,2,6,13,
9,2,6,9,3,15,3,4,3,11,6,1,2,3,3,1,5,1,2,3,3,1,3,11,9,3,9,6,4,6,3,5,6,1,8,1,5,1,5,9,3,10,2,1,3,11,3,
3,9,3,7,6,8,1,3,3,2,7,6,2,1,9,8,18,6,3,7,14,1,6,3,6,3,2,1,8,15,4,12,3,15,5,1,9,2,3,6,4,11,1,3,11,9,
1,5,1,5,15,1,14,3,7,8,3,10,8,1,3,2,16,2,1,2,3,1,6,2,3,3,6,1,3,2,3,4,3,2,10,2,16,5,4,8,1,11,1,2,3,4,
3,8,7,2,9,4,2,10,3,6,6,3,5,1,5,1,6,14,6,9,1,9,5,4,5,24,1,2,3,4,5,1,5,15,1,18,3,5,3,1,9,2,3,4,8,7,8,
3,7,2,10,2,3,1,5,6,1,3,6,3,3,2,6,1,3,2,6,3,4,2,1,3,9,5,3,4,6,3,11,1,3,6,9,2,7,3,2,10,3,8,4,2,4,11,4,
6,3,3,8,6,9,15,4,2,1,2,3,13,2,7,12,11,3,1,3,5,3,7,3,3,6,5,3,1,6,5,6,4,9,9,5,3,4,8,3,3,4,8,10,2,1,5,
1,5,6,3,4,3,5,10,5,9,13,2,3,15,1,2,4,3,6,6,9,2,4,11,3,1,6,17,3,9,6,3,1,14,7,8,7,2,7,6,2,3,3,1,18,2,
3,10,6,12,3,11,1,8,9,6,6,9,1,3,3,3,2,3,7,2,1,11,4,6,3,5,3,4,6,9,6,3,5,1,11,7,3,3,2,9,3,10,11,1,6,12,
2,9,9,1,11,1,2,6,4,6,5,7,2,1,9,8,19,3,3,3,6,5,3,6,4,3,2,3,7,15,3,5,4,11,3,4,6,5,1,5,1,3,5,1,5,6,9,
10,3,2,4,11,3,3,15,3,7,3,6,6,3,5,1,5,15,1,8,4,2,1,3,9,2,1,3,2,13,2,4,3,5,1,2,3,4,2,3,15,6,1,3,3,2,
10,11,4,2,1,2,36,4,2,4,11,1,2,7,5,1,2,10,3,5,9,3,10,8,3,4,3,2,10,6,11,1,2,1,6,5,9,1,11,3,9,15,1,5,7,
5,4,8,25,3,5,4,5,6,3,9,1,11,3,1,2,3,4,3,3,5,9,1,11,1,8,7,5,3,1,6,5,10,2,7,3,2,18,1,2,3,6,1,2,7,6,3,
2,3,1,3,2,10,5,1,5,3,6,1,12,6,6,3,3,2,12,1,2,12,1,3,2,3,4,8,3,1,5,6,7,3,17,3,7,3,2,1,15,11,4,2,3,4,
2,1,14,1,3,2,13,9,11,1,3,8,3,1,8,6,1,6,2,3,3,7,5,3,4,6,2,9,1,5,4,8,3,3,15,1,5,9,1,5,4,2,4,6,12,20,1,
6,5,3,6,1,6,2,1,2,3,9,7,6,3,2,7,15,2,4,5,4,3,5,9,4,2,7,8,3,4,2,3,1,5,1,6,2,1,2,3,4,2,3,16,12,5,4,9,
5,1,3,5,1,2,9,3,6,1,8,1,11,3,3,4,9,2,9,6,4,3,2,10,3,15,11,6,1,3,9,2,31,2,1,6,3,5,1,6,6,14,1,2,7,11,
3,1,3,3,5,7,2,1,5,3,4,5,7,5,3,1,6,11,9,4,5,9,6,1,6,2,6,1,5,1,3,9,3,3,17,3,1,6,2,3,9,9,1,8,3,3,4,3,5,
9,4,5,4,5,1,2,9,13,6,11,1,2,1,11,3,3,7,8,3,10,5,6,1,9,21,2,12,1,3,5,6,1,3,5,4,2,3,6,6,4,2,3,6,15,10,
3,12,3,5,6,1,5,10,3,3,2,6,7,5,9,6,4,3,6,2,7,5,1,6,15,8,1,6,3,2,1,2,3,13,2,9,1,2,3,7,27,3,26,1,8,3,3,
6,13,2,1,3,11,3,1,6,6,3,5,9,1,6,6,5,9,6,3,4,3,5,3,4,2,1,2,10,12,3,3,5,7,5,1,11,3,7,5,13,2,9,4,6,6,5,
6,3,4,8,3,4,3,3,11,1,5,10,5,3,22,9,3,5,1,2,3,7,2,13,2,1,6,5,4,2,4,6,2,6,4,11,4,3,5,9,3,3,4,3,6,2,4,
9,5,6,3,6,1,3,2,1,8,6,6,7,5,7,3,5,6,1,6,3,2,3,1,6,2,13,3,9,3,5,3,1,9,5,4,2,13,5,10,3,8,10,6,5,4,5,1,
8,3,10,5,10,2,15,1,2,4,8,1,9,2,1,3,5,9,6,7,9,3,8,10,3,2,4,3,2,3,6,4,5,1,6,3,2,1,3,5,1,8,6,7,5,3,4,3,
14,1,3,9,15,17,1,8,6,1,9,8,3,4,5,4,5,4,5,22,3,3,2,10,2,1,2,7,14,4,3,8,7,15,3,15,2,7,5,3,3,4,2,9,6,3,
1,11,6,4,3,6,2,7,2,3,1,2,9,10,3,8,19,8,1,2,3,1,20,21,7,2,3,1,12,5,3,1,9,5,6,1,8,1,3,8,3,4,2,1,5,3,4,
5,1,9,8,4,6,9,6,3,6,5,3,3,9,6,7,2,1,5,10,3,6,3,8,13,2,9,1,2,16,5,4,3,2,3,3,7,3,9,2,1,9,5,4,5,4,5,1,
2,3,1,5,21,4,6,2,3,9,1,8,4,2,1,5,7,6,5,10,2,4,5,19,2,3,1,5,10,5,6,3,6,13,6,2,4,14,4,2,4,12,3,5,4,3,
8,6,4,5,6,4,11,3,1,5,1,3,5,3,3,4,3,2,7,14,4,8,9,4,2,3,10,2,9,3,1,12,12,3,3,6,6,2,1,11,1,5,3,4,6,2,
10,9,3,2,6,12,3,3,27,4,3,2,13,18,2,1,2,13,6,6,2,3,3,4,6,5,1,6,8,9,3,4,3,6,9,5,1,27,2,1,5,15,6,4,2,4,
8,7,6,3,2,3,6,3,1,2,7,6,2,7,3,12,3,3,5,6,6,10,9,3,3,8,4,2,3,10,2,16,2,7,5,1,3,6,8,1,2,3,6,1,5,4,3,2,
1,5,7,3,3,6,9,17,4,5,3,12,3,1,5,6,1,15,5,7,6,6,8,3,3,1,9,2,3,15,7,2,3,3,1,3,2,3,7,3,2,4,5,6,3,16,5,
4,11,1,5,3,12,4,2,15,3,1,6,8,4,3,2,3,4,8,7,3,3,2,1,5,6,1,8,7,2,1,2,10,9,5,1,5,3,6,15,4,9,6,5,1,3,3,
2,6,6,1,2,6,9,12,1,5,3,4,8,4,3,6,5,7,3,6,3,3,2,1,12,2,3,4,3,2,1,2,3,7,2,4,5,12,12,6,1,3,6,11,15,1,3,
9,5,3,3,4,2,1,3,5,4,5,3,4,8,3,7,3,2,12,4,5,1,6,3,2,18,1,11,3,4,3,5,4,3,6,5,7,5,3,9,6,1,6,2,13,5,7,8,
9,4,9,6,6,3,8,7,12,5,6,4,11,3,1,5,30,3,1,2,4,8,7,5,3,12,3,6,9,12,1,15,2,1,6,3,5,1,2,7,3,8,1,5,4,11,
10,3,2,16,3,9,2,1,2,1,2,4,26,7,11,1,11,10,5,4,5,1,3,2,7,2,3,10,2,3,1,6,6,3,6,8,1,6,5,4,2,3,1,14,6,4,
5,6,1,2,7,14,4,3,2,1,2,3,1,6,29,3,7,5,1,3,14,16,2,15,4,3,2,3,6,6,1,2,3,3,7,8,4,15,2,1,5,4,3,2,3,13,
2,6,1,5,9,6,6,9,1,2,6,4,6,5,10,2,4,8,6,4,3,8,4,5,6,7,3,2,4,6,2,10,3,20,4,8,3,18,1,3,2,3,1,11,9,1,5,
3,18,7,6,2,9,4,2,7,5,1,5,4,2,1,9,8,6,7,5,7,3,3,21,5,3,3,10,5,4,6,2,6,9,1,5,7,9,5,9,4,3,2,7,3,5,15,7,
3,3,2,6,19,2,1,2,3,4,6,5,3,9,3,25,3,2,3,6,4,5,16,3,11,1,5,6,9,1,3,2,15,4,3,3,9,5,1,2,6,10,5,4,12,5,
1,3,11,3,1,9,5,6,1,15,9,6,14,1,3,2,3,7,3,6,5,4,2,6,13,5,4,3,8,1,5,9,7,3,2,3,7,8,1,3,2,6,10,2,10,2,3,
6,1,18,2,3,1,5,1,11,4,3,5,6,6,9,7,12,18,2,10,12,5,3,1,14,3,9,4,2,3,4,3,2,1,6,14,9,7,8,7,9,5,4,3,2,3,
3,4,11,6,1,5,9,3,1,9,5,1,6,5,9,16,3,2,3,3,4,3,3,5,10,3,6,5,4,5,7,3,5,7,2,1,11,9,1,5,1,2,10,2,1,17,1,
6,3,5,1,5,9,3,7,6,6,11,4,3,8,3,4,2,6,3,4,2,18,3,3,10,12,3,6,9,5,1,5,13,3,8,4,3,2,12,9,4,6,6,5,9,6,1,
12,2,6,9,6,7,5,1,2,12,6,7,5,3,1,3,2,3,13,2,3,3,1,11,4,9,2,9,4,2,12,1,6,6,2,1,26,1,9,3,2,3,6,1,3,6,5,
4,2,1,12,5,1,5,1,6,3,9,20,3,10,8,1,6,3,5,6,1,2,3,7,6,6,11,3,4,2,1,8,9,6,1,3,8,3,1,3,2,6,15,4,8,1,9,
5,12,1,3,12,2,1,11,1,8,1,3,6,2,9,4,2,7,2,9,12,3,1,3,5,1,5,19,3,5,7,3,3,12,2,1,6,8,7,8,6,1,3,5,13,2,
1,6,3,2,6,4,6,5,9,3,7,14,1,3,5,1,2,7,17,1,3,11,1,5,7,2,1,8,4,5,3,4,5,4,2,3,1,8,3,3,9,15,7,3,2,15,1,
5,7,2,10,5,4,2,4,9,2,7,3,2,12,3,3,9,9,1,18,3,5,7,6,2,3,1,15,3,2,1,3,14,10,2,10,6,12,8,9,6,7,3,2,6,
16,6,3,5,4,5,3,9,1,8,7,3,11,3,6,1,9,2,4,15,6,2,6,1,5,19,11,1,2,7,3,6,12,2,1,2,7,6,5,1,8,3,10,2,10,
11,6,1,2,1,6,11,12,3,3,1,3,2,3,1,5,6,6,3,1,3,8,4,3,2,9,6,6,7,2,6,3,4,3,9,3,5,6,7,3,2,4,11,3,1,14,9,
1,9,5,3,7,5,1,5,7,3,5,1,11,3,4,3,8,6,4,11,1,2,7,9,6,3,12,3,5,1,6,11,9,3,10,3,5,7,2,1,3,6,11,7,6,2,3,
4,11,1,5,6,4,20,1,3,5,4,2,21,10,2,16,6,5,3,6,6,1,5,4,3,2,4,2,13,9,2,4,14,3,9,3,6,1,5,3,3,7,5,6,7,12,
3,2,10,11,1,9,2,3,6,1,8,9,7,3,3,2,3,4,9,2,7,15,2,9,4,5,1,2,4,6,2,6,9,1,6,5,1,8,4,2,15,1,3,14,1,5,1,
9,5,7,2,13,3,9,2,10,3,2,4,9,2,6,13,12,2,10,11,1,9,11,1,2,6,1,3,3,3,2,3,7,2,12,6,3,9,1,6,14,7,2,3,4,
11,3,6,9,4,2,10,3,2,3,1,9,3,2,6,6,4,14,3,4,5,1,12,6,5,12,4,5,10,6,3,6,6,2,7,6,12,17,9,4,5,3,9,4,2,4,
8,7,3,2,3,12,1,3,2,3,1,8,3,3,10,12,2,1,2,7,2,9,1,3,6,2,7,2,1,9,8,3,3,1,8,10,3,3,15,2,4,3,12,8,3,3,4,
6,15,2,9,9,4,2,13,5,1,11,4,5,7,3,2,9,4,6,14,1,3,2,6,3,12,3,4,5,10,8,4,15,3,3,2,1,5,7,3,5,16,11,9,1,
2,1,2,4,11,4,9,6,14,1,8,6,9,7,5,9,6,3,16,5,7,3,5,1,5,1,3,11,1,2,3,4,5,3,7,3,2,6,15,12,3,3,4,3,2,1,2,
3,4,3,3,11,9,4,2,1,9,3,2,1,8,9,10,5,3,3,15,1,6,14,3,3,3,1,6,5,4,9,9,2,4,9,5,1,14,1,5,7,2,1,15,6,11,
13,5,4,3,5,4,8,7,3,3,5,7,3,2,1,5,6,1,3,5,4,2,1,5,13,11,3,1,6,9,2,13,2,4,5,3,7,5,1,9,3,5,10,3,3,2,12,
1,2,4,3,8,7,8,9,1,2,6,1,5,1,3,6,5,3,3,10,3,2,3,19,2,3,6,7,2,6,4,5,6,6,4,2,3,7,5,3,6,1,5,9,1,9,5,4,5,
1,6,2,7,14,1,8,1,9,3,5,3,4,8,7,15,5,10,3,5,12,1,14,1,6,8,3,4,18,2,4,2,7,6,5,4,6,2,3,4,2,3,7,11,4,3,
2,1,5,3,10,5,4,3,3,11,9,1,8,3,10,2,13,2,7,11,7,2,6,3,4,2,3,3,13,5,1,9,9,2,1,8,1,9,2,3,4,2,3,6,1,3,3,
14,19,2,4,8,13,2,1,5,6,1,5,4,3,5,6,1,5,1,12,2,15,13,3,3,9,3,3,11,1,5,9,13,2,9,4,3,3,6,8,3,4,8,3,4,8,
1,21,29,4,2,3,1,2,4,8,3,10,2,6,6,3,6,1,5,1,3,11,1,5,3,4,3,5,7,3,3,2,9,4,5,4,8,7,5,1,5,1,6,3,2,10,5,
4,26,4,5,3,1,5,4,5,3,3,4,5,1,11,1,2,3,7,2,1,12,6,2,13,9,2,3,7,15,3,2,3,1,11,4,2,3,1,11,3,4,8,3,7,2,
3,9,4,6,3,6,12,15,8,4,17,4,11,3,7,5,9,7,2,6,4,2,18,3,3,1,5,1,2,10,3,3,5,6,3,1,20,4,3,14,3,1,6,9,2,
12,7,3,3,5,10,5,7,8,7,8,3,4,18,2,6,6,3,6,25,6,3,2,3,3,4,3,5,1,5,1,9,5,7,8,4,3,2,10,2,1,5,3,7,9,5,19,
5,9,1,5,1,6,2,1,2,7,3,5,4,20,3,10,2,6,4,3,17,4,11,4,6,5,1,8,21,6,4,11,4,11,4,3,17,1,3,2,7,3,8,1,11,
3,4,12,11,3,1,6,2,3,7,2,4,12,2,3,3,1,11,10,3,2,7,2,3,3,4,3,5,3,4,3,8,7,3,3,11,3,12,16,3,9,3,9,5,4,
15,9,3,8,6,3,6,1,3,2,6,4,3,11,4,3,2,7,5,9,10,5,1,3,2,1,14,9,1,5,3,3,3,7,20,12,1,2,4,6,2,10,2,16,9,8,
3,18,4,3,2,3,7,2,3,13,3,5,7,9,5,3,3,7,5,3,3,7,3,12,2,7,11,4,6,5,4,6,9,5,9,4,12,5,4,2,12,3,9,3,1,5,
15,1,5,1,2,1,20,1,14,4,3,3,9,3,5,7,2,9,15,9,1,6,15,3,15,2,9,6,1,2,7,3,5,3,4,3,5,6,1,3,6,5,1,9,2,10,
2,3,7,3,3,11,3,3,4,9,9,5,1,5,1,3,2,3,6,9,1,5,4,2,9,1,3,3,3,5,4,5,3,9,6,4,6,3,2,3,7,8,1,6,2,3,19,3,3,
8,10,14,10,5,3,3,7,2,13,2,7,5,9,7,14,1,2,7,8,1,14,3,4,3,17,4,2,9,1,8,4,3,20,4,9,2,15,3,6,1,15,3,5,7,
20,7,5,1,6,5,4,2,4,3,3,14,1,2,6,7,8,4,15,8,9,1,5,9,3,16,2,9,3,1,6,5,9,1,3,5,7,9,14,3,4,8,1,2,10,5,4,
9,5,1,5,4,2,3,6,3,10,2,1,3,2,10,5,13,9,5,1,9,3,8,7,2,13,2,7,5,6,7,3,3,2,7,5,1,15,9,11,1,8,1,2,4,3,3,
8,1,3,6,5,4,6,2,7,2,3,10,5,6,1,3,3,2,1,5,1,15,8,6,10,9,2,3,1,2,4,8,7,9,11,3,1,11,3,3,9,1,5,18,4,2,3,
10,2,6,3,7,2,1,14,12,4,2,3,6,15,9,16,11,4,18,3,2,6,1,6,2,3,10,5,9,9,4,3,2,12,4,5,7,3,2,4,6,8,1,8,3,
4,8,6,7,5,15,7,2,6,4,6,3,5,1,6,14,3,6,6,10,5,1,5,7,3,3,15,2,4,6,2,1,5,7,2,13,9,6,5,3,4,2,6,3,12,9,4,
5,1,6,2,6,6,3,1,11,1,2,1,6,8,7,5,1,8,9,16,2,3,10,11,4,5,1,5,3,1,2,7,3,12,2,4,2,3,6,6,4,3,5,6,4,5,1,
5,6,3,6,6,10,14,10,5,7,5,4,5,3,1,2,7,3,3,6,3,6,5,7,5,7,8,4,5,13,2,1,3,2,7,2,3,6,4,3,15,9,6,3,6,8,6,
6,1,14,3,7,5,18,1,2,3,4,6,11,9,1,15,9,11,10,9,5,19,3,2,1,12,2,3,3,1,5,3,7,5,4,2,12,7,8,7,11,3,10,5,
7,2,6,6,1,8,4,3,3,9,2,3,7,11,3,1,21,8,1,5,3,1,2,3,4,5,10,8,15,4,5,4,5,1,15,3,3,18,5,4,8,3,1,6,14,1,
2,3,9,6,3,4,5,1,2,25,2,10,2,15,4,2,3,6,1,12,2,4,9,3,2,3,4,5,1,2,1,20,9,18,15,15,4,8,7,3,6,14,1,11,1,
2,6,15,6,3,1,2,7,5,1,9,11,6,9,1,5,9,16,3,2,1,3,5,10,6,5,3,6,10,6,3,2,1,8,1,8,3,7,2,1,8,1,3,8,3,4,2,
4,11,9,4,6,2,4,3,12,11,3,1,6,15,3,5,6,3,1,11,3,1,6,3,11,4,6,11,1,5,3,9,6,1,3,6,9,3,2,10,11,4,6,12,8,
7,5,15,9,1,3,2,7,5,1,6,5,6,3,1,8,6,1,3,6,5,1,5,3,1,6,6,8,10,5,6,4,15,5,7,2,3,4,3,2,10,9,12,2,6,4,2,
1,12,3,12,5,1,2,3,1,3,3,3,2,12,1,5,6,1,3,5,4,3,5,9,1,3,2,10,12,5,6,1,6,3,12,2,18,7,8,4,11,3,4,2,1,3,
11,10,8,6,9,1,6,8,3,3,6,3,6,1,3,6,5,4,8,4,3,8,4,6,2,3,3,10,6,6,2,3,10,2,6,1,5,1,3,15,11,3,1,2,19,5,
1,2,1,11,1,8,1,3,5,10,3,12,2,6,7,6,2,19,5,15,3,1,6,6,2,3,15,7,2,4,9,18,2,3,10,2,1,6,5,1,3,5,6,3,6,4,
3,3,12,2,15,10,3,18,5,1,6,3,2,4,3,2,6,4,3,6,2,3,7,2,10,6,2,3,9,1,2,9,1,8,6,15,3,3,4,20,4,24,3,8,9,7,
6,3,9,2,10,5,1,3,5,4,15,2,6,10,3,6,3,3,17,3,3,9,3,4,5,6,3,4,5,1,2,12,3,4,11,3,1,6,3,5,6,3,12,3,7,6,
18,2,12,1,5,4,5,3,7,5,16,2,4,5,6,13,9,2,3,10,2,10,3,8,3,1,15,6,3,5,1,3,5,6,4,2,1,3,5,6,13,11,4,3,2,
7,3,3,15,2,3,7,2,1,14,1,3,11,4,2,9,9,9,1,6,3,2,10,5,3,3,7,5,6,1,6,15,17,6,4,3,2,1,5,1,8,6,1,5,4,9,
12,3,2,6,7,2,4,2,7,2,3,3,10,3,2,4,9,26,1,2,6,4,2,19,2,13,12,8,6,3,1,6,6,8,1,3,3,2,6,7,8,4,6,9,8,3,4,
5,3,7,5,6,1,5,1,2,12,3,21,12,4,5,3,3,3,1,6,2,7,3,3,14,3,1,5,6,6,3,10,2,3,7,2,1,6,5,6,12,3,4,3,3,2,
12,6,10,8,7,15,9,3,2,13,6,2,3,1,3,2,1,14,4,20,1,5,4,2,10,3,9,5,1,2,22,3,9,6,3,2,3,1,11,3,7,15,5,12,
1,5,4,8,9,1,9,11,4,5,3,3,7,2,4,9,2,1,9,9,9,3,2,12,9,1,8,3,3,9,10,8,10,2,7,3,2,10,9,5,1,3,5,12,1,5,
12,3,3,12,3,6,1,14,6,7,3,3,6,3,11,6,6,4,18,2,6,7,2,10,5,6,12,1,2,3,6,1,2,1,5,6,13,3,8,4,2,4,5,4,3,
17,1,6,8,12,3,1,5,1,9,2,4,3,8,3,1,3,3,3,2,7,2,10,3,2,10,3,6,11,3,1,5,6,1,3,2,4,6,2,7,6,5,7,2,6,13,5,
7,2,13,3,15,2,9,9,4,3,8,4,5,7,5,4,5,10,11,10,8,1,9,3,2,3,3,6,1,5,13,2,4,9,9,3,9,3,2,3,12,3,10,17,13,
5,1,14,6,4,5,6,1,3,11,1,6,8,1,3,3,5,7,8,10,3,2,19,3,5,3,4,8,21,1,3,2,3,3,3,7,8,7,2,10,5,1,2,4,9,5,6,
18,1,5,21,4,2,10,12,8,4,11,3,4,2,1,3,11,3,3,4,14,1,5,9,7,3,2,9,4,5,7,2,6,4,5,6,7,2,1,6,6,2,3,9,15,6,
19,3,6,5,1,9,5,6,4,2,4,3,2,1,12,6,9,2,1,2,1,29,6,4,12,5,1,2,3,3,6,1,2,7,3,3,8,6,1,2,16,2,12,3,3,4,5,
1,11,9,6,10,3,15,2,15,3,1,2,7,3,2,7,8,1,6,5,1,3,6,6,5,3,4,11,4,6,6,3,8,3,9,10,11,9,1,11,1,8,1,11,7,
5,10,5,16,2,4,5,3,1,11,3,6,1,3,2,1,2,7,6,12,5,1,6,8,1,2,3,7,3,5,6,1,8,7,17,6,1,3,3,3,2,10,5,13,6,6,
2,1,2,4,5,1,2,1,11,3,3,7,2,9,6,13,3,5,4,8,1,2,10,5,3,21,1,5,3,4,12,6,3,2,3,6,1,14,4,6,9,9,3,23,4,5,
3,7,2,1,3,2,3,21,4,5,4,5,1,9,2,3,6,6,1,2,10,5,6,6,4,2,13,9,11,4,3,8,7,8,1,9,5,1,3,3,5,7,2,1,15,2,1,
2,4,5,3,1,6,8,3,28,5,1,6,5,4,6,3,2,7,5,1,2,4,3,2,10,3,6,11,3,16,5,1,5,6,7,3,14,18,3,3,1,6,2,3,3,4,
11,1,9,5,1,3,2,10,5,4,2,3,7,9,3,21,11,1,2,1,14,1,2,9,3,3,3,6,1,12,5,18,3,1,6,5,13,12,9,8,3,3,7,12,6,
2,4,3,6,2,4,8,10,20,13,2,6,1,3,2,1,5,7,5,1,2,13,6,14,1,8,13,3,5,1,3,5,3,4,3,3,3,5,6,3,10,20,10,2,1,
8,6,3,6,4,2,9,1,6,5,13,6,8,1,9,12,6,2,7,11,10,5,7,6,2,9,6,4,5,6,3,15,7,2,12,3,15,3,3,1,3,11,16,3,2,
3,3,10,8,1,5,4,6,5,1,3,5,4,8,18,4,3,2,1,14,1,14,6,1,5,3,7,5,3,3,3,4,3,2,7,9,2,3,6,1,5,9,4,15,20,1,9,
2,3,7,9,3,2,6,3,6,3,7,5,13,3,8,1,8,15,1,5,1,21,3,14,7,3,5,1,6,9,6,3,5,6,6,10,3,2,1,5,3,6,6,7,6,17,3,
1,6,5,3,4,3,2,6,19,3,5,9,1,14,1,3,6,15,8,1,5,4,2,1,8,9,13,2,3,4,9,11,3,10,2,3,6,1,3,6,2,9,3,1,11,6,
4,3,8,9,15,6,12,1,5,1,3,3,2,3,18,7,3,11,1,29,4,6,3,5,1,20,4,3,14,1,2,7,3,3,9,5,4,2,7,2,4,15,2,3,4,3,
3,9,2,1,2,7,6,9,5,1,2,6,1,5,4,5,7,5,9,6,4,3,5,7,5,4,11,1,3,11,6,3,4,6,14,1,24,6,2,9,4,5,7,5,7,2,6,
15,12,3,4,3,2,4,27,2,1,5,6,4,5,6,6,9,1,12,2,4,11,6,10,2,6,1,6,8,1,14,1,3,12,5,1,14,1,2,10,2,6,3,7,2,
3,7,11,12,10,2,7,3,3,5,15,4,5,9,1,3,3,8,1,3,3,2,1,12,2,1,12,5,3,1,5,1,3,11,4,2,4,3,2,9,1,9,2,4,8,13,
2,3,4,11,10,8,4,2,3,12,3,7,6,8,1,6,2,7,5,1,2,6,9,16,5,7,12,6,20,4,17,6,7,2,9,1,14,6,10,3,5,1,20,9,7,
6,2,18,3,1,11,3,7,5,12,21,1,8,1,17,4,3,2,1,2,7,20,4,6,3,12,9,2,3,1,3,2,1,2,1,12,5,4,3,3,5,7,3,8,9,7,
9,12,2,3,3,4,2,10,5,3,6,1,6,2,7,3,3,3,2,7,8,18,7,3,2,7,2,3,12,4,2,10,5,7,6,17,4,5,3,3,3,7,2,7,6,3,5,
9,7,5,6,3,1,3,3,14,1,2,12,3,1,2,4,8,3,10,2,1,5,1,5,4,32,3,4,6,2,7,6,5,1,6,3,5,9,12,3,1,5,4,3,8,10,2,
7,3,3,6,3,2,3,1,2,4,11,3,4,2,1,8,9,7,3,11,7,5,7,2,3,1,2,7,5,6,4,8,4,5,4,12,20,3,6,1,3,9,2,1,2,15,1,
15,2,4,9,6,6,2,1,2,7,18,8,9,1,6,5,3,6,9,1,9,3,3,11,9,19,3,5,9,1,5,4,3,8,12,7,3,2,3,7,8,12,3,6,4,6,5,
7,23,1,8,1,11,3,1,5,1,5,1,3,2,10,5,3,15,4,3,3,2,15,4,3,3,3,11,18,1,2,4,3,3,2,7,6,5,10,2,1,2,15,3,7,
8,6,15,1,2,3,4,15,5,4,17,9,6,4,11,10,2,7,5,10,3,2,1,5,7,2,13,3,18,6,9,2,4,3,2,3,1,14,3,3,12,4,5,13,
3,12,2,4,12,5,10,2,1,5,7,8,1,3,3,2,3,4,9,14,7,3,8,7,3,2,3,3,4,2,1,2,6,1,6,3,6,14,1,3,6,5,7,2,22,3,5,
1,6,6,15,2,6,1,3,5,6,1,5,1,5,3,4,5,3,7,8,4,3,6,5,1,5,4,6,5,9,4,2,1,2,13,3,11,3,7,5,3,1,14,3,4,23,3,
3,9,3,3,4,3,5,9,1,3,6,9,5,4,6,15,5,1,5,1,2,3,9,1,2,10,6,2,3,4,17,3,3,12,6,4,18,8,1,3,2,1,2,3,10,3,
12,2,1,2,9,10,3,11,4,23,9,1,8,10,11,1,12,11,1,8,12,10,8,1,2,4,5,1,5,7,2,4,9,2,4,2,7,5,1,12,8,4,3,8,
10,5,1,3,2,15,1,8,16,3,6,5,12,4,6,9,8,1,6,3,2,6,3,1,14,9,1,11,3,3,3,1,3,8,7,3,15,8,1,5,1,2,6,1,6,5,
7,3,5,4,14,1,18,3,8,7,2,10,12,3,2,4,2,9,4,2,7,2,3,1,12,8,7,2,13,8,1,5,16,3,2,3,6,3,18,4,6,2,1,2,4,3,
2,10,6,5,12,6,1,6,5,3,6,1,3,9,2,3,3,3,4,12,3,5,6,15,7,5,4,6,3,5,6,1,9,3,2,4,2,12,10,2,4,5,6,4,6,8,3,
7,2,4,2,9,25,3,3,2,3,4,3,5,13,5,3,1,5,1,5,3,19,6,2,4,5,10,3,3,3,9,5,1,6,8,1,6,6,2,13,5,3,10,9,20,6,
4,5,6,1,9,6,5,1,5,13,2,3,6,4,2,15,3,1,3,8,12,12,9,6,6,4,3,2,4,5,4,3,2,10,5,13,2,12,3,1,6,21,9,3,2,
13,3,14,3,1,5,4,3,3,5,4,5,1,11,1,2,10,2,3,18,7,2,10,11,3,7,3,5,4,2,1,2,7,9,17,4,11,7,5,12,3,1,5,1,3,
5,13,9,5,9,12,9,1,12,20,1,2,3,1,3,5,13,3,6,6,3,2,18,1,5,6,12,1,2,4,5,3,1,2,12,1,2,18,1,11,7,12,9,21,
3,5,1,12,8,6,1,2,1,5,1,5,4,2,18,4,2,6,9,3,3,7,11,1,3,12,3,5,12,10,11,3,7,18,14,3,4,3,12,3,6,14,1,9,
2,1,2,10,11,4,5,1,9,2,4,5,7,5,3,4,3,3,6,8,6,7,5,9,1,5,12,12,3,6,1,11,3,10,11,1,2,6,1,3,18,3,11,3,1,
14,6,9,1,2,7,3,2,1,5,1,8,1,5,4,3,5,9,6,3,7,2,3,9,6,13,2,3,7,3,5,6,1,2,1,5,12,4,5,16,5,4,5,3,1,9,6,
14,15,1,9,2,3,7,3,2,4,11,4,15,9,5,13,2,1,11,4,2,4,3,2,13,2,6,10,9,3,6,5,9,1,2,3,1,6,14,3,10,3,8,4,3,
3,2,3,10,6,3,2,10,3,8,3,16,5,9,1,6,8,12,3,4,6,17,3,10,11,1,8,7,3,2,7,3,12,15,2,4,6,3,8,10,5,7,2,1,8,
6,1,5,4,3,15,6,5,7,5,4,5,3,1,2,7,5,1,5,16,9,2,4,14,10,2,10,3,2,15,4,3,11,9,6,1,5,6,3,9,3,27,3,7,2,3,
3,7,12,3,6,5,6,3,12,6,9,4,9,2,1,2,1,11,4,5,1,6,5,7,3,2,1,6,23,3,3,1,3,3,15,5,4,3,6,2,7,3,8,6,4,5,10,
9,5,3,3,6,1,5,7,2,1,2,12,6,4,9,2,4,8,7,6,5,9,6,4,9,2,7,2,3,1,11,9,4,5,13,2,1,12,3,2,3,6,13,2,4,5,9,
3,7,5,6,1,6,3,2,4,6,8,1,5,3,1,11,1,2,7,9,5,6,10,5,3,1,2,7,6,2,4,5,1,3,17,3,1,8,6,4,11,4,15,5,1,12,2,
7,5,10,8,1,2,10,5,3,4,2,4,2,12,3,7,2,16,2,3,7,3,2,1,11,30,1,3,12,2,7,9,6,9,6,3,2,15,1,8,1,11,7,8,9,
3,18,3,9,1,5,4,2,1,3,12,9,15,3,3,17,7,3,26,1,8,6,7,8,4,15,2,1,3,5,6,1,14,3,7,6,14,9,10,2,4,3,3,2,3,
4,11,3,12,4,3,6,6,3,6,2,10,23,9,7,5,1,12,2,1,12,11,7,5,3,16,6,2,1,5,1,5,1,2,3,3,6,6,7,3,3,14,1,9,3,
3,2,12,1,6,6,3,2,12,12,1,3,2,19,3,5,6,1,6,2,10,11,6,1,5,3,9,21,6,1,3,6,11,7,5,3,3,1,5,9,7,2,13,8,6,
4,9,2,1,5,4,3,2,3,3,3,7,8,1,6,3,5,6,1,12,2,9,1,9,5,6,10,3,8,7,3,3,6,8,6,10,2,4,3,17,13,5,15,3,12,3,
13,6,8,1,5,6,1,5,3,4,21,2,4,3,2,9,1,3,3,3,5,4,2,3,15,6,9,12,4,2,3,4,5,1,2,4,8,3,19,3,3,3,15,2,7,3,5,
4,5,13,3,9,5,3,1,24,6,17,4,6,8,4,3,8,7,5,7,2,3,3,7,8,3,6,1,27,8,3,6,1,3,17,9,3,1,9,3,2,1,12,9,6,2,1,
6,3,3,2,6,1,5,9,4,3,2,3,9,3,7,3,5,3,4,5,1,17,7,15,3,2,1,24,14,1,3,5,6,4,2,1,3,6,6,3,2,9,3,6,4,2,1,3,
11,1,2,7,11,15,3,1,3,2,3,13,2,7,8,6,4,2,1,8,7,14,6,10,2,6,1,3,6,5,1,9,2,7,17,6,7,2,4,9,8,4,9,2,3,15,
7,8,4,2,3,10,32,4,2,7,3,17,1,27,9,9,2,3,6,10,3,12,8,3,3,7,2,1,11,3,7,6,2,7,18,5,1,2,7,5,3,4,8,3,10,
2,7,5,10,5,9,4,2,1,5,7,2,10,9,5,9,1,9,2,4,11,9,4,2,1,5,4,3,3,5,7,8,4,8,1,2,4,21,2,6,9,1,11,6,4,9,9,
2,1,17,1,2,7,6,2,4,6,2,7,8,22,3,3,3,14,15,1,9,6,6,5,4,11,1,3,2,9,3,18,3,4,2,1,2,3,7,5,3,3,7,2,1,5,1,
3,2,10,5,6,12,6,7,5,12,3,4,5,6,3,1,3,6,5,1,14,1,5,9,12,7,6,9,3,5,4,5,13,3,2,6,4,2,3,13,5,4,5,1,8,1,
5,13,5,1,9,2,3,10,6,2,3,4,6,5,1,9,11,1,5,22,2,10,5,19,2,7,6,5,1,5,1,2,1,5,7,5,4,3,3,5,3,9,3,9,13,15,
3,8,6,4,2,3,7,18,5,16,11,19,6,2,7,5,4,2,4,5,10,5,1,8,10,30,6,3,2,9,9,1,6,5,1,12,3,5,7,3,2,1,2,4,3,5,
3,3,7,3,6,3,2,15,15,9,1,9,2,9,3,15,3,3,1,14,7,8,1,9,5,4,2,1,2,3,3,4,2,9,4,6,20,1,6,3,2,19,6,3,5,1,3,
8,3,19,2,10,3,5,1,12,5,3,1,15,8,3,7,2,3,13,18,9,2,4,2,12,10,2,1,2,6,6,6,3,19,2,6,3,6,6,7,2,6,3,4,15,
12,5,1,9,8,3,3,1,5,4,11,3,1,2,7,5,3,3,1,11,10,3,15,2,3,7,2,10,11,6,15,3,1,9,5,3,4,5,4,5,7,5,9,9,4,3,
5,7,2,3,1,2,4,9,5,1,3,3,12,2,3,1,5,6,1,17,3,13,15,11,10,3,18,8,6,1,2,3,3,6,1,9,11,7,3,12,2,25,8,1,6,
8,6,4,12,6,8,9,12,4,2,3,1,3,6,6,8,6,9,7,3,2,1,2,6,1,5,6,9,1,3,2,9,3,3,4,6,2,1,2,3,1,3,2,1,2,6,10,2,
7,3,23,4,20,1,6,8,1,2,4,5,1,17,10,8,7,11,4,2,6,12,1,9,5,12,15,1,12,5,13,17,1,2,4,9,5,1,8,1,2,7,6,5,
9,3,24,4,2,3,6,6,7,5,3,3,7,3,6,6,9,5,1,12,3,2,3,3,12,15,7,2,3,13,2,1,2,7,2,4,15,5,4,2,9,6,4,5,7,14,
3,15,6,16,8,3,3,4,3,27,3,9,3,8,3,1,6,2,12,1,3,5,1,5,4,5,1,11,15,3,4,2,4,2,4,8,1,5,9,3,7,6,12,3,6,6,
14,13,3,12,2,6,3,1,18,2,3,6,10,9,3,2,3,9,1,5,10,9,5,6,7,6,5,10,11,1,3,5,1,3,2,3,3,9,1,18,11,4,15,5,
1,14,7,5,12,3,4,5,9,4,2,1,5,9,3,10,3,8,7,17,3,4,5,3,3,3,1,3,2,1,5,7,2,6,4,3,6,2,3,1,6,2,1,2,4,5,1,
14,1,15,8,1,3,11,9,7,3,21,5,1,3,3,9,5,9,4,5,6,1,5,19,2,7,6,2,3,7,18,6,5,4,6,5,3,12,6,7,3,2,7,5,6,4,
8,12,1,2,1,5,15,7,23,9,3,9,3,1,9,6,6,5,3,21,1,3,3,8,4,3,8,9,7,11,4,6,2,1,2,10,3,5,6,4,2,12,3,7,2,1,
5,9,15,4,5,4,3,15,2,12,1,5,3,7,8,1,5,4,5,6,13,6,5,1,11,4,5,1,8,12,7,2,3,3,27,1,2,4,3,6,5,1,11,4,3,
20,1,12,8,6,1,3,11,1,3,6,3,2,10,3,3,5,3,4,5,6,1,11,3,1,5,13,2,1,3,5,6,3,10,11,7,2,1,5,1,21,2,3,4,3,
2,10,6,17,10,8,3,1,9,11,1,3,14,1,2,3,7,2,10,23,9,4,2,7,6,5,1,6,3,12,2,3,4,11,18,7,3,11,6,3,7,8,1,6,
14,4,2,4,3,2,9,4,11,4,2,3,15,6,1,9,6,6,9,6,9,3,2,1,2,3,7,2,18,3,27,3,3,4,5,6,7,2,1,5,1,3,11,1,14,7,
3,2,4,18,3,2,3,12,12,1,2,1,6,5,19,2,13,14,1,5,9,21,7,5,10,8,1,3,3,3,11,10,3,5,3,10,2,1,6,3,5,1,5,1,
11,7,5,6,6,1,5,7,6,2,7,2,4,5,1,9,6,5,15,1,3,12,5,4,5,1,5,9,3,12,3,1,9,5,1,6,3,3,9,18,3,2,7,6,3,5,7,
5,7,15,3,5,3,10,6,9,11,6,4,3,2,6,7,2,21,15,4,14,6,3,3,3,4,5,10,6,2,9,3,7,5,3,6,1,9,2,4,8,1,5,7,2,6,
16,3,3,3,2,7,2,6,4,3,6,5,4,5,1,5,4,2,1,2,15,10,2,3,3,3,1,9,11,1,2,7,21,8,6,3,6,1,5,4,20,15,4,2,6,4,
9,2,4,3,3,5,3,1,3,5,1,5,12,9,9,1,3,3,8,9,3,4,3,8,4,8,3,3,6,3,1,6,8,1,6,5,1,2,12,13,5,7,5,3,18,12,1,
27,5,7,8,3,10,6,5,3,6,1,6,2,13,2,7,5,3,1,2,3,1,5,1,8,6,9,9,7,8,1,9,3,14,1,2,1,5,6,10,6,2,3,3,10,11,
1,2,10,8,12,1,2,3,1,21,3,2,9,3,6,4,2,1,3,9,3,12,2,9,9,1,5,1,20,1,5,15,4,9,11,1,5,4,8,6,15,4,3,3,5,6,
3,1,9,2,15,4,5,7,2,3,4,15,3,5,7,9,5,9,3,4,11,4,3,8,13,11,6,3,4,6,5,10,5,10,9,2,6,9,16,2,1,9,2,3,6,4,
3,3,5,4,11,6,1,3,2,7,5,10,2,1,14,1,5,4,9,6,3,8,4,3,5,12,3,6,4,2,1,2,10,15,2,6,7,2,4,2,10,5,12,12,6,
4,5,6,10,3,2,3,4,2,10,23,10,5,12,1,5,3,4,3,9,5,1,5,3,7,9,8,1,14,7,3,2,1,3,14,1,2,3,1,6,2,30,1,2,7,6,
6,3,6,2,10,8,6,1,9,3,5,12,16,5,13,2,3,7,3,2,7,2,9,7,3,5,1,3,2,1,5,3,10,2,12,3,22,5,1,5,16,14,1,3,2,
6,7,6,12,5,15,4,3,3,2,1,6,5,4,17,7,2,3,6,1,5,6,9,4,9,6,2,4,9,5,7,9,6,2,6,4,8,3,6,6,9,13,5,1,9,6,6,
20,3,10,2,3,6,1,5,4,5,7,2,3,7,2,3,7,3,3,5,12,6,1,6,5,4,21,12,5,1,11,3,1,2,4,9,2,19,5,1,3,2,4,3,2,3,
10,6,9,5,10,2,6,4,11,13,6,6,2,1,2,4,8,7,18,2,3,3,7,2,4,5,19,12,6,5,7,2,6,4,3,2,1,3,9,12,3,2,16,9,5,
1,9,5,6,15,4,6,5,3,7,3,2,4,3,2,10,21,2,6,6,3,1,27,5,10,3,6,3,11,21,1,2,7,14,1,11,10,5,3,9,3,13,9,5,
1,11,3,1,6,5,3,6,1,3,2,10,5,6,10,5,13,2,10,12,3,14,3,3,7,11,6,4,15,2,4,3,2,3,1,14,3,3,4,3,3,5,1,5,6,
3,1,3,5,3,3,4,8,9,13,5,1,9,3,3,5,4,3,2,18,4,5,10,11,3,9,12,6,7,3,23,6,1,3,14,3,3,7,8,6,1,5,4,8,1,9,
8,7,2,10,5,3,6,1,3,2,13,6,2,3,6,1,9,3,6,6,3,3,2,3,3,10,5,1,14,1,6,14,4,2,9,4,14,1,2,3,4,3,5,12,15,1,
6,3,23,3,6,1,2,10,2,6,3,12,10,8,1,5,4,5,1,5,1,2,3,4,5,6,7,6,6,11,3,4,8,3,1,3,21,9,3,2,6,6,1,3,17,7,
2,3,1,2,10,14,3,7,9,11,1,8,10,2,3,4,2,4,11,3,1,5,4,5,1,2,3,7,14,3,1,2,7,11,1,5,1,14,18,6,7,2,6,4,3,
3,12,5,19,6,17,3,4,8,1,9,8,3,4,2,16,9,3,8,4,3,6,2,3,4,6,11,3,10,12,6,8,1,5,6,9,6,3,1,3,6,12,2,15,3,
3,7,2,1,5,10,5,1,6,8,4,5,6,4,3,3,12,2,3,4,8,3,13,5,15,1,5,1,3,2,3,1,3,12,3,3,3,15,20,7,2,10,2,3,6,6,
1,8,7,27,15,6,2,4,3,11,1,6,9,9,2,4,15,5,1,8,7,3,11,16,5,4,5,9,1,8,13,2,3,4,3,2,18,3,4,5,16,9,3,2,3,
1,14,1,5,4,2,3,6,12,9,10,5,10,3,5,6,1,15,8,7,3,2,1,9,6,3,5,6,3,1,2,7,20,1,5,6,15,1,3,5,9,3,3,1,3,6,
5,16,9,14,1,5,6,16,3,2,12,7,3,6,2,13,15,2,4,3,5,3,10,2,6,7,8,1,8,7,3,2,6,10,3,6,8,1,15,11,4,6,6,2,1,
2,4,3,21,9,2,4,2,4,3,5,7,3,6,5,4,2,3,1,6,9,5,1,3,2,1,27,8,9,3,1,2,12,3,9,9,9,1,2,4,3,2,9,12,10,3,6,
9,2,7,5,3,3,4,2,16,2,6,7,2,7,6,14,6,4,5,3,1,2,10,8,1,3,5,6,1,14,4,2,6,7,11,4,2,15,6,3,10,11,1,8,6,6,
7,17,1,8,4,6,2,9,3,6,1,3,3,5,18,6,10,5,1,9,6,5,10,2,21,15,7,2,6,1,6,3,17,3,4,3,3,9,2,3,1,2,18,12,4,
5,3,7,8,3,3,4,8,7,3,3,9,2,1,17,3,3,1,6,3,2,3,1,14,1,8,10,3,14,9,7,2,3,34,3,2,1,2,6,15,15,4,2,1,8,4,
12,5,6,12,6,9,15,1,6,3,5,3,7,11,4,2,1,12,2,19,5,4,5,1,5,7,3,5,9,6,6,9,6,10,11,4,6,2,6,1,5,10,8,7,3,
2,1,9,9,5,9,1,2,7,11,1,6,3,9,2,1,8,6,1,2,1,5,9,7,11,13,6,5,4,2,3,1,3,3,2,3,7,5,1,6,5,13,2,9,1,3,2,6,
7,12,3,6,15,6,5,4,14,3,3,6,1,8,4,20,1,17,7,3,5,7,5,1,12,3,6,11,3,12,7,6,2,7,5,3,7,5,7,6,2,13,3,5,4,
3,2,3,4,5,6,3,7,2,1,2,7,2,4,9,3,5,4,5,1,9,5,4,2,4,3,2,3,6,7,14,1,2,7,14,1,3,17,1,8,1,8,3,3,6,1,8,4,
17,1,14,4,5,1,9,2,3,4,23,3,1,6,5,3,4,2,1,3,15,24,5,1,14,1,6,6,2,3,12,3,4,3,2,4,5,10,6,11,3,12,9,9,1,
6,3,2,3,7,2,3,3,7,12,3,2,3,12,3,4,8,6,9,15,3,7,3,2,13,5,3,7,3,20,4,3,5,7,3,14,3,7,6,12,2,9,9,1,2,18,
1,8,3,4,3,5,13,5,3,4,17,6,3,6,3,1,11,3,3,13,2,7,3,8,1,5,3,6,15,1,3,2,16,3,11,4,2,7,6,11,1,8,6,1,2,
10,3,8,1,5,4,12,2,7,3,15,6,2,3,1,3,2,3,6,9,6,4,2,3,7,9,2,22,2,4,12,15,2,1,11,4,6,11,3,7,3,2,3,9,3,7,
11,4,5,22,6,17,6,6,9,6,1,5,18,4,5,6,1,20,13,3,9,3,2,1,3,2,10,3,2,9,3,1,9,3,2,6,7,3,5,9,1,12,2,3,4,5,
13,5,12,9,1,3,6,5,4,17,1,9,8,3,3,6,4,5,4,3,3,14,7,6,9,3,12,5,6,4,5,3,7,9,2,12,1,6,3,2,4,5,22,2,6,1,
20,6,10,8,4,2,3,7,3,5,7,3,5,6,7,3,6,8,10,2,6,3,6,6,9,10,3,2,3,1,2,10,3,2,10,2,22,3,3,8,1,3,15,3,5,4,
3,5,1,5,10,2,7,2,1,3,14,6,1,5,9,1,6,3,9,8,7,2,3,1,12,2,1,11,1,2,6,10,5,19,3,3,17,9,10,3,3,3,11,3,7,
5,13,2,9,1,9,5,6,1,5,4,8,3,3,4,3,9,3,2,4,17,3,6,13,3,5,13,2,9,10,8,1,5,1,9,5,6,18,7,6,3,2,3,4,6,2,7,
2,3,1,5,4,5,1,5,6,15,3,1,2,10,5,4,9,2,9,1,5,4,18,5,7,3,2,9,1,5,10,8,6,6,4,5,4,2,3,15,1,6,6,14,3,1,5,
7,3,2,9,3,3,4,3,17,13,11,4,15,6,6,5,6,9,3,3,10,8,16,14,4,3,2,3,3,4,3,8,1,5,3,1,5,19,8,12,1,6,11,12,
1,6,8,1,5,6,13,2,13,2,1,12,3,2,16,5,7,3,2,3,1,6,30,5,15,7,2,1,12,2,9,9,10,21,2,3,4,2,1,9,3,2,19,2,
12,15,7,6,3,12,9,3,5,3,3,6,1,3,2,3,4,5,7,8,1,2,10,8,4,6,11,1,8,4,5,6,6,4,5,7,18,6,3,5,3,4,3,2,1,20,
3,1,14,19,3,9,3,2,9,7,9,3,12,5,1,15,18,11,1,2,1,2,15,10,9,3,3,3,6,9,5,4,2,6,9,4,15,2,12,1,2,7,6,6,5,
9,1,8,7,14,1,11,3,4,3,3,2,9,9,15,4,2,15,4,5,6,3,7,3,3,5,3,6,13,6,5,4,18,2,1,5,9,7,5,10,3,3,5,12,1,6,
5,3,3,10,3,11,9,6,6,3,19,8,7,3,3,17,3,4,8,3,7,2,21,6,10,5,4,9,3,5,4,5,4,2,4,3,5,7,5,1,2,7,6,2,1,14,
6,6,1,15,2,3,9,9,1,3,8,3,6,1,15,2,1,6,3,11,4,6,2,3,16,9,9,3,14,1,8,7,2,1,9,2,9,1,5,1,5,9,3,1,2,7,8,
3,9,12,10,6,9,3,3,5,4,9,5,12,9,3,1,5,4,3,12,6,5,6,1,3,9,5,3,7,6,14,18,3,1,3,6,2,10,9,11,3,4,11,4,11,
4,2,1,9,9,12,3,9,5,12,3,6,7,2,3,3,4,17,1,12,2,6,4,6,12,3,2,1,11,9,1,8,13,5,3,4,5,15,1,6,6,8,9,6,1,5,
3,1,12,5,10,3,2,3,6,4,6,5,3,3,12,7,3,2,4,5,15,1,3,12,3,8,7,12,3,2,3,7,6,12,3,2,6,9,7,5,1,8,7,3,9,6,
2,9,4,2,3,4,3,3,6,8,13,3,2,9,19,9,6,14,10,8,4,20,1,5,3,6,16,8,4,2,1,2,7,11,3,1,3,11,7,3,15,11,1,14,
4,11,3,7,3,6,2,4,9,5,9,6,1,6,9,6,2,7,3,6,12,3,15,9,3,3,12,2,1,11,1,9,5,1,2,10,8,9,1,5,12,6,12,3,1,3,
3,9,11,4,3,2,1,8,4,2,15,3,7,5,3,3,10,2,1,5,4,5,6,1,5,1,3,12,5,3,1,6,5,7,8,13,5,1,3,6,9,5,6,7,5,4,5,
10,3,2,6,3,6,3,1,2,9,9,15,1,3,3,8,1,5,1,5,4,5,1,8,12,10,2,1,30,11,1,2,6,1,9,5,4,2,10,6,12,5,1,11,3,
3,10,3,5,1,5,9,7,8,1,11,4,5,15,6,4,3,5,3,3,1,3,5,12,10,9,12,2,3,3,1,3,2,1,8,4,20,6,1,11,3,7,15,2,1,
2,9,3,3,7,2,4,17,12,3,7,3,5,9,4,6,6,2,1,9,2,3,16,5,19,5,7,11,12,1,5,6,3,15,3,7,11,6,1,3,2,4,3,6,5,
15,1,3,6,5,1,8,1,2,7,11,1,3,17,15,10,6,2,3,3,1,9,6,6,12,2,1,2,3,10,3,5,7,17,1,2,7,11,1,5,3,13,3,2,9,
10,3,3,8,4,5,3,4,3,6,2,4,6,3,9,3,2,1,11,3,3,4,8,3,4,3,3,5,7,6,2,18,1,6,2,6,7,2,12,3,1,11,6,7,2,1,3,
14,1,14,1,17,7,5,1,5,1,11,7,2,1,5,9,6,12,18,3,4,3,5,3,6,4,5,9,10,3,2,7,26,7,2,4,2,7,5,1,2,3,6,1,8,1,
20,9,6,1,3,12,2,15,1,9,3,3,5,1,8,7,5,18,3,3,12,7,5,3,4,9,5,1,6,2,1,2,4,3,11,9,1,5,15,1,3,3,3,11,4,2,
4,29,4,2,1,2,6,9,3,10,2,7,20,28,6,5,1,3,2,3,13,3,9,3,5,3,6,4,14,1,6,3,5,3,3,4,6,9,6,5,1,5,1,3,2,12,
3,13,9,2,6,9,4,20,6,9,7,3,2,3,4,3,27,12,15,3,5,1,11,1,8,6,3,1,2,19,3,2,13,8,7,2,3,3,3,1,3,5,7,8,13,
2,1,11,1,14,1,8,7,2,10,5,1,6,6,5,4,6,3,6,9,2,7,11,4,3,8,10,14,3,4,11,10,14,1,3,5,1,11,3,1,11,12,1,6,
5,4,12,2,3,7,3,8,9,1,5,4,8,9,4,11,1,2,3,7,15,3,2,3,19,5,6,3,4,5,10,11,6,1,2,16,9,8,4,3,2,10,5,1,3,5,
6,10,9,11,4,2,7,5,3,19,3,2,1,2,6,7,5,10,5,4,6,14,4,6,8,1,9,6,5,1,6,3,5,6,3,13,2,3,4,9,2,3,4,5,1,2,4,
5,3,13,2,3,7,2,4,6,6,8,1,5,1,12,2,1,14,43,2,4,11,9,1,5,9,10,5,4,2,4,6,3,30,5,1,6,6,2,1,5,19,6,5,9,3,
4,5,24,1,8,15,10,2,1,9,5,9,19,6,2,4,9,2,4,5,9,6,3,1,2,4,6,2,6,4,3,8,16,8,1,9,3,5,4,23,6,1,6,14,1,12,
2,4,14,3,3,9,6,1,3,2,10,11,3,9,3,4,11,7,2,4,9,2,3,1,5,1,6,2,3,3,6,1,2,1,6,6,2,7,3,11,1,6,15,9,8,1,2,
12,10,3,3,12,3,2,10,8,1,5,4,24,5,1,5,9,1,5,21,6,3,4,11,1,11,3,7,5,4,3,2,13,5,6,4,2,3,12,1,9,20,4,2,
3,4,6,9,12,3,18,8,6,1,9,14,6,4,9,2,1,5,9,4,12,5,13,6,5,3,1,2,4,11,7,6,5,7,3,20,9,6,4,5,7,6,2,3,4,5,
3,7,3,2,6,7,5,3,18,16,8,1,5,1,5,3,7,6,20,3,7,2,7,14,7,2,7,9,11,6,10,2,3,18,7,3,9,8,3,19,2,3,1,5,6,1,
3,5,7,2,3,27,3,9,4,9,5,1,6,14,7,2,7,5,3,10,3,3,2,9,4,2,9,9,1,6,5,3,1,9,14,3,3,1,18,2,1,5,7,2,3,7,8,
1,12,3,2,3,4,2,1,3,6,11,3,7,2,6,1,14,6,10,3,20,1,11,4,5,6,1,8,12,3,1,3,2,1,12,12,9,2,3,7,9,3,5,7,6,
5,28,2,3,12,7,5,3,7,5,3,3,7,9,6,14,1,8,4,17,6,13,2,4,6,8,1,3,5,1,5,1,6,3,6,3,5,6,1,6,8,6,1,2,12,4,9,
3,2,6,6,10,8,1,2,10,2,13,17,1,6,8,6,4,8,3,4,3,3,6,8,3,15,7,2,4,5,4,17,10,6,2,13,2,7,11,3,7,5,3,1,11,
7,5,10,2,21,3,1,5,16,2,7,3,2,6,9,1,3,2,9,4,6,8,6,1,9,12,17,6,1,5,1,5,4,5,1,3,2,12,12,4,15,2,3,1,15,
5,1,12,5,6,1,3,3,8,4,2,3,18,3,10,6,9,5,12,33,6,4,11,3,3,3,4,5,1,2,25,8,15,1,11,3,10,6,3,8,10,3,9,3,
2,1,12,2,3,7,8,4,5,6,3,6,4,11,3,3,4,6,3,2,7,2,4,5,1,14,4,2,15,1,3,5,4,3,3,11,4,6,3,5,10,5,12,1,8,4,
3,8,1,3,17,1,23,4,5,1,9,2,9,1,5,6,3,6,6,10,3,5,24,1,6,3,5,7,6,2,13,5,3,1,3,8,18,4,2,1,2,15,13,9,3,3,
14,6,4,3,3,2,3,9,6,3,9,16,2,4,6,9,5,4,11,4,11,3,3,3,1,5,6,9,4,9,23,3,1,3,2,1,2,7,6,8,6,3,7,9,2,10,2,
15,1,12,5,4,5,4,11,1,3,5,1,8,6,6,4,5,6,10,8,3,4,3,5,13,3,5,1,6,2,1,11,3,13,5,9,19,6,3,6,9,2,1,2,13,
5,7,3,9,3,11,7,12,2,9,10,6,5,3,1,21,6,9,21,5,12,6,1,18,2,3,1,5,10,2,3,7,15,14,6,4,11,4,9,2,7,20,3,9,
1,2,7,6,3,9,6,2,4,3,20,3,3,4,3,3,5,16,6,2,3,4,5,1,3,5,9,1,6,5,3,18,7,3,14,1,2,1,2,3,1,14,15,10,6,3,
6,2,12,10,3,2,7,15,5,3,7,11,15,4,3,2,6,10,9,9,24,2,3,6,7,3,9,6,9,5,6,7,8,4,2,1,8,15,1,3,3,15,3,2,3,
4,6,14,7,8,27,10,3,2,13,2,1,3,2,3,4,2,6,7,5,1,5,7,5,10,8,1,20,1,8,4,8,9,1,2,1,2,4,3,2,19,5,6,9,9,3,
3,4,11,4,2,1,5,3,4,2,10,3,2,3,6,4,3,2,1,15,5,7,2,7,3,8,4,14,6,3,1,20,1,3,6,5,1,20,6,7,3,5,3,4,2,1,3,
11,6,4,15,8,3,25,2,7,5,1,2,3,4,11,7,3,14,9,9,6,6,3,1,11,4,26,1,5,3,4,2,4,6,3,18,9,8,13,5,3,4,3,12,2,
6,3,10,9,8,4,21,2,7,8,10,3,5,3,4,2,6,15,4,8,3,19,9,12,8,1,3,3,9,5,4,12,2,3,4,9,20,1,8,6,1,6,15,2,10,
8,3,6,3,3,9,4,6,11,24,6,3,9,3,3,1,6,12,3,17,7,6,2,1,5,15,7,2,1,5,7,2,7,9,11,4,9,2,9,9,1,11,1,3,5,12,
12,3,3,1,3,6,2,9,4,2,13,5,9,15,7,6,3,2,4,11,4,11,7,8,4,8,10,3,3,5,4,2,3,7,5,1,8,12,9,1,8,4,3,3,14,3,
4,3,3,8,15,1,9,2,3,7,2,3,4,3,15,2,6,9,4,9,5,3,9,9,1,5,6,9,13,6,5,4,5,3,7,2,4,2,3,7,2,6,7,3,14,7,3,2,
1,5,3,1,6,3,2,10,14,3,13,5,7,3,3,14,1,6,3,11,12,3,9,3,4,3,11,10,6,3,2,15,4,5,1,3,3,2,12,4,2,7,5,3,4,
3,8,4,3,6,11,3,13,2,7,18,8,3,7,2,1,2,12,1,6,6,14,15,1,2,1,5,12,15,9,1,5,4,11,3,9,6,6,21,9,1,12,6,5,
9,1,2,4,5,13,6,5,1,6,3,6,6,17,6,4,2,6,3,6,1,3,9,5,3,3,7,12,2,1,15,3,2,4,6,2,12,6,3,4,2,4,14,3,3,4,5,
27,4,6,3,2,9,10,5,7,2,15,10,3,2,6,1,5,9,7,2,1,2,10,8,10,2,7,5,3,4,5,6,4,3,8,13,6,5,1,2,3,3,1,24,9,5,
1,11,6,4,6,5,3,4,3,2,6,7,5,3,4,3,5,4,3,11,4,2,10,5,4,14,7,3,11,10,2,3,4,2,3,3,25,18,2,4,3,3,3,11,1,
8,7,3,11,3,6,19,2,4,14,3,3,1,8,1,5,15,7,2,3,9,1,2,6,19,5,1,35,1,21,5,4,3,2,15,4,2,3,6,6,13,9,6,9,2,
4,5,1,6,2,6,4,3,8,6,1,15,2,1,2,12,6,4,6,6,5,3,12,3,6,4,3,5,18,4,2,6,7,5,1,14,1,6,3,2,3,1,6,5,10,8,3,
3,4,6,14,12,10,8,1,2,9,4,5,6,9,1,3,5,10,11,9,3,9,6,7,5,1,6,3,2,18,3,18,1,6,8,7,2,7,3,6,2,3,7,3,12,9,
8,6,6,1,2,3,13,11,4,11,4,9,8,4,3,5,6,1,6,8,15,1,6,5,13,11,3,1,5,1,11,13,6,35,9,16,3,5,7,6,3,9,3,8,6,
15,1,5,4,11,7,3,5,9,6,3,10,2,10,15,14,10,5,1,8,7,5,7,2,4,5,7,2,13,2,1,11,1,14,9,4,3,5,3,7,9,3,6,5,9,
1,5,6,1,8,6,1,12,2,1,9,3,2,1,5,9,3,1,17,3,12,3,1,9,6,5,3,3,4,3,5,3,9,19,2,7,2,3,1,2,7,3,2,6,7,3,6,6,
2,1,6,14,1,3,11,4,3,2,1,6,5,3,6,1,3,8,9,3,1,5,1,9,6,5,13,11,6,1,14,3,3,12,1,5,1,3,5,1,5,15,4,15,6,2,
9,1,2,3,9,13,3,3,9,2,1,3,12,24,5,4,2,7,2,18,3,18,1,3,3,8,9,6,7,9,9,2,7,5,16,2,13,6,3,2,1,17,3,4,3,3,
9,11,3,7,18,6,11,12,15,1,6,24,2,9,1,12,2,3,7,6,8,1,21,2,1,2,7,3,2,6,7,3,2,7,6,11,10,8,1,14,1,11,1,5,
7,5,7,5,9,7,2,10,8,4,8,1,5,1,14,6,3,10,3,8,1,5,16,2,3,7,11,1,3,11,6,3,1,6,6,9,3,11,1,3,2,13,2,1,3,2,
4,3,6,2,19,5,1,2,28,2,12,6,3,4,3,2,1,6,11,3,7,2,6,4,3,2,1,6,5,1,3,6,11,7,17,4,2,4,5,3,13,3,5,4,2,4,
12,9,3,3,15,3,2,10,5,9,4,6,3,15,2,3,12,3,6,6,1,5,7,2,9,4,2,6,4,5,4,2,7,11,4,3,8,7,5,3,1,5,1,5,10,5,
9,3,1,6,8,1,2,12,1,9,3,3,15,11,3,3,3,1,3,3,8,24,1,2,3,4,3,8,4,2,1,2,6,6,4,5,1,3,8,10,5,9,1,2,10,20,
12,9,1,15,5,6,3,1,3,6,2,9,3,1,9,2,3,7,3,5,7,5,4,6,11,3,9,13,5,9,3,3,4,11,3,1,3,8,3,24,3,3,9,10,6,11,
15,9,1,11,3,7,2,1,6,18,12,6,12,21,5,21,1,8,6,4,11,1,9,3,18,9,8,13,5,3,1,5,1,3,12,5,10,2,3,7,2,1,29,
13,5,1,5,6,9,9,1,20,1,6,5,7,6,2,25,2,1,5,10,14,1,12,9,3,2,4,5,6,3,1,2,7,5,1,12,12,17,1,8,1,6,5,3,4,
2,6,7,5,7,8,6,1,8,1,6,3,5,1,15,5,1,3,2,6,3,1,5,9,4,5,1,11,4,12,3,2,9,9,9,6,12,3,1,6,17,1,14,3,4,6,5,
7,2,1,8,7,3,5,9,6,6,9,4,3,3,2,7,5,6,1,6,2,1,11,3,7,5,1,17,13,3,5,7,5,4,9,6,3,5,10,3,3,11,3,1,2,10,2,
6,6,9,12,7,2,3,6,4,11,1,14,16,8,12,6,22,6,2,10,3,5,1,3,5,1,5,7,3,6,6,2,3,3,4,20,1,6,5,6,3,4,5,1,2,3,
1,6,2,21,1,3,2,3,3,9,13,12,11,4,3,5,1,2,24,1,17,6,7,3,21,3,2,13,5,1,12,3,5,6,1,3,12,2,3,9,4,2,7,8,4,
3,12,3,8,10,2,12,3,1,5,6,10,5,9,6,1,3,6,9,6,6,2,7,9,20,4,12,3,8,7,5,1,11,3,3,15,3,4,2,3,15,1,9,2,1,
8,1,9,9,3,5,4,5,3,3,10,12,23,3,1,3,3,8,10,11,1,5,18,4,5,1,12,2,1,11,3,12,3,3,3,1,3,6,5,12,4,3,6,2,4,
3,5,3,3,16,6,5,12,12,4,2,3,7,2,16,2,3,1,15,14,6,13,5,3,4,14,4,2,1,3,2,4,3,5,1,12,3,11,10,5,13,2,1,5,
3,4,2,6,7,5,1,2,7,11,4,8,3,1,5,1,8,10,2,10,2,3,7,3,12,2,3,1,6,8,3,7,3,3,2,7,2,4,11,13,3,2,3,3,15,4,
2,1,12,2,10,8,1,5,4,3,3,6,6,8,1,5,3,13,17,1,6,3,11,9,7,9,5,1,35,9,6,1,2,7,9,5,9,1,2,9,4,5,6,3,1,9,3,
5,7,2,1,5,10,3,21,9,5,1,3,3,3,14,15,6,22,3,9,8,3,9,1,2,4,5,10,6,2,1,2,3,1,11,4,3,2,4,2,9,3,1,2,7,18,
2,13,17,1,5,6,3,3,3,4,3,8,4,3,5,4,11,3,1,3,15,3,9,8,6,7,12,17,1,2,1,6,5,4,9,6,6,5,15,6,12,3,15,10,9,
5,3,3,7,5,1,6,3,2,10,6,5,7,12,3,2,4,39,15,3,2,6,6,4,5,4,26,6,6,4,5,4,2,4,3,3,5,9,4,5,10,6,3,5,7,3,3,
8,7,5,4,14,4,3,15,8,12,3,6,6,10,12,2,3,3,4,3,2,4,5,12,7,6,6,5,13,2,1,5,7,2,1,3,11,10,8,3,3,1,6,2,13,
8,6,3,1,11,1,9,3,30,6,5,1,9,9,6,12,3,5,6,1,2,7,18,2,13,5,1,2,4,8,6,1,5,3,7,6,2,1,12,2,3,3,6,1,8,4,3,
3,9,6,12,5,3,7,2,1,12,5,4,5,10,3,2,6,10,5,7,5,15,1,9,3,14,1,3,9,2,3,7,6,8,9,1,6,3,5,3,3,4,15,2,10,6,
15,2,12,4,9,6,11,13,18,3,6,5,6,7,2,6,4,5,4,9,5,1,9,2,6,3,31,18,8,3,4,3,15,2,1,2,4,8,3,10,3,5,4,5,1,
15,5,1,3,18,3,2,3,7,2,3,7,2,6,3,4,3,14,9,1,5,4,2,4,29,9,12,3,3,3,4,5,7,9,5,10,2,7,2,1,9,6,8,19,2,3,
6,1,15,8,1,20,1,6,30,14,3,1,2,3,1,3,3,9,3,5,1,5,6,1,2,7,5,1,8,10,11,3,15,6,1,3,6,2,3,4,5,15,1,12,5,
4,5,1,12,2,1,2,12,19,2,4,9,12,8,4,11,4,3,8,4,3,2,3,19,3,3,5,4,6,8,6,6,7,2,1,18,2,3,6,4,2,4,18,5,1,2,
9,1,2,13,2,3,4,8,12,15,1,17,1,15,5,4,3,2,7,5,1,2,7,5,1,2,6,1,3,15,5,10,20,3,3,4,5,7,5,4,6,3,8,7,3,3,
9,3,2,1,14,3,4,9,6,5,3,1,6,6,3,2,9,6,4,3,8,10,20,3,4,3,5,9,1,3,6,21,2,7,11,9,13,5,10,5,3,3,1,3,3,15,
5,4,3,2,6,3,12,7,3,14,4,5,7,2,10,2,1,2,6,15,7,8,12,10,2,7,5,3,3,4,9,2,3,6,1,14,3,6,1,5,1,2,3,4,23,1,
2,4,3,11,7,5,7,5,15,6,1,6,2,3,4,6,3,11,4,9,6,9,3,18,12,2,1,20,7,15,9,3,18,9,6,14,4,2,12,7,3,8,13,6,
5,9,19,3,3,6,5,1,2,10,3,2,3,3,10,9,2,19,2,3,4,6,11,1,2,1,11,4,6,3,8,15,7,2,4,17,3,7,2,1,2,9,3,6,7,9,
3,2,3,10,2,1,15,2,3,13,6,6,3,6,3,2,15,4,5,6,1,5,3,15,6,3,3,7,8,7,6,5,7,2,7,8,6,1,20,6,3,30,9,7,3,6,
11,1,2,1,2,4,5,10,3,2,9,4,23,3,7,2,3,7,3,3,5,1,18,2,1,2,7,3,3,15,3,2,4,11,4,3,12,3,11,10,5,1,3,2,3,
3,4,23,12,3,1,6,6,2,12,3,21,4,21,5,7,3,9,11,1,9,2,9,1,3,6,9,2,7,8,15,7,2,1,9,3,6,5,4,5,6,6,9,1,14,9,
7,3,8,9,1,3,11,3,6,4,17,15,1,5,3,7,5,13,2,7,3,3,6,8,3,7,5,6,1,21,2,7,6,5,7,2,4,2,3,7,2,1,6,14,1,3,6,
5,1,5,1,3,15,2,9,6,13,14,7,9,6,8,1,2,12,1,5,6,10,3,2,13,3,3,5,6,1,14,6,3,4,3,3,12,2,12,3,25,2,1,8,6,
3,3,7,5,1,2,3,1,21,2,7,6,2,13,5,4,3,6,9,6,17,3,7,2,12,1,9,5,3,1,9,2,10,6,5,7,5,1,14,7,3,6,2,7,5,1,
11,1,3,5,6,6,13,2,10,9,9,2,3,7,5,7,2,3,6,7,8,6,9,7,14,4,21,3,3,2,1,2,3,1,5,4,20,1,14,4,2,1,5,3,4,2,
3,10,12,6,2,1,5,16,11,3,21,1,14,6,7,2,18,7,3,11,12,4,8,3,7,8,3,10,2,4,3,6,9,3,2,13,2,1,5,1,11,18,4,
8,9,1,9,8,10,6,2,3,4,5,12,4,5,1,5,1,12,3,8,4,2,1,3,6,11,10,2,6,10,6,5,1,14,3,16,2,3,4,3,3,2,4,11,12,
15,7,11,3,6,3,3,4,5,13,2,3,10,8,10,2,13,3,6,5,3,3,4,5,1,9,3,15,3,9,3,8,15,28,2,3,4,2,3,6,15,9,7,9,5,
7,5,4,20,4,5,4,5,18,9,3,1,6,5,4,2,3,9,1,21,6,2,1,9,2,10,3,6,12,14,3,6,1,9,6,6,2,13,5,3,1,11,7,2,15,
3,10,11,4,11,15,6,1,5,12,6,1,11,9,1,2,1,6,3,15,5,10,2,4,5,6,6,3,12,4,3,3,5,9,4,11,6,7,5,1,6,3,2,3,6,
6,1,2,1,2,7,17,4,2,7,2,4,2,7,5,3,4,6,3,9,2,10,5,9,6,1,2,10,6,5,6,3,1,27,2,7,9,6,6,17,6,1,9,9,6,2,7,
2,10,3,3,5,3,16,15,5,6,13,5,10,9,5,7,11,4,3,5,1,11,3,6,7,12,6,2,7,2,1,2,10,11,9,3,9,9,9,1,5,9,7,5,1,
8,9,3,4,3,6,6,3,3,8,6,3,30,12,16,5,12,1,2,4,3,3,8,15,7,8,1,3,2,1,8,1,5,1,5,9,1,2,3,12,1,5,1,9,5,1,
35,9,7,3,5,6,13,5,7,6,2,1,2,3,22,24,3,2,1,8,9,1,6,11,7,6,2,12,6,1,5,13,3,8,1,3,6,5,4,3,3,2,12,6,4,
17,3,13,2,3,4,5,1,5,30,9,24,1,5,4,5,1,11,3,1,3,2,3,10,15,2,3,1,2,9,10,3,11,1,3,2,18,3,10,2,6,1,6,5,
9,13,6,14,6,7,8,1,15,5,1,2,3,9,18,1,6,8,13,2,3,4,8,13,3,2,18,6,1,5,10,3,6,8,3,4,9,2,4,5,3,7,8,7,5,1,
5,7,8,7,15,5,6,4,6,9,17,3,1,9,2,1,2,3,4,6,5,7,3,2,3,7,6,5,4,6,2,3,15,7,2,6,4,3,9,3,2,1,20,9,19,2,10,
17,3,7,5,16,2,15,12,6,1,3,3,2,7,5,1,8,6,3,3,3,4,2,9,4,2,1,20,15,12,1,2,4,3,3,3,6,6,2,6,1,6,5,3,1,5,
4,2,19,3,2,9,7,8,4,2,1,3,14,7,3,5,3,3,6,9,4,8,4,21,2,3,10,2,6,1,5,24,25,15,2,10,2,3,3,1,3,26,4,5,6,
1,3,3,5,3,6,1,20,10,2,6,4,2,10,6,3,17,4,3,6,15,9,2,3,1,14,6,1,8,6,9,3,4,3,11,1,5,1,12,2,3,12,4,12,5,
7,3,3,5,1,5,3,6,1,3,2,1,9,3,2,6,3,10,2,13,5,7,5,4,5,1,3,15,5,1,11,10,3,14,1,6,5,6,7,11,4,23,4,5,3,3,
7,2,1,12,2,1,3,14,6,4,5,3,13,6,5,4,5,1,3,21,9,3,2,3,4,11,4,8,1,2,4,9,5,7,2,15,6,4,2,1,8,12,4,8,1,2,
3,10,2,3,1,5,1,3,5,12,12,6,1,9,9,2,13,5,3,7,5,1,11,4,5,10,14,6,4,15,3,17,6,1,8,10,2,1,14,1,14,1,2,
12,4,5,12,4,9,17,12,6,7,3,5,6,1,5,4,3,3,8,4,3,2,1,15,6,3,5,3,7,3,2,1,6,5,6,4,15,5,4,5,6,3,10,11,7,5,
3,7,2,1,5,1,8,12,1,8,4,6,5,9,7,3,5,1,12,12,2,9,6,4,2,3,1,8,7,3,2,13,15,5,1,5,7,3,6,3,3,2,12,4,6,3,8,
9,13,2,4,2,7,2,4,2,7,6,2,7,2,1,8,10,2,4,3,5,3,7,3,8,9,1,2,12,6,1,15,5,1,2,7,8,12,3,7,3,2,4,12,2,3,
12,21,1,9,6,6,8,6,19,2,3,6,4,11,6,15,3,1,6,2,6,7,2,6,16,3,2,1,5,3,7,9,3,20,16,5,1,5,1,2,3,10,2,16,
11,1,12,5,3,3,7,2,1,5,1,5,3,12,6,4,3,8,3,7,3,5,10,2,15,12,3,4,8,6,12,3,1,3,18,8,6,1,5,7,11,10,2,7,2,
1,9,5,1,9,6,2,7,3,15,2,4,6,5,3,21,4,3,2,1,5,1,18,2,1,5,3,10,5,9,16,5,9,12,9,9,3,4,5,10,3,8,10,2,1,9,
6,2,19,6,2,28,8,7,14,4,2,7,5,3,4,3,6,11,3,25,2,6,3,4,3,17,3,9,9,1,3,3,9,38,7,5,13,5,3,4,8,1,2,4,8,3,
3,4,3,23,6,3,6,10,2,3,7,12,6,6,3,11,6,1,3,5,12,4,6,5,3,4,3,3,9,3,5,9,3,1,9,6,5,4,6,5,1,11,4,3,5,21,
6,3,7,5,16,5,3,7,2,16,5,6,1,5,7,2,4,5,27,4,3,5,7,20,4,11,3,3,7,6,11,3,7,9,5,7,2,1,2,10,2,6,7,2,1,6,
5,1,5,4,6,3,9,2,19,2,4,3,8,7,6,11,1,3,9,3,8,12,7,6,21,6,5,4,5,4,17,3,6,3,3,3,6,1,8,4,5,1,6,5,9,1,14,
7,2,12,4,6,3,3,2,3,9,16,3,2,4,9,2,4,6,2,1,9,2,3,7,9,2,7,8,4,11,13,2,12,10,3,29,6,7,5,18,9,1,5,4,9,2,
4,3,21,5,6,6,3,9,6,4,6,11,1,3,11,4,2,3,9,13,2,6,1,5,6,7,3,2,7,5,16,5,7,15,18,3,11,3,1,2,15,7,8,7,2,
13,2,13,3,5,4,3,3,15,3,5,6,3,6,7,3,11,1,20,7,12,5,10,6,2,3,3,4,3,8,4,8,3,16,3,8,13,2,13,14,1,5,9,12,
1,3,9,2,10,5,10,15,6,8,7,14,1,8,1,3,15,5,12,3,1,2,4,9,12,8,6,6,4,3,2,9,1,3,2,6,13,6,5,4,9,11,1,5,3,
1,14,10,3,9,5,1,12,3,12,6,6,15,3,2,18,3,3,15,1,3,6,2,3,6,6,9,18,1,2,3,7,2,1,6,5,1,2,1,9,5,6,1,5,4,5,
9,3,13,5,9,1,20,1,6,2,1,20,12,9,3,7,3,2,3,10,5,3,3,4,12,5,6,15,3,10,5,21,3,1,12,2,16,5,1,11,9,13,11,
4,2,1,2,10,2,3,7,3,3,3,11,10,11,7,3,8,15,4,35,3,4,5,4,6,8,1,2,7,5,3,3,1,9,15,2,4,3,2,9,1,14,6,4,6,6,
2,1,6,5,3,10,2,15,3,1,2,7,6,6,11,7,6,5,7,3,2,3,4,8,7,18,9,3,8,3,1,8,1,2,4,8,1,6,5,6,3,6,6,4,3,3,8,7,
5,13,9,15,3,14,13,2,6,4,5,1,20,4,5,3,6,9,1,12,2,7,6,2,12,6,7,3,3,2,7,15,5,6,4,3,3,5,9,1,14,1,2,3,9,
7,3,2,9,4,2,1,2,10,5,1,5,7,3,5,4,2,10,5,4,11,3,7,3,2,1,5,3,6,3,1,2,13,2,3,1,18,3,30,9,3,2,6,3,4,6,
14,13,18,6,5,3,10,3,9,3,2,4,2,9,4,2,4,5,13,11,1,20,1,8,4,3,5,3,7,3,5,12,25,2,3,4,3,6,5,6,13,5,7,6,3,
2,7,2,15,9,1,6,2,1,5,4,2,1,2,6,6,1,3,17,24,13,6,5,1,3,3,2,3,4,29,6,1,12,2,1,3,5,4,3,3,6,5,10,11,4,3,
5,33,3,1,5,1,17,3,4,5,3,6,4,6,14,1,5,9,7,3,8,9,1,15,2,1,6,3,15,3,2,1,2,3,4,5,13,12,5,3,7,2,9,12,9,9,
16,5,1,2,15,1,5,4,2,6,3,6,1,8,4,3,17,1,2,7,5,6,1,5,1,15,2,1,24,11,10,2,9,3,3,3,4,5,1,6,3,6,5,7,8,9,
12,16,3,6,8,3,10,2,15,7,6,3,12,2,6,10,14,3,9,21,3,4,2,1,3,12,8,1,8,3,7,3,15,3,6,5,3,3,7,5,1,6,8,1,5,
9,6,1,5,1,12,6,2,13,2,9,28,2,3,1,5,6,1,2,3,3,7,2,3,4,6,5,3,6,3,1,11,3,7,11,10,3,5,1,11,3,6,6,7,11,7,
2,1,14,6,16,6,2,15,6,1,8,7,18,3,2,1,11,21,3,1,3,2,1,3,27,8,1,9,12,3,15,6,8,3,4,3,5,6,1,15,6,8,1,9,2,
9,3,10,2,4,6,6,3,6,5,3,12,4,2,3,4,5,12,4,2,19,11,3,7,3,6,3,3,9,5,6,7,18,3,5,6,6,4,3,6,2,18,4,3,8,6,
3,6,4,3,8,6,13,8,9,16,3,6,5,3,6,1,5,4,9,2,9,4,8,15,7,12,3,5,1,5,10,5,7,5,3,4,2,1,2,25,2,1,2,7,8,3,
12,1,5,4,17,1,2,1,2,9,1,5,22,2,13,2,9,7,3,2,3,7,2,1,20,6,1,9,5,1,3,5,4,17,6,3,4,12,6,8,1,8,1,5,1,14,
6,4,5,10,6,9,15,6,5,1,3,6,8,3,3,6,3,3,7,18,12,6,2,10,3,2,4,14,7,3,5,1,8,7,5,13,8,12,3,12,10,5,6,1,8,
6,9,3,9,1,5,10,2,12,10,8,1,2,9,15,4,6,5,3,3,3,4,3,3,11,3,22,6,8,4,3,3,5,7,2,1,2,10,14,15,1,2,3,12,3,
24,10,8,13,14,4,2,9,1,9,8,3,3,4,5,6,1,8,6,6,1,9,3,5,7,9,2,30,4,3,5,3,3,4,6,6,11,3,4,2,1,8,4,2,9,6,1,
2,12,3,1,6,6,2,3,3,1,8,1,11,1,5,4,11,3,4,6,5,7,23,4,15,11,10,2,10,27,2,13,6,2,10,5,13,6,8,10,3,5,7,
2,4,21,8,1,2,4,6,5,9,3,12,9,1,3,2,10,3,2,6,3,12,13,5,1,3,8,4,3,2,4,5,15,1,3,2,1,8,10,9,2,3,3,4,5,3,
1,9,5,15,15,3,9,1,2,7,3,8,10,2,1,15,6,3,3,3,5,6,1,2,7,5,1,5,3,12,3,1,11,3,7,12,5,22,6,15,2,3,3,7,2,
7,5,4,5,7,2,3,7,5,1,2,4,3,8,13,6,11,4,11,10,3,2,3,7,5,13,5,9,6,4,6,5,9,1,2,4,11,3,1,5,6,7,2,3,1,21,
6,3,2,4,3,5,6,6,1,3,2,3,1,3,2,9,7,3,9,2,3,1,24,3,17,1,5,6,1,8,1,11,7,15,6,2,7,2,4,6,3,5,3,7,3,3,20,
7,5,4,3,3,3,9,8,4,5,6,3,1,8,6,1,6,2,6,7,2,1,2,19,9,2,7,2,4,11,3,16,6,5,1,2,15,7,18,3,5,10,5,13,5,7,
9,3,2,1,3,14,6,4,3,8,6,1,5,9,19,2,3,1,9,5,4,11,1,8,1,6,5,6,7,6,14,1,11,19,14,13,9,14,1,3,6,2,3,9,3,
4,8,1,5,4,6,15,5,6,1,5,9,1,8,1,6,5,13,2,7,2,4,2,4,9,5,4,2,1,9,6,9,8,12,4,5,30,10,5,6,1,2,6,1,9,6,3,
8,4,9,2,10,2,7,3,18,2,3,18,1,11,3,1,5,6,3,4,6,12,9,8,1,9,5,21,22,2,13,12,3,2,7,5,9,1,3,8,3,6,3,1,14,
6,7,5,13,9,2,10,3,5,7,6,5,10,3,6,9,5,1,15,5,1,12,12,5,4,2,12,3,4,5,3,7,5,3,6,9,12,1,12,17,24,1,6,15,
2,12,1,8,1,6,5,9,10,5,4,6,8,6,7,2,13,2,1,6,3,3,2,7,18,5,1,2,7,20,6,10,20,1,3,17,4,5,4,2,10,11,3,7,2,
1,2,10,15,2,6,9,30,7,5,9,1,15,3,2,1,8,1,14,7,5,7,11,7,12,8,3,7,9,5,4,5,6,3,7,3,2,1,2,3,4,3,11,10,6,
5,3,3,12,1,2,4,5,1,9,11,24,13,2,1,2,3,13,6,8,1,5,1,3,12,8,1,5,7,8,12,3,7,5,15,4,3,3,5,3,10,6,5,4,2,
3,1,11,7,2,6,3,12,7,5,7,8,6,1,3,5,1,5,7,2,1,2,15,4,3,6,11,4,6,3,21,6,3,2,9,6,10,5,1,15,8,9,1,14,6,
10,14,21,1,3,18,3,2,10,3,2,7,2,6,3,9,7,5,3,7,20,1,5,3,10,12,12,2,16,2,1,2,9,1,18,11,3,6,1,5,9,4,12,
8,6,9,10,2,16,5,3,4,5,10,2,9,7,5,7,20,1,5,6,15,13,3,2,13,3,2,3,19,2,3,6,4,11,10,6,5,3,1,12,2,6,4,11,
7,5,18,9,7,6,3,11,9,1,3,3,5,3,4,6,11,1,3,2,12,3,27,1,5,1,5,1,2,6,4,15,17,1,5,9,4,12,5,7,2,1,8,1,23,
3,4,3,2,1,5,3,12,7,8,12,7,3,3,2,7,6,3,6,6,9,6,3,11,4,29,10,11,19,8,4,5,13,6,6,21,5,3,1,5,3,13,2,6,7,
2,7,5,15,15,3,1,9,3,9,5,9,15,4,2,1,2,10,2,4,5,6,3,1,20,1,6,3,2,3,16,5,3,1,2,4,5,10,3,3,5,3,4,5,7,3,
12,8,3,4,5,4,11,1,3,2,12,10,3,8,6,6,4,3,2,9,10,5,1,8,13,9,18,6,5,4,8,4,5,6,3,7,2,1,9,6,11,4,6,14,4,
2,6,3,9,1,2,7,11,1,9,2,3,9,12,13,3,2,13,8,6,3,16,9,5,10,2,4,11,15,1,2,3,4,6,5,7,5,16,2,7,5,13,2,1,
14,3,3,1,5,10,14,10,6,3,2,4,2,7,5,6,4,5,7,6,5,4,15,9,5,6,1,9,3,8,13,2,10,2,12,6,3,1,3,8,3,7,18,2,7,
5,3,7,11,4,2,3,12,1,2,1,5,7,8,6,4,2,9,4,6,9,2,12,3,3,24,1,2,4,6,2,16,11,3,1,2,9,4,21,6,2,18,3,6,6,3,
4,17,10,8,1,5,4,8,4,5,9,9,12,3,6,4,3,3,2,10,3,14,7,9,6,6,3,5,6,1,5,3,7,15,5,3,4,15,8,7,5,6,1,5,3,1,
5,7,12,5,7,14,4,3,12,11,10,2,3,1,5,10,6,5,4,3,3,2,3,9,1,14,1,14,4,6,6,5,3,10,11,1,2,10,3,8,1,3,11,4,
2,1,18,2,4,6,2,6,4,2,10,8,6,16,5,1,5,7,2,3,3,12,7,3,3,2,3,10,2,6,1,5,4,6,6,5,3,1,6,8,24,1,5,7,5,4,9,
5,9,7,5,1,12,2,13,8,7,2,6,3,15,10,14,7,3,8,3,7,3,11,3,1,2,7,6,2,4,9,5,1,6,9,20,6,7,2,4,2,3,4,6,9,2,
4,12,8,1,8,13,3,5,4,5,3,3,22,2,3,7,12,6,2,22,9,5,6,10,21,2,7,5,4,5,1,8,6,4,2,3,15,3,3,9,3,3,10,2,19,
5,16,12,12,5,1,9,5,1,2,12,4,2,3,4,15,2,3,3,3,7,12,3,2,1,12,5,4,6,2,12,1,14,1,2,1,30,6,3,6,5,10,5,6,
3,3,4,9,11,3,7,11,10,8,7,3,6,6,5,22,2,9,6,4,6,3,5,1,9,11,9,1,12,2,3,4,15,3,2,1,5,10,3,6,3,5,6,1,6,3,
2,4,6,3,11,3,3,4,5,6,7,11,9,3,4,3,8,3,4,3,8,7,2,1,14,1,9,2,6,4,5,6,7,3,3,11,3,13,12,2,1,8,1,6,2,6,4,
2,19,2,7,20,13,3,2,3,16,6,2,10,11,1,9,11,1,2,3,13,21,3,2,4,5,6,4,9,2,9,22,3,9,2,3,1,9,17,1,2,12,6,3,
1,3,3,14,1,12,2,1,14,3,1,5,7,9,5,1,14,4,2,9,3,3,3,6,6,3,16,14,1,6,9,8,1,5,1,15,11,7,2,1,3,11,3,16,
12,12,11,1,5,1,9,8,3,7,3,5,3,4,3,9,3,2,10,3,6,14,1,5,7,3,6,5,10,6,18,15,2,12,6,1,6,2,6,9,6,4,11,4,2,
1,12,2,1,9,11,3,9,1,2,9,4,15,2,4,3,3,5,3,1,3,8,3,25,5,4,3,3,2,3,1,3,2,3,12,4,11,3,12,18,1,2,7,6,21,
21,5,4,11,3,6,4,5,10,11,4,14,1,2,10,3,6,5,1,8,6,6,3,6,6,19,9,5,1,8,3,13,6,5,1,2,1,2,10,8,1,20,1,2,7,
3,6,5,10,5,1,5,9,6,1,8,9,3,10,3,5,6,6,13,2,7,17,1,2,1,11,6,4,5,3,3,4,3,6,5,9,1,9,2,10,3,5,1,5,6,1,
14,6,7,5,12,1,3,5,4,3,14,3,7,9,6,3,12,5,3,7,6,2,3,13,12,2,3,13,5,4,3,2,6,6,3,6,1,8,13,9,3,6,2,7,6,2,
13,2,3,4,8,4,3,6,6,5,3,1,5,4,2,1,5,3,31,5,3,15,10,11,10,5,4,3,2,10,2,1,5,19,3,6,6,3,6,2,10,2,15,12,
3,6,6,13,5,3,7,11,1,3,3,2,1,5,7,17,1,2,7,2,6,3,1,11,10,3,2,7,20,6,6,3,13,9,3,5,6,7,8,9,7,8,3,10,2,1,
2,4,5,15,6,10,2,10,2,1,8,9,3,7,2,3,3,3,1,3,8,9,9,7,12,3,8,15,27,3,4,6,11,3,18,9,21,3,7,5,4,5,19,5,1,
21,20,18,12,15,4,3,3,5,3,6,3,6,1,5,1,12,5,3,3,4,3,8,4,2,6,7,2,9,15,15,1,6,2,1,5,7,5,15,9,3,1,2,4,5,
3,6,9,13,3,5,6,3,1,6,3,2,1,8,1,5,1,12,2,1,12,2,3,13,12,3,3,14,3,12,6,1,3,3,12,3,2,3,4,5,6,3,4,3,3,2,
9,3,21,1,5,1,8,7,5,7,12,3,15,12,14,1,9,11,1,5,7,2,9,4,3,2,3,7,11,1,3,11,1,6,9,6,2,6,4,21,11,19,2,4,
3,3,3,2,4,6,8,7,5,10,12,3,3,2,10,3,2,9,9,12,4,5,4,5,6,6,3,4,3,9,14,12,4,9,12,3,9,2,3,12,13,12,9,2,7,
2,3,12,3,6,19,3,2,1,20,4,2,3,3,3,6,1,3,9,6,11,4,2,10,5,18,7,9,11,3,12,10,2,1,35,7,2,13,17,7,11,3,6,
3,1,6,3,15,3,2,3,3,4,11,6,6,4,3,12,3,3,5,7,3,14,3,1,2,10,2,1,6,5,9,1,11,7,8,4,5,6,3,4,5,1,6,5,4,2,
15,7,2,4,11,3,1,5,9,6,1,9,9,3,3,2,9,3,6,1,3,3,9,6,18,11,3,7,9,9,5,1,2,18,4,11,1,5,4,15,20,4,3,3,9,3,
12,5,7,14,1,14,9,10,18,15,2,10,6,2,18,7,8,1,5,3,3,10,2,3,4,6,12,2,1,12,6,2,3,4,6,6,8,1,6,9,2,4,3,5,
3,7,6,2,10,3,2,9,3,3,7,5,7,3,3,2,6,12,3,1,5,1,2,6,4,11,4,2,1,3,27,8,10,6,5,6,15,3,12,7,5,1,2,7,6,2,
4,3,3,14,10,8,1,12,2,10,2,4,2,3,4,6,15,2,10,5,7,3,2,18,18,1,3,2,4,5,4,5,10,5,1,2,12,7,5,1,2,6,15,1,
5,1,8,4,11,7,12,2,4,2,7,8,3,6,3,1,5,6,4,30,11,3,3,12,6,7,3,11,1,15,9,14,1,6,3,2,3,9,12,10,3,5,1,5,7,
3,15,2,4,5,13,6,11,1,17,7,14,1,6,9,21,2,6,6,1,14,4,9,5,7,11,7,18,8,4,8,3,4,8,9,10,5,3,6,15,1,9,5,7,
5,4,3,3,2,7,5,9,6,1,9,5,9,1,3,15,3,2,6,7,8,4,2,1,8,10,11,15,10,8,6,9,7,8,1,9,2,1,2,7,26,4,3,20,10,2,
1,2,1,5,7,5,9,13,3,14,3,1,2,13,2,4,15,3,17,3,1,2,3,4,2,6,7,2,6,12,7,11,4,6,12,3,8,9,1,5,1,3,8,10,8,
7,2,3,4,8,3,3,10,9,2,4,11,3,6,6,6,3,6,13,2,1,2,3,4,3,11,7,2,7,3,3,2,7,6,2,3,10,8,4,8,3,9,10,12,8,15,
1,15,5,4,2,3,3,4,5,4,5,7,33,11,1,14,3,1,2,3,4,3,9,5,1,3,5,21,3,16,6,9,20,1,3,5,7,5,4,11,1,3,20,4,5,
7,3,5,15,3,10,8,1,3,2,4,2,7,5,7,5,3,10,3,5,9,10,5,1,9,6,5,3,4,2,13,20,13,2,3,3,9,12,1,5,3,1,3,3,12,
17,4,11,13,17,4,5,1,5,3,1,2,9,16,3,24,6,5,12,12,6,6,1,2,1,11,6,4,3,8,3,19,6,2,3,1,9,2,4,3,11,10,9,2,
10,3,18,2,3,12,3,4,6,9,8,1,20,4,2,1,5,3,7,14,10,5,4,5,7,2,6,6,1,2,7,6,8,1,5,3,6,6,13,20,1,27,3,6,5,
10,5,10,11,3,4,5,3,13,5,9,10,2,1,3,6,6,2,21,7,3,14,3,7,2,3,3,4,9,6,3,2,1,15,12,5,3,4,9,9,2,6,7,2,4,
12,12,17,3,15,21,6,1,2,3,12,10,11,1,9,5,12,3,1,5,3,3,3,4,2,1,17,3,12,7,3,8,4,5,16,5,4,5,3,6,1,9,9,2,
4,6,11,13,5,10,6,5,1,3,11,1,5,7,8,7,12,3,8,3,1,3,12,6,2,6,7,5,3,1,3,17,1,12,6,17,12,3,7,2,4,14,6,4,
12,14,7,12,8,4,3,3,3,6,5,4,5,19,2,6,4,5,4,2,7,6,9,5,1,2,7,3,5,10,23,7,2,6,1,5,6,3,4,3,23,1,6,5,3,1,
6,2,12,3,3,9,3,6,1,5,13,2,3,10,23,3,4,11,1,21,8,1,3,8,3,7,2,1,6,9,5,1,8,3,4,5,1,2,13,12,3,8,1,11,3,
6,6,4,5,6,7,3,2,1,14,1,5,16,5,21,3,7,3,6,11,4,6,3,2,3,6,10,6,17,3,10,12,20,1,12,3,9,2,9,1,9,6,3,3,8,
19,17,4,2,3,4,3,3,5,4,2,1,9,8,1,5,16,5,4,2,3,10,6,9,5,1,8,7,3,3,2,7,8,21,6,1,12,3,3,6,5,3,3,3,12,7,
12,5,3,1,6,5,1,2,18,10,2,1,21,9,2,7,3,2,12,4,6,6,5,9,1,14,1,2,7,3,2,4,14,3,3,1,41,3,1,3,6,5,4,5,12,
3,10,3,3,6,5,3,7,5,1,5,4,15,18,2,13,8,3,7,2,1,9,2,1,3,11,1,3,2,3,6,3,6,4,8,3,9,3,19,9,11,4,6,5,1,2,
18,9,1,3,5,6,10,5,3,15,1,14,1,5,1,15,14,19,6,2,15,4,3,8,4,3,2,1,2,1,6,5,4,20,4,15,2,10,8,1,12,2,12,
3,1,5,6,3,3,7,3,2,7,3,3,5,3,9,10,6,24,17,1,3,2,12,10,3,3,2,7,5,1,2,13,6,3,11,1,3,5,12,6,10,8,1,5,1,
5,3,6,1,3,6,9,5,1,6,2,7,3,2,1,9,5,3,6,6,3,3,4,5,1,8,4,3,2,1,6,3,2,3,1,17,3,1,3,5,1,5,7,9,5,3,3,4,9,
2,12,3,7,5,3,3,1,3,3,8,6,9,1,21,5,15,3,7,3,11,16,5,10,9,9,5,4,2,13,8,7,2,6,4,3,23,30,18,10,14,3,4,3,
5,1,5,1,3,5,13,17,3,12,3,9,16,14,4,2,7,5,1,6,3,2,1,3,11,1,2,1,2,9,1,9,11,7,6,2,4,3,5,16,2,3,7,2,1,
12,3,5,1,8,3,3,10,14,7,5,13,5,1,2,3,6,4,5,1,5,3,7,3,12,18,5,3,4,5,13,3,2,1,2,10,3,5,1,5,10,6,20,3,4,
6,2,9,6,3,9,10,3,9,5,6,10,9,6,3,2,9,4,6,9,2,4,30,14,4,2,3,13,8,4,3,14,3,7,14,1,3,11,6,1,12,12,5,1,5,
7,3,2,12,9,4,3,3,5,1,14,1,8,6,4,2,6,3,4,3,14,4,14,7,8,3,4,5,1,15,8,9,6,4,2,1,5,7,3,2,3,4,9,6,11,3,4,
6,5,6,4,5,9,6,6,1,14,3,1,11,6,4,9,20,7,5,4,3,8,4,3,3,15,5,4,3,8,7,5,6,9,6,9,1,17,3,4,2,15,3,7,5,6,4,
6,2,1,5,22,9,3,3,2,13,8,10,11,6,4,6,3,5,1,8,16,2,9,1,12,3,8,9,1,6,3,18,5,10,3,12,8,1,8,10,2,9,6,4,2,
4,3,6,9,3,8,4,6,14,1,6,11,3,1,9,5,7,3,17,19,5,15,4,2,3,1,5,1,12,2,9,4,3,2,1,9,6,9,6,2,4,3,2,1,3,5,6,
1,8,4,2,3,3,13,2,12,15,13,2,1,5,7,2,7,11,9,15,4,12,5,12,1,9,11,1,5,3,15,1,2,25,8,4,8,4,3,5,3,13,6,5,
1,3,5,1,14,7,2,6,1,3,3,5,12,3,7,2,9,4,12,3,3,20,10,8,1,5,1,3,11,1,5,13,5,4,33,12,8,15,7,2,3,12,9,16,
6,2,6,6,1,5,22,6,5,4,6,17,7,5,3,9,3,15,12,9,1,6,3,5,6,1,12,2,4,9,5,6,7,14,4,6,6,5,7,2,1,8,4,8,4,3,5,
6,1,6,5,7,3,8,6,3,3,9,16,8,4,2,21,10,9,5,1,2,7,9,14,6,25,2,4,9,9,17,3,6,7,2,6,1,6,8,6,13,3,2,12,3,6,
1,3,3,2,3,4,3,2,9,10,11,6,4,3,2,6,10,5,12,6,4,3,3,12,2,21,1,8,3,3,1,3,8,9,3,10,12,6,3,15,5,6,1,8,9,
7,9,2,3,10,2,12,1,2,3,1,14,1,6,9,5,6,3,12,3,1,5,1,3,12,9,5,3,6,4,11,6,4,5,6,13,3,5,15,7,5,22,8,7,3,
2,1,3,5,1,11,3,6,3,6,4,2,4,9,2,1,2,1,15,2,4,11,12,7,11,4,3,2,9,10,5,4,2,3,10,8,13,2,7,3,2,6,6,1,8,6,
19,2,3,6,3,10,6,2,7,5,13,2,12,3,1,2,3,12,3,4,17,1,17,7,9,12,2,6,1,18,2,1,2,3,3,4,11,7,9,3,5,1,5,10,
2,4,8,13,2,7,15,6,5,7,5,1,29,3,3,4,3,15,2,3,4,8,6,1,6,3,9,2,4,11,16,5,19,5,3,1,27,5,3,7,9,8,1,9,5,1,
9,2,1,17,1,2,7,3,12,2,6,19,3,2,3,15,1,2,10,8,9,6,12,3,1,3,3,8,21,16,3,9,6,6,5,6,4,8,12,4,2,10,2,1,
14,7,8,1,5,4,3,2,12,4,5,21,4,9,3,5,12,3,10,12,11,10,5,1,3,2,1,20,3,4,2,1,9,5,9,1,3,3,2,6,6,10,8,1,6,
8,12,1,5,7,17,3,1,2,3,4,8,3,9,6,1,5,6,3,1,3,15,17,10,3,8,3,9,13,18,5,1,3,2,3,3,15,3,4,8,4,5,24,21,3,
6,4,8,22,5,3,4,5,6,4,14,1,15,6,9,5,1,2,7,3,3,5,7,3,3,9,2,4,5,10,5,9,1,11,10,5,3,6,19,3,12,5,3,10,15,
3,11,4,9,5,7,5,4,2,9,3,12,4,14,1,2,9,4,5,22,2,6,4,6,2,3,7,3,2,12,10,3,9,3,5,1,6,11,18,1,20,6,12,6,4,
3,12,2,3,1,6,11,3,1,3,3,2,3,7,6,17,4,8,1,2,4,3,6,11,4,5,1,20,3,10,3,8,6,4,2,7,6,2,4,3,3,3,5,4,3,2,6,
9,13,5,10,5,3,6,18,7,11,3,4,11,1,8,10,3,5,3,1,11,3,6,3,10,2,3,6,7,2,3,9,19,2,3,1,39,9,2,4,5,1,3,3,8,
1,14,6,1,2,7,3,2,1,5,3,7,17,1,9,5,7,3,5,3,4,3,3,2,13,2,1,5,4,5,10,3,14,1,2,3,7,6,6,9,2,4,5,4,17,3,6,
9,1,3,2,1,12,8,7,5,27,4,5,1,6,14,3,6,4,2,1,18,14,3,3,1,8,1,2,7,6,11,10,3,3,33,2,4,3,6,5,9,22,5,3,1,
2,4,3,3,2,3,27,1,2,12,6,9,3,7,2,9,6,4,9,2,1,2,21,7,2,7,5,3,1,9,12,14,7,2,1,6,3,2,6,3,10,2,9,1,5,7,2,
28,5,6,7,33,14,3,4,18,8,12,1,6,5,4,11,6,9,1,3,2,9,3,1,11,3,1,15,9,5,12,10,11,3,1,11,3,4,3,2,7,3,11,
1,6,18,14,6,4,2,9,12,10,9,5,3,1,12,5,9,3,6,1,9,2,3,1,6,9,5,13,2,1,2,3,9,3,1,12,9,15,8,6,4,5,10,3,5,
3,9,10,5,3,3,9,1,6,3,6,6,5,6,7,2,1,15,5,9,3,1,11,4,6,3,8,3,1,3,2,1,2,1,5,9,3,10,2,3,3,6,1,3,9,12,8,
1,9,5,15,6,10,9,8,4,9,11,4,6,5,6,3,1,9,6,5,9,6,4,11,3,12,15,1,2,1,6,8,13,17,22,6,9,3,3,3,2,12,10,2,
6,3,7,2,1,5,15,6,1,8,1,5,1,9,3,3,12,5,1,6,5,9,4,3,2,3,4,21,2,6,1,15,33,6,2,12,1,2,7,2,4,5,12,3,6,1,
5,15,13,17,4,14,22,3,20,6,16,17,1,6,6,2,7,5,3,13,2,1,5,4,3,2,3,3,7,3,11,1,2,3,18,1,9,2,3,7,9,11,7,5,
3,4,5,6,9,1,5,4,3,6,6,6,9,14,7,27,23,4,3,6,2,22,5,1,14,3,3,4,5,10,2,4,5,4,3,3,6,14,7,2,1,6,3,6,5,1,
5,3,12,3,3,4,3,18,2,3,22,6,21,5,1,17,6,4,11,9,7,9,20,1,5,4,6,15,8,18,3,6,6,4,14,1,3,3,2,3,7,17,6,3,
19,15,8,13,2,4,8,6,10,14,21,1,5,4,2,3,9,7,3,5,13,5,7,3,2,16,5,1,11,3,7,5,7,3,14,3,7,6,3,14,1,5,6,4,
6,3,3,32,1,2,4,9,2,3,4,17,1,9,8,3,15,7,3,5,3,6,1,12,15,3,8,1,8,13,3,5,1,3,2,9,1,5,1,3,5,7,2,16,2,3,
1,8,1,5,1,5,9,1,5,4,2,10,14,1,3,2,10,5,4,3,6,5,12,3,6,4,6,8,10,3,8,7,5,3,4,6,11,16,8,7,2,6,7,2,15,3,
7,6,24,2,3,3,4,9,2,4,9,24,2,1,2,3,3,6,9,4,20,7,3,5,3,7,6,6,5,1,2,3,3,1,3,5,13,12,3,3,9,2,10,11,3,6,
4,5,7,5,3,34,5,10,2,4,5,7,5,3,10,5,6,1,2,12,1,8,4,6,9,2,1,3,9,18,2,7,3,2,1,2,15,1,2,3,1,3,12,3,2,13,
12,3,12,6,9,3,5,1,11,4,5,9,13,18,2,4,8,3,3,4,3,12,2,1,17,6,6,1,2,3,15,12,1,2,9,4,5,4,18,2,7,8,3,3,
16,3,6,5,4,2,1,2,21,9,1,2,7,12,5,6,3,6,9,4,6,2,3,25,14,1,6,8,6,1,5,10,3,8,4,14,6,13,6,2,10,2,6,4,5,
6,1,11,24,4,2,7,12,3,5,10,6,5,1,5,1,20,4,3,5,12,1,20,4,5,4,9,8,9,4,5,12,4,6,2,7,6,17,7,9,5,1,3,3,3,
2,12,7,5,4,6,6,2,12,13,2,15,3,3,3,7,5,3,1,3,5,13,3,9,8,4,3,6,9,2,4,9,6,15,6,6,18,2,3,7,14,25,5,3,3,
3,4,8,3,9,1,12,2,1,11,3,3,4,18,2,1,3,21,9,5,6,3,21,7,9,5,6,3,4,3,5,12,18,28,2,7,2,6,3,6,4,9,2,10,8,
3,3,10,9,3,9,6,12,2,15,1,15,3,21,8,13,3,5,1,6,5,3,7,5,3,4,18,12,2,9,4,5,1,5,1,9,6,6,2,7,3,2,9,4,6,2,
9,1,2,1,9,2,3,3,15,4,3,3,14,4,11,3,6,10,5,7,3,11,6,33,6,3,1,5,7,15,14,10,3,2,6,4,3,3,3,2,3,6,4,15,5,
9,3,9,4,2,12,1,2,13,5,1,3,5,13,2,1,5,12,3,1,15,6,3,12,17,6,1,9,9,5,6,6,3,3,4,11,3,7,12,3,12,12,3,6,
2,3,1,9,27,2,12,6,7,2,10,5,31,15,3,2,12,12,4,5,4,5,16,6,3,3,2,3,4,5,1,2,1,11,1,3,14,3,3,1,5,6,10,9,
3,5,7,3,12,6,8,9,6,4,11,12,9,6,4,8,3,3,1,9,2,3,4,6,24,3,5,3,4,30,2,16,2,1,5,7,2,1,5,16,3,2,1,8,1,3,
2,18,12,6,3,7,2,3,10,3,5,1,5,4,2,7,2,1,12,2,9,4,2,1,5,33,1,5,4,6,14,1,5,1,2,16,2,13,6,3,6,2,7,8,10,
9,5,4,11,21,7,2,3,3,13,14,21,6,3,7,3,3,9,9,9,5,1,6,3,8,3,7,5,24,4,6,3,3,2,3,3,6,9,12,4,8,6,4,15,11,
7,2,6,1,11,4,6,14,4,2,7,2,10,11,7,2,9,1,11,4,5,6,3,7,12,3,3,27,2,1,5,1,8,7,5,1,5,7,5,7,11,10,2,10,6,
2,3,10,2,13,5,1,8,12,13,3,15,23,10,2,3,6,3,7,5,10,8,6,1,3,2,1,8,7,5,12,1,9,11,1,8,1,11,3,3,4,18,20,
3,25,3,6,3,5,1,12,3,2,12,6,4,3,12,5,12,4,6,3,8,13,11,10,3,12,3,6,2,12,1,2,4,9,2,4,8,1,14,12,1,2,1,
11,6,4,3,6,14,1,17,7,3,15,9,5,1,8,1,5,6,4,6,3,11,3,15,18,7,2,10,5,6,3,12,4,5,9,4,3,5,7,5,3,10,15,8,
10,5,9,6,1,6,12,2,1,14,4,2,3,4,15,11,1,8,1,2,4,6,2,10,15,8,7,2,4,12,9,5,1,2,1,6,23,6,6,1,3,2,15,4,8,
1,6,3,3,5,4,14,1,6,3,2,3,4,2,9,4,6,5,6,1,14,3,6,4,6,2,18,1,11,4,3,3,2,10,8,7,6,6,3,8,3,22,2,7,6,3,9,
2,1,14,4,9,2,1,2,10,18,8,6,1,8,6,1,9,11,3,7,3,9,6,2,4,8,1,2,4,15,23,1,2,4,5,9,4,8,3,4,6,2,4,11,4,18,
2,1,3,15,2,10,9,5,1,12,5,10,2,3,3,7,3,5,3,15,6,1,2,1,5,22,29,6,10,12,2,1,8,1,11,4,3,17,6,3,4,5,1,9,
6,35,6,3,6,7,8,12,12,3,19,6,2,3,3,1,3,3,2,6,10,9,8,9,15,6,12,6,4,6,6,5,15,1,2,3,4,3,8,9,6,3,6,3,7,9,
5,1,3,3,3,5,4,2,1,3,5,10,2,10,8,1,3,11,10,2,4,3,15,15,20,7,6,2,3,3,4,3,5,7,2,10,3,2,3,1,5,10,6,5,16,
3,2,9,1,2,16,5,4,2,1,9,5,3,3,10,2,1,12,2,1,15,2,3,1,6,5,7,2,9,9,7,11,7,5,6,10,6,9,9,5,7,3,11,12,7,6,
2,4,6,3,5,7,2,1,6,5,4,14,12,1,5,3,12,9,3,3,15,3,10,11,1,14,9,4,3,5,9,1,9,3,6,2,3,9,1,9,2,4,6,5,3,3,
7,2,6,3,1,18,6,11,6,4,6,12,11,7,3,5,6,3,3,4,5,4,9,3,9,8,1,9,6,2,7,2,1,2,13,2,3,3,6,9,1,18,2,1,3,2,7,
11,12,4,5,1,3,6,6,2,31,5,6,3,3,12,7,8,16,5,6,1,5,3,4,12,3,2,1,3,2,9,4,11,3,1,2,3,4,12,6,9,6,9,6,2,3,
4,5,6,3,12,27,1,11,1,3,5,1,5,6,10,9,9,5,4,2,3,3,22,5,3,7,12,14,6,6,3,6,4,17,4,15,6,3,5,4,5,1,11,1,8,
15,4,3,3,2,19,14,1,8,1,5,4,5,6,9,6,1,5,3,10,3,5,3,6,6,4,3,6,2,4,11,7,5,1,27,5,4,14,6,1,2,10,6,5,7,9,
14,6,3,1,9,3,2,7,3,3,5,3,7,3,11,3,1,2,19,9,5,6,1,17,6,6,1,5,9,4,9,8,3,1,8,1,6,21,5,3,1,3,3,2,3,3,6,
18,1,11,3,7,8,1,5,7,14,10,5,15,6,3,4,3,17,3,3,10,9,2,1,3,6,9,9,2,1,9,11,13,29,3,4,6,8,6,1,9,6,8,10,
15,17,7,5,7,5,15,6,4,3,5,6,4,2,4,2,30,3,15,7,14,1,5,3,1,3,3,2,3,13,12,14,6,7,5,10,11,1,5,3,1,5,1,3,
5,7,9,2,7,5,12,9,1,11,9,10,6,5,19,6,14,4,2,7,11,1,3,15,6,12,2,1,2,3,6,19,5,4,2,1,3,6,3,11,10,2,4,8,
1,6,5,3,10,5,3,10,15,9,5,4,5,1,3,6,2,9,1,2,21,4,2,10,6,15,2,10,2,4,5,1,6,5,9,1,8,1,9,6,3,3,8,12,3,4,
15,2,3,15,3,9,3,16,5,1,8,7,6,14,1,2,10,11,15,1,3,20,6,15,1,3,8,3,16,3,2,10,3,5,1,20,6,3,18,3,1,3,3,
15,5,4,11,10,12,2,1,8,9,13,5,3,4,6,2,9,4,6,3,2,18,3,3,4,2,3,7,18,8,10,15,2,7,5,3,1,2,4,3,12,5,4,6,9,
2,3,1,15,3,8,3,6,13,2,9,10,9,5,6,6,3,3,4,29,6,6,7,8,10,2,3,3,4,3,17,21,6,1,3,2,10,3,6,3,6,6,11,7,6,
14,3,10,30,2,1,6,3,2,3,1,17,3,22,3,9,2,1,2,12,1,12,3,2,1,21,6,2,7,3,20,1,6,8,27,3,3,9,13,8,3,1,6,2,
12,1,5,3,6,3,7,20,18,1,2,3,1,3,6,2,4,5,1,8,6,1,3,11,1,9,6,3,2,9,6,7,2,3,3,7,12,9,20,4,5,12,1,5,9,1,
3,6,8,1,2,10,15,2,1,11,1,3,9,5,3,7,8,3,10,20,1,8,3,12,6,15,1,3,2,1,12,2,4,5,7,3,11,3,22,3,11,9,1,2,
7,2,1,5,22,2,4,11,4,9,3,8,4,2,3,7,5,1,5,4,11,4,3,6,5,31,3,15,5,13,3,2,4,3,2,6,3,4,3,5,3,9,1,11,4,5,
10,6,3,2,3,6,1,11,7,3,23,10,2,13,2,3,4,6,6,5,1,8,6,4,5,1,3,2,1,2,3,9,19,2,7,15,3,2,6,4,11,1,6,8,12,
3,4,3,3,2,7,2,1,2,16,15,5,6,3,1,20,1,3,8,9,6,7,12,3,8,7,8,3,10,6,5,3,1,2,10,2,7,5,21,7,2,4,2,12,7,5,
3,1,14,3,7,12,14,12,7,5,3,10,2,13,3,11,1,12,5,6,4,8,7,3,3,9,26,1,6,3,12,12,2,3,6,6,16,18,6,6,2,6,9,
1,6,8,6,1,5,3,7,6,12,2,3,1,9,2,4,5,10,2,3,7,2,7,6,14,3,7,3,2,1,18,2,4,14,12,4,9,11,3,12,1,5,3,4,15,
6,6,3,5,13,14,1,2,7,8,3,7,5,6,12,3,7,12,6,2,4,6,3,2,9,1,8,6,10,3,2,10,9,2,10,5,9,6,10,3,5,7,8,1,11,
3,1,3,12,18,2,3,3,19,6,2,6,6,1,9,5,3,1,2,7,18,3,5,4,3,5,4,8,1,14,3,3,1,9,6,6,2,6,9,7,3,2,15,6,4,5,4,
9,8,4,3,5,1,17,18,6,4,5,4,6,9,15,3,2,1,5,21,1,2,3,9,1,5,4,14,6,4,6,3,8,3,12,3,1,6,18,9,3,12,2,1,3,5,
4,2,15,6,4,11,4,5,3,6,1,5,1,14,1,2,3,3,4,15,2,4,9,15,8,9,1,17,1,2,3,1,6,2,7,3,8,27,13,2,10,5,12,6,3,
1,5,6,3,1,9,2,7,6,6,5,3,1,5,1,6,3,2,7,5,1,14,13,2,6,6,6,7,5,3,15,10,17,1,5,6,4,6,14,6,6,9,3,1,2,4,5,
6,12,3,3,1,15,6,8,1,3,3,5,4,11,9,1,3,9,2,3,1,15,15,11,13,2,3,6,4,2,4,12,2,10,5,1,2,7,6,5,7,9,5,6,7,
11,10,5,12,4,3,6,2,4,3,15,2,4,6,8,3,3,1,6,8,4,3,3,5,6,4,11,3,10,5,6,1,5,3,16,17,3,1,3,2,4,14,1,2,7,
5,3,24,3,1,5,1,9,17,7,2,9,4,2,3,15,3,4,6,8,1,8,6,1,6,2,3,9,1,9,3,3,3,11,1,3,2,13,15,2,3,9,1,14,1,2,
9,1,5,7,6,5,19,5,1,6,8,7,9,11,3,3,15,4,6,3,11,1,14,9,1,8,10,5,1,5,9,3,3,7,14,9,4,12,15,6,3,2,4,5,3,
16,6,6,2,6,1,6,27,5,7,3,5,3,10,2,7,9,17,10,3,9,3,3,2,9,3,6,4,21,6,5,1,3,2,3,1,5,9,4,2,6,7,3,5,7,8,3,
9,1,20,19,3,8,1,3,8,9,3,1,6,8,7,9,14,1,6,6,5,4,3,11,10,9,2,1,3,2,7,2,19,6,5,18,1,6,11,4,5,4,2,12,1,
6,3,5,3,3,7,2,6,1,14,15,1,11,10,8,4,3,2,1,6,5,24,4,6,5,1,23,3,3,4,6,2,13,2,19,6,3,2,7,6,5,6,1,5,3,1,
8,3,7,2,1,8,10,20,9,10,5,6,1,5,1,12,21,5,6,3,7,5,9,1,9,6,6,3,14,1,2,3,9,13,12,3,2,3,4,11,4,3,6,26,3,
13,5,3,1,11,30,3,1,9,5,1,3,2,1,15,3,11,1,12,2,1,17,1,14,6,9,6,1,5,3,1,12,9,3,2,24,4,2,3,21,4,11,4,2,
1,8,9,21,10,2,10,2,3,9,3,15,12,10,11,7,3,8,4,2,6,3,6,6,4,5,9,10,5,1,3,3,8,6,21,3,1,9,5,6,10,15,3,3,
8,4,2,3,1,5,1,9,2,9,3,3,7,3,3,14,15,1,2,12,1,9,2,3,7,6,8,4,5,13,5,7,3,5,4,5,4,5,1,14,4,11,1,9,2,4,
15,5,4,2,12,1,2,4,3,2,4,5,1,3,8,4,6,8,1,6,20,10,5,9,3,1,6,8,1,5,1,9,11,15,3,1,5,7,5,3,15,16,5,9,4,3,
3,2,7,5,13,2,10,2,1,14,13,5,10,2,6,12,3,4,5,1,2,6,7,3,9,2,1,8,4,2,1,12,3,18,6,8,3,3,1,5,10,9,2,4,3,
15,3,3,12,17,3,10,2,6,1,6,3,11,1,2,1,2,3,6,9,7,8,16,3,26,7,14,1,8,34,2,4,9,6,9,3,17,1,5,6,1,2,7,6,2,
6,1,3,8,12,1,2,9,3,3,4,3,15,2,16,3,26,16,2,1,2,4,11,10,8,1,3,2,16,5,3,1,3,2,3,3,18,6,4,24,3,15,8,7,
5,3,1,18,2,6,7,6,9,2,3,1,6,3,3,2,27,3,1,5,1,6,5,10,3,2,3,6,1,3,6,3,6,12,2,1,6,5,1,8,10,5,9,7,3,3,8,
9,7,8,1,9,11,9,1,5,7,2,1,5,6,1,8,1,5,4,14,3,9,6,7,6,2,12,15,3,4,5,1,2,13,5,3,6,3,1,21,3,18,15,3,11,
3,3,4,6,12,2,1,5,7,8,3,1,8,7,5,4,5,21,15,1,3,12,18,5,1,14,1,6,2,1,6,8,10,11,6,16,12,2,3,1,12,8,4,5,
1,17,4,3,2,9,1,5,15,10,14,9,13,3,11,1,3,6,5,6,10,12,5,7,5,3,1,12,5,7,5,1,6,6,2,1,5,4,2,6,7,20,3,4,9,
6,20,1,8,7,8,7,9,3,15,2,3,3,7,5,1,5,9,3,4,3,3,2,12,3,3,3,16,6,3,5,6,1,30,2,3,9,4,21,3,2,3,6,4,8,3,9,
1,9,2,3,3,4,3,15,3,14,1,3,5,9,16,2,7,5,1,2,4,3,12,8,1,11,1,8,1,8,6,12,3,10,2,7,2,1,3,15,20,24,3,3,9,
10,2,6,9,1,5,4,9,2,3,4,3,8,1,5,9,9,10,2,1,14,1,8,7,2,1,9,5,6,4,5,13,20,7,8,7,2,6,10,9,9,14,7,3,3,3,
6,6,12,3,2,7,5,4,5,9,3,9,3,6,7,2,1,5,9,1,11,4,12,12,2,19,6,5,4,2,7,3,2,1,2,12,1,5,7,3,2,19,6,14,1,2,
7,14,7,8,4,2,10,9,11,1,14,6,3,4,5,1,6,8,3,7,5,3,12,1,5,1,14,7,8,6,9,7,2,15,6,1,9,2,4,5,1,2,6,1,15,6,
5,7,8,3,4,38,3,6,3,12,3,7,3,2,1,2,6,10,2,24,3,1,2,19,3,3,9,23,6,6,9,7,3,9,6,6,6,17,7,11,4,3,8,9,6,7,
2,18,1,2,13,2,3,1,5,4,11,13,2,1,2,12,4,11,13,5,6,9,3,10,8,1,6,2,6,12,4,3,2,4,9,8,7,11,4,3,3,5,1,3,
11,6,1,2,3,7,8,3,12,9,4,17,4,8,10,3,3,6,5,6,3,1,8,10,6,5,4,2,1,5,9,18,7,20,6,3,6,9,7,8,4,12,5,6,3,4,
6,12,3,14,3,12,7,3,3,3,5,16,8,7,14,4,11,6,1,8,7,8,4,3,5,9,1,2,1,9,20,3,7,2,1,14,3,1,6,21,8,9,3,4,5,
3,7,6,3,9,2,3,12,1,3,6,3,3,2,3,25,9,8,6,1,3,17,16,5,7,2,1,8,6,4,2,7,2,3,10,2,4,9,3,2,3,4,9,6,5,1,17,
3,4,14,6,6,4,9,12,9,3,17,1,14,3,6,10,2,3,7,2,15,6,4,6,9,5,6,6,9,12,4,6,5,3,6,4,2,13,5,7,2,12,18,1,2,
4,6,5,7,11,7,2,10,12,6,2,21,15,1,5,9,10,11,1,3,2,4,11,4,3,3,9,9,6,5,1,2,6,4,2,1,5,22,5,18,4,6,12,3,
8,9,13,14,4,2,9,3,1,2,9,6,4,3,5,3,3,7,9,6,3,2,7,2,6,3,7,12,15,2,3,1,2,10,3,2,10,2,1,14,3,4,8,6,1,5,
9,16,8,3,3,4,8,4,5,4,5,10,6,5,3,12,16,18,6,6,2,1,2,19,8,1,2,4,5,6,7,6,2,3,6,3,1,14,7,8,13,2,15,1,11,
3,6,4,2,1,20,12,1,9,3,3,6,5,4,6,5,3,12,10,5,4,11,6,12,10,8,3,1,3,2,1,9,5,1,2,6,15,4,6,2,13,9,5,3,43,
9,2,6,3,1,3,2,6,7,3,2,3,9,3,7,6,2,1,5,4,3,2,6,6,1,8,1,3,11,7,3,9,2,1,5,4,9,6,6,2,10,17,6,10,2,3,3,1,
14,25,5,7,2,10,5,7,8,3,4,6,2,7,6,18,6,3,5,13,8,9,16,17,3,12,13,9,2,10,6,2,7,3,5,1,6,5,6,7,12,6,8,4,
5,3,13,9,8,4,5,16,8,12,10,17,12,13,5,6,9,13,3,6,6,2,7,3,6,2,3,6,1,3,14,10,11,1,5,4,15,6,3,2,3,6,1,
11,12,10,18,8,16,8,10,2,3,6,4,2,1,5,3,12,4,3,2,3,1,20,7,9,5,13,12,3,8,7,12,8,1,15,6,3,3,2,6,10,9,2,
1,12,2,19,11,9,7,2,1,2,4,5,9,7,5,3,4,2,13,3,8,7,17,10,5,1,2,4,5,4,15,5,9,6,4,3,3,2,3,4,2,1,2,1,9,11,
10,9,5,7,8,1,2,10,2,18,9,15,4,6,6,8,4,3,18,2,4,3,3,5,4,5,1,5,3,4,5,33,10,2,6,1,8,7,5,3,7,11,7,6,9,5,
3,7,3,3,6,3,6,11,3,7,14,7,3,11,1,2,18,4,3,6,6,6,8,16,8,10,2,1,3,2,10,5,22,5,1,5,1,5,1,2,12,3,12,6,
18,4,2,3,3,4,11,3,1,8,12,1,8,10,9,2,1,2,6,6,1,3,5,12,4,14,1,8,1,6,8,12,3,10,3,8,12,3,4,20,3,3,7,3,6,
3,18,12,2,15,4,2,9,6,4,3,8,3,1,9,5,15,10,11,9,15,9,7,5,6,4,3,20,7,6,5,3,4,8,3,10,9,3,5,4,3,11,7,2,1,
2,7,3,2,18,3,1,5,1,9,6,5,24,4,14,6,1,6,2,6,1,9,2,3,1,5,13,2,4,5,6,3,10,11,9,21,1,8,6,1,6,2,3,3,1,30,
3,2,6,10,3,2,4,6,17,10,2,9,7,15,14,3,18,4,3,2,1,2,6,9,1,2,4,5,3,3,3,1,3,3,3,2,9,1,14,3,10,3,5,4,23,
3,3,12,13,2,7,23,12,10,6,6,5,4,5,7,9,5,1,5,13,15,2,3,16,3,2,3,6,1,11,7,3,5,7,3,8,4,2,10,8,1,2,3,9,7,
5,3,1,11,3,10,11,10,12,3,2,19,6,14,3,1,15,2,4,18,2,9,25,17,9,10,5,1,5,3,4,12,3,8,7,2,10,3,2,9,1,3,
15,3,2,6,7,3,5,6,3,10,2,1,3,5,4,6,2,9,6,4,3,3,15,8,6,3,1,9,8,7,8,13,9,8,13,2,4,14,6,3,7,3,8,3,1,3,
11,9,7,3,5,3,18,1,8,13,3,6,5,3,6,6,4,2,9,1,2,1,9,2,4,2,3,1,3,3,8,16,14,7,2,3,3,1,14,6,3,10,6,5,1,3,
5,1,15,6,5,9,6,6,15,19,9,9,3,2,7,6,15,3,2,9,1,20,15,4,5,3,1,2,3,1,14,15,1,5,1,9,3,3,2,3,7,2,4,9,3,3,
6,3,15,5,1,9,6,6,9,21,5,13,3,23,10,2,3,7,3,11,1,8,4,2,9,6,4,11,10,18,5,6,1,8,6,6,1,3,11,6,4,14,12,7,
2,4,15,2,9,3,1,5,6,1,2,1,2,4,5,3,7,6,5,12,3,7,26,7,9,5,9,4,2,9,1,3,3,3,5,9,10,8,15,7,11,6,3,6,1,5,1,
2,3,4,3,2,1,12,20,10,3,3,2,4,6,2,15,6,4,3,9,5,19,11,4,9,3,3,5,16,8,3,3,6,16,3,11,3,1,2,7,6,20,1,8,
16,2,4,14,1,6,3,5,6,6,19,3,3,2,6,4,2,15,25,6,5,9,3,3,7,6,2,3,1,3,5,1,2,3,1,6,24,3,3,5,3,4,6,5,12,7,
6,5,7,17,13,2,15,6,4,6,12,3,14,3,4,6,3,5,1,3,2,4,11,16,2,3,3,4,2,1,3,5,7,2,7,11,13,2,3,24,1,2,7,2,
13,11,10,6,11,3,9,6,4,12,6,27,2,13,2,15,6,3,1,3,3,2,3,3,22,9,14,6,1,12,3,12,2,4,14,3,7,11,6,4,5,1,3,
2,3,10,2,6,3,7,3,17,4,9,6,3,2,4,21,3,8,4,5,1,3,11,6,4,3,2,3,3,3,1,8,1,9,12,6,9,3,11,19,3,3,14,1,5,9,
1,2,4,5,15,1,2,6,1,11,4,3,2,6,7,5,10,6,5,9,3,7,6,11,6,12,6,22,5,4,3,12,8,10,2,1,8,1,6,5,3,9,3,4,9,9,
2,4,2,12,13,3,5,1,14,6,10,8,7,11,3,4,6,2,4,8,6,1,6,5,24,6,4,8,6,4,6,9,2,1,14,4,9,3,8,4,2,3,1,6,9,2,
3,1,5,1,9,9,2,9,1,3,2,9,6,10,3,15,5,6,3,6,7,2,12,15,10,14,1,6,2,7,21,2,1,6,3,2,6,7,8,12,1,11,4,5,1,
11,9,10,5,13,3,2,6,6,9,9,3,7,5,1,6,6,3,11,1,17,13,15,12,2,4,2,4,9,15,6,5,9,7,5,3,6,1,8,6,13,2,13,5,
18,4,5,3,1,6,6,2,10,2,3,6,6,13,5,10,5,3,7,5,3,3,7,17,1,5,6,3,7,3,2,4,5,12,19,3,5,3,4,3,2,1,2,13,9,3,
12,9,2,3,7,3,6,14,19,2,1,2,1,6,15,3,3,2,3,3,4,8,9,1,2,3,4,5,10,9,2,4,5,1,3,5,27,3,6,1,14,3,16,12,2,
7,3,5,6,6,1,12,5,3,4,6,8,6,4,15,2,3,4,11,4,2,1,14,21,4,5,1,3,2,7,5,1,9,2,3,1,5,4,3,5,7,3,3,5,1,8,6,
16,11,9,25,18,5,7,5,4,2,9,1,8,19,5,7,8,3,10,8,1,3,3,2,1,5,6,4,5,6,1,9,9,12,5,4,9,5,9,10,2,1,15,5,7,
3,8,6,4,11,3,3,7,12,9,2,10,2,1,6,8,1,27,8,19,8,4,6,5,3,4,2,1,14,1,12,11,12,9,1,12,6,6,8,3,9,18,6,21,
1,3,2,7,6,11,4,12,8,6,1,2,6,6,15,13,8,15,4,15,3,6,6,21,8,1,5,19,9,3,17,1,2,7,6,5,4,2,4,5,16,8,13,3,
2,10,2,1,11,4,15,5,9,1,6,9,5,1,11,4,5,1,5,13,14,1,2,3,9,6,16,5,3,18,15,3,4,17,4,2,3,1,6,2,3,9,1,3,
15,2,3,1,3,2,3,3,3,7,12,3,2,1,14,6,1,3,3,8,4,3,3,5,10,12,15,27,5,3,3,4,17,10,9,2,3,12,3,22,2,1,11,
10,6,3,2,3,7,15,2,1,5,1,3,2,6,7,2,9,12,22,5,1,6,3,6,6,6,2,6,16,5,15,1,9,3,2,3,3,12,15,1,6,5,3,3,4,6,
2,3,7,3,8,7,5,9,9,9,6,1,3,5,1,11,1,2,1,11,10,11,3,4,3,3,2,7,5,7,11,3,16,5,9,4,3,2,3,7,2,18,1,11,6,
10,2,6,6,3,1,6,6,2,13,2,10,6,9,5,1,11,4,14,1,2,9,4,15,5,6,1,9,3,6,11,6,4,8,3,19,6,3,6,8,3,4,3,8,27,
7,9,14,7,9,26,3,10,8,7,6,2,9,9,1,36,2,1,6,3,3,2,13,3,2,12,7,3,5,1,2,7,5,3,7,27,8,7,9,9,2,18,6,1,15,
5,19,2,9,13,6,2,48,10,5,1,11,7,2,1,2,12,1,5,3,16,3,20,1,2,3,7,2,1,5,6,1,5,10,18,11,1,9,24,12,14,1,2,
1,2,7,2,15,4,17,4,3,5,6,1,3,3,5,18,1,5,6,4,3,2,6,3,6,9,4,2,6,4,5,4,6,8,30,3,3,1,6,8,4,18,2,10,8,3,9,
1,2,3,4,18,14,1,2,12,1,3,5,4,8,9,3,3,3,7,5,12,12,1,3,5,6,6,3,4,15,3,2,7,8,7,6,5,4,6,2,22,5,1,5,3,12,
3,4,3,2,3,4,3,2,6,7,6,5,1,6,3,5,7,24,20,4,6,9,15,2,12,18,7,5,3,9,1,3,2,3,21,25,6,2,15,3,4,8,7,5,1,8,
4,3,2,15,1,9,3,2,6,1,3,26,15,1,3,2,6,3,10,6,3,20,6,1,3,18,2,6,7,8,1,3,2,1,3,9,2,1,14,3,1,12,9,5,3,
13,3,2,4,5,3,3,3,4,2,4,11,4,20,9,3,4,14,6,10,3,2,3,3,13,5,10,2,4,15,8,1,6,5,3,12,3,1,5,4,5,6,19,2,
19,2,3,12,12,1,6,15,6,2,3,10,5,9,13,2,9,1,6,5,4,6,2,6,12,3,7,9,3,3,5,7,2,4,6,14,7,5,7,2,1,14,6,9,3,
7,3,8,7,6,9,2,4,9,11,4,2,1,3,21,14,12,10,3,2,4,9,5,1,8,3,9,9,7,2,3,7,2,9,12,3,10,9,6,5,4,5,6,7,3,11,
6,9,9,1,3,17,1,2,3,12,3,12,6,4,17,1,3,2,9,10,3,2,1,3,5,9,1,2,7,2,3,10,5,1,9,2,10,8,6,1,14,7,3,5,24,
1,5,7,3,6,3,6,14,1,6,26,13,2,4,14,7,9,6,3,5,1,11,12,10,3,12,3,3,11,3,1,2,4,6,3,6,3,2,3,6,10,5,4,5,3,
7,3,8,6,1,2,18,7,6,5,7,2,1,11,1,2,6,9,7,3,2,13,23,3,4,12,23,3,7,2,1,5,4,3,3,27,2,10,9,6,5,1,3,5,6,4,
6,3,5,3,9,6,7,3,5,7,2,3,6,1,3,3,8,10,14,12,1,2,6,12,9,4,6,3,6,5,1,6,8,1,6,2,15,1,2,4,18,6,11,3,15,
13,2,6,16,9,6,5,3,6,1,6,12,3,5,4,8,6,1,6,5,7,6,6,5,6,3,6,10,3,2,4,15,2,4,5,4,2,7,6,2,3,10,20,4,32,4,
9,6,9,3,3,5,4,2,3,6,6,4,2,9,9,4,15,2,1,5,15,3,4,3,15,2,16,2,3,15,6,16,2,3,9,10,8,3,4,5,4,6,14,7,2,6,
12,7,2,1,18,14,6,4,3,15,5,3,1,5,1,15,12,8,4,9,6,14,4,5,25,3,5,3,19,2,3,1,9,11,7,2,3,13,6,5,3,7,18,3,
5,3,7,5,4,9,6,11,4,23,1,5,25,9,2,24,7,2,12,28,5,6,1,6,15,3,11,4,6,20,1,14,3,1,2,4,5,13,8,10,2,15,6,
1,9,2,4,3,3,3,6,6,12,2,3,7,5,6,9,6,7,6,5,12,3,4,3,2,12,3,7,56,7,6,6,5,1,2,6,1,5,6,4,3,3,5,9,9,4,5,7,
5,13,3,3,2,3,6,15,1,5,3,4,3,15,18,17,4,6,12,17,1,3,2,4,3,11,15,39,1,14,6,1,6,2,6,16,5,1,5,12,1,6,11,
7,3,2,6,1,3,12,5,4,2,4,5,6,3,1,6,3,12,2,1,14,15,3,9,4,6,9,2,18,6,6,7,15,5,3,3,12,3,15,10,9,21,9,17,
3,3,4,3,6,2,12,15,1,5,1,5,3,7,5,9,7,5,7,6,5,1,3,20,7,5,3,6,9,3,3,22,9,11,3,1,3,6,2,3,6,1,20,7,2,3,
10,2,4,2,15,4,5,6,4,8,7,6,8,34,2,1,8,4,8,4,3,5,6,9,1,5,7,3,6,6,3,2,12,3,3,4,6,2,3,4,6,6,3,2,10,8,12,
1,14,1,3,12,2,6,15,7,5,9,18,12,3,7,5,1,2,3,3,4,2,1,8,1,21,9,3,2,13,6,2,3,4,2,1,8,7,27,3,3,2,12,1,6,
8,18,4,3,23,4,5,9,4,2,4,12,12,2,16,2,10,3,20,7,11,1,21,3,14,3,4,6,3,6,3,6,5,10,5,1,3,8,3,7,3,2,9,3,
3,7,6,5,7,2,6,7,8,10,24,2,1,3,9,2,6,7,2,4,15,5,21,1,2,7,11,9,15,3,10,15,8,18,1,6,8,4,2,1,2,7,6,3,5,
6,6,4,5,6,3,4,5,6,9,1,5,15,4,3,5,3,10,5,7,12,2,3,1,2,12,1,5,7,3,5,12,4,3,2,1,5,3,1,3,11,4,3,3,17,3,
7,2,3,7,2,1,2,1,11,1,14,15,9,4,2,1,9,8,3,15,3,1,3,5,7,14,1,6,2,3,10,3,2,3,12,7,8,4,6,2,10,3,15,2,1,
17,7,2,6,3,4,6,17,4,8,21,1,11,4,18,2,4,2,7,2,1,3,6,9,5,7,9,8,1,14,3,7,3,9,6,8,16,3,2,21,4,3,5,22,11,
10,3,9,23,3,1,3,3,9,5,9,1,8,13,2,3,3,7,3,9,2,1,3,9,11,4,6,5,6,4,14,1,5,9,3,4,3,2,4,2,7,2,3,3,18,1,3,
12,3,2,1,8,7,3,21,5,15,4,6,14,12,3,4,5,12,1,5,7,11,6,13,3,12,2,3,15,1,5,4,3,8,1,8,3,33,6,3,7,11,4,3,
5,3,7,2,1,9,6,3,9,3,5,10,14,3,12,3,10,6,6,5,4,5,6,4,9,2,6,4,11,7,12,26,9,9,6,4,2,9,15,6,3,6,13,5,6,
1,6,2,6,7,15,3,5,1,6,8,4,3,3,14,18,4,9,11,3,16,5,7,2,13,5,3,7,5,9,4,5,1,6,5,4,9,5,16,3,2,6,4,11,10,
3,9,2,9,7,8,4,2,1,23,7,5,4,9,5,6,4,2,7,5,10,5,1,2,10,3,17,4,3,5,3,10,5,7,5,3,7,5,1,5,4,33,2,3,3,9,6,
7,5,13,9,2,3,1,9,8,3,1,5,4,20,1,6,9,5,4,11,1,3,9,5,13,8,7,2,6,1,6,3,2,9,1,2,12,13,5,12,3,10,6,2,3,9,
6,7,3,2,7,2,16,8,7,2,1,21,3,6,6,23,6,1,5,3,16,5,4,2,1,2,12,10,8,1,9,2,4,5,1,8,1,2,15,7,3,17,3,9,3,3,
3,1,11,10,15,12,3,14,15,1,3,6,5,3,25,3,8,12,12,10,3,8,9,1,2,12,1,5,1,14,4,6,11,3,7,3,3,9,5,4,9,5,7,
5,3,10,3,32,1,6,14,6,1,5,3,7,17,1,6,9,2,10,2,12,1,2,3,3,6,6,3,10,2,9,3,7,3,11,7,2,1,2,4,9,5,19,11,1,
3,11,7,12,5,3,12,1,5,4,2,15,1,12,12,6,3,26,3,10,3,3,14,6,1,5,1,9,8,12,4,2,7,8,7,23,4,9,20,1,5,6,7,2,
16,14,10,3,3,5,9,18,1,14,3,15,7,2,4,11,4,2,7,6,2,3,6,10,5,6,3,6,1,15,5,3,9,1,9,2,6,3,4,12,3,3,15,2,
7,3,2,1,5,18,7,3,11,9,10,6,6,3,6,5,9,4,2,1,8,1,3,3,15,2,3,9,4,20,1,20,3,7,5,3,3,9,13,12,11,3,9,1,5,
15,12,3,15,1,3,3,8,4,8,7,11,1,6,2,3,9,3,1,11,1,5,15,3,12,3,4,5,7,3,5,3,4,6,2,1,15,11,9,4,3,9,5,6,3,
7,2,7,8,6,10,6,3,6,5,9,3,10,5,4,3,8,7,3,5,12,10,3,2,1,9,5,1,5,1,8,7,6,8,4,8,10,2,15,16,2,3,1,3,5,6,
12,7,15,2,4,5,6,4,2,9,16,9,3,2,9,7,2,7,3,8,3,19,2,3,7,3,2,19,9,3,3,11,10,6,14,6,7,6,9,6,5,1,3,11,9,
1,5,1,6,3,6,11,3,12,13,6,3,6,5,1,15,3,2,10,14,6,1,2,3,7,8,19,5,6,4,9,6,3,11,6,1,3,5,1,3,5,7,5,4,9,2,
1,23,15,1,15,6,5,9,3,7,3,3,8,9,10,2,3,10,6,2,12,12,3,10,11,1,3,2,16,5,12,1,5,1,6,3,2,3,1,6,23,4,3,2,
6,7,8,9,1,2,13,2,3,12,3,1,5,1,9,5,1,8,1,3,17,9,6,10,8,3,3,10,9,11,1,5,4,6,3,2,13,6,2,10,3,2,4,8,15,
16,15,6,18,2,15,3,18,7,5,1,2,7,5,7,8,12,3,3,3,10,14,7,5,4,2,7,5,1,2,12,13,5,3,6,13,3,8,6,15,13,3,15,
2,6,7,15,5,3,10,11,13,5,13,5,4,5,9,9,1,2,12,7,3,8,3,7,9,5,4,20,7,2,27,1,2,18,7,2,1,2,16,21,3,5,7,9,
5,1,3,8,13,2,3,4,2,1,2,12,10,3,8,3,7,2,12,6,3,16,6,3,2,9,6,28,6,3,2,1,3,5,10,5,6,13,3,24,15,3,8,9,1,
2,1,6,8,15,10,2,4,2,10,5,7,11,10,6,3,2,1,14,1,2,12,1,14,6,10,2,1,6,3,5,13,3,5,6,3,12,4,6,3,2,1,8,15,
4,2,19,2,7,5,1,2,27,6,6,9,1,18,5,7,9,2,12,3,7,2,1,3,11,1,2,1,5,6,15,4,11,4,2,12,6,7,5,10,3,6,6,5,4,
3,11,10,5,9,12,3,3,4,6,2,7,3,3,2,7,5,4,5,1,21,12,5,3,7,2,3,1,2,3,16,3,2,15,1,3,5,1,6,20,9,4,9,8,10,
2,3,3,4,3,8,1,8,3,3,1,6,2,6,7,8,4,2,1,3,2,12,6,7,14,33,3,9,1,15,2,7,3,5,1,2,4,6,9,5,9,6,4,11,9,4,3,
3,2,30,3,1,3,11,1,9,5,1,5,9,4,3,2,3,15,7,8,9,4,2,7,11,9,1,6,8,1,12,5,4,5,15,3,7,8,3,3,4,3,2,1,2,19,
5,1,17,16,9,8,13,17,3,4,2,4,11,9,6,1,9,3,8,3,6,1,2,16,6,8,3,12,7,6,3,5,1,6,2,7,9,11,3,10,6,6,11,10,
3,5,9,6,1,5,1,9,6,3,2,3,9,12,4,2,4,6,3,6,5,1,2,1,5,1,8,1,11,6,3,4,2,6,10,3,17,7,3,12,3,2,6,7,8,6,6,
3,10,12,3,6,9,9,8,3,15,12,7,2,9,1,3,18,2,1,9,2,3,6,1,3,11,7,9,6,2,1,14,3,3,6,1,12,3,2,7,14,7,2,1,2,
7,3,3,6,8,3,7,2,10,3,2,6,3,16,3,5,7,8,6,1,5,10,15,6,2,3,9,1,5,19,11,3,4,15,2,9,1,5,3,7,3,2,1,2,3,9,
9,4,6,9,2,3,3,7,6,2,4,3,6,5,6,9,9,25,3,2,1,2,4,15,9,5,1,8,7,8,6,4,5,6,10,5,7,5,13,12,3,12,2,6,9,7,5,
6,9,4,5,6,10,14,4,15,3,2,1,12,8,1,21,14,4,6,3,8,3,10,11,3,1,11,9,6,1,2,3,15,13,9,2,3,1,2,3,4,6,14,
12,1,2,1,5,4,12,9,9,17,6,10,2,1,6,3,3,15,2,6,4,11,10,2,7,2,1,3,9,2,3,6,7,8,1,5,15,6,4,5,6,7,3,5,3,6,
1,27,3,12,11,1,6,3,2,3,16,9,2,10,2,3,19,8,7,5,3,15,7,3,5,7,9,9,2,4,9,18,23,1,11,7,2,3,6,6,16,3,6,15,
14,1,5,1,9,9,6,6,2,6,19,8,4,8,1,2,7,11,4,6,5,12,3,1,5,6,13,2,10,2,1,17,7,5,3,3,15,15,7,2,3,4,3,8,7,
2,10,9,2,3,1,3,5,10,6,12,3,2,3,7,50,19,5,1,2,16,6,3,3,2,3,9,6,7,8,7,5,7,3,3,5,10,3,14,12,1,14,1,14,
3,3,7,8,3,12,3,4,2,1,17,7,3,2,6,3,24,1,2,13,5,10,2,12,1,11,1,2,1,9,11,1,3,18,5,15,7,5,12,1,3,11,1,2,
1,2,18,4,2,9,10,9,15,5,7,9,6,6,5,4,15,6,3,2,3,7,3,2,7,5,13,2,1,5,7,3,11,18,3,3,4,11,6,3,3,7,8,4,6,8,
1,3,3,2,6,12,7,5,3,9,9,4,2,1,2,7,9,15,2,3,4,6,6,5,9,1,5,3,21,6,1,5,9,9,1,14,6,21,3,1,6,12,3,12,8,7,
2,6,4,14,4,6,17,4,6,8,4,2,4,9,2,3,12,3,6,1,6,5,4,8,12,3,6,1,11,4,3,2,1,35,13,5,1,5,1,3,12,3,17,4,5,
1,3,12,2,7,8,7,3,3,2,7,6,2,13,2,10,5,6,1,14,4,2,4,9,2,4,6,3,3,29,1,9,8,6,6,1,12,2,6,13,2,3,10,11,1,
9,8,1,9,3,8,7,14,3,15,6,4,5,10,3,2,1,6,8,7,3,5,3,4,5,4,21,5,9,4,6,6,8,7,5,21,18,10,9,2,3,6,12,4,3,
11,1,11,4,5,1,8,7,3,32,7,6,2,3,6,16,12,2,6,3,7,17,10,6,5,7,2,6,4,5,7,6,3,21,6,3,11,4,11,3,3,18,4,11,
1,5,4,6,3,12,5,6,7,2,3,28,2,15,6,9,1,6,8,10,3,17,1,11,9,1,9,9,2,16,14,1,18,2,7,6,11,3,10,8,3,4,11,7,
2,1,11,3,3,15,3,4,3,3,2,9,9,1,8,12,1,2,1,29,12,1,8,7,5,7,11,4,3,8,1,5,1,8,1,5,4,2,10,8,12,22,8,4,3,
5,1,6,5,4,11,1,2,3,4,6,9,30,3,21,6,3,2,1,2,1,14,3,7,3,12,2,4,2,3,6,21,10,2,1,21,5,1,17,3,3,4,2,1,8,
9,3,15,4,9,2,9,19,11,1,5,4,3,11,6,4,9,2,4,12,3,9,2,21,3,22,8,6,13,5,1,2,7,5,7,6,2,7,14,6,9,1,3,8,7,
2,4,14,13,2,15,6,1,9,6,3,5,6,6,16,9,3,6,5,1,6,8,1,3,2,4,11,15,9,7,3,2,19,3,5,6,1,3,8,4,14,1,8,1,2,9,
9,6,1,17,12,3,1,5,10,2,3,1,9,6,11,3,4,5,3,7,2,1,3,9,20,37,11,3,7,30,3,2,18,4,5,3,3,1,45,5,4,5,4,2,1,
9,5,9,4,5,1,11,1,8,1,26,7,11,10,6,5,3,6,1,3,3,8,4,5,6,12,9,1,2,13,14,3,3,12,1,17,7,2,3,1,11,3,1,6,6,
12,11,4,2,15,9,4,5,1,2,3,6,1,3,5,6,9,7,2,7,9,9,5,1,14,3,3,1,11,4,8,15,1,5,4,11,1,3,8,7,5,15,3,10,12,
3,23,1,3,3,12,20,3,7,2,19,2,7,2,4,5,6,10,8,3,10,12,17,9,1,3,3,2,7,8,6,1,6,2,1,2,4,20,1,8,6,6,12,1,9,
6,5,25,9,2,3,10,11,7,5,12,22,9,6,6,15,12,6,12,18,9,6,2,12,1,6,6,2,6,1,6,8,4,3,5,7,2,4,6,3,2,13,5,1,
5,4,3,9,18,17,6,3,6,1,3,6,3,20,3,3,4,6,11,6,3,6,3,6,15,4,3,2,3,9,3,18,3,1,5,3,7,6,5,7,2,9,7,3,9,3,
12,6,5,1,3,8,9,4,11,4,11,3,7,18,2,3,16,2,12,3,3,1,3,3,3,6,5,6,4,6,14,13,2,3,7,9,5,7,5,7,2,1,2,12,4,
5,6,3,18,3,7,5,22,8,4,3,3,8,9,6,1,5,1,5,3,12,10,3,2,7,8,3,4,12,8,6,21,1,5,10,5,3,6,4,9,5,7,3,3,5,10,
3,6,9,11,16,5,7,5,15,10,11,1,3,2,9,1,18,3,2,6,1,9,5,6,3,16,2,4,11,4,3,3,8,9,3,3,7,15,3,5,4,6,15,9,
17,1,8,1,6,3,2,10,8,4,2,16,2,3,4,5,10,3,6,5,1,3,2,4,12,5,4,5,3,10,3,3,5,10,17,12,3,12,1,11,1,3,11,1,
15,14,1,3,2,7,11,1,9,9,3,8,1,6,3,12,2,3,4,5,1,20,4,8,6,1,3,5,3,3,16,5,13,15,2,1,3,11,4,6,8,7,8,7,5,
3,1,5,12,3,6,3,6,7,12,21,2,13,12,15,8,1,3,2,1,9,5,4,9,2,6,9,6,3,4,8,7,5,13,2,7,11,4,5,1,3,14,12,13,
5,7,5,4,15,6,11,3,10,2,3,6,6,12,1,14,3,3,4,3,3,11,1,2,10,2,13,6,2,10,2,1,6,3,5,1,2,4,14,10,5,6,1,5,
4,21,18,2,7,2,3,10,12,5,3,6,6,1,2,1,6,8,3,4,9,5,7,2,3,7,5,7,8,1,2,4,5,1,3,15,2,10,2,6,7,15,3,2,22,5,
7,23,3,9,3,3,22,12,3,2,9,1,6,3,5,4,5,1,6,6,2,25,11,16,11,7,12,9,5,16,5,1,18,2,3,9,10,11,9,3,10,8,1,
5,3,1,2,9,1,8,6,1,8,4,8,7,2,3,13,5,4,6,2,13,3,27,29,3,6,7,9,8,22,3,3,2,7,3,11,4,5,16,12,14,1,3,11,1,
3,9,8,3,10,2,12,10,11,7,2,1,5,4,12,6,14,15,16,2,1,6,9,2,4,8,3,7,2,3,1,11,13,11,10,2,3,4,2,10,9,5,4,
3,14,1,8,1,8,7,3,8,3,4,8,9,1,9,3,2,3,10,8,9,9,7,3,6,3,15,2,9,6,1,5,12,1,2,4,3,3,2,1,6,5,3,13,2,1,2,
3,7,5,3,12,12,7,9,2,3,7,5,3,10,5,6,3,7,11,9,4,11,4,2,7,5,6,1,11,4,3,3,3,6,8,1,6,6,9,11,9,1,23,12,18,
1,5,9,9,10,11,4,6,9,5,3,10,5,3,4,5,13,2,1,9,2,6,4,5,4,2,7,2,3,10,2,4,15,12,2,6,1,9,2,19,6,3,11,15,3,
6,1,3,3,3,5,7,3,6,6,24,3,6,9,20,1,2,3,4,17,9,10,2,3,4,3,9,5,21,13,14,1,2,3,1,3,3,2,1,11,1,8,7,2,7,3,
2,1,5,9,6,15,3,7,14,1,3,15,9,8,13,21,18,12,6,3,5,1,11,4,3,30,5,3,13,9,5,1,2,7,26,4,8,3,4,3,14,4,2,4,
3,2,6,7,5,6,6,10,6,5,9,3,7,3,17,3,1,2,18,9,7,3,11,6,1,8,1,6,9,6,3,9,2,1,17,3,4,6,3,11,10,14,1,3,2,1,
2,7,6,5,10,9,5,9,12,3,6,1,8,16,5,3,3,3,1,11,7,5,1,9,2,6,4,9,2,3,4,11,10,14,6,4,2,4,5,4,6,20,7,3,5,7,
9,5,3,1,2,3,1,3,8,4,5,16,2,10,6,6,11,9,21,3,19,2,1,14,1,2,10,5,16,5,6,9,6,6,4,6,2,3,3,6,1,3,9,3,3,6,
3,2,6,3,10,6,3,3,3,11,10,3,3,2,25,2,1,2,1,14,27,3,7,5,6,3,1,5,15,9,6,10,5,3,3,7,6,11,16,9,8,3,3,7,3,
5,4,3,2,3,4,11,7,5,10,2,1,2,6,6,3,1,2,3,7,14,18,3,4,5,16,5,12,6,1,5,1,9,3,2,21,10,14,3,1,2,10,3,20,
1,14,4,2,3,13,12,3,23,7,14,1,14,10,6,5,3,1,11,7,3,2,1,2,4,5,4,2,4,3,8,7,11,1,9,9,5,6,1,9,2,9,15,3,6,
1,11,3,7,29,3,3,4,20,3,3,7,6,5,1,9,2,3,1,20,1,2,1,20,10,5,6,13,5,10,6,5,7,2,6,15,1,6,5,9,1,5,7,6,2,
7,2,4,9,17,16,3,12,5,9,4,5,6,10,8,6,4,3,5,10,3,5,1,6,5,4,8,21,24,1,6,6,3,2,7,2,15,3,1,2,3,1,3,5,6,1,
21,9,3,12,8,22,8,3,15,15,7,5,16,6,8,3,3,4,3,2,1,5,1,5,1,8,4,2,21,10,3,11,4,2,3,9,10,2,9,1,5,9,7,5,3,
4,8,7,12,11,3,10,29,6,1,3,3,2,3,4,20,3,15,16,6,3,2,19,2,3,1,14,4,3,12,15,2,3,1,5,1,6,2,1,6,6,2,21,9,
7,6,3,12,5,4,3,8,4,3,3,3,6,3,3,20,3,6,9,6,4,2,9,3,1,9,2,3,1,5,4,8,9,3,21,7,5,7,2,4,9,2,1,3,6,8,3,3,
16,3,5,1,11,3,7,8,16,9,15,5,3,7,11,1,6,3,5,1,5,6,10,12,3,3,5,7,2,22,9,6,8,6,1,5,1,2,6,4,5,21,6,1,5,
7,2,4,5,4,5,3,3,9,6,12,4,6,2,7,3,2,1,20,9,4,2,4,23,13,3,2,9,10,5,6,13,9,5,1,5,7,2,10,2,19,11,3,6,4,
3,8,9,1,14,6,1,3,17,3,1,5,6,1,3,6,3,11,1,6,3,2,13,11,3,15,3,12,6,9,1,6,6,9,3,8,12,1,20,4,5,13,2,7,
11,3,1,5,3,6,4,6,2,15,7,5,3,12,1,2,9,1,14,1,8,6,9,1,6,8,7,14,6,3,16,6,14,10,6,33,2,4,5,6,3,9,1,6,3,
2,4,5,10,2,4,14,10,9,5,1,9,2,25,6,2,6,1,6,14,15,1,15,2,7,9,2,10,17,7,5,4,6,11,15,3,6,3,7,3,21,9,20,
7,5,1,5,10,14,10,3,2,10,15,3,5,1,11,3,1,2,7,2,1,5,3,4,6,21,9,2,4,9,2,10,2,1,6,5,15,1,12,2,6,13,2,12,
1,2,3,1,11,7,17,9,6,16,12,2,1,2,1,15,2,12,1,9,3,9,9,5,1,11,7,2,1,3,2,3,4,2,3,10,18,2,3,3,6,19,6,3,
11,1,30,15,3,3,2,3,9,15,3,1,12,18,5,9,1,2,15,3,10,5,1,3,5,1,11,1,2,3,10,2,3,3,1,3,18,5,22,3,2,1,6,3,
3,2,22,3,2,9,1,11,12,1,2,18,7,8,16,5,9,21,1,8,7,3,11,4,6,3,3,2,1,5,25,2,3,9,3,4,3,3,5,19,5,9,9,10,2,
3,1,12,5,4,6,5,13,26,3,10,15,5,13,20,9,4,5,4,5,1,11,10,8,7,3,3,2,7,9,6,3,2,1,23,9,1,6,3,11,4,6,2,7,
2,9,7,2,1,9,5,3,3,1,5,4,9,2,6,9,3,1,5,16,6,8,1,6,2,1,2,9,9,4,2,1,20,9,3,10,3,2,12,1,14,3,1,5,1,3,2,
3,6,1,3,3,5,9,1,9,8,1,2,3,19,2,10,5,1,14,9,4,23,33,4,5,1,5,7,8,7,5,7,18,9,8,3,10,17,6,6,1,2,13,5,9,
4,5,6,1,23,7,14,3,1,5,7,8,1,3,2,1,8,7,3,5,6,4,2,9,3,7,6,3,2,4,3,5,1,6,14,4,11,1,3,6,9,2,4,9,2,6,7,3,
8,4,17,3,3,10,9,6,5,3,9,7,3,5,1,9,5,7,9,5,12,3,4,2,9,12,3,6,3,1,15,17,4,6,17,7,8,3,4,3,2,18,1,2,4,
11,7,11,1,14,9,10,2,1,2,12,1,12,3,2,1,6,3,2,6,4,9,2,7,18,5,4,3,8,4,3,3,5,3,4,3,12,12,8,1,2,3,6,1,2,
16,2,12,7,5,13,2,3,7,8,3,7,3,3,5,7,8,1,5,6,10,2,6,4,11,6,4,2,4,8,6,9,1,5,4,5,1,12,9,3,11,1,26,4,3,5,
3,3,16,6,2,1,17,7,5,6,12,7,8,4,14,1,9,2,3,7,15,8,1,5,6,3,4,3,3,9,3,9,5,18,3,4,3,11,6,4,2,3,1,3,2,10,
9,5,9,7,3,2,4,2,10,3,11,4,5,7,8,1,15,3,3,18,11,3,15,10,3,3,6,5,1,5,3,1,11,10,3,9,6,9,2,3,13,2,15,6,
1,8,3,3,21,6,10,2,7,14,1,9,5,21,3,10,2,1,2,12,13,6,6,5,4,6,8,3,3,6,3,13,2,3,4,6,12,3,5,7,3,2,1,9,2,
10,3,11,1,5,4,11,4,6,20,1,5,10,2,7,18,6,12,3,5,9,1,12,9,11,10,2,3,4,3,2,4,5,4,5,3,4,14,6,1,2,3,3,4,
5,3,7,2,4,24,2,9,22,2,1,11,4,2,4,5,9,1,3,2,15,1,12,5,3,7,3,2,10,5,13,3,5,6,13,2,1,8,4,5,1,6,15,11,
13,6,6,3,2,3,1,3,3,5,13,2,7,2,3,1,2,4,9,15,11,1,3,6,6,3,5,19,11,4,5,1,11,4,2,7,3,5,12,1,12,5,7,3,5,
7,17,10,3,2,3,15,10,2,3,7,5,18,7,11,10,3,2,4,8,1,2,15,7,21,9,5,6,10,2,7,2,1,12,8,3,1,8,1,11,10,8,7,
3,11,1,11,7,3,12,5,1,5,1,8,22,5,4,6,5,6,9,9,12,22,3,2,3,3,7,3,6,11,19,3,3,5,9,1,12,2,4,2,3,16,5,9,9,
3,10,5,3,4,3,14,15,3,3,12,1,6,6,27,2,1,12,2,4,5,4,3,3,2,7,15,21,6,5,1,12,2,3,3,13,5,7,5,9,19,5,9,6,
6,3,7,14,7,12,3,3,9,12,8,6,9,1,21,20,1,5,13,17,4,6,5,4,6,3,6,5,3,7,6,8,6,18,7,5,4,5,10,2,12,6,10,9,
2,1,2,3,9,9,10,6,5,6,4,3,12,3,2,15,3,7,6,14,4,12,17,1,2,7,3,8,4,5,6,7,12,2,6,4,3,6,2,3,9,1,27,9,21,
5,4,8,3,4,6,8,9,18,10,3,5,7,18,5,4,5,7,14,6,3,1,6,9,2,4,11,9,4,11,9,4,3,2,3,9,6,9,4,11,3,10,3,2,6,7,
3,12,3,2,4,5,3,6,6,6,13,2,4,3,8,4,6,8,15,6,4,2,4,5,9,7,8,4,20,3,4,15,14,6,3,1,2,10,2,7,3,6,11,4,6,
11,4,9,2,3,4,12,6,3,2,3,16,5,1,14,13,2,3,1,9,5,3,3,1,8,1,5,1,30,5,1,8,4,2,1,14,3,3,4,11,4,6,17,1,6,
5,9,7,15,5,4,14,1,6,3,12,2,1,11,9,6,1,5,10,3,11,3,1,2,4,3,15,6,5,4,2,1,18,9,2,3,3,9,13,6,15,5,1,21,
9,11,3,6,9,10,9,3,2,10,5,3,3,9,10,3,3,6,8,10,15,3,5,12,7,18,5,1,6,8,1,5,1,18,5,10,3,5,7,8,9,16,2,1,
5,4,2,1,14,4,14,6,6,9,4,2,3,7,3,2,6,4,3,5,6,4,3,14,6,4,14,4,3,15,2,15,1,20,4,5,6,9,1,5,1,8,7,3,17,1,
2,1,11,4,5,7,29,4,2,9,6,7,3,5,3,4,2,4,9,5,3,3,1,3,3,9,9,12,8,21,1,5,3,4,2,3,7,3,11,1,8,1,2,7,6,14,3,
3,9,3,3,1,3,2,9,7,9,3,2,3,3,3,7,5,4,5,1,24,3,3,5,3,10,9,3,3,2,4,3,8,7,11,6,16,5,4,5,1,2,10,2,6,3,10,
15,14,1,6,5,10,9,2,3,1,5,3,7,23,7,8,1,2,3,1,6,3,5,4,11,1,6,15,2,6,1,3,11,7,2,16,5,10,2,4,3,2,10,8,3,
3,1,3,11,22,9,5,3,1,2,7,17,1,2,1,26,1,9,11,3,6,1,3,2,7,15,3,2,1,5,4,3,2,6,10,9,8,7,2,4,11,3,12,6,13,
14,12,1,5,4,3,8,4,9,2,3,4,3,2,3,4,14,4,8,7,2,4,11,9,1,5,1,18,9,2,3,3,19,8,6,7,2,6,15,16,5,4,2,7,5,7,
9,12,32,3,7,3,5,7,11,4,15,2,13,3,5,3,4,11,6,1,8,4,17,4,2,19,3,11,1,9,5,4,11,9,3,9,3,3,4,20,3,3,12,1,
17,3,16,6,14,3,12,6,3,6,19,5,1,3,12,3,2,15,1,5,3,7,8,7,5,10,5,12,1,5,1,8,12,3,7,6,2,13,15,8,6,4,14,
3,3,19,5,28,2,7,11,3,4,3,23,4,6,12,9,5,1,8,1,5,6,9,9,7,9,5,4,17,7,6,11,3,6,7,2,18,3,7,2,7,3,2,6,7,5,
1,2,24,4,2,4,11,24,4,9,6,2,3,1,6,2,7,14,6,3,7,14,1,20,3,10,2,18,3,9,1,20,3,4,11,6,1,12,3,2,1,6,9,9,
3,5,4,3,18,9,11,4,6,5,7,2,13,5,3,10,9,5,9,1,8,1,5,4,5,3,3,4,17,4,27,3,2,4,15,6,2,3,3,4,5,12,15,34,6,
15,18,5,10,2,1,17,10,5,3,12,3,4,14,12,4,3,11,7,5,3,4,2,1,3,2,12,10,6,15,12,2,1,2,4,20,13,3,5,7,5,6,
1,9,2,4,5,1,14,1,3,9,8,3,6,1,3,9,6,2,4,5,6,7,3,5,9,9,6,3,1,9,2,9,7,35,3,4,3,2,1,11,9,6,4,12,5,4,3,2,
4,2,3,21,9,4,3,5,7,5,7,6,9,14,21,4,6,5,4,2,4,8,1,6,5,4,5,19,2,3,3,9,1,5,7,5,12,4,12,3,5,4,3,2,6,9,1,
9,5,3,3,1,5,16,3,6,3,5,3,4,6,5,4,5,10,11,3,1,3,3,5,13,2,12,3,9,3,6,1,8,12,1,3,14,7,8,6,4,17,3,10,5,
1,2,3,1,3,6,5,1,3,6,11,1,2,3,3,7,2,6,7,3,11,10,3,8,13,6,3,6,12,2,3,3,25,9,2,1,9,3,21,14,1,11,1,3,2,
9,3,3,9,13,5,7,14,1,20,9,10,2,9,3,3,13,11,4,6,8,10,3,2,1,5,1,5,4,5,7,12,3,9,6,5,3,12,4,3,11,7,3,9,2,
1,3,6,6,2,1,11,3,10,11,4,5,3,4,18,3,2,22,14,1,5,10,5,6,7,3,3,15,5,7,2,16,17,7,8,4,21,5,22,11,1,5,1,
2,1,5,15,4,5,7,9,2,19,8,1,6,15,14,7,12,5,3,4,5,13,6,2,25,15,2,13,3,17,3,12,10,17,6,7,2,3,7,2,10,8,1,
5,4,5,6,4,11,10,2,4,5,3,6,9,10,2,3,1,21,15,5,33,13,3,5,1,14,1,8,7,3,2,1,8,4,2,6,10,2,1,14,10,20,1,
12,5,7,2,13,6,9,3,5,4,9,6,8,3,4,9,6,5,1,3,11,1,8,15,16,5,4,12,8,6,1,3,5,1,8,3,12,10,3,5,9,10,3,2,9,
4,11,4,17,1,15,9,3,3,14,1,2,15,1,12,3,9,5,18,3,15,1,5,1,18,2,7,11,12,10,2,1,5,15,1,8,6,1,5,6,12,1,2,
9,6,4,11,7,3,20,3,12,13,5,4,2,3,12,9,4,3,2,12,1,3,11,9,4,2,6,3,1,6,14,6,4,3,6,6,3,3,9,5,1,3,5,1,11,
7,2,3,10,8,3,9,1,2,12,10,6,11,1,2,7,5,3,10,12,11,3,10,9,2,9,7,9,9,11,6,4,6,8,4,6,2,3,4,3,5,7,5,7,15,
8,1,5,15,1,8,13,15,5,4,21,5,18,10,2,7,5,13,3,9,6,6,3,2,19,2,7,3,3,5,7,2,1,6,5,3,10,2,1,5,9,3,1,2,13,
2,7,15,5,13,2,1,11,9,1,5,25,3,2,9,1,11,13,5,10,6,5,1,5,4,11,3,4,15,2,3,1,9,11,6,1,15,3,6,6,8,6,6,7,
2,3,1,14,6,7,3,12,2,7,6,2,1,2,4,5,6,13,5,19,2,3,15,3,3,6,18,1,6,11,4,5,4,2,3,4,5,7,14,9,16,5,7,2,6,
4,17,9,7,5,15,18,1,3,11,9,6,4,3,2,3,3,25,2,25,3,5,1,3,5,6,10,35,4,3,2,3,12,3,7,11,1,3,21,14,3,9,15,
1,5,12,1,2,10,3,6,5,4,5,6,6,3,7,9,9,5,9,21,1,3,5,6,15,7,8,6,3,10,2,4,9,5,1,2,4,3,2,3,3,7,3,5,3,1,3,
5,21,1,11,7,20,1,6,14,7,3,2,12,7,11,4,6,2,10,2,1,5,10,2,3,7,12,3,8,10,2,1,5,15,6,1,35,7,2,4,2,4,8,1,
11,3,7,6,23,7,14,6,7,6,6,3,18,15,5,3,4,12,26,13,6,6,5,3,1,3,2,4,6,8,10,5,7,5,4,11,3,7,8,10,11,4,2,
18,6,12,3,4,3,5,3,4,17,6,7,27,6,9,5,9,10,5,4,3,2,3,7,8,12,6,1,5,25,3,5,3,10,8,6,1,14,10,6,2,3,3,9,6,
1,9,2,3,1,3,2,9,1,3,17,1,3,17,4,9,12,2,12,6,4,8,13,3,9,6,2,12,1,5,4,3,2,3,13,11,6,7,2,1,12,2,1,12,6,
14,7,20,4,6,9,2,3,9,6,7,12,5,1,2,7,5,42,1,8,12,9,13,2,13,2,6,12,7,3,3,15,14,13,3,3,9,3,3,2,9,9,16,5,
4,11,9,12,4,18,2,10,3,12,6,2,12,4,5,1,8,3,12,7,5,1,3,15,6,3,5,6,1,3,6,9,11,6,1,5,3,4,3,2,10,8,3,4,3,
3,17,27,7,5,6,4,5,3,6,1,5,13,5,3,15,10,14,1,30,5,27,12,4,9,3,3,6,3,5,1,6,11,4,3,3,5,3,1,9,2,10,12,6,
17,7,2,1,2,1,12,9,5,1,5,4,3,6,15,17,7,3,5,3,7,8,7,9,3,12,3,3,5,9,3,10,8,3,1,9,6,3,3,8,1,8,6,1,14,7,
5,7,3,5,4,5,6,7,11,6,4,15,5,1,3,2,1,14,1,12,2,6,12,7,3,3,8,1,5,9,1,8,12,10,5,1,15,3,9,5,6,4,6,2,19,
8,1,5,4,2,13,2,6,7,2,13,8,12,6,21,3,1,2,7,2,1,2,12,1,3,2,3,12,7,11,9,6,4,3,2,6,1,5,1,5,10,5,3,4,2,1,
3,11,10,3,2,3,1,5,9,6,7,9,5,1,2,1,2,7,11,1,24,6,3,2,6,3,9,1,6,3,18,3,2,12,6,7,15,3,27,3,6,5,15,3,12,
10,6,3,5,10,11,10,9,2,9,10,8,1,5,6,6,4,23,3,4,8,6,1,8,15,6,10,5,4,3,5,9,4,2,3,4,2,15,9,7,9,5,1,9,21,
2,7,3,3,5,10,9,5,4,9,6,2,18,7,9,5,16,17,10,5,3,4,3,3,3,12,8,9,6,1,11,22,3,3,2,7,2,13,5,7,9,17,3,19,
6,2,3,16,3,20,3,3,4,2,21,9,1,9,9,2,9,3,12,6,7,6,2,12,1,11,16,2,10,6,2,10,9,14,9,7,3,5,12,1,2,1,6,3,
3,2,10,2,6,3,4,15,2,10,3,5,1,2,4,5,3,6,1,5,4,5,7,8,4,3,3,12,5,15,7,3,17,1,5,1,6,2,1,2,12,7,6,5,7,12,
5,4,5,10,5,4,2,4,14,1,2,4,6,2,7,3,8,7,2,4,20,1,6,9,3,6,15,2,15,3,6,9,16,9,6,6,5,9,1,3,5,9,12,3,10,2,
6,3,7,3,2,9,3,3,4,3,8,4,3,3,3,5,9,1,11,6,4,11,7,2,10,5,4,5,7,2,1,2,3,7,20,7,3,5,13,11,3,16,15,11,3,
7,6,8,12,7,6,5,4,2,6,7,6,2,10,9,5,10,6,2,1,5,9,7,9,5,9,15,7,14,6,1,9,11,3,12,7,2,9,4,8,7,2,13,3,12,
3,2,6,9,3,4,5,6,9,4,14,1,6,8,6,10,9,6,5,7,14,9,10,9,2,1,2,1,21,9,2,4,3,6,11,3,1,2,3,4,8,4,6,8,9,1,2,
7,8,7,6,15,5,6,1,2,6,7,2,3,4,5,1,8,6,6,4,5,4,6,14,7,2,1,5,6,3,10,2,1,5,3,10,11,4,6,9,15,2,4,14,6,3,
13,2,7,3,2,6,12,3,4,3,5,1,17,3,4,17,10,6,8,1,5,18,1,11,6,3,4,3,8,4,12,6,3,9,2,1,8,1,6,20,18,1,6,2,
16,6,8,7,3,8,3,6,6,3,7,9,9,2,7,5,1,11,4,5,6,1,2,3,7,3,8,1,14,10,6,5,6,7,12,3,3,9,11,4,3,8,3,1,6,3,5,
19,11,4,12,3,3,2,18,4,6,2,3,3,6,4,2,13,2,27,1,2,4,6,8,6,4,5,6,1,8,10,11,1,3,6,5,18,6,4,23,9,1,8,1,6,
12,17,4,2,13,9,2,3,6,1,5,10,5,6,15,3,9,7,3,5,6,12,12,1,6,8,1,12,15,8,6,3,31,6,8,12,3,6,4,3,9,3,2,1,
8,4,15,11,4,3,9,5,3,12,1,12,2,1,14,4,11,1,5,9,3,1,9,3,2,3,3,4,2,1,8,15,9,7,3,8,7,6,30,2,3,6,1,9,14,
22,3,9,2,3,10,6,6,6,2,1,5,6,1,9,5,3,6,9,6,4,3,3,5,7,2,12,9,4,5,3,4,6,3,14,7,6,9,11,13,9,2,4,9,3,2,6,
10,5,1,11,10,2,3,18,6,3,1,2,15,4,3,5,6,1,5,1,18,5,9,6,4,2,18,1,14,7,3,6,5,4,11,1,14,4,5,21,4,2,3,3,
4,3,2,4,5,9,3,27,7,11,4,5,1,5,3,16,3,2,4,5,19,6,5,7,14,1,5,3,4,2,13,2,1,9,8,1,5,1,11,7,2,3,1,6,8,6,
7,14,6,3,10,17,7,8,3,1,8,1,5,10,5,1,5,1,2,12,4,11,1,3,2,7,6,2,7,8,4,3,2,9,9,1,5,4,3,2,7,3,3,12,8,9,
3,6,7,2,1,5,1,9,11,3,1,6,3,2,13,3,12,8,18,7,2,3,3,15,10,9,15,2,6,3,6,10,3,6,2,3,19,5,1,14,3,3,30,4,
2,4,2,4,11,3,4,6,11,1,9,6,3,9,3,5,3,12,10,14,9,1,6,3,9,2,10,5,4,24,2,4,11,1,2,1,6,8,13,2,7,20,9,7,
23,6,4,15,9,8,10,2,6,6,9,1,11,13,15,11,4,14,7,3,3,8,6,1,2,7,3,8,13,2,7,17,3,22,3,2,4,14,1,11,3,6,1,
5,1,8,4,5,3,9,9,7,14,3,13,2,7,5,19,12,2,1,9,6,6,9,5,9,6,1,9,5,4,3,14,1,5,3,6,1,24,9,2,4,20,4,2,4,3,
2,3,3,4,5,1,3,11,1,5,15,4,20,1,3,5,7,12,2,3,7,14,9,7,8,1,5,1,3,8,3,9,7,5,1,5,4,6,5,4,5,4,9,2,6,7,2,
3,3,10,2,12,4,12,2,1,6,20,25,3,5,3,18,1,5,4,6,5,4,2,10,2,10,6,5,4,5,15,7,3,5,16,5,1,5,10,6,8,4,6,2,
10,5,9,4,6,6,3,12,3,5,31,24,2,4,5,3,3,7,8,4,6,3,11,9,1,5,6,3,15,6,1,2,7,21,2,1,2,10,2,1,5,1,5,10,5,
3,3,10,5,7,5,1,17,3,39,6,9,6,6,1,3,9,3,3,2,4,9,5,4,11,1,5,1,18,2,3,4,2,3,3,4,6,5,3,7,2,30,7,23,3,9,
3,6,6,6,7,8,12,6,7,14,15,4,5,4,2,9,4,6,5,6,1,3,6,11,4,8,3,7,3,2,6,7,5,4,3,3,2,7,3,2,9,4,2,10,9,24,2,
1,2,18,10,5,3,4,11,4,8,7,11,10,6,6,9,9,11,3,6,15,7,3,6,8,3,4,6,2,1,11,15,1,8,9,7,3,3,12,3,2,1,6,3,6,
2,13,15,12,17,10,2,4,2,3,6,10,11,3,1,8,3,28,5,7,5,7,2,1,5,10,9,14,7,12,2,4,6,8,3,3,1,3,3,5,7,2,21,9,
3,1,2,3,4,6,15,12,2,12,3,3,4,9,2,10,2,1,9,2,3,1,6,6,5,3,4,3,8,7,8,4,5,12,1,5,12,1,9,12,3,5,7,23,7,
15,5,13,15,6,12,2,6,15,1,5,4,2,3,4,2,15,4,14,3,7,5,10,5,6,4,5,1,12,5,12,7,5,4,2,10,9,5,3,3,7,17,4,5,
7,3,11,13,6,5,4,3,9,3,2,3,3,7,11,1,8,1,5,7,5,3,7,12,11,4,8,9,10,14,4,5,12,3,6,6,10,3,3,3,11,1,9,5,6,
4,3,11,7,8,12,9,1,12,6,11,4,2,12,7,3,11,4,5,1,14,1,2,19,6,17,10,5,1,2,4,9,2,24,6,12,3,9,6,3,4,5,21,
12,7,30,12,18,6,11,4,6,6,3,2,9,10,6,5,4,3,12,3,2,15,3,1,27,24,18,2,6,4,6,3,11,3,3,7,5,16,9,6,5,12,
12,10,3,5,3,19,5,7,9,6,8,6,1,11,12,21,4,2,1,30,3,5,7,9,9,9,8,15,7,2,1,5,4,5,10,6,8,7,3,12,8,1,6,5,9,
1,12,17,6,7,3,5,3,1,5,4,14,1,5,1,3,5,13,5,3,16,5,6,3,1,8,6,10,5,7,3,6,8,10,2,1,5,7,2,3,1,2,7,8,4,18,
5,1,6,8,10,2,6,3,15,19,8,3,7,2,1,11,3,7,8,3,4,14,1,3,8,3,7,3,6,11,22,3,2,12,1,3,14,7,11,10,2,3,18,7,
9,3,2,3,13,2,1,9,5,3,3,1,3,2,4,9,27,14,6,1,2,15,6,1,3,12,5,6,3,4,5,3,4,8,6,7,3,2,9,4,5,1,6,15,8,1,3,
18,5,15,3,9,3,3,1,5,15,3,6,25,12,3,2,4,5,13,3,2,1,9,2,1,3,5,6,1,12,8,3,1,3,2,4,2,3,4,3,14,9,1,3,5,1,
11,9,7,15,5,13,14,3,15,4,3,5,3,3,1,5,18,1,6,5,3,3,3,7,3,5,10,6,3,12,3,3,14,9,7,2,6,6,13,6,11,6,4,5,
4,12,5,4,20,4,2,7,3,12,2,9,6,3,10,11,1,8,3,10,8,15,4,3,9,3,11,9,1,9,2,4,5,4,11,4,3,18,5,6,1,2,7,21,
9,11,3,7,2,1,5,1,21,5,9,15,1,3,2,7,3,5,7,2,9,1,8,7,5,1,14,1,8,1,8,6,6,1,8,6,1,12,20,3,4,3,2,15,4,5,
7,9,3,8,9,3,1,9,2,3,3,13,2,13,14,13,12,2,16,3,2,9,6,3,10,9,2,1,3,5,6,1,2,1,6,14,4,2,6,9,1,17,18,4,
14,1,6,23,4,6,5,9,7,11,4,3,5,6,1,3,5,1,11,1,5,18,1,9,11,1,23,4,6,5,4,2,15,6,3,16,5,6,3,9,1,14,1,2,3,
1,6,2,7,3,20,3,3,16,11,3,4,2,1,12,2,3,1,21,5,1,9,8,3,3,6,1,8,4,15,6,6,3,5,13,5,3,4,11,7,2,7,3,5,3,
13,12,14,9,4,3,12,3,2,6,9,3,3,1,3,5,3,10,5,57,12,1,2,12,6,3,10,29,6,4,3,3,2,4,5,16,2,10,2,10,6,14,6,
12,7,8,1,5,1,5,3,6,6,1,17,6,1,5,13,2,1,3,6,9,20,7,9,6,5,4,5,28,6,11,6,4,3,8,3,9,13,8,1,5,1,2,3,3,4,
6,5,4,8,4,5,3,1,6,6,3,14,1,6,5,6,10,9,9,12,2,1,2,15,7,5,3,9,21,4,5,13,3,3,2,12,7,3,8,7,18,8,1,5,4,2,
7,15,8,7,2,1,2,18,3,7,2,10,11,6,3,1,14,3,3,7,15,3,6,5,9,4,3,5,4,3,11,6,3,10,12,11,12,7,3,5,1,6,3,15,
5,7,6,3,5,6,1,2,10,3,14,1,14,13,11,1,9,11,1,2,10,2,9,4,2,9,4,2,10,3,5,3,3,7,3,2,4,3,3,3,5,1,11,3,7,
20,3,12,13,2,7,5,3,3,10,14,15,10,2,1,12,2,19,2,3,7,3,5,1,5,10,9,6,5,10,14,4,6,6,3,8,7,3,2,6,1,5,3,6,
6,6,4,6,2,6,4,2,15,10,8,15,1,2,3,1,8,1,11,1,2,1,5,4,5,10,6,11,3,3,18,1,3,6,2,7,2,3,1,11,3,1,11,13,8,
3,12,4,8,3,3,4,3,5,12,6,10,6,6,5,3,22,2,18,12,3,9,9,1,14,12,3,1,3,3,5,10,3,2,19,9,14,6,7,3,6,3,2,3,
3,3,6,19,15,2,13,11,19,6,3,8,4,11,7,8,13,12,2,12,4,11,3,6,1,3,2,6,3,15,7,17,1,6,3,12,3,2,9,12,9,1,2,
10,2,6,9,3,10,21,9,2,4,5,1,5,3,3,3,7,8,6,19,11,3,3,13,6,6,3,6,5,3,1,6,8,7,3,2,9,4,5,3,15,13,2,4,3,6,
6,5,4,5,4,2,15,1,14,6,9,4,6,8,1,2,13,15,14,3,3,4,6,2,3,7,20,4,6,8,6,1,8,12,10,2,7,14,9,15,1,6,15,15,
6,9,3,12,3,2,1,3,15,11,3,1,12,2,12,1,2,12,3,10,3,8,6,1,15,2,3,13,5,1,21,3,5,6,3,6,1,3,2,6,15,12,1,
11,13,8,4,3,5,7,6,2,6,16,3,3,3,12,2,16,9,5,1,2,3,1,5,3,1,11,1,3,11,9,12,7,5,3,13,6,3,11,6,1,14,3,3,
10,8,10,11,1,5,7,6,2,13,5,6,10,5,3,7,6,2,6,6,1,3,2,3,4,2,1,9,3,6,5,4,17,3,7,9,17,13,2,7,3,12,8,7,6,
2,3,15,10,6,8,6,7,12,2,1,3,17,7,3,2,1,9,6,11,1,2,1,5,4,15,6,9,2,6,4,11,3,10,2,10,2,7,6,8,6,1,5,9,4,
5,4,20,6,4,8,13,21,3,8,3,7,3,2,3,6,18,7,8,1,11,4,11,6,4,3,2,9,1,5,1,5,7,3,2,10,12,6,3,5,1,3,3,17,6,
7,9,5,1,3,9,8,7,2,3,3,3,4,3,3,2,12,7,8,6,9,12,1,12,8,9,4,5,4,12,6,15,5,4,26,7,8,4,8,3,7,11,16,5,1,2,
6,6,19,5,12,7,2,3,1,6,11,13,11,10,8,3,7,2,13,2,6,13,2,7,3,8,1,3,3,14,6,4,15,5,18,10,5,6,1,8,12,10,9,
27,8,6,4,6,5,18,6,1,3,5,13,3,2,19,3,8,9,1,5,4,9,9,6,2,7,6,20,1,5,3,10,6,5,6,3,7,11,18,1,8,12,6,15,7,
11,7,12,23,4,3,5,6,19,5,3,7,2,1,8,9,10,5,3,7,11,6,4,5,6,1,3,9,3,5,4,5,6,15,9,21,3,1,6,15,3,5,1,5,1,
12,3,5,22,5,13,5,9,3,1,6,6,8,1,3,12,3,6,5,16,8,1,5,4,6,2,3,7,3,6,5,3,15,7,6,15,9,9,2,3,1,3,12,3,5,6,
6,13,11,10,5,4,2,6,7,6,2,3,9,1,5,7,27,2,6,3,21,1,2,10,8,15,3,4,5,1,6,15,3,2,3,3,22,20,10,5,1,9,2,15,
1,2,7,3,8,4,14,4,3,2,3,7,8,3,1,18,2,1,8,1,5,3,3,9,3,7,3,3,3,5,9,1,11,3,7,6,9,3,20,1,2,9,6,3,1,3,6,9,
5,1,15,5,1,9,9,6,5,6,6,4,5,1,5,7,11,7,14,3,3,3,7,3,2,7,3,3,11,1,8,1,8,16,2,7,2,15,4,2,22,2,3,15,6,4,
11,6,4,5,34,12,6,9,6,3,6,8,12,1,5,9,6,19,6,3,6,5,18,1,2,3,4,2,3,12,6,12,3,13,5,1,9,6,5,3,12,1,2,7,6,
5,9,1,3,5,10,9,8,10,2,1,5,15,1,6,15,5,4,3,6,14,3,9,6,7,3,3,2,4,9,6,11,10,5,3,15,10,11,3,1,12,3,2,3,
9,1,5,1,6,15,2,10,36,6,6,2,6,9,1,5,1,5,6,9,10,5,15,15,3,1,2,10,17,7,9,2,3,4,12,5,13,3,9,3,8,3,12,7,
11,1,8,3,3,6,3,6,22,9,3,5,1,9,8,4,5,4,15,5,1,6,2,18,7,2,3,3,13,15,6,8,13,5,3,4,3,8,6,1,12,2,13,2,9,
7,2,3,10,20,3,6,10,3,6,5,7,2,7,9,5,4,5,1,2,18,1,8,3,9,16,8,9,22,9,5,6,3,12,3,10,17,1,3,2,3,6,6,4,3,
2,4,2,7,18,2,13,5,4,8,7,11,7,5,1,27,9,3,6,12,9,3,3,2,10,6,15,2,13,2,10,2,6,6,4,14,18,4,11,3,4,3,3,2,
4,5,6,10,5,7,3,3,11,3,1,2,3,12,4,3,2,13,8,7,2,16,2,3,10,2,6,15,1,5,9,4,6,2,13,9,12,8,1,6,3,3,2,1,5,
6,10,3,5,10,11,10,2,7,5,3,4,3,3,9,8,6,6,4,6,15,9,2,9,1,23,1,3,3,9,24,11,1,8,6,1,3,11,1,2,1,29,3,4,8,
1,21,8,3,10,5,7,3,2,10,21,9,6,6,5,1,23,6,6,3,7,3,9,2,13,11,1,6,14,1,5,3,1,3,8,4,5,1,5,7,3,9,9,5,4,
15,3,2,7,5,13,2,9,4,11,4,3,2,3,7,5,10,6,2,9,4,5,7,3,2,4,6,12,2,1,18,11,6,4,6,17,15,3,4,5,10,6,8,4,3,
9,3,6,12,3,11,1,14,3,6,1,5,13,6,17,4,18,5,10,20,21,1,9,9,12,5,6,10,18,15,5,7,12,15,3,2,7,5,3,3,13,2,
3,1,5,1,2,6,6,10,8,3,4,6,14,1,2,12,3,7,3,6,9,3,8,1,11,3,21,4,2,7,2,3,1,15,9,6,5,1,6,2,7,5,3,3,3,4,8,
9,1,3,11,3,10,5,1,2,15,18,9,6,4,3,12,2,1,3,11,3,3,7,2,13,5,6,4,2,4,17,3,1,14,1,9,2,30,19,5,4,12,3,2,
4,3,11,4,2,4,5,6,3,1,6,24,5,1,15,5,9,9,3,7,3,17,7,5,4,2,4,14,1,3,2,9,1,6,5,7,3,2,10,15,5,7,9,5,7,2,
1,11,3,6,10,2,10,5,7,2,9,10,9,6,2,10,23,7,3,2,3,1,6,9,5,25,8,1,2,3,1,9,6,15,11,3,1,3,2,3,6,7,5,13,2,
4,5,3,3,3,4,3,8,7,15,3,5,9,37,23,1,11,16,3,2,10,9,18,2,1,2,21,7,9,6,14,3,6,1,3,2,10,14,24,15,6,10,
12,8,4,5,7,5,9,6,1,5,7,2,3,3,4,18,2,10,5,1,2,3,10,5,13,2,7,2,6,7,15,3,3,6,5,9,12,12,3,13,2,12,7,18,
12,3,2,1,3,5,7,3,5,7,2,3,7,2,1,12,3,5,13,2,13,5,1,5,3,7,8,7,5,1,2,6,4,6,12,3,9,2,9,1,11,12,1,5,6,3,
1,2,10,5,10,3,5,6,4,2,4,3,15,18,9,5,4,5,4,12,3,3,12,2,10,8,1,5,7,2,1,6,6,20,9,3,3,3,1,3,2,19,11,9,4,
3,3,9,2,3,6,6,1,3,6,3,5,6,7,17,3,12,3,4,6,3,2,4,3,20,1,5,1,5,3,6,1,3,2,1,17,1,2,9,3,6,4,3,3,2,3,9,1,
36,3,2,4,2,3,4,35,3,4,15,6,2,12,9,4,2,9,9,7,5,4,9,15,5,1,12,8,1,6,5,3,1,3,8,3,6,4,6,8,1,12,2,1,5,6,
15,4,6,8,7,23,1,11,3,6,1,8,10,2,1,18,6,6,5,18,4,5,7,5,18,16,5,9,6,4,2,1,2,6,1,3,6,11,1,2,1,2,9,16,2,
13,9,11,10,14,1,3,11,10,3,15,8,3,1,3,5,6,1,5,10,5,16,12,5,1,9,5,6,7,2,7,3,21,2,3,6,1,5,4,11,7,3,12,
15,6,5,6,1,2,6,6,1,12,2,3,12,4,12,2,10,8,4,6,5,10,2,16,9,3,2,3,7,23,9,4,9,5,1,2,4,6,2,12,9,4,11,1,5,
6,10,2,3,15,4,6,3,11,21,10,14,19,6,3,5,1,2,13,5,4,2,1,3,5,1,6,8,1,6,2,3,7,2,39,9,1,9,2,9,9,1,6,5,1,
8,15,6,4,2,7,2,13,6,2,12,13,12,2,6,7,11,12,4,11,7,3,2,1,6,14,6,1,8,1,3,2,6,22,6,9,8,4,3,3,2,1,11,15,
6,4,8,7,9,5,4,6,14,1,2,3,4,8,3,1,14,9,12,6,4,3,3,8,4,3,2,1,6,3,5,7,11,19,8,1,5,1,11,7,8,10,3,2,7,5,
6,1,9,2,3,6,15,4,5,1,3,5,3,10,3,26,6,3,9,10,5,6,1,6,3,2,15,7,15,2,3,12,4,6,8,1,2,3,6,4,11,1,3,14,3,
7,17,1,5,4,9,2,13,5,10,5,9,10,2,1,9,6,8,16,11,7,11,1,6,2,1,5,7,2,6,9,6,4,2,1,12,12,8,1,5,7,2,7,5,1,
2,16,12,2,6,1,14,9,7,5,9,22,2,6,10,20,4,15,3,3,21,18,5,13,8,1,3,15,8,7,5,3,13,2,12,1,2,9,4,11,1,5,9,
1,2,10,3,14,3,1,9,5,1,2,4,18,6,6,9,2,4,3,8,4,14,9,10,5,13,2,10,5,6,10,9,5,25,3,2,3,4,5,3,6,7,3,2,13,
11,9,4,2,1,8,1,5,6,7,2,4,9,11,16,3,2,1,8,9,1,11,1,8,12,22,5,1,5,1,35,1,3,17,18,6,1,9,3,12,6,23,6,1,
12,2,13,3,3,2,10,3,11,6,3,1,3,5,1,2,3,1,5,1,8,1,6,2,6,7,29,13,5,3,7,3,2,12,1,3,5,6,10,3,3,2,21,7,20,
3,1,6,2,1,6,3,6,11,1,3,9,2,3,12,1,12,6,2,4,15,6,5,3,4,17,4,11,3,10,6,2,3,4,2,4,15,2,4,14,4,11,15,1,
8,3,10,5,7,5,1,2,4,9,2,22,5,6,1,6,2,1,2,7,15,2,9,9,1,15,2,3,7,5,4,9,11,6,3,1,3,5,30,3,4,3,2,3,13,3,
6,6,3,12,8,1,5,10,6,14,1,5,9,9,4,3,2,6,1,3,5,6,1,11,3,4,8,3,1,9,2,7,2,24,1,3,8,3,6,19,2,9,3,3,4,3,3,
15,2,28,2,3,3,1,5,9,12,3,7,8,1,6,3,12,2,1,14,7,11,4,5,18,3,7,3,12,2,6,3,4,2,4,11,3,3,18,9,13,12,3,9,
5,4,2,10,2,3,19,14,1,14,6,4,2,18,7,3,5,12,4,9,6,8,6,6,4,6,20,1,2,3,4,6,14,1,5,19,3,5,10,2,3,13,2,12,
3,10,3,12,8,13,5,7,2,6,22,5,4,5,1,5,3,7,18,9,2,9,1,8,16,26,6,3,1,14,4,3,3,6,8,1,5,22,8,6,4,6,5,1,5,
15,7,2,1,14,9,9,10,2,1,9,6,2,10,3,2,3,3,1,23,3,7,2,3,1,12,2,12,1,15,8,4,2,9,6,1,14,3,3,7,8,3,4,12,6,
9,5,1,24,9,12,2,1,6,8,15,1,12,8,9,6,4,8,4,3,2,1,8,7,9,3,2,28,2,1,3,5,9,12,28,3,3,9,2,6,3,1,3,6,9,2,
3,7,5,6,12,3,18,4,3,17,3,7,3,3,9,5,6,1,5,3,6,7,2,3,13,2,3,7,3,15,2,4,14,7,2,27,3,3,7,2,1,3,5,9,15,1,
2,3,16,6,3,5,12,4,5,1,9,5,1,5,7,3,12,5,13,2,3,4,3,2,4,14,7,18,11,4,3,3,14,3,10,14,4,11,1,9,6,5,10,3,
2,12,3,13,5,7,5,9,3,6,16,3,3,2,3,3,12,37,12,8,12,13,2,9,1,5,4,11,1,5,4,3,15,3,8,6,15,31,3,11,1,2,3,
4,3,5,3,4,3,12,5,4,29,3,3,4,2,4,9,3,14,4,12,3,21,6,3,2,10,2,3,3,21,4,6,3,5,3,12,3,7,2,1,8,12,3,6,6,
7,2,9,4,2,1,18,6,11,3,1,3,5,7,20,1,2,6,1,6,3,12,3,9,2,9,12,3,6,3,7,5,1,3,6,5,6,13,2,7,20,6,15,1,15,
6,3,2,3,1,11,9,1,5,7,6,11,9,10,9,5,6,1,11,3,4,5,6,4,2,1,17,3,7,2,3,13,5,4,9,5,7,17,3,3,25,17,3,12,4,
6,20,4,15,11,9,1,3,2,7,5,15,12,4,6,5,3,10,11,4,3,8,6,3,16,2,3,1,9,2,3,4,3,3,5,7,2,1,5,7,2,7,5,6,12,
15,3,13,2,4,9,6,6,15,9,3,2,6,3,6,13,2,16,2,12,4,17,9,10,9,12,9,3,2,10,3,5,6,1,3,5,1,5,1,5,13,5,16,
30,6,8,6,1,5,3,13,3,12,5,4,6,3,11,21,3,7,2,12,19,2,10,5,9,4,5,6,6,7,6,5,4,3,15,15,8,7,8,1,5,13,2,4,
41,3,1,5,6,6,3,9,12,1,8,9,1,9,5,13,3,2,3,9,6,9,7,5,3,7,6,5,9,19,5,1,9,20,9,1,2,7,5,3,9,4,9,3,14,3,1,
5,9,6,1,5,15,3,1,20,1,6,5,3,4,3,5,12,3,3,1,3,3,9,6,15,2,10,11,4,8,9,1,2,1,2,4,3,6,6,9,2,9,1,14,1,15,
8,6,6,9,10,3,5,6,9,1,5,7,3,11,1,2,1,6,5,1,18,5,4,5,1,11,9,4,3,3,2,7,3,9,9,5,1,3,2,6,3,4,2,13,2,4,6,
18,3,5,7,6,6,5,3,12,6,4,14,6,3,10,12,6,2,13,3,11,1,5,42,15,10,11,7,2,6,6,13,12,6,3,12,3,15,2,3,10,2,
4,3,3,9,15,3,3,12,3,8,7,3,11,25,5,9,15,1,11,3,7,12,2,1,2,10,2,3,1,2,18,1,23,1,5,4,8,7,2,1,3,11,1,12,
5,15,1,6,6,17,7,5,3,12,1,3,2,3,12,4,3,6,5,4,12,14,1,23,6,1,5,1,8,6,6,4,3,6,5,1,8,3,3,6,15,3,22,3,2,
4,2,22,8,3,15,4,21,2,4,3,2,1,8,6,6,3,4,2,18,6,7,2,12,3,1,12,5,3,1,5,1,8,4,2,19,6,23,1,15,11,1,2,1,
12,20,24,4,2,3,1,6,5,7,5,12,1,5,3,7,9,11,7,20,1,2,3,7,9,8,1,11,13,23,24,10,9,11,9,1,9,5,4,5,3,3,1,3,
8,7,8,9,9,1,6,9,3,18,2,1,9,3,2,3,3,1,21,2,12,4,20,1,3,11,1,8,1,9,5,6,6,1,3,5,24,1,5,1,3,3,5,19,9,2,
3,1,11,3,7,14,6,4,3,12,3,27,14,6,3,10,11,6,13,5,16,2,4,6,14,6,4,8,7,3,6,9,2,6,9,4,15,5,6,1,3,6,5,13,
11,4,11,7,12,2,6,3,1,3,3,2,1,11,3,1,5,12,9,13,2,4,12,3,6,5,3,16,2,4,3,2,9,9,7,3,11,15,6,13,12,8,10,
2,1,3,11,1,2,13,5,4,5,1,5,9,3,1,2,4,5,4,2,7,8,3,4,5,6,9,7,5,1,9,6,3,12,24,15,20,3,7,3,8,3,4,11,7,2,
1,6,3,5,6,4,6,2,40,2,3,10,3,2,12,7,5,6,4,3,12,5,3,18,9,10,5,1,5,3,4,2,15,3,6,9,1,5,16,18,8,9,4,2,3,
4,2,1,12,8,7,3,2,3,4,6,3,11,3,1,5,4,2,1,14,4,2,3,10,2,12,10,18,17,3,3,15,6,1,20,4,3,2,3,10,11,1,5,4,
5,7,2,3,28,2,7,2,1,2,7,8,7,6,2,1,6,3,3,2,1,6,5,9,19,2,13,2,3,1,2,4,5,33,1,5,7,3,2,3,16,3,3,8,12,18,
7,2,1,44,3,13,2,13,11,10,3,5,7,6,2,13,3,26,6,7,2,10,8,16,9,2,1,2,15,1,6,5,6,7,3,12,12,8,1,2,3,4,3,8,
4,5,12,1,8,22,3,2,12,3,12,1,2,12,7,5,1,9,14,7,5,9,4,9,5,12,19,21,8,21,4,3,3,12,2,3,7,12,3,3,5,3,1,
14,10,5,4,2,10,3,2,6,24,6,4,8,1,5,7,8,1,18,8,10,5,10,3,6,3,6,2,3,4,6,21,8,1,6,8,3,7,2,13,2,1,3,14,6,
1,11,3,9,7,11,3,1,6,5,10,3,14,3,9,4,2,4,3,3,9,35,3,6,15,7,12,11,7,2,6,7,2,1,6,6,9,5,3,3,4,9,5,6,4,
21,30,9,2,3,6,6,13,9,3,2,7,3,5,15,7,8,12,13,3,2,3,9,6,3,16,26,3,4,2,4,11,1,9,5,10,18,2,1,3,2,7,5,1,
6,15,6,9,6,2,3,3,1,6,8,4,11,4,5,3,9,4,5,4,6,2,9,1,9,14,9,7,3,3,5,3,9,15,1,2,4,9,2,9,9,6,4,21,3,21,2,
18,10,5,7,3,5,9,3,10,5,18,6,6,4,3,6,2,10,14,9,7,12,2,6,4,11,3,4,5,3,9,6,3,1,14,6,1,8,1,6,5,7,5,6,6,
16,3,14,7,3,5,3,7,6,15,2,4,5,6,4,18,2,1,2,3,4,5,4,12,2,3,3,9,13,2,3,19,5,1,3,2,7,17,9,1,3,12,9,5,6,
1,2,1,12,5,9,4,9,5,1,11,16,3,2,4,24,6,6,9,5,6,3,16,11,3,1,3,8,7,2,1,8,9,1,9,8,9,1,3,9,8,4,5,3,3,3,7,
2,1,5,1,8,25,8,3,12,7,3,14,13,3,3,14,1,14,1,9,11,6,1,5,19,3,5,1,5,12,3,4,2,4,11,1,14,13,6,2,3,10,14,
7,9,5,24,6,1,3,5,6,1,9,12,3,6,5,6,12,15,1,6,5,3,7,3,2,1,8,6,6,7,2,6,12,3,13,6,5,1,9,5,1,8,1,21,3,14,
1,6,5,4,2,10,2,3,7,5,6,10,2,3,12,3,4,3,8,7,18,9,5,6,6,1,18,6,8,7,5,9,4,8,9,3,10,8,10,9,11,3,7,8,10,
2,3,4,6,6,3,5,27,1,3,6,9,2,10,2,3,3,1,6,5,7,3,14,4,2,15,3,6,24,1,3,5,3,9,4,2,9,10,5,9,1,8,3,3,15,1,
6,2,3,7,5,21,7,12,11,1,9,2,4,6,9,8,12,6,13,9,2,1,33,2,4,5,1,9,6,2,13,14,1,3,11,19,5,9,13,2,1,11,9,1,
3,15,2,1,8,6,6,4,3,6,12,2,6,7,2,27,6,4,11,12,3,4,3,5,3,10,2,1,2,10,8,1,6,9,5,6,7,2,9,10,2,12,1,15,
21,6,3,21,3,8,3,4,5,3,4,5,13,3,2,6,7,3,6,6,5,3,1,5,3,10,8,3,9,7,3,6,2,12,3,7,5,1,5,10,11,13,6,9,3,
12,2,9,1,6,14,1,9,5,6,4,3,17,13,5,1,14,3,3,4,15,2,4,5,9,1,12,2,13,3,12,3,2,7,15,15,3,17,1,6,8,3,7,
18,12,2,19,2,12,7,8,3,3,1,11,3,4,11,4,2,10,8,3,3,4,6,5,1,3,3,9,6,2,1,2,3,19,2,1,3,12,2,12,4,5,4,26,
6,1,5,10,2,3,4,3,6,5,12,12,21,6,15,1,2,10,5,3,4,3,15,6,6,11,4,14,1,9,11,13,2,15,1,17,16,2,22,12,5,3,
3,4,3,5,16,2,9,3,28,2,1,12,2,7,30,5,6,7,20,7,3,5,3,4,8,1,12,5,10,18,9,2,15,4,5,7,5,4,3,2,1,3,5,12,4,
3,2,6,4,11,13,2,19,9,9,3,2,13,3,9,11,7,3,2,9,3,1,2,7,6,6,14,4,2,1,2,6,7,2,7,6,5,3,6,4,2,3,6,3,1,2,9,
4,5,1,3,8,4,20,4,2,7,5,7,3,6,9,2,3,3,4,8,1,5,9,3,30,3,19,2,30,4,2,4,11,3,6,4,5,15,1,3,23,10,3,6,11,
3,15,1,6,2,7,8,3,9,10,11,3,12,4,11,12,6,1,5,1,2,6,1,9,5,6,1,14,13,2,1,14,4,2,12,27,3,10,5,6,12,7,8,
4,9,2,4,9,5,9,6,9,3,3,7,9,5,1,17,1,9,6,12,29,6,4,3,2,13,6,2,3,6,3,1,11,4,2,3,1,11,10,2,6,6,9,7,9,11,
10,9,5,13,6,6,3,2,1,17,1,17,3,6,6,10,9,3,5,13,3,9,2,24,1,8,7,6,3,12,5,12,10,3,9,5,1,2,1,6,6,8,9,10,
8,3,12,7,5,1,14,12,15,4,5,7,14,1,5,3,6,3,1,6,5,3,3,4,3,17,1,3,5,9,3,3,4,8,3,15,4,15,2,9,4,3,9,5,4,5,
9,3,9,3,3,13,14,3,9,13,3,3,5,4,17,1,3,2,7,3,2,3,7,6,5,6,1,3,6,8,3,4,3,3,2,1,2,3,16,6,2,1,6,3,12,6,
20,9,13,5,6,6,3,1,5,1,5,1,14,6,4,5,18,10,2,9,1,6,8,7,3,6,9,9,8,4,3,2,6,7,3,12,5,13,3,2,7,2,1,2,16,5,
1,14,4,21,14,3,3,1,9,2,4,3,2,1,3,26,6,4,5,4,15,11,13,15,3,15,2,6,4,3,2,6,10,5,10,11,30,4,11,1,3,20,
4,30,18,5,10,14,3,10,5,6,10,5,34,5,3,4,6,2,7,6,5,7,5,6,1,11,24,6,13,9,11,6,6,4,15,14,6,1,5,4,3,2,3,
3,10,2,6,1,3,2,19,2,3,4,2,3,6,10,9,8,4,8,1,9,20,1,5,1,8,3,4,5,1,9,6,3,2,9,1,3,2,4,5,9,7,3,2,9,4,12,
9,5,15,13,2,4,11,6,3,7,2,3,3,4,5,6,1,5,9,1,3,2,13,2,9,7,2,1,6,9,2,15,7,11,15,7,12,20,12,3,1,9,12,5,
1,2,1,14,1,9,11,6,1,20,4,5,13,3,3,12,17,3,30,10,2,15,16,2,4,5,3,7,9,6,3,5,16,2,7,12,8,6,7,2,12,4,5,
1,14,4,3,12,3,8,7,5,9,3,15,1,2,9,3,6,1,14,1,3,3,5,15,3,4,2,1,9,5,3,1,5,9,6,4,3,2,12,3,13,5,30,7,5,
13,5,7,2,4,11,1,3,2,24,9,7,2,15,22,5,9,9,1,2,7,11,7,3,2,3,4,8,13,5,4,6,20,1,8,18,4,3,3,3,9,15,2,3,6,
1,6,5,3,7,8,7,2,3,9,9,1,3,2,1,17,1,6,5,6,3,7,3,9,2,3,1,15,2,3,4,2,6,3,4,3,5,12,7,5,3,28,2,21,1,8,3,
10,18,9,11,1,8,1,5,1,8,18,3,9,7,6,12,5,10,6,6,3,12,9,6,6,3,2,9,6,7,2,1,20,19,6,12,20,3,10,2,6,1,3,2,
1,5,34,8,1,2,3,1,3,3,2,25,8,3,7,3,9,2,6,4,3,5,1,2,7,11,4,12,15,6,9,3,11,16,14,4,8,4,3,5,6,6,1,9,11,
3,4,15,2,3,7,11,18,1,3,11,24,3,7,21,2,22,5,3,3,6,3,16,5,1,8,10,3,3,14,1,2,18,16,3,12,9,2,3,1,3,3,8,
15,9,7,5,3,6,7,9,9,6,8,3,4,3,2,1,8,19,3,2,1,6,9,6,3,11,4,3,8,10,11,3,6,12,9,1,5,4,3,5,1,2,4,3,12,3,
2,16,3,5,7,23,7,2,10,2,21,3,1,6,9,5,6,15,9,4,14,16,5,4,8,7,6,5,6,4,5,7,14,16,2,10,8,4,11,12,7,6,2,3,
4,21,8,4,2,4,2,4,5,13,3,2,7,3,2,1,14,3,10,2,9,1,14,4,2,4,2,12,3,3,1,6,2,1,26,1,23,24,1,2,4,8,7,9,9,
5,13,20,3,1,9,2,3,4,3,18,2,4,6,14,1,2,6,1,8,6,6,1,12,6,2,3,6,4,2,4,5,4,9,3,2,3,12,6,9,13,9,6,8,6,1,
2,1,11,3,1,2,4,8,1,2,9,4,11,6,4,5,13,2,6,10,38,15,7,3,5,1,6,2,3,3,1,20,1,2,10,2,3,1,5,1,8,1,5,4,3,8,
9,7,6,12,3,3,5,4,2,3,3,7,11,7,2,3,19,20,3,6,1,5,1,3,11,3,7,9,9,6,5,1,3,12,5,9,6,3,6,10,12,3,6,11,7,
5,3,18,1,5,6,3,1,15,3,6,12,9,5,4,15,6,8,1,5,12,10,9,3,27,5,19,2,3,6,1,15,12,8,3,10,5,4,2,10,5,4,9,3,
3,5,1,5,15,3,3,4,3,2,1,2,13,15,3,15,2,25,2,7,5,1,3,2,3,9,3,7,15,12,8,1,2,12,13,3,6,9,6,11,4,5,1,3,2,
12,15,6,9,1,2,7,6,6,5,4,6,3,11,1,14,9,3,4,3,5,1,5,10,2,3,6,1,2,1,12,2,6,4,2,19,14,7,5,3,3,4,3,3,5,
12,6,1,11,3,9,3,3,1,11,3,12,7,12,8,27,3,1,5,12,9,1,8,9,25,3,5,7,6,5,9,6,6,1,14,4,2,13,14,7,3,8,3,1,
3,3,2,6,1,6,2,15,6,1,33,5,13,3,6,14,9,1,9,2,1,12,2,9,4,6,9,2,6,4,6,2,6,1,14,6,6,7,3,2,13,14,1,9,5,
10,9,5,9,15,1,2,3,6,1,9,9,21,9,2,3,4,5,1,27,2,3,10,15,3,2,3,19,6,2,4,3,11,7,2,25,11,1,3,2,6,7,5,10,
6,2,4,6,2,3,4,24,5,1,6,2,21,24,3,10,3,5,7,2,1,20,9,3,10,5,7,5,16,2,3,1,3,8,10,2,13,5,3,6,6,3,1,3,2,
21,7,21,5,1,15,8,6,1,5,16,3,5,7,5,19,3,8,3,1,5,1,9,6,12,2,9,4,6,2,3,6,3,3,12,3,12,7,15,8,6,4,3,2,13,
5,9,1,9,8,1,2,12,7,6,3,5,1,5,4,20,6,9,6,10,5,3,6,7,5,4,3,2,1,2,30,3,3,7,3,11,18,1,6,15,3,2,4,11,4,2,
10,8,7,3,2,3,6,1,12,2,16,2,10,5,1,5,6,3,3,3,6,1,9,3,2,4,2,3,4,6,9,2,45,1,3,5,22,3,9,5,15,1,12,5,10,
2,1,6,8,7,6,12,2,1,8,4,8,13,15,5,6,4,14,10,2,1,8,1,6,12,5,1,14,13,2,3,4,6,15,2,3,3,1,3,5,6,7,8,6,6,
7,5,1,14,27,9,6,3,12,9,4,5,7,9,9,3,3,9,2,4,5,6,3,1,9,11,1,20,4,6,3,8,7,8,12,7,18,8,4,6,3,2,19,8,15,
1,5,1,3,5,13,5,4,14,1,3,6,11,6,7,5,3,3,4,3,3,12,2,13,5,4,3,5,3,3,6,13,6,14,1,2,4,9,5,6,18,1,5,7,8,1,
3,6,2,7,2,10,18,3,17,1,6,14,6,3,3,15,13,2,12,3,3,7,23,9,1,20,6,4,2,7,2,1,2,12,10,11,13,14,1,9,3,9,
11,12,1,2,7,2,4,2,3,1,11,3,1,6,2,12,1,8,4,2,1,5,10,14,3,3,4,8,10,3,5,3,15,10,11,9,4,2,1,5,7,20,1,6,
3,3,5,9,15,1,23,1,6,20,15,3,7,2,7,6,3,6,14,16,5,1,14,4,2,7,2,6,3,1,14,4,27,3,5,13,8,10,2,4,8,15,10,
2,1,3,12,5,7,2,1,9,3,8,7,5,1,2,12,3,7,3,12,3,8,6,9,1,5,6,3,4,6,15,6,8,16,6,3,11,1,9,5,1,18,3,3,11,1,
2,3,7,2,13,5,1,11,1,15,5,4,6,5,4,5,1,8,4,8,7,2,9,7,2,6,7,9,15,3,11,1,3,8,12,1,9,11,9,3,10,2,6,1,14,
1,6,5,7,3,12,6,6,11,7,3,3,2,9,9,6,10,3,3,14,1,14,1,2,7,3,15,8,18,9,1,9,2,3,3,4,11,3,6,1,2,10,2,24,9,
1,26,10,9,5,4,3,9,3,6,15,5,1,15,5,6,12,7,11,10,3,14,6,1,14,1,3,2,3,12,1,2,3,4,6,8,6,15,1,3,14,6,16,
3,6,6,5,1,5,12,3,3,1,5,19,9,20,6,4,3,8,1,5,4,9,3,8,4,6,9,3,3,6,5,18,1,6,8,12,3,3,3,4,2,13,6,5,6,6,4,
5,4,2,7,3,17,13,5,3,1,5,10,3,6,2,12,15,3,10,8,4,3,3,6,20,6,3,1,6,3,12,3,14,16,6,5,3,7,8,3,10,2,3,9,
9,21,6,7,8,10,23,6,9,1,11,22,5,1,9,5,3,3,6,3,6,9,12,1,18,11,13,2,13,3,3,2,3,6,3,16,2,7,8,3,4,3,3,2,
7,15,5,6,1,9,20,7,3,2,3,9,7,3,3,14,6,4,5,6,3,10,2,4,3,2,1,3,6,5,1,2,15,3,3,6,9,7,18,9,17,9,1,6,3,12,
2,10,2,13,8,4,11,12,3,9,3,13,5,7,15,2,9,4,2,3,3,4,9,12,5,9,3,7,15,3,3,2,3,3,4,11,6,4,20,1,3,3,2,3,7,
2,1,3,5,6,1,2,1,17,18,4,6,14,7,3,5,3,7,12,5,1,3,5,4,3,18,12,12,18,2,7,5,4,5,15,6,1,2,10,8,13,2,12,1,
2,4,11,3,1,20,1,12,2,3,6,6,1,3,9,2,1,17,6,7,9,6,9,14,9,3,4,5,1,3,9,2,4,11,13,3,3,5,1,6,3,6,5,6,3,1,
18,2,6,9,1,2,3,12,7,3,5,3,4,3,3,3,12,3,5,6,9,22,2,1,6,3,5,3,19,15,5,3,13,2,6,4,2,9,4,3,12,8,3,4,3,3,
5,1,6,8,10,2,7,2,1,5,13,5,4,5,3,9,10,3,5,1,2,9,1,8,12,7,3,8,7,12,2,3,15,3,7,6,5,1,8,1,5,6,4,9,3,9,6,
3,2,7,8,4,5,10,8,1,2,9,4,15,5,1,8,10,8,9,18,6,1,11,3,4,3,15,2,13,9,6,5,3,4,2,4,20,1,24,6,5,3,1,9,3,
5,10,15,2,3,12,3,3,16,8,6,16,3,2,6,9,13,2,3,1,2,12,22,3,11,7,23,1,6,8,10,2,9,3,1,9,3,3,6,5,1,15,8,1,
3,15,2,9,4,15,11,15,6,1,9,5,6,7,11,1,24,2,4,5,3,1,15,2,19,15,3,17,1,3,2,10,5,7,2,9,9,6,1,6,2,13,9,6,
30,2,12,3,3,4,15,3,11,10,2,3,1,3,2,6,9,15,3,18,4,6,2,1,5,15,6,1,2,15,3,7,3,3,5,4,12,3,26,24,3,12,3,
10,3,5,9,7,3,5,1,5,22,2,1,11,6,9,13,6,2,3,7,3,14,16,11,1,3,15,2,10,2,18,15,4,3,6,5,1,11,7,2,3,12,1,
9,6,20,13,6,8,1,6,8,1,11,18,7,6,2,7,5,6,7,6,15,5,7,15,3,11,9,1,5,6,13,2,3,7,9,9,15,2,3,1,3,11,6,18,
7,3,8,9,3,3,4,18,11,7,23,4,11,4,2,6,7,6,11,4,2,3,9,21,9,1,2,7,12,14,7,2,1,6,8,3,4,3,5,1,9,2,1,18,11,
1,5,3,7,3,9,5,7,8,7,8,6,4,2,4,6,9,2,3,6,1,9,6,15,2,7,3,6,2,15,25,3,2,4,6,2,10,3,8,6,4,14,3,7,3,5,13,
6,5,4,6,5,1,14,4,11,1,3,11,4,2,12,1,2,7,2,1,9,5,6,9,1,2,12,1,15,14,3,6,1,3,11,9,1,12,3,6,3,2,3,3,3,
6,4,17,7,5,3,12,1,2,4,3,2,19,9,2,28,5,3,28,6,6,3,15,2,15,9,9,4,5,3,15,7,5,22,6,2,6,9,7,3,2,1,8,7,5,
4,8,7,15,5,1,2,6,6,1,8,15,4,6,9,2,1,9,3,11,4,5,1,15,6,5,1,5,9,6,3,1,3,20,10,2,6,7,6,9,6,6,9,5,1,11,
10,14,1,2,1,14,16,5,6,3,6,1,11,3,1,8,6,7,17,1,2,7,6,2,4,3,3,2,10,3,3,5,1,8,1,11,1,9,3,11,9,3,4,3,2,
3,7,6,5,3,7,3,6,6,5,3,1,15,20,1,14,16,3,2,12,1,11,3,1,17,7,30,8,3,1,3,8,4,30,3,5,13,15,2,25,6,2,3,1,
3,2,1,2,7,14,6,3,10,3,3,5,6,1,5,12,1,12,2,6,10,15,9,2,6,4,3,2,6,3,6,1,12,12,11,3,15,10,2,19,14,7,2,
15,16,2,3,4,3,3,6,6,5,10,5,3,1,11,7,15,2,4,9,6,5,7,9,5,4,6,3,2,1,8,10,9,5,1,2,4,11,7,3,2,22,9,2,3,7,
27,2,1,2,16,20,6,9,7,5,3,1,15,3,21,2,4,3,8,4,6,2,1,5,7,2,7,11,12,12,1,8,6,4,9,2,4,2,3,7,12,3,8,6,1,
2,1,5,4,30,2,3,1,6,11,10,2,3,10,3,5,10,5,1,11,3,19,15,5,21,1,3,11,7,3,12,2,7,5,4,2,12,1,2,13,5,16,
21,2,13,15,3,5,4,6,11,3,6,4,5,3,12,1,6,18,2,15,21,15,3,1,3,6,6,3,2,10,5,3,1,24,3,3,5,9,12,6,7,5,3,4,
6,14,1,15,2,3,4,3,6,2,3,6,1,23,9,15,13,2,1,2,19,11,9,6,4,11,4,11,3,6,10,6,3,6,6,2,6,4,3,3,5,24,1,6,
11,3,9,7,5,15,3,3,4,6,3,14,3,9,6,3,1,6,3,11,9,10,2,10,14,6,7,6,11,4,14,3,3,1,9,12,5,3,6,16,5,9,1,9,
5,4,29,1,17,7,2,6,3,1,3,11,7,3,2,7,2,3,1,9,11,1,3,2,15,1,2,7,6,8,1,6,3,9,15,6,14,6,4,12,11,4,5,9,7,
8,4,2,1,12,12,20,16,2,3,4,8,10,2,1,3,2,19,8,1,5,1,6,3,2,19,5,3,1,2,9,3,6,7,17,10,20,1,2,4,3,6,6,5,3,
6,4,8,4,3,6,2,3,7,3,9,11,9,7,6,8,6,3,15,10,17,1,23,1,8,12,10,9,9,5,10,15,2,4,2,4,15,3,3,3,2,4,9,12,
5,3,4,3,20,3,6,4,6,24,2,3,4,5,12,1,2,3,3,6,13,2,1,5,13,9,2,10,3,3,12,5,1,5,9,6,1,3,2,6,4,5,13,3,9,5,
10,11,4,8,1,5,6,6,4,11,4,21,2,3,9,3,6,4,15,5,1,11,1,2,6,7,5,3,7,3,11,10,5,4,14,3,7,2,9,10,9,2,10,3,
3,8,6,1,5,12,15,7,5,1,14,1,8,12,9,6,3,4,5,15,13,14,4,15,20,1,5,15,6,7,5,10,8,9,1,3,6,6,2,3,3,19,3,5,
9,13,6,5,15,6,4,5,6,4,6,5,1,12,2,6,7,2,1,3,11,6,3,1,3,3,2,1,2,4,3,5,1,20,6,3,3,9,13,3,3,2,49,9,17,7,
3,3,5,9,7,9,2,3,10,2,3,6,4,5,9,7,8,3,4,18,2,18,6,9,6,10,5,7,3,2,3,15,1,5,18,1,6,8,1,2,10,3,11,3,7,5,
4,2,3,4,11,1,3,8,12,12,4,5,4,8,12,6,6,1,8,6,9,1,21,2,3,12,10,3,2,7,15,6,2,1,5,4,2,24,7,3,2,7,11,12,
4,5,1,15,14,3,10,3,3,11,1,5,4,11,10,2,1,2,3,4,6,5,1,23,10,6,30,5,10,14,6,6,3,3,3,4,3,8,6,6,7,3,12,5,
3,12,6,1,3,2,4,5,9,1,2,4,11,4,5,21,4,21,9,3,2,24,1,5,1,5,9,19,2,15,10,5,3,22,2,3,9,3,6,10,5,6,3,1,9,
18,3,2,3,7,24,5,1,2,3,7,17,10,9,2,3,4,5,3,18,7,3,12,8,1,3,2,13,2,1,2,15,3,3,7,2,7,5,1,2,6,9,1,9,2,1,
2,3,9,9,7,3,15,2,4,20,1,2,1,5,6,3,1,5,4,3,27,2,1,24,11,12,7,9,12,5,18,4,20,1,6,8,3,9,1,2,7,14,22,3,
2,7,3,9,11,3,10,6,5,1,3,6,5,3,12,1,9,9,2,27,1,5,9,3,3,1,8,7,8,7,8,3,28,2,12,1,2,18,4,5,1,5,1,6,3,2,
4,5,6,3,1,14,6,6,7,11,1,3,27,5,1,8,1,11,10,3,5,4,8,4,18,3,3,5,4,11,15,6,6,4,3,3,5,7,5,1,2,19,3,3,12,
5,1,5,22,2,10,2,4,11,3,3,15,3,7,5,3,10,5,6,3,3,4,6,8,4,3,3,9,3,12,11,1,6,3,6,3,3,2,7,8,3,9,13,8,3,4,
5,3,4,15,9,2,3,1,3,3,2,1,11,16,5,9,4,17,4,3,11,1,11,3,6,19,9,5,10,2,1,5,3,25,5,1,3,17,16,9,21,17,3,
12,3,3,9,1,5,7,14,4,5,6,13,2,4,26,9,4,6,5,4,5,6,16,11,9,1,5,3,4,6,2,18,7,3,6,5,3,7,9,2,9,6,3,1,11,9,
1,2,7,8,3,3,4,3,2,1,9,5,1,6,11,3,1,6,12,6,12,9,8,3,12,6,1,5,10,5,1,9,3,5,21,9,3,22,3,8,7,2,13,5,28,
2,9,4,11,4,2,3,4,8,7,17,6,3,1,3,2,13,8,9,10,8,7,11,7,11,12,19,5,1,12,3,2,1,17,3,4,8,9,3,6,6,1,2,6,4,
8,3,6,6,7,2,1,3,6,3,2,6,12,1,2,10,2,6,10,2,4,6,12,3,3,15,2,19,3,5,1,6,5,4,11,1,2,3,9,3,16,21,8,7,21,
15,3,11,1,12,3,3,11,4,17,3,4,5,7,6,14,3,6,1,3,3,9,3,3,8,4,6,17,3,9,10,2,3,15,1,2,18,6,18,1,21,6,5,3,
4,2,4,5,7,3,5,1,6,2,3,7,6,5,4,20,10,3,2,7,20,3,6,1,3,2,6,3,1,11,3,4,8,13,5,7,2,10,5,1,12,2,7,5,3,3,
13,17,4,3,6,2,22,3,2,6,6,4,6,11,3,7,27,5,1,6,6,3,21,5,6,4,11,4,6,8,7,2,3,7,5,1,2,18,24,6,6,1,2,12,6,
22,5,13,2,10,20,3,10,12,2,6,9,1,3,20,1,3,3,5,3,9,1,6,6,2,3,4,8,6,6,1,3,2,3,7,27,8,3,1,6,9,6,8,4,5,
18,9,1,18,6,8,3,7,17,1,2,15,7,5,13,21,2,10,3,5,10,5,7,12,2,1,12,6,5,6,1,5,7,2,3,6,12,3,6,1,2,6,6,9,
9,10,11,4,5,3,19,8,1,15,6,5,4,2,3,1,5,3,3,10,3,11,3,1,2,18,7,2,10,6,11,4,11,13,3,12,12,9,2,3,12,4,3,
6,5,1,6,2,6,1,5,13,2,4,2,3,7,9,8,6,9,3,4,3,17,3,10,2,1,8,1,11,3,10,2,9,4,6,3,3,3,2,3,4,5,16,5,4,21,
2,13,2,15,7,3,3,6,8,6,7,2,1,2,3,15,6,1,3,11,3,10,6,12,5,4,5,15,3,1,6,8,6,6,1,3,9,5,10,6,5,1,8,3,4,
14,1,20,1,2,6,4,6,2,10,9,8,3,3,1,9,2,3,9,7,5,9,9,3,7,2,1,3,15,6,5,3,21,4,30,2,3,10,2,4,2,3,4,5,1,2,
4,14,1,3,5,7,5,4,5,12,7,8,3,4,15,17,4,2,4,6,23,1,5,4,2,15,18,6,15,6,13,14,1,12,2,6,1,8,7,5,6,3,4,5,
1,6,8,15,3,4,8,1,12,23,6,13,6,6,3,2,3,1,2,13,9,3,14,4,12,2,6,40,12,5,4,3,5,1,5,7,15,8,6,15,4,6,3,5,
1,5,4,3,12,2,3,6,16,3,11,10,5,6,3,1,9,20,3,4,6,2,1,12,3,2,9,16,5,9,3,37,3,17,13,3,9,6,5,3,7,2,3,4,
18,6,6,3,3,9,14,1,6,5,4,11,7,2,1,3,6,5,4,9,15,6,6,23,6,1,3,6,2,13,2,9,24,6,3,21,1,5,6,7,2,13,3,2,1,
6,5,18,3,4,3,6,11,4,2,7,3,5,4,6,8,4,2,10,3,12,8,6,6,9,6,3,1,5,12,10,8,4,5,3,4,9,2,12,7,6,8,6,1,2,18,
4,3,2,9,10,9,11,1,9,2,7,5,12,9,4,3,2,6,1,6,8,12,7,8,10,3,2,37,3,2,6,1,9,15,6,8,10,3,2,3,3,6,9,15,4,
2,6,4,5,6,24,3,7,21,14,3,1,5,1,5,15,4,9,2,1,9,9,5,4,6,5,10,11,6,18,1,6,5,10,5,7,2,21,7,6,5,12,3,1,8,
3,9,6,3,7,3,2,9,3,1,9,5,1,26,1,2,1,14,12,6,9,1,2,7,8,15,1,12,27,2,1,5,10,3,5,9,1,6,5,3,13,2,3,3,1,8,
1,12,3,20,7,3,11,13,2,6,10,18,6,9,5,6,13,8,7,5,10,5,3,3,4,3,9,8,1,6,18,32,19,6,20,1,3,5,1,5,4,2,9,3,
7,5,1,15,2,3,4,8,3,4,3,20,22,5,3,13,14,13,2,6,4,6,8,1,3,2,1,8,9,1,2,3,7,8,4,2,16,18,6,8,1,5,1,6,15,
3,2,7,5,3,7,3,3,9,12,3,5,1,9,11,4,11,7,3,5,7,14,4,2,3,10,2,4,5,4,6,3,17,1,3,5,1,8,22,5,9,12,4,8,1,5,
4,5,6,4,2,9,1,18,8,3,1,3,18,3,9,8,12,1,6,3,2,3,13,3,9,2,3,3,3,10,5,4,2,4,29,22,6,2,3,7,5,13,12,3,12,
8,3,1,9,2,18,1,5,3,6,7,9,3,8,7,6,2,12,6,12,4,8,1,14,6,21,13,3,3,9,5,6,7,23,1,9,6,3,2,3,3,7,2,1,17,1,
32,7,6,11,4,6,3,12,5,6,13,2,7,6,2,13,5,9,6,1,11,9,6,25,2,15,6,7,2,6,1,5,3,16,6,5,28,3,5,4,3,8,7,6,2,
25,17,6,15,7,3,21,8,1,5,1,3,2,1,2,1,17,10,2,3,4,5,1,5,9,4,6,5,6,7,6,12,2,12,13,15,2,4,9,3,3,2,12,15,
12,9,6,1,5,3,1,5,9,6,4,12,3,11,3,10,5,12,3,6,1,11,4,14,10,2,12,1,2,4,21,8,15,1,5,10,15,3,6,17,9,3,1,
9,3,8,1,3,3,18,6,6,8,12,7,2,3,1,6,15,9,21,5,4,12,2,3,4,6,20,4,8,6,1,3,3,15,2,15,6,16,6,3,2,7,3,2,1,
6,15,3,11,6,9,19,3,5,3,6,4,12,2,10,15,5,3,3,24,7,11,4,30,11,3,1,3,6,5,6,16,2,1,11,1,2,6,1,5,4,11,10,
8,16,2,4,8,1,17,10,2,3,3,1,6,3,15,11,16,12,3,14,3,13,20,3,7,9,15,14,1,5,10,5,1,9,5,3,6,10,9,8,4,9,2,
12,15,1,11,1,8,1,3,3,15,15,2,1,6,5,6,7,3,2,10,3,3,12,2,6,12,7,2,6,9,3,1,2,9,3,1,5,12,7,5,1,14,3,3,7,
12,17,3,10,12,6,2,1,6,6,2,16,9,8,9,9,4,6,15,2,19,21,9,8,3,4,6,14,1,3,15,9,3,2,1,2,7,3,23,9,6,6,4,2,
3,7,2,30,3,10,2,7,11,4,11,3,1,3,2,4,11,13,15,3,5,13,11,30,6,3,6,1,2,7,5,3,18,3,9,1,5,6,1,9,8,16,9,2,
13,2,4,5,10,12,2,1,5,1,6,2,10,3,8,1,3,6,5,7,2,3,7,8,3,12,12,6,1,15,3,3,5,3,6,1,18,14,1,12,2,3,3,1,3,
11,6,1,5,7,2,3,21,4,2,1,18,6,6,14,1,2,1,6,8,3,9,3,3,18,10,6,3,2,10,3,5,3,12,1,11,1,2,1,9,2,1,5,4,5,
4,2,27,6,7,5,7,2,1,9,18,2,15,9,7,2,1,9,11,4,3,8,7,2,13,2,13,2,18,13,2,4,3,12,8,7,6,8,1,15,3,5,3,4,6,
12,8,7,6,6,21,9,5,13,5,6,6,16,2,3,4,8,10,5,10,11,9,1,2,9,3,10,11,6,1,2,1,2,7,5,31,5,1,6,8,7,5,3,10,
2,7,36,6,3,5,7,5,1,2,1,2,10,5,22,3,20,4,3,3,5,4,3,12,6,5,9,15,9,6,3,3,19,8,1,5,4,2,3,6,6,6,7,2,3,7,
3,3,3,11,3,3,7,2,6,12,3,12,12,10,15,6,5,3,6,4,2,4,5,13,3,2,10,3,3,17,3,1,14,1,3,8,3,4,5,7,3,5,1,17,
7,5,12,6,3,1,5,10,5,1,12,5,1,2,13,5,12,9,9,6,3,15,16,14,1,24,3,2,21,1,6,2,6,4,2,1,8,4,8,3,4,2,1,3,2,
12,1,12,5,4,5,4,6,5,6,12,6,4,3,15,2,16,2,7,11,7,3,15,9,2,9,1,3,20,12,4,2,4,8,6,9,6,6,1,8,4,3,8,10,5,
4,2,1,3,14,3,10,8,1,5,1,17,1,12,2,6,22,9,3,12,3,5,3,7,3,2,7,6,3,6,6,5,3,22,2,1,6,24,2,13,17,3,1,3,3,
5,3,22,3,6,11,10,12,11,1,5,4,5,6,1,5,4,14,4,2,4,11,6,7,20,1,6,8,3,7,8,7,2,1,32,3,3,9,16,5,9,3,4,14,
1,14,7,14,3,3,4,3,6,5,1,3,5,1,5,10,5,15,6,1,12,6,2,4,9,5,7,3,5,1,6,15,12,2,1,2,10,15,6,11,4,5,1,3,3,
2,1,11,10,5,1,2,15,6,1,5,16,5,13,12,2,1,42,12,2,4,2,9,18,3,12,6,1,5,3,1,11,16,15,3,17,7,5,10,6,6,26,
4,3,8,3,4,11,6,13,20,7,3,17,4,2,15,3,10,5,9,1,24,17,9,10,9,2,16,15,5,13,6,3,8,3,4,2,16,3,2,15,4,23,
3,4,3,5,1,6,15,21,2,1,2,3,15,4,2,9,4,12,5,10,21,3,6,18,2,1,9,3,8,7,8,4,3,6,5,1,15,3,5,12,3,1,5,4,2,
1,5,3,6,4,9,38,3,6,1,2,25,2,13,2,4,5,12,7,5,1,5,4,6,2,3,6,4,15,5,6,3,6,6,1,5,15,13,2,3,1,8,1,5,1,3,
6,12,2,13,15,3,21,5,18,3,7,3,8,15,1,24,2,3,12,4,5,9,7,2,1,9,2,18,3,4,15,3,8,22,5,3,3,7,9,5,3,6,7,5,
3,4,3,2,3,10,29,3,10,3,3,2,4,14,1,6,12,15,3,5,7,6,11,9,4,6,9,5,22,8,12,1,3,9,2,6,7,2,4,6,11,3,1,14,
1,14,1,21,5,3,21,10,6,17,1,6,14,1,6,5,3,1,3,3,5,10,2,3,4,5,3,6,7,3,15,5,6,15,1,18,11,3,1,17,4,6,8,1,
3,3,17,1,6,3,3,5,4,3,3,14,39,1,6,15,2,6,4,15,15,15,5,1,2,7,5,3,9,16,5,25,5,9,18,1,15,5,6,3,1,5,12,
10,8,1,3,2,9,4,12,3,5,3,10,2,10,6,6,5,4,2,4,5,6,4,3,6,11,4,27,2,6,7,2,7,6,15,14,1,33,2,15,9,4,5,7,2,
3,3,12,7,8,12,3,7,8,3,15,7,3,5,1,5,10,5,1,2,3,10,3,11,15,33,1,5,7,3,2,3,15,4,11,4,2,4,11,9,10,9,2,1,
2,16,6,3,5,3,3,1,5,1,5,3,7,9,3,2,13,6,9,2,15,3,15,7,6,3,2,7,2,1,9,5,10,6,2,21,1,8,3,3,6,9,4,3,3,12,
2,1,9,6,9,3,8,1,8,7,8,6,1,8,3,7,8,3,4,2,18,3,7,3,2,1,6,9,5,1,6,5,9,13,11,6,1,3,2,7,2,4,9,5,3,4,3,17,
3,6,15,4,23,12,28,8,9,3,7,8,7,6,5,6,1,5,12,7,6,2,1,2,9,3,1,21,3,2,1,8,6,9,6,3,1,6,11,4,6,5,7,5,1,6,
6,12,8,15,3,6,3,10,6,2,4,3,15,2,16,3,12,5,7,6,14,3,13,2,22,5,1,5,6,1,3,2,3,19,8,3,4,2,1,9,5,3,1,15,
20,9,3,4,5,1,5,10,33,2,7,3,3,11,1,2,16,5,6,3,3,13,9,17,18,7,5,21,4,3,3,8,7,3,2,3,4,6,2,7,5,10,11,1,
5,1,9,11,3,4,5,6,6,9,6,1,2,7,8,7,14,6,4,5,21,1,15,5,9,3,3,4,8,1,2,4,14,1,8,6,6,6,12,6,7,3,9,2,10,3,
11,4,3,8,4,5,7,5,4,2,12,3,13,2,9,1,2,3,9,6,3,10,6,8,1,6,5,15,1,8,4,17,1,5,12,10,6,5,6,3,6,1,6,3,9,2,
3,6,7,20,4,5,4,6,3,6,5,9,1,5,7,3,2,12,7,5,1,14,3,1,2,4,21,2,6,16,14,27,22,5,1,5,1,9,2,9,3,6,10,5,6,
16,8,12,19,9,2,4,8,1,11,3,7,3,8,4,5,13,2,3,16,12,3,2,3,1,3,3,15,9,3,2,3,13,17,22,6,2,1,2,4,8,7,20,9,
1,11,9,1,2,15,6,1,6,2,6,1,3,2,9,6,9,4,3,2,18,3,6,1,3,2,4,3,2,18,6,4,11,6,9,1,3,3,2,3,3,1,6,8,7,3,9,
2,3,1,9,5,7,8,16,6,5,10,3,21,6,5,9,4,36,2,3,12,7,17,4,6,5,13,5,1,9,6,14,7,6,18,14,1,2,18,9,3,3,7,2,
7,5,4,5,7,2,21,16,29,1,9,17,4,3,3,9,5,1,3,2,19,3,5,3,10,9,8,15,1,5,7,12,2,13,3,3,9,6,2,13,5,1,5,1,
14,1,8,4,2,3,7,5,4,2,15,4,8,7,18,2,18,1,11,6,4,3,8,3,4,35,15,12,3,1,9,8,3,4,15,2,1,17,1,12,5,3,1,5,
9,1,6,2,3,3,4,2,10,6,15,14,13,11,7,3,12,8,1,3,15,2,16,18,9,5,6,4,2,1,9,9,2,4,14,1,5,4,2,7,2,4,2,4,
15,3,6,9,2,1,20,3,4,17,1,3,5,4,3,2,7,5,3,1,6,3,12,3,5,16,12,2,3,3,1,3,3,3,14,12,10,3,6,2,9,16,3,2,4,
5,1,2,3,7,6,11,3,1,17,12,13,14,1,2,13,5,22,3,2,1,17,12,3,4,15,5,9,9,3,34,15,6,9,5,1,2,6,9,1,11,1,8,
7,12,2,1,9,3,2,4,14,3,7,2,1,15,3,6,8,6,4,2,9,6,24,1,6,3,2,12,1,6,5,6,3,4,8,4,5,4,2,3,9,3,7,11,9,10,
11,6,1,2,1,9,2,9,6,1,3,2,12,18,4,3,8,10,3,11,13,8,4,3,6,26,4,5,9,1,5,1,6,9,8,3,4,5,1,5,3,21,4,9,2,
13,6,2,3,9,6,1,9,2,7,2,3,6,7,12,6,14,3,4,6,12,12,5,1,5,4,6,2,3,13,9,8,4,5,18,12,15,4,2,3,6,1,9,3,3,
5,3,6,15,3,7,3,8,3,4,6,20,7,9,9,9,2,3,7,5,3,6,1,9,2,7,2,18,3,3,1,3,15,3,12,3,2,15,25,20,1,5,12,9,4,
2,7,8,9,13,18,8,12,7,18,3,5,6,3,3,9,25,8,13,2,3,9,3,3,4,5,1,3,2,7,12,3,6,9,8,3,15,6,4,2,18,4,17,13,
5,1,2,3,21,3,7,5,1,2,7,3,15,2,4,2,9,6,4,9,5,7,3,26,13,3,8,6,4,9,6,2,12,6,9,1,6,5,4,5,1,11,4,3,2,28,
3,2,18,12,6,6,4,5,6,1,5,12,7,11,10,5,9,4,6,9,2,9,1,2,1,12,3,5,9,12,1,3,9,5,16,2,3,1,21,2,6,12,18,7,
8,9,7,11,15,9,9,1,8,6,7,5,9,21,4,3,6,5,16,3,3,2,6,7,3,5,9,6,6,4,14,3,4,8,1,12,3,5,1,3,11,1,8,6,6,6,
7,8,7,3,12,5,10,20,1,12,3,5,1,5,3,3,10,3,2,3,7,9,11,24,1,15,12,5,7,3,2,15,1,5,7,5,3,3,12,9,1,3,5,6,
3,7,6,12,6,2,3,4,12,18,11,6,1,2,6,16,5,3,7,14,10,9,5,3,10,9,24,2,7,8,7,3,12,2,6,4,5,4,12,3,11,3,6,1,
5,4,5,7,2,6,1,9,2,10,5,9,9,1,11,18,6,6,3,7,5,4,9,9,12,3,2,6,10,8,1,6,8,9,3,4,3,2,1,12,3,8,6,3,10,5,
7,8,1,9,5,7,5,10,3,2,9,15,4,5,1,9,5,1,6,6,3,20,22,5,3,6,4,9,5,1,2,13,2,3,1,3,5,1,12,8,1,11,18,4,2,1,
12,6,9,2,4,5,1,3,8,9,1,17,3,3,1,8,3,9,4,12,5,13,5,4,11,6,15,1,2,1,2,3,4,2,9,22,2,1,6,8,7,3,8,3,4,27,
3,8,9,6,10,12,2,9,10,9,2,1,15,2,12,3,3,25,2,3,4,21,5,3,9,12,10,14,4,23,13,12,2,1,2,3,4,6,11,4,5,1,5,
13,3,5,9,4,9,6,2,10,12,2,15,1,3,14,13,12,2,10,5,3,7,3,11,7,2,6,6,1,2,6,16,3,18,3,14,3,4,11,7,2,3,1,
6,8,12,13,11,4,5,7,5,4,2,10,3,12,14,1,8,4,11,7,3,2,12,15,1,9,11,1,3,2,1,2,21,1,3,12,3,6,2,9,13,15,
11,6,1,2,12,6,3,15,1,11,3,6,1,9,9,6,9,5,6,18,1,14,13,27,6,5,1,3,5,3,3,1,5,1,2,1,5,1,15,11,3,1,11,13,
2,12,13,12,5,12,1,2,13,2,6,6,6,7,15,11,1,3,3,2,1,2,4,3,6,5,12,9,3,12,4,5,4,2,1,5,4,5,13,8,3,6,16,5,
9,1,8,15,6,13,6,5,1,11,9,3,7,9,6,18,2,9,4,6,6,5,4,2,3,4,3,5,3,1,6,14,1,2,1,5,4,2,1,9,14,9,7,3,6,2,3,
22,2,1,15,6,21,8,9,3,12,7,3,6,5,4,2,1,8,10,11,1,2,3,4,5,6,12,1,11,3,3,4,6,3,6,8,6,7,3,2,4,20,4,5,6,
3,16,5,9,16,11,1,2,10,11,4,3,3,2,9,6,7,6,2,13,9,18,3,2,12,7,6,5,3,6,1,5,15,7,20,12,1,12,3,14,1,5,10,
3,2,4,5,13,3,3,5,1,9,5,10,2,12,3,7,2,6,13,2,18,4,12,14,12,25,12,2,1,2,1,11,3,13,9,8,1,6,8,1,20,4,15,
3,2,1,9,2,6,7,5,10,3,2,6,1,9,2,19,5,1,3,14,7,9,6,14,4,11,10,2,3,12,3,1,30,5,6,10,2,1,6,15,5,15,9,6,
1,15,5,13,6,6,9,5,1,2,6,19,2,1,2,7,11,7,5,7,3,6,6,8,1,2,3,1,8,27,6,3,4,8,7,2,3,1,14,7,6,8,6,10,8,1,
5,4,11,1,3,8,10,9,14,7,12,2,4,5,10,2,7,2,9,10,2,9,15,6,3,10,11,1,3,6,11,15,15,22,30,5,27,19,2,7,2,1,
3,2,12,6,1,9,5,1,3,3,24,3,5,6,7,3,9,2,3,7,15,6,5,4,15,8,1,2,3,12,13,5,4,6,2,13,5,12,3,10,14,6,1,8,3,
4,3,3,17,3,4,30,3,12,6,2,1,6,5,9,15,6,3,1,6,5,6,3,7,2,7,6,8,1,23,12,13,15,2,13,6,5,1,3,3,2,1,5,6,3,
13,15,12,2,24,4,3,2,1,2,3,9,7,6,5,4,3,3,2,12,9,6,15,3,1,5,1,23,1,15,5,4,15,8,3,6,3,3,4,3,6,6,9,9,3,
9,6,5,3,7,8,10,5,19,5,7,8,1,2,7,2,3,12,1,8,9,3,7,8,3,4,6,15,2,10,9,8,1,5,12,7,2,15,6,13,2,7,5,10,3,
8,6,10,6,12,2,6,7,6,5,10,2,9,3,3,15,4,5,9,1,14,6,9,7,8,4,2,4,9,6,2,10,8,7,2,6,7,9,8,7,6,12,2,3,12,9,
7,2,10,12,5,6,3,12,7,2,15,10,8,6,7,5,12,1,6,20,3,7,18,3,5,4,3,2,6,3,1,3,11,1,5,9,10,5,6,1,8,7,3,9,3,
2,10,2,3,3,4,8,1,6,6,8,7,2,1,11,10,6,3,2,9,3,3,9,4,14,1,30,2,15,10,3,11,18,10,5,3,18,6,1,5,7,18,20,
7,5,6,1,3,6,2,4,3,3,2,18,3,1,6,9,6,12,3,3,2,7,5,3,18,10,12,3,2,9,1,8,1,3,2,4,14,18,3,1,3,8,9,3,12,1,
9,3,8,7,6,5,16,5,3,1,2,4,8,1,6,3,2,3,1,5,9,6,7,8,10,2,7,3,3,15,2,3,9,1,2,3,9,1,39,11,6,3,3,4,5,3,10,
21,6,15,11,4,5,9,6,13,20,1,6,6,8,9,3,4,14,1,6,5,3,19,2,4,5,7,3,2,13,11,13,5,3,4,11,13,6,9,6,11,9,16,
2,7,6,20,22,11,4,3,5,3,1,5,3,1,6,5,4,5,1,3,2,9,12,7,2,1,2,7,3,5,6,12,13,6,6,2,10,5,21,19,2,4,2,7,6,
2,9,1,9,5,1,5,3,4,5,12,9,4,2,1,5,4,14,7,3,11,3,22,8,3,3,15,4,3,9,15,14,1,5,1,3,5,6,6,4,3,2,3,6,7,35,
13,2,4,15,8,10,3,2,6,1,9,2,7,2,4,17,3,1,14,7,2,1,14,1,11,3,3,4,3,2,4,15,2,4,9,9,12,20,3,1,11,6,3,10,
5,4,20,1,5,7,5,7,2,9,1,5,3,18,3,12,15,25,8,4,2,24,6,9,12,7,2,3,3,7,2,6,4,18,11,15,1,11,4,6,3,5,4,2,
3,3,9,3,6,1,3,3,9,5,4,6,8,10,2,13,2,1,3,14,10,5,18,7,2,1,3,35,1,5,1,5,12,7,8,18,9,3,6,1,5,1,29,1,3,
2,9,1,12,20,6,4,5,12,1,2,15,10,15,6,2,4,11,7,15,17,18,10,3,3,12,20,7,5,7,8,12,1,15,12,6,5,6,4,2,4,3,
2,4,12,18,5,15,6,1,12,2,6,9,3,1,2,4,8,7,6,8,1,6,3,17,4,6,5,7,2,6,3,4,2,10,3,2,3,1,2,3,30,1,5,4,5,4,
2,1,2,3,3,15,7,3,2,13,6,6,9,3,17,1,3,5,6,9,22,2,1,6,8,10,12,6,2,13,2,6,1,6,12,6,2,3,10,14,1,9,6,5,7,
14,1,3,2,4,11,3,4,3,5,9,6,12,7,8,1,6,3,12,18,3,2,13,3,15,6,5,4,5,12,4,3,2,1,14,6,7,8,3,4,3,8,4,6,2,
4,3,5,1,5,7,9,3,2,4,6,6,3,2,12,6,10,9,2,1,12,8,3,15,1,8,6,7,3,2,12,6,7,14,1,2,1,11,3,7,3,3,12,5,6,1,
5,3,7,5,1,5,18,7,2,1,11,4,14,1,9,5,7,6,5,9,3,12,13,21,5,4,8,10,3,11,13,2,6,3,1,18,6,15,6,8,1,2,4,5,
4,11,3,1,6,3,11,1,11,7,5,7,8,6,21,4,11,1,2,1,6,11,9,13,2,10,3,2,16,2,1,5,4,11,1,15,3,3,2,12,1,8,9,3,
13,9,3,5,4,8,13,2,6,15,4,2,16,5,4,3,11,7,5,3,1,21,8,7,9,6,3,11,3,1,2,7,2,4,14,6,7,3,5,31,3,2,1,15,
12,6,5,4,5,6,9,6,1,6,2,7,3,3,2,12,6,19,3,2,3,6,4,8,4,6,3,11,4,6,8,25,5,15,10,8,3,9,1,12,3,2,3,6,6,7,
6,11,4,41,16,5,4,8,18,9,10,3,12,6,2,16,5,7,3,5,21,15,10,3,8,13,2,7,3,9,5,3,10,2,10,3,15,5,3,4,5,3,1,
2,3,7,5,27,12,3,3,24,1,14,3,3,3,1,6,3,6,3,5,6,9,3,3,9,6,1,5,1,5,7,2,1,5,7,6,5,1,6,5,3,9,13,12,5,10,
8,19,9,2,3,1,3,15,3,14,13,2,9,15,9,1,2,9,9,4,5,1,12,3,14,6,4,3,5,4,9,2,10,17,10,5,1,5,6,3,6,9,10,3,
2,18,15,7,2,10,3,5,1,2,9,1,3,5,10,6,8,6,10,17,13,6,6,2,6,6,9,6,4,6,3,3,5,4,6,3,2,3,7,9,14,4,11,16,8,
1,11,13,2,9,9,1,11,3,1,6,6,12,5,1,12,3,6,11,9,1,3,9,2,3,22,9,2,4,5,3,6,10,5,9,10,3,5,3,4,3,3,11,6,
13,15,5,24,16,12,3,2,7,2,6,3,1,8,1,5,1,5,3,15,1,5,9,7,5,1,3,12,2,10,2,4,29,1,12,12,2,6,3,7,3,2,27,3,
7,6,2,10,3,12,5,3,16,6,15,9,14,15,1,8,18,3,1,3,12,6,8,4,2,18,3,10,8,6,1,2,7,18,8,3,1,3,6,2,7,3,2,1,
2,4,5,10,6,5,9,3,1,6,5,4,6,5,1,8,22,5,22,6,5,4,2,3,7,5,1,8,12,3,4,3,5,9,1,2,3,7,2,6,4,9,9,2,1,9,5,4,
11,6,15,7,2,3,16,2,4,8,7,8,6,9,3,3,4,11,7,3,5,4,23,4,8,3,4,9,6,8,13,5,7,2,16,2,3,7,5,7,11,3,4,6,14,
7,8,3,13,2,12,10,6,12,3,9,11,7,2,3,4,6,5,7,2,1,12,17,10,6,9,6,9,15,3,2,3,10,2,4,5,9,10,6,2,4,3,5,3,
7,3,8,7,24,3,2,9,9,16,6,3,6,5,10,11,6,4,11,4,3,2,4,2,7,3,9,5,13,17,9,7,2,10,2,3,6,6,9,4,2,10,8,6,7,
3,2,9,10,5,9,1,3,21,21,5,10,3,5,1,2,9,4,6,26,3,7,5,19,5,4,5,4,3,2,10,2,10,8,1,2,3,6,1,5,7,2,4,11,3,
1,2,9,3,25,11,7,8,7,8,4,6,2,10,12,23,13,5,1,5,6,15,9,13,5,10,5,6,4,3,3,5,9,12,1,8,1,11,4,6,15,3,9,2,
9,16,6,8,15,1,18,15,3,12,11,1,14,1,8,1,15,5,12,22,2,18,7,6,8,15,1,5,4,9,2,1,14,1,3,2,3,16,5,13,11,4,
6,12,2,3,3,7,9,9,5,12,9,6,13,5,16,11,10,5,3,1,20,3,7,5,10,3,3,2,6,6,1,2,1,5,10,2,12,6,7,8,4,2,1,14,
3,7,3,3,2,6,1,5,9,12,3,6,3,6,4,17,4,2,4,9,5,9,12,3,1,6,15,15,9,5,10,2,4,3,5,1,5,9,3,7,3,9,8,1,5,1,3,
3,5,4,5,6,3,4,23,4,8,1,2,12,7,5,15,10,3,2,6,13,9,2,3,6,7,5,4,5,4,5,16,15,6,15,12,5,1,2,12,3,3,7,18,
9,2,10,9,5,4,3,12,5,6,4,5,1,5,22,17,13,17,3,7,8,3,7,12,2,1,3,6,5,3,25,3,5,10,2,1,2,18,1,15,3,6,5,15,
1,8,3,3,1,3,2,13,2,1,3,2,7,11,7,3,5,9,1,11,4,6,3,2,31,9,3,11,15,7,3,11,4,5,1,3,2,16,33,2,4,3,8,18,1,
5,1,2,18,3,4,3,3,5,4,2,3,3,4,3,2,9,9,15,7,5,1,2,12,1,5,9,4,5,4,2,10,3,6,5,7,8,1,33,2,13,8,9,1,3,20,
1,18,2,1,3,11,9,16,3,11,4,5,1,2,7,2,13,6,5,6,3,1,5,6,3,7,5,15,18,16,2,7,3,3,6,6,2,6,7,2,1,9,11,1,3,
6,9,2,15,3,10,5,7,6,3,26,3,3,4,6,3,2,9,3,7,9,2,7,5,1,6,9,12,3,11,3,7,5,4,15,2,12,3,3,1,9,9,5,6,30,
10,17,4,3,5,1,2,12,1,5,15,16,29,7,2,3,4,5,16,2,3,10,3,5,1,6,3,12,5,7,3,12,12,5,3,3,7,3,5,7,11,19,2,
3,3,3,12,3,10,6,14,1,8,3,7,3,15,8,1,6,2,3,9,1,17,1,2,7,11,4,12,14,1,9,2,3,7,8,7,3,5,4,3,9,5,3,3,4,8,
12,10,5,3,21,1,3,2,16,12,12,11,3,1,3,5,1,5,7,9,3,3,2,12,13,2,1,3,2,15,13,2,4,5,1,17,3,15,4,3,2,1,5,
12,1,2,12,1,14,16,6,23,7,3,6,2,12,7,8,3,3,7,3,9,2,9,6,1,12,3,14,30,6,28,5,1,5,1,5,7,3,2,7,9,5,10,6,
8,3,10,2,1,9,5,12,6,4,8,7,3,2,4,2,7,5,12,25,6,8,16,6,5,3,22,3,21,3,11,21,4,2,10,8,19,3,9,3,15,8,3,7,
2,6,12,3,7,9,3,6,9,2,3,7,3,2,10,6,9,8,1,5,10,2,10,12,3,3,2,9,13,5,3,3,7,3,12,9,5,3,1,5,1,8,7,5,18,7,
5,4,24,6,5,7,12,2,3,12,1,12,3,20,34,6,2,3,4,3,17,13,15,5,6,1,3,6,2,3,9,1,21,14,1,5,6,3,4,2,18,1,12,
2,6,6,4,11,1,2,10,2,1,15,3,2,13,6,14,12,7,12,5,1,2,7,3,15,3,3,2,15,4,11,7,17,4,11,4,6,5,10,3,6,11,3,
3,7,5,6,7,2,6,7,15,8,1,6,5,7,21,14,15,6,9,1,15,5,1,3,15,11,6,4,15,6,8,1,9,3,8,1,6,2,1,12,2,3,10,3,5,
4,5,1,9,2,9,15,1,6,8,1,5,3,1,12,8,1,5,9,6,4,6,5,10,11,4,14,9,13,9,11,24,3,3,3,19,2,3,25,5,12,6,7,2,
3,1,17,3,7,3,2,4,14,9,6,6,1,14,1,5,3,4,2,3,1,2,13,6,8,3,9,1,3,6,9,14,3,4,3,3,3,5,6,3,15,1,5,4,3,5,
24,4,2,9,3,7,5,1,5,15,7,8,3,4,5,10,2,1,8,6,3,3,10,12,23,4,11,10,3,21,18,2,1,2,6,1,14,12,9,3,3,3,1,6,
3,9,5,12,4,6,3,2,9,4,11,7,9,15,3,6,2,4,9,5,16,3,11,1,35,6,7,3,5,3,6,4,5,1,5,6,10,5,13,15,9,6,6,6,5,
7,3,2,18,3,4,12,5,6,3,4,3,2,1,15,5,9,7,5,3,7,5,6,4,8,3,3,12,3,7,5,4,9,5,1,3,6,2,3,6,18,18,3,10,11,3,
1,2,4,8,15,7,3,11,1,8,1,5,1,6,5,7,15,5,3,9,3,13,3,6,8,7,5,3,1,2,7,2,3,6,7,3,5,4,2,1,2,15,16,2,7,18,
3,2,3,6,1,2,7,6,5,10,3,9,8,3,4,5,12,1,2,1,6,5,3,6,19,6,5,4,8,7,5,36,7,3,6,3,5,12,15,1,3,11,6,13,27,
9,6,23,12,12,7,6,3,5,1,3,17,3,1,2,4,11,4,6,8,10,9,6,9,3,8,6,1,3,5,7,3,5,1,8,16,5,4,8,4,5,3,1,12,5,4,
3,3,8,12,7,8,4,3,2,4,2,12,10,6,2,15,7,5,18,9,3,6,4,8,12,7,18,3,5,4,5,1,14,4,5,12,3,10,2,7,2,1,2,3,
12,3,4,14,4,2,3,18,7,5,3,3,1,11,9,6,7,6,6,8,1,12,9,14,6,3,7,6,5,3,9,7,3,11,15,6,9,7,3,11,10,9,12,12,
11,1,3,11,4,17,13,8,9,1,5,27,3,7,3,8,1,3,3,3,11,3,3,12,3,7,11,4,2,6,7,2,9,4,6,2,7,12,6,3,2,3,6,1,2,
6,6,1,12,2,3,3,4,5,3,1,2,4,15,9,5,6,3,1,11,1,8,10,11,1,3,11,9,7,2,3,9,9,7,2,3,3,1,5,16,17,10,8,3,1,
6,2,10,5,16,2,3,7,5,3,1,20,3,10,11,7,15,9,26,10,8,9,1,17,3,4,3,5,7,3,8,10,5,1,3,23,7,20,10,3,8,1,5,
1,2,22,5,3,7,3,17,1,3,2,12,7,8,6,1,15,14,4,2,6,7,2,1,8,19,6,6,3,5,7,14,7,2,1,20,1,6,5,3,6,1,5,13,5,
1,14,4,6,5,9,3,4,6,2,3,4,5,4,11,4,2,4,3,15,3,2,7,5,9,7,2,12,1,14,4,15,35,9,6,1,18,2,6,10,3,11,1,2,7,
5,10,3,3,3,5,21,1,3,5,7,5,4,6,5,3,4,2,13,2,4,2,13,2,3,6,1,2,7,11,10,5,10,32,1,6,11,12,1,5,1,6,2,3,7,
8,3,1,3,6,2,9,4,6,3,5,1,6,8,1,2,9,4,20,4,12,5,1,5,10,5,4,3,11,7,18,14,6,4,5,6,12,9,13,6,9,5,13,8,9,
1,5,4,3,8,12,7,3,3,14,6,10,2,13,6,5,3,1,2,7,2,9,1,3,18,9,3,6,5,4,6,9,6,5,7,5,3,4,5,6,4,3,5,12,7,15,
8,13,8,6,6,12,6,1,6,8,10,9,21,5,6,1,8,1,5,4,9,26,4,5,1,2,7,15,3,3,2,3,4,2,10,15,5,1,14,1,14,10,9,6,
3,3,2,7,3,11,21,13,6,9,2,1,2,18,3,1,9,2,7,6,6,5,3,3,4,20,9,10,9,15,5,6,9,1,5,6,3,3,3,1,18,3,3,2,9,3,
7,3,11,1,9,9,2,1,2,12,4,5,4,2,3,25,5,7,3,2,4,12,15,3,14,1,6,8,13,5,9,28,3,2,3,9,18,10,2,1,14,1,5,9,
6,7,5,6,1,8,12,3,21,4,12,6,17,3,13,2,4,6,3,15,12,2,10,5,13,29,4,6,8,33,10,8,1,3,8,3,4,2,4,11,3,3,3,
4,12,9,27,2,7,14,10,6,11,4,3,5,6,9,6,1,5,1,8,6,3,3,7,2,4,12,2,1,11,10,14,6,9,7,3,2,7,11,7,14,1,2,1,
6,9,2,15,3,4,3,3,5,15,6,1,5,13,9,2,6,12,10,3,8,1,6,2,16,5,12,7,6,9,2,3,1,17,4,9,2,4,3,11,1,9,14,6,7,
12,6,6,5,3,3,10,3,5,4,3,2,1,5,7,3,5,4,8,9,1,3,2,9,4,2,15,15,12,15,3,7,3,9,5,1,38,4,11,6,4,11,15,16,
3,5,6,1,17,1,2,3,9,1,2,4,5,15,6,3,7,9,5,15,4,2,13,2,4,8,3,7,3,9,5,1,2,18,3,10,5,4,15,2,4,14,1,9,6,
11,1,3,11,3,7,5,18,21,1,6,3,2,7,3,3,5,1,5,15,19,15,6,9,2,12,3,4,5,28,8,3,4,8,3,7,14,10,8,1,2,3,6,4,
11,4,2,19,11,3,4,6,2,7,11,16,23,3,4,3,12,5,16,2,15,1,2,22,6,5,9,18,3,1,18,3,14,9,12,3,1,6,2,27,9,6,
16,9,5,3,3,3,4,11,1,3,2,10,6,2,3,10,2,3,15,9,1,14,3,6,10,12,9,6,12,2,15,6,7,3,9,3,6,21,3,3,14,3,12,
13,2,9,6,3,3,15,13,5,1,8,7,8,3,4,15,9,12,3,2,7,5,1,2,3,4,3,12,5,1,14,7,8,18,9,1,12,8,10,3,11,3,18,
10,15,12,5,1,2,12,1,17,3,10,6,5,1,3,5,7,2,3,4,9,2,10,3,6,5,6,4,6,3,27,5,4,15,3,2,4,11,4,9,6,2,15,3,
15,1,5,13,3,9,11,3,7,2,7,5,4,6,6,2,12,1,3,5,1,5,4,20,1,3,3,12,3,2,3,13,21,5,3,15,10,11,1,18,2,3,1,
17,4,8,3,7,3,20,10,2,3,3,6,1,18,9,5,6,4,5,6,1,6,9,6,2,7,5,6,4,3,3,5,12,3,4,3,11,4,11,1,3,6,5,1,9,2,
3,4,2,9,4,3,3,2,3,7,9,3,8,4,8,6,1,6,2,7,6,8,1,3,5,21,6,15,9,15,9,7,5,3,10,8,3,1,5,15,1,12,5,3,3,12,
3,22,5,25,3,5,12,4,9,6,15,5,9,6,3,7,6,2,10,8,3,4,8,13,2,12,1,2,3,4,3,20,12,3,7,8,7,2,4,6,3,2,6,4,6,
5,3,4,6,11,3,7,14,4,6,5,10,6,8,1,12,9,9,6,11,3,12,3,22,5,7,6,17,4,3,5,6,7,8,16,9,2,9,6,15,4,3,3,23,
1,6,3,2,7,2,9,6,1,3,2,3,4,3,12,2,3,1,6,6,8,6,3,15,1,2,3,1,8,3,13,9,8,4,9,6,8,1,2,4,9,6,8,3,3,6,1,18,
11,1,3,2,12,1,6,3,5,3,19,30,3,6,11,15,3,1,2,10,3,5,6,3,1,17,4,3,3,2,3,13,5,4,3,2,10,2,3,7,29,7,3,6,
3,2,1,15,17,12,4,20,4,5,7,6,3,2,9,31,5,15,4,3,3,3,5,6,3,6,7,2,1,6,8,3,7,3,5,7,2,4,6,3,2,4,2,4,35,1,
3,2,7,2,9,4,2,1,12,3,12,5,3,13,11,1,18,5,6,3,12,1,8,16,8,7,3,11,6,1,3,14,1,5,1,14,6,4,32,10,5,7,2,1,
2,7,8,1,6,5,6,3,12,7,5,1,15,14,6,6,3,21,4,5,3,18,7,5,4,8,18,4,3,6,20,6,3,10,17,1,2,12,3,6,10,5,7,14,
1,5,3,4,3,5,10,14,10,3,2,3,1,14,1,5,4,3,3,6,5,15,33,1,6,3,12,3,15,2,3,1,6,11,3,6,13,3,3,9,5,12,3,3,
13,15,5,1,5,4,2,3,6,3,6,10,5,4,2,3,22,14,4,5,6,1,14,1,6,20,3,6,3,3,9,6,15,3,1,6,3,5,1,14,6,1,8,21,1,
17,1,5,7,3,6,5,15,3,1,6,3,2,1,8,4,8,7,8,4,9,15,5,9,12,4,6,6,2,6,1,20,10,8,6,12,4,6,17,3,9,6,4,3,6,2,
7,6,2,7,2,9,4,5,3,10,2,15,1,6,21,3,5,16,8,3,7,5,10,11,9,13,8,1,21,9,8,1,26,3,1,6,6,5,7,8,18,6,1,17,
3,7,17,3,6,16,3,5,7,3,2,6,3,24,6,4,6,11,3,6,1,6,5,3,1,6,2,12,19,2,9,3,1,2,4,8,1,2,4,5,4,6,5,3,1,6,3,
3,8,1,11,13,2,7,2,9,7,33,2,15,7,2,4,2,7,20,6,1,11,4,14,1,14,4,2,1,8,7,5,19,3,8,10,2,3,4,8,12,3,1,5,
1,3,5,7,3,3,12,3,3,6,5,4,5,12,3,9,6,6,9,4,2,15,15,10,3,15,3,3,6,5,1,2,15,1,6,6,9,6,8,10,11,10,14,9,
15,6,9,10,8,12,3,7,12,9,12,17,1,11,13,2,4,5,9,25,8,3,4,2,1,8,1,6,8,7,2,13,3,5,24,10,3,2,10,2,1,3,5,
6,4,2,7,3,5,7,6,5,6,4,2,15,13,2,10,3,17,4,3,3,2,28,2,12,16,5,3,1,5,4,5,7,5,3,1,3,2,3,10,6,14,3,13,2,
3,10,12,17,18,9,1,3,11,4,14,10,3,2,3,4,6,8,6,15,1,14,1,3,5,4,2,10,3,6,12,2,7,3,2,4,6,9,6,6,8,1,5,1,
5,12,12,9,12,3,6,16,2,1,9,2,16,12,6,6,3,2,3,6,1,3,6,2,3,9,7,6,2,3,3,6,6,4,21,33,5,6,3,12,1,2,6,6,6,
4,30,8,7,11,10,8,7,3,2,9,9,6,4,15,9,5,1,2,4,11,7,6,11,6,10,8,4,2,13,3,3,29,15,1,6,6,2,3,4,3,5,6,4,6,
24,2,16,2,3,3,6,3,7,5,1,3,6,11,7,2,1,3,5,9,3,13,9,6,11,3,1,20,1,15,14,10,6,18,5,22,5,1,2,18,7,3,5,3,
6,3,1,9,2,4,2,18,1,8,1,5,7,5,4,5,6,7,2,13,5,15,13,9,6,8,6,3,6,4,3,2,7,6,15,2,3,9,6,13,9,17,4,6,5,6,
3,1,6,14,1,2,1,9,20,3,3,4,5,30,10,3,3,2,12,3,7,5,6,4,3,8,6,16,2,3,3,9,6,10,5,4,5,7,11,4,6,2,1,6,15,
9,12,9,3,2,1,5,12,1,2,13,2,7,6,2,4,3,3,8,1,14,4,8,4,6,12,2,10,3,2,9,4,3,8,1,14,1,5,4,2,4,5,3,3,3,6,
19,2,12,7,23,16,2,3,7,8,4,11,6,1,3,6,15,14,6,4,12,9,3,3,9,9,9,6,2,13,2,7,5,3,7,5,1,6,5,1,14,1,2,7,5,
13,6,11,3,28,2,1,5,7,2,1,39,2,1,2,1,6,3,6,2,3,10,2,4,3,11,1,20,33,15,16,9,11,6,4,9,2,10,23,3,12,3,
10,2,10,2,9,7,9,3,5,7,5,6,7,3,12,11,1,3,3,3,12,3,11,4,5,1,8,6,10,2,10,2,22,6,8,1,3,2,1,8,9,6,6,1,29,
1,5,4,24,2,7,2,3,1,11,1,2,13,2,3,9,1,12,6,6,8,3,10,2,15,1,5,9,3,7,3,12,2,4,5,12,7,2,6,7,5,12,3,1,20,
6,9,6,9,7,5,9,6,12,1,6,15,6,5,12,7,3,3,12,8,19,6,2,1,11,4,12,3,2,4,5,1,9,11,7,6,9,6,5,7,8,4,17,1,3,
17,10,17,15,3,4,11,7,12,5,3,7,8,6,4,2,6,7,6,14,1,2,7,8,4,8,6,7,9,3,2,10,5,4,9,6,2,4,3,2,16,5,4,6,2,
6,1,8,12,6,10,5,9,1,2,10,2,3,7,6,3,2,3,6,1,2,1,17,3,12,3,12,7,2,1,5,13,2,13,11,1,9,5,1,2,6,22,3,12,
14,4,6,3,5,6,7,8,9,3,3,1,24,11,6,4,3,5,1,21,5,1,9,6,3,14,6,12,9,1,5,4,5,9,1,18,5,21,4,8,9,1,3,11,4,
6,8,18,3,16,6,2,3,15,4,3,3,8,6,10,5,4,2,24,1,3,6,5,3,3,9,1,2,10,6,26,24,21,1,2,3,10,8,6,9,10,6,3,2,
10,6,5,4,5,3,1,11,9,1,3,2,3,13,12,3,17,1,2,10,15,27,2,1,2,13,14,4,2,9,13,5,1,2,3,6,1,8,16,3,8,3,12,
3,21,10,3,5,1,2,4,9,6,30,3,8,3,9,3,7,5,1,5,4,3,15,8,6,13,3,9,9,11,3,10,6,2,19,3,5,12,1,20,3,1,5,1,3,
5,6,1,5,12,3,3,9,10,3,9,9,6,6,8,15,9,21,4,3,3,6,3,2,4,5,10,6,8,6,19,3,5,4,8,1,6,3,3,17,1,12,3,6,8,
37,3,6,2,15,3,9,7,5,1,3,14,10,6,5,10,11,6,3,1,3,3,8,1,3,3,2,1,12,3,6,15,6,3,2,3,9,12,6,3,12,7,12,11,
12,30,21,1,11,3,6,9,24,6,1,9,2,9,10,8,15,1,6,6,8,7,2,6,1,15,5,13,2,1,5,7,20,1,15,12,14,3,3,15,7,5,
21,4,6,2,9,9,6,1,15,9,6,20,9,3,6,1,3,5,1,11,10,21,5,4,14,4,6,20,4,15,2,4,5,1,8,12,3,7,3,6,11,3,12,
10,3,3,3,2,13,17,9,3,12,4,5,9,12,6,7,3,2,7,8,18,7,8,4,20,3,1,6,15,6,2,1,12,14,3,15,3,7,6,5,6,3,37,3,
20,6,1,6,12,3,14,4,6,5,9,12,12,1,5,1,8,3,4,3,2,1,2,30,10,11,7,15,14,1,3,6,11,4,6,3,9,3,5,4,3,11,15,
1,3,5,6,12,7,2,3,3,4,3,3,3,9,2,1,5,12,10,8,3,10,12,5,4,20,1,8,24,1,2,7,3,2,1,11,1,14,1,17,28,3,6,3,
23,7,3,2,1,12,2,7,3,5,3,13,2,13,2,9,4,2,18,6,3,1,5,6,4,24,6,2,10,17,3,13,9,2,19,2,10,8,10,9,3,2,16,
2,10,9,8,7,5,3,7,3,11,1,3,3,15,2,1,11,4,9,5,3,10,2,6,6,4,14,13,3,17,9,3,3,10,9,15,8,1,2,3,1,6,5,3,1,
9,14,1,11,6,12,1,6,6,8,1,9,9,17,1,20,18,7,8,4,2,3,1,15,11,1,5,9,15,3,1,2,9,9,4,27,6,5,4,5,3,6,7,5,9,
13,11,4,3,3,2,10,2,1,15,9,2,6,4,3,3,3,17,7,6,6,3,5,1,2,3,1,9,6,5,3,3,3,16,6,15,5,4,3,12,8,12,9,6,1,
5,18,4,3,3,2,7,2,6,7,6,5,9,6,4,5,6,9,1,12,8,4,2,16,5,4,11,3,1,6,3,2,4,3,2,36,7,15,27,6,3,9,12,5,9,6,
3,7,6,3,12,2,1,17,4,6,14,1,3,5,7,2,6,1,15,11,13,9,11,9,3,7,11,1,5,1,2,7,3,2,1,5,3,12,3,7,3,29,12,1,
20,15,9,6,3,9,10,8,7,11,4,2,16,9,14,7,14,6,4,3,6,6,8,3,3,1,14,10,9,2,3,3,3,4,6,12,2,3,27,6,7,9,8,3,
9,3,7,3,15,2,13,8,10,5,3,1,3,2,15,1,3,2,3,4,5,10,11,7,2,7,3,2,3,6,1,3,8,4,3,3,2,6,16,6,12,3,5,9,21,
3,10,9,6,15,2,7,2,1,2,3,9,4,11,10,3,5,6,4,3,3,2,12,6,7,5,9,6,7,2,4,11,4,2,4,11,7,6,9,5,6,7,5,10,15,
5,7,2,3,10,6,14,3,3,4,2,1,2,22,6,5,4,3,2,1,3,2,24,4,12,15,9,8,1,5,12,3,7,5,3,4,21,6,6,5,12,6,6,15,1,
8,1,3,20,12,9,4,3,3,5,1,5,1,14,3,7,5,6,4,9,2,22,8,4,3,6,2,4,24,6,18,3,3,2,9,13,2,3,16,14,25,11,6,6,
7,3,5,13,6,3,5,1,11,1,17,1,14,10,11,7,2,1,11,3,1,6,8,6,9,1,5,1,8,6,1,8,3,4,11,10,3,2,4,5,9,4,6,36,3,
2,3,6,10,2,10,12,5,3,7,5,3,4,6,3,5,1,5,1,5,10,2,12,1,12,2,3,3,9,4,9,6,2,3,4,2,16,2,3,12,3,3,1,9,9,2,
3,12,6,10,3,12,9,9,12,2,3,7,15,6,6,26,3,1,3,3,8,6,10,5,15,9,16,8,7,6,2,7,5,3,1,14,1,2,3,1,5,1,8,12,
12,7,3,2,3,10,15,3,2,12,1,15,5,10,3,9,5,3,18,1,3,6,2,9,3,7,8,3,3,1,6,12,2,4,12,5,13,15,6,5,3,1,12,2,
10,5,18,9,13,5,1,9,11,4,2,9,1,9,2,24,1,3,5,10,2,28,5,4,17,6,10,5,22,2,13,2,4,5,9,6,6,4,14,10,2,1,9,
5,4,2,13,2,4,21,15,8,1,6,5,10,2,30,3,4,11,4,11,4,3,11,6,4,9,3,5,3,7,3,5,4,6,17,13,15,5,7,8,6,3,16,2,
19,3,2,24,10,12,2,21,1,20,3,7,5,10,20,1,2,6,6,10,3,5,6,4,2,6,10,9,3,8,3,4,6,2,12,12,3,10,3,2,13,5,
12,1,2,12,13,9,5,16,3,5,1,8,12,1,5,15,7,2,4,5,25,12,3,9,5,3,4,21,2,3,13,6,6,9,6,8,1,5,13,2,9,10,5,6,
1,12,2,3,3,12,1,2,3,10,12,8,1,8,3,10,5,9,10,5,4,2,19,5,1,8,1,15,5,6,3,10,9,6,2,19,8,6,4,2,1,8,1,5,1,
5,7,8,3,15,4,5,7,8,10,3,3,15,6,8,3,3,1,8,7,9,5,4,5,3,18,7,5,9,9,9,3,3,1,6,15,3,17,12,3,4,6,8,15,6,3,
10,2,15,1,12,3,2,12,6,10,12,3,2,1,5,1,5,4,5,9,3,4,3,2,6,3,7,9,3,2,4,5,4,6,9,3,17,1,11,6,24,6,9,6,3,
9,3,3,1,6,17,18,10,8,7,5,7,6,6,3,3,5,3,7,2,12,9,1,3,2,10,3,3,8,4,2,10,11,12,3,19,6,5,7,3,2,10,6,5,6,
4,6,3,6,2,4,3,6,14,6,1,8,6,4,18,15,3,15,5,7,12,3,14,1,2,12,10,3,2,6,7,3,3,6,5,16,2,3,3,7,14,9,9,13,
3,5,12,4,8,1,2,10,2,3,7,11,1,5,1,14,3,25,2,3,3,7,2,4,2,3,4,5,6,4,2,1,8,6,3,3,3,16,5,1,5,9,3,12,3,3,
4,6,5,18,1,5,4,11,1,9,21,2,1,14,1,12,14,1,3,5,9,15,6,12,7,3,5,4,3,5,7,3,6,2,4,20,10,33,12,8,3,3,1,6,
2,10,21,5,19,2,1,3,5,4,2,3,1,35,6,4,15,5,4,5,3,4,3,3,8,24,3,3,4,27,8,3,9,9,6,9,6,1,12,12,3,8,3,1,6,
2,1,20,4,3,8,6,6,7,2,4,2,12,3,10,9,6,9,8,1,12,9,11,7,12,3,2,16,2,16,5,10,6,5,6,3,4,3,3,9,5,7,5,6,10,
5,13,5,7,3,2,7,2,6,3,1,3,11,7,5,13,20,6,1,2,7,8,7,5,6,10,8,10,2,7,2,3,3,4,3,5,3,7,5,16,2,4,3,2,10,5,
1,3,11,4,11,10,6,3,11,9,10,12,8,1,5,6,10,12,2,3,6,1,14,6,9,16,8,6,6,15,10,9,6,6,12,2,1,9,6,2,1,14,
13,3,14,1,2,30,3,10,14,1,5,4,15,2,1,3,2,22,11,1,3,6,2,3,4,12,5,1,2,6,16,3,3,3,11,3,1,2,4,9,6,9,2,3,
1,8,1,6,5,3,13,2,3,7,3,3,5,12,13,2,3,10,14,1,11,3,10,5,3,9,6,3,19,2,3,13,3,2,13,5,7,17,10,11,7,2,3,
4,21,2,10,2,3,1,11,4,2,3,4,3,9,9,2,9,6,4,15,9,5,9,6,6,3,6,1,8,18,3,4,5,12,6,3,1,3,5,7,6,2,12,6,4,6,
12,2,4,2,7,3,3,11,9,7,2,7,3,5,7,5,10,5,1,5,3,12,13,14,1,6,14,4,17,9,9,3,3,12,7,2,1,2,22,3,3,2,7,5,3,
15,1,2,7,5,16,9,6,11,10,9,2,4,5,10,8,3,4,3,18,20,18,4,3,8,4,2,1,8,9,1,11,9,12,10,14,9,10,2,4,3,5,1,
5,1,18,5,3,7,3,5,7,15,2,13,11,9,1,5,1,6,5,15,7,2,6,7,3,2,1,6,14,21,3,28,8,6,4,5,7,14,3,10,3,3,11,3,
1,11,1,2,1,2,9,10,9,2,19,9,2,3,7,2,3,3,6,1,2,6,6,4,5,6,3,10,2,9,6,6,19,11,4,9,12,5,3,1,5,1,5,9,28,
12,8,3,7,3,3,6,15,5,1,2,6,6,21,4,5,6,13,2,10,2,6,7,3,9,8,4,5,13,3,12,2,4,5,19,12,6,2,6,1,6,8,4,6,5,
10,9,15,12,5,1,3,12,3,2,3,9,27,1,2,3,12,1,5,1,3,11,4,17,1,5,7,18,3,2,3,6,15,4,5,4,15,17,16,8,4,8,9,
1,5,7,5,1,14,6,1,3,3,2,1,5,16,5,1,5,3,19,5,1,2,4,8,10,3,3,11,10,5,9,1,21,3,14,7,8,10,5,1,5,22,8,4,3,
2,7,3,8,3,4,2,3,7,14,1,3,5,3,3,36,10,3,2,9,6,6,12,1,2,10,2,3,4,8,6,9,1,11,10,5,6,9,1,3,6,3,5,1,12,3,
6,9,17,10,8,1,14,4,5,3,18,7,3,2,3,1,24,5,15,6,1,12,2,3,1,11,6,4,9,2,3,4,5,13,8,7,2,10,6,2,3,4,3,5,
13,6,3,3,18,12,3,6,14,22,5,7,5,1,5,9,10,2,10,5,1,12,2,1,8,21,6,4,5,3,15,6,4,6,5,6,13,11,1,21,3,9,8,
10,3,5,9,6,1,5,1,5,18,1,5,4,9,8,12,10,15,2,1,9,14,6,9,4,2,1,3,11,3,3,9,18,7,9,27,2,3,3,4,18,2,1,2,4,
14,7,12,2,15,1,2,1,5,9,3,9,1,5,12,15,3,3,24,1,11,4,5,1,11,7,6,9,12,11,4,8,3,7,5,15,3,10,9,3,2,16,2,
12,3,1,5,10,2,3,1,23,1,11,1,5,10,3,2,22,5,1,12,9,5,3,6,7,2,1,5,9,6,12,3,6,1,17,1,5,1,8,3,12,12,1,5,
12,6,4,2,1,5,3,6,6,4,9,9,3,3,2,3,22,3,12,2,10,3,17,25,6,12,2,12,10,6,9,5,13,3,3,2,4,14,7,9,3,2,4,6,
6,15,12,8,3,6,3,1,2,4,5,6,10,2,3,19,9,5,1,14,19,5,15,3,7,3,8,4,2,3,12,13,3,2,3,13,2,22,2,9,4,3,18,
17,3,6,1,2,13,12,12,5,13,15,3,2,7,11,10,14,1,5,7,3,3,11,4,6,15,9,5,1,8,10,5,10,2,6,19,5,9,15,7,2,1,
5,7,12,8,13,9,5,1,9,11,9,1,9,3,8,7,2,1,2,9,9,1,6,8,4,5,10,15,5,15,16,6,14,10,2,7,2,6,7,5,3,4,15,3,2,
1,3,15,14,12,16,5,13,5,10,2,3,21,6,3,9,7,5,4,5,4,6,11,13,11,4,3,2,7,5,1,9,5,15,13,3,3,14,3,4,8,1,2,
4,3,2,4,5,6,10,3,2,9,4,18,2,16,2,10,5,3,1,14,1,5,1,2,7,6,5,3,31,5,10,6,3,14,1,11,1,9,5,3,3,24,3,3,9,
4,6,3,15,11,9,1,2,4,3,12,5,4,29,1,5,12,7,11,1,5,9,1,5,3,6,1,5,1,15,5,12,7,6,5,7,2,3,27,3,3,3,7,12,2,
1,14,3,3,3,4,11,15,19,2,1,5,3,4,2,6,3,4,6,9,18,5,10,2,7,6,2,1,5,4,5,3,13,2,3,4,8,13,6,8,12,1,3,12,2,
3,7,3,9,6,8,7,5,4,5,9,12,3,6,10,5,10,3,11,7,8,16,5,4,5,9,30,1,6,3,2,1,2,10,18,32,6,9,7,5,6,9,1,5,3,
6,1,3,5,4,2,18,1,2,15,3,4,12,8,1,6,3,2,10,3,15,5,16,2,3,4,6,14,6,16,5,1,5,18,4,2,3,1,6,29,4,18,5,3,
6,1,9,6,5,10,2,15,18,10,2,12,4,2,3,4,2,10,6,12,6,15,12,15,15,2,7,6,9,9,9,2,4,2,7,5,6,1,6,33,2,3,4,3,
5,4,5,1,8,4,5,1,14,7,11,4,5,1,9,6,2,7,11,4,6,3,9,12,3,5,1,5,12,4,14,6,3,6,7,2,12,6,9,3,1,6,3,12,3,5,
1,9,5,1,5,7,2,3,10,14,1,5,9,1,3,2,4,14,4,11,6,3,6,6,1,14,6,4,20,6,4,15,14,1,8,1,17,4,3,8,3,4,11,16,
5,3,1,2,7,5,1,2,3,1,21,2,7,6,2,10,3,5,3,4,2,3,1,17,3,1,9,5,6,10,6,2,15,7,9,5,16,5,3,1,2,18,7,9,6,8,
4,2,9,10,21,15,15,9,5,1,8,1,9,2,6,27,3,4,24,5,6,15,10,5,10,11,9,1,5,7,2,4,2,10,17,6,15,1,5,3,3,3,1,
20,1,2,15,10,5,1,5,7,17,3,3,4,11,1,6,3,14,3,4,26,7,20,1,2,10,2,6,1,14,7,3,11,3,7,8,6,1,5,1,2,6,1,6,
2,3,3,7,2,6,1,3,2,1,3,2,13,20,4,27,11,28,15,11,10,3,5,3,3,4,6,12,9,5,1,14,1,3,5,7,3,17,12,1,2,4,3,
11,1,8,3,3,4,11,1,6,12,2,3,3,4,5,4,6,6,14,1,2,7,6,2,3,10,12,11,6,13,5,10,3,2,13,18,5,16,3,2,9,4,15,
8,3,10,9,2,10,11,7,8,10,20,4,3,6,2,3,7,5,3,4,18,2,6,1,3,11,10,9,3,3,2,4,5,4,2,4,3,3,2,3,7,18,5,4,14,
1,11,9,1,12,5,6,10,2,3,6,3,13,2,7,5,10,11,12,7,3,8,10,2,1,11,1,3,15,9,2,9,12,9,1,12,2,6,19,6,2,7,8,
3,3,1,8,16,9,12,8,3,3,9,7,6,9,5,10,18,2,4,5,4,6,11,18,6,6,1,8,10,11,28,2,1,17,1,12,8,15,1,6,9,3,2,1,
2,6,10,12,20,10,3,2,13,11,3,1,6,15,3,2,4,5,6,4,2,19,11,4,3,5,1,5,6,4,12,8,7,14,3,10,5,13,9,8,6,10,
11,1,2,10,2,33,1,2,3,4,11,4,3,3,12,2,1,5,4,2,3,13,14,4,6,9,5,9,15,7,18,2,3,6,1,3,3,5,7,2,3,3,7,21,2,
10,2,16,17,4,6,3,5,7,2,3,4,15,3,5,1,2,7,11,12,3,4,3,8,10,2,9,15,3,10,11,4,2,15,1,2,3,3,4,3,2,3,3,7,
3,5,10,9,6,9,12,3,2,3,6,6,1,3,17,9,15,4,9,5,7,9,21,9,5,12,3,15,7,2,1,2,9,3,3,12,3,4,3,6,6,11,3,1,8,
6,1,18,5,7,3,2,4,6,6,2,6,10,6,20,3,12,30,6,4,6,12,5,6,1,8,6,12,15,9,1,9,8,3,12,7,3,5,1,11,6,4,11,9,
1,5,3,10,2,4,5,4,5,22,15,3,9,2,3,13,29,9,1,3,5,1,12,9,6,5,4,3,3,12,3,3,11,24,1,9,5,1,9,11,10,5,3,6,
1,18,2,1,9,9,5,9,3,7,2,4,11,4,11,10,6,3,2,3,9,10,8,3,9,3,10,2,6,1,21,2,3,3,12,3,4,3,14,6,12,1,6,6,9,
5,4,2,7,15,15,2,3,1,11,3,3,3,4,6,9,3,14,6,3,6,3,10,11,16,5,4,9,3,9,3,2,15,9,1,3,2,13,8,7,5,12,4,6,6,
2,13,8,15,12,9,1,3,2,13,14,1,14,3,7,11,37,5,3,4,2,1,12,11,1,18,2,3,1,5,9,1,2,9,9,1,11,15,4,3,2,4,6,
3,3,14,3,1,5,6,10,6,8,22,2,1,6,3,5,3,7,3,5,3,1,3,5,21,6,3,3,7,8,15,9,9,1,3,17,4,11,1,3,2,9,6,4,6,8,
4,2,1,2,10,6,5,1,3,3,3,2,9,10,9,12,2,12,25,5,6,7,6,5,6,9,7,5,3,1,26,13,15,2,10,3,5,10,11,3,1,9,11,
12,13,9,2,13,3,2,3,18,10,20,4,3,17,1,2,9,3,1,9,5,3,4,15,5,3,7,3,3,18,2,9,4,6,3,2,6,3,9,6,4,5,1,12,
14,1,5,7,11,6,13,2,4,9,5,6,1,9,5,1,6,5,3,1,11,4,3,6,11,1,3,9,2,4,2,4,6,3,6,5,1,2,7,5,4,5,39,7,11,10,
3,5,4,3,18,11,1,2,3,4,9,11,3,3,4,3,6,5,4,3,24,6,2,1,5,12,9,15,1,3,15,26,24,1,3,17,1,15,2,18,3,1,3,8,
24,3,1,2,7,2,1,9,3,6,5,6,13,8,4,3,8,3,6,1,23,4,8,3,4,3,3,39,11,6,3,6,7,5,7,5,3,3,6,15,4,6,21,2,1,2,
3,1,3,6,12,3,2,7,5,12,1,14,1,2,1,2,12,1,21,3,18,2,7,3,2,1,2,16,2,7,2,4,27,2,12,15,9,1,5,10,3,2,4,2,
12,15,6,4,12,6,2,15,1,11,1,5,3,4,2,9,19,2,4,14,3,12,7,5,6,4,3,2,6,4,14,7,12,8,7,3,3,5,1,20,4,5,4,2,
9,1,6,3,14,1,2,7,2,3,6,16,5,1,2,7,8,1,6,11,3,6,4,2,3,6,1,2,3,7,21,6,6,9,5,15,3,33,4,3,11,1,11,10,3,
12,3,5,9,6,22,12,5,1,15,5,1,3,2,3,1,5,1,5,1,9,8,3,7,17,4,6,5,9,7,2,10,3,20,10,9,9,9,5,7,3,8,7,5,10,
5,18,10,8,4,2,4,5,4,2,10,5,4,2,4,11,3,6,3,1,11,1,2,12,3,3,4,11,13,6,21,5,7,3,3,17,4,5,10,3,8,7,2,3,
3,18,15,7,14,3,1,9,12,3,2,6,7,5,7,3,8,4,9,12,24,8,12,6,3,4,3,9,21,9,5,15,1,14,1,5,22,2,10,23,1,2,18,
16,5,1,2,3,10,5,9,1,3,24,5,7,6,9,5,1,3,9,8,3,7,5,10,18,2,3,1,6,2,7,3,2,9,22,2,6,1,6,3,15,6,3,5,10,8,
3,7,9,15,14,6,9,6,1,3,6,9,12,2,10,3,3,12,2,1,2,4,6,8,1,5,19,2,4,5,3,3,19,3,2,10,9,2,9,3,21,4,5,1,11,
3,13,2,3,7,6,5,1,6,2,1,5,4,8,7,3,3,11,1,12,2,4,2,3,4,5,3,7,2,9,1,5,1,8,7,5,9,30,6,3,9,3,3,7,15,3,6,
3,8,3,1,3,2,4,9,12,8,1,12,2,10,5,21,4,5,10,15,15,6,2,4,15,3,2,4,11,4,12,2,6,1,20,4,9,8,7,11,6,3,6,1,
18,2,3,7,5,18,3,9,3,1,12,14,15,9,1,3,8,4,9,12,32,1,5,7,8,9,6,4,2,3,18,15,9,3,1,2,4,3,6,2,7,2,1,3,21,
11,13,2,7,17,4,9,15,17,10,6,5,4,14,6,6,4,21,5,3,4,3,3,17,3,1,5,3,21,6,4,2,9,4,9,3,2,3,3,6,9,1,21,18,
2,10,9,9,5,4,20,7,6,2,1,14,3,13,11,15,9,9,10,5,7,9,2,7,12,6,5,7,6,15,2,3,9,12,1,2,1,6,9,2,7,2,6,3,
15,19,2,9,1,6,3,11,4,5,9,15,6,1,5,4,32,3,15,4,5,13,2,7,5,3,6,12,7,5,1,9,5,7,6,8,7,2,7,8,3,3,4,15,2,
9,6,3,3,4,14,10,11,1,15,2,6,4,2,13,2,6,13,17,3,12,10,2,7,5,1,9,6,9,3,2,4,9,2,1,3,17,18,4,3,3,17,4,3,
2,3,18,10,3,2,7,5,10,6,2,4,6,3,5,6,1,20,3,4,11,4,2,1,2,12,3,3,4,8,1,5,1,5,16,3,9,5,13,3,2,9,4,9,2,4,
5,4,6,2,7,2,1,3,15,6,8,3,9,15,6,4,8,6,1,3,5,3,4,3,11,7,5,3,22,3,24,8,4,6,3,6,8,16,5,4,2,16,5,3,4,3,
2,7,5,6,10,17,12,9,1,3,3,2,3,4,5,4,14,10,2,9,4,8,3,9,13,5,10,12,2,1,3,11,3,10,6,17,3,1,5,1,3,29,3,7,
8,10,5,4,11,3,15,1,14,15,9,7,24,9,12,11,3,1,5,3,7,18,18,5,7,6,6,3,2,13,11,6,3,27,3,3,3,4,8,3,4,12,
15,3,3,2,3,7,2,10,5,4,11,9,19,17,4,2,10,2,1,5,4,18,5,3,4,2,1,8,1,6,8,10,6,18,3,8,4,5,21,9,12,1,8,4,
15,5,6,4,26,1,15,3,8,4,5,1,3,12,12,11,1,9,21,8,7,18,3,8,4,5,12,3,6,4,12,3,20,1,17,3,1,5,1,3,2,9,4,9,
2,9,1,9,11,18,3,15,3,10,5,4,2,1,12,5,7,14,1,6,3,11,6,3,4,2,10,3,6,2,22,8,7,26,9,10,2,10,5,1,15,9,5,
6,12,3,4,20,1,2,13,2,6,6,1,5,9,4,2,9,4,2,12,6,7,8,9,1,9,3,8,1,3,8,7,3,2,3,4,15,8,7,3,18,3,5,1,3,8,
13,36,3,6,5,4,2,3,1,5,6,4,9,2,1,9,3,3,3,2,13,11,6,3,4,6,26,1,5,10,5,13,2,3,6,4,6,9,14,6,1,20,1,8,7,
8,7,3,5,6,13,6,12,3,2,4,3,5,1,5,1,5,4,5,4,5,3,7,8,7,3,5,7,8,3,1,3,3,9,5,1,2,28,5,3,6,13,20,10,3,3,
11,9,15,7,9,5,6,7,3,5,9,4,6,3,3,8,24,1,14,7,9,12,2,10,5,3,4,6,5,3,4,12,5,6,3,7,2,6,4,20,7,14,4,12,9,
6,8,6,12,4,5,4,2,15,4,11,12,6,4,5,6,1,8,12,3,3,3,10,9,3,2,3,4,3,11,10,21,5,4,9,11,6,1,12,2,10,5,3,7,
11,7,2,3,12,10,14,4,15,3,3,2,4,11,4,6,8,4,5,7,8,1,5,16,3,2,1,3,2,9,3,3,4,15,6,12,3,2,7,5,1,8,4,30,5,
1,14,3,3,1,15,5,4,5,1,5,3,7,14,1,23,21,4,6,26,9,12,3,22,2,3,9,4,6,11,3,1,3,5,7,6,12,5,16,2,3,4,2,3,
12,9,4,3,2,6,1,5,16,9,3,5,3,9,9,4,8,25,3,2,4,9,6,9,9,3,9,6,5,12,15,10,5,7,14,9,15,7,3,6,2,7,8,4,11,
7,12,15,5,10,3,3,2,3,3,6,6,3,6,1,2,1,6,8,15,1,5,16,6,5,3,6,1,12,2,1,18,15,9,5,15,6,1,6,3,2,10,12,11,
4,8,4,15,3,3,8,9,1,11,1,3,11,1,5,22,6,9,12,3,8,4,6,3,5,12,3,6,9,7,5,3,6,1,12,5,1,2,3,21,19,2,7,3,5,
30,9,4,5,7,12,6,11,10,3,2,6,3,6,13,8,4,5,19,6,5,1,2,7,11,3,6,10,5,9,4,3,3,2,13,9,6,11,1,2,13,5,3,1,
5,3,3,10,8,40,5,1,5,10,9,11,3,13,5,3,7,5,7,6,15,9,3,2,15,7,6,5,4,5,1,12,2,1,3,11,6,3,4,3,2,6,6,10,
23,6,6,6,7,5,12,13,8,4,9,15,11,9,4,6,11,3,1,2,28,2,7,11,1,6,3,17,10,3,5,16,3,2,9,1,3,5,1,5,7,2,6,6,
3,1,5,6,3,7,5,21,7,6,5,1,11,4,3,3,9,6,2,10,2,1,5,3,7,14,13,18,2,1,6,6,8,1,5,3,10,11,12,3,12,12,3,10,
18,5,10,6,3,18,17,7,9,5,9,6,1,5,1,2,15,6,4,3,2,3,15,7,2,13,2,3,6,1,3,5,3,3,7,9,14,4,12,3,2,36,3,1,6,
5,10,14,1,8,15,6,4,5,16,3,2,6,3,9,6,1,3,3,3,6,6,5,3,7,8,12,10,18,26,4,5,1,11,9,19,12,2,1,9,5,3,45,3,
1,3,5,25,5,25,6,2,3,4,11,1,8,6,1,3,12,6,5,9,15,9,4,5,3,7,21,5,1,5,1,5,4,9,9,2,3,1,24,3,8,1,8,1,5,6,
3,3,3,4,3,5,7,2,1,3,2,3,7,20,10,5,7,5,1,5,9,3,3,7,9,5,9,9,1,11,4,2,4,3,6,6,6,2,1,12,23,6,1,12,3,17,
6,1,23,7,8,3,10,8,4,6,2,15,7,5,7,6,5,4,5,1,2,12,1,3,20,1,5,1,5,3,6,3,16,5,1,8,1,6,9,11,4,24,2,9,9,
10,6,5,4,5,3,3,4,11,1,5,10,6,5,7,3,3,2,13,2,22,18,9,5,3,1,6,3,15,6,11,3,3,12,6,7,2,3,3,6,4,5,1,6,9,
6,2,3,7,3,17,1,27,9,5,3,7,9,2,22,3,14,15,4,5,1,3,5,1,5,4,5,6,16,11,15,19,3,2,6,7,32,3,3,3,6,15,1,3,
5,4,3,9,3,2,4,5,9,7,14,1,15,11,3,4,2,1,12,6,9,6,17,9,4,11,1,2,1,11,3,12,1,3,2,10,3,9,8,3,7,2,3,3,7,
2,7,9,2,3,1,8,12,1,42,11,1,5,1,2,7,5,3,1,5,4,2,10,18,2,1,5,4,3,8,4,3,6,2,9,1,9,5,1,5,9,1,8,7,14,1,3,
2,4,3,21,11,1,8,6,1,5,10,9,33,5,1,12,8,4,3,9,9,6,3,2,1,9,5,6,13,14,6,1,3,8,13,11,13,2,3,12,1,3,5,10,
11,3,3,10,9,5,9,1,8,3,4,6,8,12,3,4,2,1,2,1,6,3,6,9,5,1,5,10,5,1,5,1,17,13,5,24,3,1,6,6,2,10,6,5,12,
3,4,2,9,12,7,5,16,2,3,1,18,2,1,18,6,3,26,27,3,1,6,3,9,3,8,9,6,4,2,6,9,4,12,14,9,16,3,2,9,1,6,8,1,11,
9,4,2,10,2,1,11,10,6,5,9,16,3,6,5,6,3,4,2,13,2,1,9,3,5,6,9,1,5,4,3,14,3,1,11,15,15,1,3,2,13,6,3,6,9,
2,1,2,7,14,4,3,2,3,4,14,4,3,5,4,9,2,12,6,6,9,9,3,7,2,1,12,8,9,1,12,5,7,9,5,4,2,4,12,3,5,7,8,6,15,3,
1,14,13,3,15,14,6,1,5,6,4,3,11,9,1,6,5,4,9,3,2,16,11,1,8,1,11,4,5,30,6,3,7,5,10,3,5,1,6,8,1,5,1,5,4,
21,12,8,3,21,4,5,1,5,6,10,2,3,4,21,2,1,2,4,8,1,6,3,3,3,12,3,12,8,4,2,10,9,9,6,2,12,7,3,6,9,3,2,6,9,
6,7,8,1,11,12,21,1,6,2,7,26,7,2,10,9,12,5,4,8,10,11,10,14,3,3,7,2,7,6,14,10,8,1,5,16,5,4,17,3,19,2,
6,3,10,9,2,13,6,6,6,3,6,6,2,3,4,3,5,3,13,2,10,2,1,6,14,9,1,9,2,1,8,7,8,4,2,15,4,5,4,2,1,18,15,5,6,9,
19,36,6,5,4,2,7,5,1,11,9,34,3,12,5,10,5,7,18,3,3,12,2,7,3,2,1,9,5,6,7,15,5,6,1,6,3,2,13,6,5,4,5,1,8,
3,9,6,7,5,12,6,22,3,3,12,2,7,5,1,14,4,9,5,3,9,6,3,4,6,9,3,8,15,15,25,27,2,3,3,16,5,4,9,5,7,20,6,7,5,
1,2,7,15,3,8,6,1,2,1,2,12,16,11,1,3,6,5,3,1,9,5,3,33,9,6,4,3,5,7,12,5,24,6,3,7,6,5,10,2,7,21,2,10,5,
6,7,8,1,8,1,5,1,6,3,2,10,2,12,1,3,11,3,1,14,3,7,3,5,18,1,5,3,6,4,2,3,10,11,9,10,8,13,5,6,1,17,6,6,
13,3,3,5,6,6,7,2,4,6,6,8,9,12,4,17,4,3,3,12,2,1,9,9,15,11,1,2,12,13,2,9,7,17,7,11,3,16,3,2,1,17,1,
11,1,2,3,9,21,13,5,1,3,3,3,12,2,6,9,1,6,6,2,3,3,1,9,2,7,5,1,2,9,4,6,3,6,6,9,6,5,4,9,2,6,9,4,2,3,6,1,
2,25,8,10,30,8,1,11,3,6,1,3,6,5,3,1,15,11,3,18,19,3,6,9,2,4,11,3,1,2,3,10,6,5,3,12,3,10,3,2,3,3,10,
32,4,3,5,3,4,3,2,1,3,17,3,1,3,3,5,3,4,2,4,9,5,3,4,8,7,18,2,10,9,2,3,12,3,4,3,5,7,3,3,2,7,11,7,5,7,5,
21,1,8,27,3,1,6,3,2,9,16,9,6,6,3,5,19,3,5,7,6,20,10,2,4,3,5,1,6,9,14,10,3,15,2,10,8,13,5,10,11,1,2,
1,9,5,6,12,9,10,9,2,7,8,7,3,2,13,2,3,7,15,11,4,3,5,18,24,12,1,2,3,3,1,15,9,11,18,1,5,4,3,2,6,6,15,
13,33,3,15,9,5,3,4,6,2,21,1,11,3,4,2,6,3,6,1,5,9,16,3,6,20,6,4,3,5,6,1,9,14,1,17,10,14,3,1,5,1,11,4,
5,6,3,7,3,29,1,9,3,8,1,33,3,2,16,2,9,21,3,1,3,21,5,6,4,11,3,7,5,1,3,5,10,11,10,11,3,16,6,2,1,12,5,9,
1,5,7,15,2,6,3,10,15,11,3,1,2,4,5,3,6,19,6,9,2,3,7,3,8,3,4,3,2,25,8,4,18,5,7,3,6,2,3,1,11,3,1,6,8,7,
3,2,12,12,4,9,5,10,2,9,4,5,13,18,11,3,7,3,2,4,29,1,2,18,1,6,17,3,7,3,8,1,3,3,8,9,1,2,4,14,9,7,6,3,
11,1,5,3,1,18,2,9,6,10,23,13,2,6,6,1,2,1,14,3,13,5,4,17,6,27,7,6,5,7,3,23,4,3,2,1,15,2,13,6,5,3,15,
3,3,6,6,25,9,5,4,6,14,4,3,2,1,21,5,3,18,3,9,10,8,7,3,17,18,3,1,3,3,18,12,9,8,1,2,10,3,11,1,3,17,3,1,
6,2,6,1,11,7,20,1,50,1,6,2,6,6,1,3,2,9,4,6,3,6,2,4,6,17,15,3,4,5,6,3,4,2,4,2,9,1,12,5,10,3,9,20,3,6,
1,3,2,13,3,12,8,18,4,6,2,3,4,2,4,5,1,6,3,11,1,8,10,11,10,8,15,7,15,21,2,7,3,17,4,17,10,2,12,1,8,6,
16,8,4,2,6,3,6,1,5,4,3,11,10,6,6,18,2,3,1,3,2,6,9,1,8,12,15,4,18,2,10,5,4,11,3,18,3,4,5,1,2,4,5,18,
1,2,9,9,12,15,4,3,8,13,14,1,5,7,8,1,3,5,13,8,1,6,8,4,6,5,10,6,5,3,3,43,6,3,5,3,3,6,16,12,5,7,9,6,5,
16,9,11,10,3,2,7,3,5,7,2,3,25,2,1,8,1,9,2,22,2,6,3,6,1,12,6,5,1,6,5,3,1,21,3,5,1,5,3,3,22,5,16,2,7,
3,3,2,4,3,2,9,7,2,3,3,4,5,10,3,8,10,11,3,7,8,10,5,1,41,4,5,7,12,2,18,7,5,1,14,3,15,7,5,21,4,24,5,7,
3,5,12,4,3,2,1,23,4,8,9,10,3,8,4,3,2,3,1,11,1,14,3,6,1,3,3,5,10,3,20,9,6,6,1,9,5,1,8,1,5,1,9,6,5,3,
4,5,1,2,12,1,12,2,3,3,4,5,6,1,5,10,15,3,6,9,3,2,15,22,14,9,6,4,2,10,5,6,3,19,6,5,4,18,8,6,3,6,4,2,3,
3,25,12,6,6,6,5,7,2,3,18,3,1,14,1,9,12,2,16,5,1,3,12,8,7,5,3,1,2,7,23,3,4,2,6,7,5,3,12,6,7,3,14,1,9,
3,8,7,3,14,1,11,18,10,3,8,1,6,2,7,6,5,4,20,1,3,6,3,2,45,6,15,9,4,9,3,9,3,2,3,6,1,6,2,3,10,2,6,1,21,
2,3,13,5,4,6,6,15,9,26,3,1,2,3,4,3,2,3,3,7,3,5,4,2,1,2,3,13,2,24,1,3,5,1,5,4,2,4,29,4,8,12,3,3,1,3,
32,3,7,3,12,3,3,5,7,15,21,2,7,2,3,7,14,7,8,6,9,4,15,6,2,7,3,3,5,6,3,12,9,4,8,3,12,7,5,3,4,5,3,22,5,
3,6,15,1,20,18,16,12,15,2,1,12,17,3,3,10,2,9,3,16,12,8,7,8,1,6,8,6,3,7,5,9,6,1,2,1,24,11,1,3,23,12,
6,6,9,4,15,6,2,7,6,6,26,9,1,5,3,1,11,3,4,2,1,2,7,3,5,10,15,3,3,15,17,7,6,29,7,3,3,8,16,6,3,5,1,3,11,
22,9,5,9,1,3,18,2,1,6,6,3,2,4,6,2,3,7,6,11,3,3,4,9,2,3,9,3,3,10,5,6,3,3,3,12,4,6,3,9,5,12,3,1,2,13,
6,9,11,3,3,10,15,15,12,8,3,4,6,6,3,3,3,14,6,6,3,7,18,3,5,4,3,5,3,12,1,6,23,1,12,2,18,9,6,9,9,7,2,6,
9,1,11,1,2,10,17,18,7,9,2,4,6,3,12,14,1,5,7,12,9,2,12,12,19,2,10,2,6,9,3,3,7,9,3,3,8,21,3,10,5,6,6,
1,3,6,9,2,7,2,10,5,9,4,3,12,5,7,9,5,1,3,3,2,16,2,3,1,3,11,7,8,6,1,2,3,4,9,12,5,13,14,1,6,11,7,3,8,4,
2,6,9,9,9,3,7,2,1,9,6,9,15,5,18,1,2,15,4,14,4,17,3,7,21,5,3,16,5,3,3,3,1,24,21,5,1,9,3,2,1,5,10,2,3,
28,2,3,9,6,7,17,3,4,6,12,3,9,3,6,6,3,3,5,3,6,1,9,6,14,6,3,4,15,2,4,9,2,9,7,2,3,4,5,1,14,1,14,3,6,1,
11,7,3,2,3,7,5,3,3,7,2,12,24,4,15,2,21,9,3,18,3,6,10,8,13,14,13,8,13,2,13,6,3,18,5,4,11,3,15,4,8,4,
5,3,15,3,10,2,7,11,3,6,3,10,3,3,11,4,6,5,3,3,10,2,3,9,3,12,4,2,9,3,3,4,6,3,2,13,11,10,8,6,9,6,10,2,
12,3,10,5,3,4,6,6,3,6,17,4,9,6,18,2,1,5,4,5,4,2,10,9,5,4,27,2,7,20,1,9,3,21,11,10,9,2,3,1,8,6,6,3,1,
6,11,3,7,3,2,12,1,6,11,12,10,12,9,9,5,10,3,29,18,1,2,3,6,1,3,12,2,3,9,10,5,1,8,30,1,3,3,3,12,3,5,9,
1,2,7,2,3,7,5,4,2,10,12,8,3,15,4,5,12,1,8,4,11,6,6,10,5,13,14,1,11,3,12,21,3,1,14,10,9,15,8,12,1,5,
19,2,6,18,7,2,12,3,10,20,13,2,1,9,3,5,7,8,3,10,2,15,3,4,3,3,2,7,3,15,8,6,1,5,10,8,10,6,9,9,8,3,1,3,
3,15,3,2,3,6,6,3,6,4,5,6,21,22,3,18,2,10,2,3,9,1,5,10,2,10,5,1,2,4,6,8,1,3,6,24,3,18,9,3,3,9,2,4,9,
18,15,8,9,12,15,3,21,10,6,8,1,11,1,2,1,11,3,3,15,3,16,14,1,3,6,5,15,6,6,22,2,4,2,9,4,6,14,1,3,8,7,2,
3,7,14,7,2,7,3,2,9,4,2,15,3,16,6,5,3,27,10,3,6,11,13,2,6,7,6,2,3,1,3,2,1,2,1,21,3,17,15,3,3,12,1,6,
9,2,7,5,18,3,4,12,11,7,2,6,4,9,6,3,8,3,4,3,8,6,3,13,12,2,4,14,1,11,4,12,5,4,9,6,5,1,9,3,2,10,9,5,7,
2,10,6,5,9,1,2,7,2,28,5,6,22,2,1,2,4,3,2,6,13,14,1,5,6,1,9,5,3,3,22,2,1,3,9,6,2,3,10,12,8,1,8,1,5,4,
3,8,6,1,8,4,15,12,3,17,1,9,14,9,3,4,3,11,6,6,4,3,5,6,19,2,4,6,11,3,6,21,13,6,8,1,2,3,1,24,12,5,3,1,
8,10,2,1,5,7,2,1,3,30,6,3,6,6,8,3,12,3,13,11,1,2,1,2,7,2,10,14,7,15,5,9,1,5,7,11,6,3,25,3,5,3,1,5,4,
5,6,6,4,3,2,3,28,12,15,3,12,3,2,6,9,3,12,18,7,6,17,4,21,9,5,3,1,2,18,4,3,3,9,15,2,6,4,9,9,3,8,6,4,6,
6,5,4,14,4,3,14,3,6,1,3,12,5,1,8,6,30,4,12,5,13,5,4,3,2,1,9,12,20,1,5,4,6,15,5,7,6,9,8,10,20,3,1,3,
5,12,1,3,5,7,12,5,1,5,1,8,6,21,16,2,6,1,11,9,4,2,4,15,11,3,4,3,3,17,4,3,11,1,9,11,4,2,4,3,5,1,9,3,2,
13,48,9,5,12,3,6,1,3,3,5,4,5,3,6,6,1,5,3,7,2,3,9,19,11,3,3,10,5,13,5,1,6,3,5,7,9,3,8,13,6,23,3,3,10,
5,1,9,2,3,12,9,13,2,10,3,2,3,1,5,1,8,6,1,15,6,3,6,3,3,5,3,10,2,3,10,6,5,4,12,2,12,4,11,9,27,3,9,15,
3,4,15,21,2,1,26,1,3,21,3,2,4,2,4,9,5,7,2,15,6,16,5,1,8,7,3,2,9,18,1,2,10,3,12,2,7,3,2,9,1,3,11,4,2,
3,15,1,9,6,2,9,1,14,3,15,10,3,3,5,9,1,6,3,2,3,10,6,5,1,5,4,5,1,6,5,3,4,5,6,6,6,13,9,5,1,5,4,3,9,3,
12,5,1,2,3,4,20,6,3,4,2,1,5,12,10,3,8,1,9,17,12,6,15,4,3,3,11,4,21,9,14,1,2,3,1,11,7,8,7,2,3,3,7,15,
17,3,16,2,4,6,5,13,9,17,10,14,4,6,5,7,20,7,8,43,6,3,6,6,8,1,11,16,8,12,4,15,9,2,9,9,7,3,9,2,6,9,1,
15,5,4,8,1,5,4,5,1,5,4,2,19,12,12,2,1,8,4,5,1,2,12,1,6,6,2,6,1,5,3,7,8,1,11,6,4,5,1,14,13,6,5,1,3,6,
2,9,9,1,9,14,6,4,6,5,21,6,3,1,11,4,5,15,1,2,13,5,3,1,5,16,3,6,8,13,2,10,12,6,5,4,3,33,2,7,5,3,15,3,
3,4,6,5,6,1,20,3,4,2,4,9,2,6,9,16,3,9,12,5,1,2,7,8,3,3,1,20,3,3,4,3,6,2,3,4,3,8,15,24,10,2,1,5,3,6,
13,20,7,3,6,5,9,1,2,9,10,3,15,2,4,6,3,2,3,6,1,6,9,3,5,1,5,9,6,4,2,3,6,22,2,10,11,7,5,3,1,9,11,1,2,
12,1,2,3,4,9,2,19,11,7,8,4,5,24,7,8,1,9,12,18,5,9,7,6,9,5,3,18,3,27,4,21,3,5,1,6,15,3,2,7,3,2,10,3,
8,9,3,18,12,3,1,3,6,20,4,5,3,4,6,5,3,16,3,2,6,7,11,4,6,6,15,5,6,4,5,6,15,4,8,3,10,2,1,2,4,5,10,9,9,
3,14,9,4,2,4,2,9,6,7,3,2,10,11,1,15,3,3,5,4,3,6,14,1,2,4,5,6,12,1,5,6,9,7,5,15,4,6,5,7,5,1,14,7,8,
13,15,2,6,16,14,7,3,6,9,2,4,11,4,5,1,14,3,7,3,11,6,9,10,9,2,3,7,11,7,2,3,6,10,5,1,8,6,7,14,1,3,14,1,
2,18,1,3,11,1,8,3,10,5,13,12,3,11,3,15,6,1,15,6,2,3,3,1,8,12,4,9,3,2,3,4,9,14,1,2,4,3,18,2,1,9,2,9,
7,3,5,6,19,6,3,8,10,3,12,15,8,1,3,8,9,1,3,2,7,2,9,15,1,5,9,7,3,9,3,9,3,2,9,6,10,11,4,6,8,4,5,1,29,3,
10,3,9,5,15,3,10,2,1,14,1,5,15,7,8,4,3,3,5,9,12,4,12,3,9,3,9,8,1,5,12,7,6,9,2,3,7,5,4,2,12,7,6,3,5,
1,6,9,6,9,11,3,6,13,12,6,2,3,9,1,2,12,9,6,3,10,8,7,15,6,2,4,6,8,6,1,18,6,6,14,4,2,15,7,11,1,6,5,7,3,
9,9,6,3,2,3,6,1,11,7,5,3,7,2,10,3,5,12,21,22,6,2,7,2,24,1,9,5,6,9,7,17,6,22,23,10,2,7,18,2,7,11,9,9,
4,8,4,9,2,3,4,11,1,3,20,18,4,9,14,3,7,15,8,9,9,6,13,3,5,7,3,12,3,5,4,8,7,3,6,5,4,11,6,1,3,5,1,6,2,6,
7,12,2,3,3,4,3,6,6,18,3,14,1,8,6,1,2,3,9,4,5,4,2,6,9,3,1,27,8,6,1,2,10,11,1,5,1,12,5,1,6,8,22,3,5,1,
6,14,1,26,10,30,12,2,1,3,20,9,13,3,12,3,2,4,9,2,4,6,3,9,26,19,2,6,15,12,1,6,6,3,5,22,2,6,1,3,5,12,1,
3,14,15,1,5,1,6,8,1,23,1,11,1,8,4,2,9,9,1,6,3,6,14,3,4,3,38,7,18,23,10,5,1,5,4,14,13,12,2,4,2,3,4,2,
3,12,21,10,2,6,10,9,2,3,12,1,14,3,3,4,11,7,5,3,3,9,15,1,9,5,25,3,2,10,8,7,11,9,1,6,5,6,4,6,2,7,5,1,
3,5,12,4,3,11,4,3,5,4,8,6,7,3,5,1,14,19,5,10,12,8,3,28,9,3,2,6,6,21,9,4,2,10,3,2,9,1,2,1,14,1,9,3,2,
3,3,1,11,7,6,2,12,1,5,7,2,15,7,6,3,2,3,1,11,18,6,1,12,2,3,1,9,6,2,9,1,3,6,5,3,7,5,9,1,6,3,2,10,9,8,
7,21,15,3,2,7,11,6,1,14,1,2,1,2,9,13,5,1,9,3,2,7,5,3,6,16,5,1,3,2,13,2,12,3,12,7,3,2,9,1,5,4,11,1,
29,1,5,18,1,8,13,3,20,6,6,7,2,4,12,2,3,4,8,21,1,5,9,1,5,4,9,2,3,10,3,5,9,1,9,11,10,8,9,12,16,12,8,7,
8,9,9,1,3,8,18,6,3,6,7,5,7,15,12,3,2,6,4,6,5,4,5,3,6,9,1,2,4,6,20,3,31,6,12,3,2,12,4,5,1,15,5,19,20,
16,6,17,3,7,3,5,7,2,1,3,2,12,1,14,1,5,24,7,5,1,8,1,18,3,3,5,4,3,9,8,3,3,4,3,5,4,3,2,10,9,20,4,2,4,5,
25,9,5,12,1,3,12,5,7,11,12,13,6,8,3,10,2,6,6,4,6,5,4,2,7,2,9,10,9,3,3,14,3,3,4,12,5,1,2,7,6,3,2,10,
18,5,7,2,15,1,6,3,8,4,15,14,4,3,5,3,7,5,12,1,6,9,14,6,4,6,5,1,6,2,6,16,5,1,5,9,10,5,6,18,4,18,15,5,
3,7,14,1,12,5,3,3,10,2,4,3,3,3,5,1,5,3,1,2,4,11,27,1,9,2,9,10,2,9,18,1,11,6,4,6,3,11,3,7,3,2,6,7,5,
1,11,3,6,9,3,9,1,23,6,4,2,12,1,5,12,9,1,14,3,3,3,6,3,21,6,1,2,28,2,13,3,6,5,1,5,3,6,1,8,7,29,3,3,4,
3,6,2,3,7,2,1,11,21,3,1,6,3,2,15,4,5,6,10,2,1,15,5,1,5,10,6,5,3,4,6,14,7,3,11,10,11,1,2,6,6,1,9,3,5,
6,7,8,10,2,19,3,5,3,9,3,6,12,7,2,3,10,6,11,1,2,1,15,9,3,2,1,26,3,7,15,11,3,6,13,2,9,7,18,17,10,8,24,
1,6,3,11,7,5,10,2,15,1,5,1,8,7,3,2,6,10,18,9,6,2,3,4,6,20,1,3,2,1,5,13,12,23,4,5,6,1,21,3,5,1,5,10,
5,13,6,11,10,3,5,3,3,9,7,11,3,19,2,1,8,4,3,9,11,3,22,14,6,7,2,1,12,3,5,10,5,4,3,6,17,18,6,6,7,3,8,1,
3,2,21,12,3,10,2,6,1,3,2,3,1,12,3,14,10,2,4,2,7,17,3,6,1,6,3,2,9,10,6,3,14,10,6,14,1,17,4,3,6,11,3,
12,3,1,2,9,6,3,12,7,2,1,12,32,3,6,16,6,15,3,2,3,6,6,4,9,14,6,4,5,12,9,1,14,4,2,6,9,13,2,6,4,8,1,9,3,
8,1,5,10,6,5,3,1,23,3,7,2,6,15,3,1,3,2,18,18,3,6,1,12,17,9,12,3,9,13,23,1,6,5,7,2,13,12,9,11,15,4,9,
2,3,6,12,9,10,11,4,3,3,2,10,3,14,1,3,9,15,3,5,3,6,3,3,13,6,3,12,14,6,6,3,4,3,9,3,11,12,7,5,3,3,4,6,
11,1,18,9,2,6,28,17,4,3,3,2,16,11,1,5,4,5,1,8,15,6,1,3,2,13,2,4,6,2,6,1,3,2,3,7,8,3,3,1,5,6,13,14,
10,6,17,7,2,1,3,5,21,1,2,12,6,12,3,12,1,5,9,7,3,17,3,1,2,10,5,3,1,11,9,3,1,9,2,3,1,17,4,8,1,5,12,4,
6,2,37,3,2,4,9,8,3,4,6,20,4,12,9,2,27,1,2,3,1,3,3,3,9,20,1,5,12,4,6,14,1,5,9,3,7,6,15,14,3,1,11,10,
6,5,22,5,6,1,11,9,4,5,10,2,10,15,5,12,1,2,4,9,9,6,2,4,5,3,1,5,1,5,6,4,3,5,13,3,5,30,4,5,1,5,9,18,4,
5,1,9,3,20,1,6,5,18,6,1,8,7,6,3,12,5,7,2,1,8,12,4,18,5,3,4,8,13,3,2,18,1,6,8,4,6,2,7,2,6,4,3,6,5,7,
3,17,4,8,33,4,3,8,3,1,11,3,1,15,8,7,5,6,3,1,6,3,5,9,15,6,1,8,15,1,6,14,1,3,8,3,4,2,13,5,1,2,4,9,6,3,
18,8,16,3,17,13,5,7,5,4,5,10,2,7,5,6,1,6,2,3,9,10,9,5,7,14,4,6,9,30,5,4,17,4,9,8,7,5,1,2,12,10,11,7,
23,21,1,2,1,6,5,3,1,6,8,7,3,3,17,3,4,8,13,5,10,12,2,3,1,5,9,6,1,8,22,5,3,25,2,6,7,8,19,3,21,5,4,2,9,
4,17,15,6,4,6,17,6,22,2,7,6,12,2,3,10,12,14,4,3,3,6,6,5,9,1,2,7,3,3,17,3,4,8,3,3,12,3,1,8,15,1,6,3,
12,5,1,15,9,5,6,3,22,8,6,13,5,12,6,3,10,14,1,5,1,9,6,3,6,21,3,2,1,8,6,1,14,3,1,2,4,3,5,3,4,8,6,7,2,
6,1,8,1,14,18,3,7,2,15,1,5,4,3,2,1,11,4,14,1,2,3,4,8,3,19,8,4,3,11,4,11,4,11,6,1,2,3,10,9,6,3,5,10,
15,9,6,2,4,3,2,10,15,15,3,15,2,15,6,3,9,7,5,16,5,4,8,3,3,10,9,3,3,9,8,7,3,2,21,12,7,5,3,7,2,1,17,12,
4,6,8,12,9,7,9,11,7,6,2,10,3,2,4,5,4,17,3,4,2,3,1,6,8,1,6,11,15,3,4,5,10,2,10,18,11,1,5,4,2,9,1,12,
3,3,5,6,4,15,5,10,6,14,9,12,6,3,22,2,7,5,10,9,2,10,17,10,12,9,9,3,5,4,8,3,7,6,2,3,25,5,6,13,11,4,3,
12,6,5,9,1,6,5,3,7,5,1,5,3,1,5,3,3,3,4,6,9,2,3,7,14,7,14,10,6,2,1,5,4,2,9,1,26,4,5,3,7,3,6,11,4,11,
1,12,3,12,11,10,2,4,5,9,7,8,6,1,9,29,1,11,12,3,12,13,12,3,2,1,15,5,1,14,4,20,3,9,3,1,6,9,11,10,5,1,
2,3,12,3,4,9,2,3,7,5,4,3,2,13,3,14,1,17,3,3,1,18,11,12,9,4,6,11,7,3,8,1,8,1,2,4,5,6,3,6,4,14,7,3,5,
1,5,1,6,5,9,10,9,5,6,1,5,7,3,12,15,8,3,19,11,16,3,2,1,5,10,12,12,5,31,9,6,2,1,12,2,7,3,3,8,6,18,13,
2,1,2,13,6,9,6,5,3,3,3,4,2,6,7,15,8,7,11,4,2,18,1,2,24,6,10,17,15,6,9,12,3,10,3,5,10,12,2,4,15,2,3,
4,5,12,1,8,7,2,10,3,14,16,3,6,5,6,3,1,15,3,5,1,5,10,5,7,14,16,5,9,3,1,2,12,1,9,5,13,2,3,4,3,2,6,4,3,
11,9,1,11,10,6,2,1,9,12,14,1,18,6,9,15,2,3,6,4,12,8,12,6,15,3,7,15,2,1,11,3,6,10,2,7,3,9,5,4,5,6,1,
5,4,5,1,5,3,10,2,4,8,6,4,17,4,20,6,1,2,6,10,9,2,1,5,13,2,10,3,2,4,23,3,4,20,1,3,2,9,13,5,13,5,3,9,
13,3,2,15,7,3,8,4,12,3,12,15,3,11,21,3,6,27,13,2,3,1,8,1,2,3,10,6,6,2,13,5,9,9,6,33,7,6,8,9,10,3,2,
7,14,6,3,37,3,21,6,5,3,3,9,4,15,2,4,9,6,8,12,9,1,6,9,5,1,5,7,11,16,5,10,3,6,9,12,14,1,6,9,9,2,3,4,2,
4,9,15,8,4,6,3,12,2,3,7,11,1,9,24,6,17,9,10,5,10,14,6,1,5,3,4,3,2,1,2,7,8,13,5,6,1,8,6,9,9,3,4,5,1,
5,12,3,7,2,21,3,24,6,1,3,11,6,1,12,5,1,2,25,2,6,7,2,7,11,4,14,1,3,3,5,7,2,1,17,1,2,10,3,15,12,3,14,
16,2,10,2,1,6,3,2,3,7,9,5,1,6,2,6,9,10,12,11,15,7,11,4,11,4,11,1,5,15,3,12,4,11,10,15,8,1,5,6,3,13,
5,10,2,6,4,6,5,4,3,17,1,15,9,2,19,6,5,13,17,1,9,9,2,4,11,7,2,3,16,6,6,12,6,11,3,3,9,3,7,21,3,5,6,3,
1,6,14,7,3,5,4,5,16,2,15,4,3,2,3,6,9,7,3,11,12,15,15,10,5,4,3,2,3,15,6,4,18,3,12,3,17,4,6,8,9,7,6,
14,3,6,21,6,7,5,6,4,11,1,6,2,7,11,3,1,3,11,7,17,7,3,8,3,19,3,14,4,12,2,7,5,4,21,3,2,10,11,12,7,15,6,
8,7,3,15,9,6,20,4,11,9,1,2,7,3,2,3,7,2,13,5,12,6,4,3,5,1,21,11,3,4,3,27,2,4,15,21,9,12,3,5,6,1,2,3,
4,14,7,2,12,9,4,3,2,3,9,1,2,6,1,6,2,12,3,3,13,5,4,2,4,2,4,5,6,12,7,3,3,3,11,1,2,6,6,1,27,5,1,6,21,3,
6,6,2,12,6,7,3,2,7,3,2,9,4,5,1,2,7,11,10,11,3,1,15,5,4,17,16,18,2,4,8,7,3,5,22,15,3,6,9,2,4,9,2,4,9,
3,2,3,4,6,3,20,1,3,8,10,8,7,5,27,6,4,3,14,4,2,18,4,2,1,5,3,7,23,9,6,1,6,23,4,5,3,4,9,2,13,2,13,2,10,
2,6,1,6,3,11,3,3,4,6,9,3,2,15,6,4,3,5,10,3,8,1,8,16,6,6,2,12,4,12,3,6,5,3,3,7,11,1,3,5,6,7,8,4,3,8,
4,11,6,10,5,6,3,1,6,3,12,23,1,5,16,5,13,6,11,3,1,11,3,7,8,6,1,2,3,3,4,11,4,6,9,2,10,5,16,2,1,11,1,2,
1,14,3,7,5,6,1,5,6,7,3,18,6,3,8,3,24,7,3,3,2,12,1,5,7,3,2,3,12,1,17,7,2,1,9,6,3,11,10,9,2,7,15,5,1,
14,1,2,19,6,2,7,5,10,6,8,4,8,13,2,7,8,4,6,8,19,15,2,16,3,2,7,2,18,1,11,4,5,6,9,1,6,5,4,3,3,3,2,3,12,
4,5,3,3,7,3,2,13,8,1,20,6,4,5,4,5,6,13,5,3,3,1,14,1,3,2,1,8,1,6,8,1,8,13,3,17,13,2,4,3,3,2,7,5,9,1,
8,3,3,7,9,11,15,7,11,1,3,3,14,3,1,5,1,8,1,5,1,5,1,14,4,2,9,4,14,7,3,3,9,20,4,5,1,3,15,11,6,1,9,3,21,
2,4,3,17,3,3,9,3,3,7,2,6,3,10,2,13,2,7,6,5,1,3,2,3,27,1,2,13,14,10,9,12,2,1,2,3,6,3,6,1,15,3,11,1,3,
3,3,5,24,1,14,27,4,26,13,2,1,2,7,24,2,19,8,3,10,8,1,3,2,6,9,15,9,1,18,2,10,5,3,6,4,5,16,2,15,13,15,
9,12,11,4,6,5,3,12,7,5,1,6,5,9,9,6,1,3,2,1,3,11,9,4,2,1,8,10,11,1,5,4,5,3,7,8,1,2,4,21,3,9,8,3,22,2,
10,11,22,2,12,6,12,3,4,5,1,3,9,6,2,7,6,12,2,3,18,6,3,1,6,5,6,3,7,3,2,7,15,2,3,1,5,19,12,8,1,2,4,11,
3,7,32,3,7,3,9,3,5,6,6,9,9,25,3,3,9,12,3,3,3,2,18,1,6,2,1,6,3,2,3,7,5,1,5,3,10,11,25,8,1,39,18,5,12,
1,5,7,3,5,6,1,3,5,1,20,9,6,6,3,6,1,3,6,11,7,5,1,12,2,18,18,6,13,3,17,15,6,10,15,6,3,2,3,18,12,10,2,
6,4,3,5,13,2,13,29,1,3,5,24,1,24,11,7,8,7,9,14,6,21,10,8,9,7,6,5,19,9,11,3,7,3,35,7,15,14,1,11,3,9,
1,9,6,5,7,14,3,6,6,3,1,2,3,1,29,7,3,6,3,5,7,11,3,1,6,14,4,5,1,5,3,6,1,9,9,5,22,6,5,4,3,20,3,3,1,5,6,
3,4,8,7,2,3,3,7,2,3,22,5,10,5,13,5,6,6,4,2,7,2,21,13,2,7,12,5,3,1,2,9,1,12,2,1,3,12,9,5,21,7,6,6,23,
7,14,4,20,3,3,4,5,15,1,6,5,1,5,4,5,9,12,7,3,12,2,3,10,3,3,15,20,6,9,6,15,3,1,14,1,6,6,9,20,1,8,4,2,
6,13,2,3,6,3,1,6,14,4,3,2,1,12,2,1,20,1,6,9,14,9,1,11,3,10,12,3,12,5,3,3,3,1,3,12,3,2,13,12,5,6,15,
4,6,8,1,14,12,15,19,5,3,22,3,2,9,6,4,14,3,9,1,3,11,6,13,2,18,1,5,1,15,3,2,4,6,2,3,9,6,3,7,3,15,5,4,
5,1,2,4,15,5,13,5,3,10,5,9,13,18,8,1,5,16,5,3,15,4,8,9,1,9,3,6,2,4,9,5,9,1,12,8,4,8,3,4,2,1,5,3,7,3,
9,2,3,3,3,10,9,3,15,2,12,10,11,9,4,11,13,6,5,7,3,11,4,2,3,4,2,6,10,3,5,7,17,1,2,10,9,9,5,6,3,3,4,5,
9,4,17,1,3,2,13,6,8,16,5,12,9,1,2,13,14,3,3,12,1,2,25,2,7,6,2,6,4,3,15,3,5,9,10,6,5,7,15,2,1,5,6,9,
12,3,1,5,1,15,2,7,14,1,9,9,3,8,7,3,17,3,1,9,2,7,17,6,3,9,6,1,15,6,8,4,2,1,2,10,32,4,6,14,6,10,11,4,
5,24,6,1,5,13,14,1,5,6,9,6,3,3,18,6,6,9,1,5,7,5,1,5,1,9,5,16,5,9,7,27,8,7,5,1,9,15,2,1,3,5,7,15,2,3,
3,1,5,16,5,12,7,3,8,3,4,2,4,11,1,12,3,2,10,6,5,10,11,24,16,5,1,12,5,7,3,11,6,1,5,4,11,3,1,8,10,3,8,
7,3,11,15,13,2,3,3,4,14,1,3,3,8,1,21,3,6,15,6,5,3,4,6,11,3,1,2,10,5,4,8,1,14,3,19,11,10,3,14,1,24,3,
2,12,3,1,9,3,20,9,4,6,5,9,4,3,2,10,5,13,15,2,3,3,1,5,9,4,17,9,1,15,8,1,6,5,1,3,6,14,15,16,3,5,1,2,7,
5,1,2,3,1,3,6,12,23,21,3,3,7,5,7,11,3,1,6,3,6,5,1,9,3,5,12,16,14,3,3,12,1,5,6,1,2,7,9,6,20,6,3,4,2,
3,1,2,12,6,1,9,9,6,5,1,20,13,3,20,4,18,5,12,21,10,12,3,3,9,2,1,27,8,3,4,2,3,12,3,1,2,9,1,12,3,3,5,
30,1,11,4,3,11,1,8,6,4,2,13,2,4,2,7,2,15,4,2,13,2,4,5,3,6,1,5,4,2,7,12,6,17,3,4,5,4,12,15,8,10,12,8,
1,5,4,17,7,6,5,4,3,3,2,4,3,3,2,16,2,4,3,2,1,8,7,5,7,2,4,15,6,11,9,3,22,14,6,1,8,12,7,11,1,11,7,2,1,
8,1,5,3,13,15,3,2,10,2,1,11,3,22,8,12,1,8,1,11,7,6,2,3,4,2,6,4,3,6,2,3,7,8,1,8,1,6,15,3,2,13,11,16,
3,15,11,4,3,3,6,6,5,3,1,3,5,3,3,4,2,13,3,3,2,9,4,2,12,10,2,15,1,3,6,8,16,5,10,2,7,2,4,5,7,12,11,9,6,
1,6,2,3,18,9,1,9,5,6,1,8,6,7,3,5,9,12,6,4,21,3,17,4,6,3,21,5,6,4,8,3,3,6,9,4,5,10,5,3,22,5,1,5,6,1,
8,1,11,4,5,4,2,10,12,6,6,11,10,8,9,12,1,2,10,6,5,6,6,7,12,3,11,7,2,13,2,10,2,3,7,3,15,3,5,12,1,5,1,
9,6,3,17,3,10,5,10,3,8,12,4,8,6,10,2,9,18,3,4,3,3,9,3,3,18,14,3,3,4,20,6,6,3,10,2,19,2,13,14,7,6,2,
3,19,6,12,3,14,4,26,3,10,6,2,4,8,6,9,21,1,6,3,2,9,3,3,13,9,8,10,3,5,6,6,9,6,4,3,3,5,3,46,3,3,14,21,
4,6,8,9,1,6,14,1,6,2,1,2,7,23,4,11,7,2,1,8,9,3,9,3,7,24,5,7,2,1,12,2,3,3,1,21,17,6,1,18,5,6,1,8,3,3,
1,5,9,10,2,33,1,8,3,3,7,2,1,15,5,6,6,10,5,7,3,23,12,3,1,6,3,11,3,1,2,3,4,3,2,13,8,6,6,4,5,13,5,1,15,
6,5,10,6,5,4,6,5,24,4,2,3,9,1,6,14,12,7,2,3,10,11,4,2,6,4,3,11,7,2,1,5,1,3,12,11,12,10,2,1,3,14,7,8,
1,2,15,9,4,6,5,3,22,6,5,7,3,14,16,14,1,2,1,5,6,6,3,19,8,3,4,2,3,1,6,9,20,4,3,2,1,6,11,7,21,5,10,14,
15,1,6,5,4,5,19,2,9,1,6,5,12,1,9,8,7,11,9,6,9,6,7,5,3,19,5,7,3,6,2,13,11,10,21,2,6,1,6,5,27,10,5,13,
2,1,12,5,3,6,6,3,7,12,2,13,11,7,3,2,3,16,6,12,15,2,33,6,9,6,4,3,14,1,2,10,12,9,9,17,9,9,1,5,4,2,3,
12,1,3,11,13,6,5,7,2,3,9,3,3,4,6,5,3,9,7,9,2,9,9,6,15,10,8,1,6,9,2,12,6,7,2,1,5,1,3,2,13,23,7,8,4,6,
2,28,2,1,6,5,3,12,1,5,7,8,4,8,6,4,3,2,6,4,3,2,6,19,2,6,7,2,1,33,6,9,2,9,1,8,10,12,8,4,15,3,2,7,3,2,
6,3,7,8,1,9,14,6,1,3,3,39,3,8,13,5,4,2,10,9,2,3,12,4,6,3,5,10,20,4,3,2,7,6,15,8,9,13,14,1,5,19,3,3,
15,3,11,3,13,2,16,11,10,3,5,6,1,3,11,4,2,1,15,5,15,4,6,3,2,7,3,3,11,4,12,3,5,1,3,5,1,5,16,3,2,3,12,
4,14,18,3,7,5,3,9,7,5,9,12,22,3,3,2,13,6,11,3,6,3,1,5,9,3,7,3,2,7,3,6,9,3,2,3,13,15,2,10,14,1,5,10,
5,4,11,3,6,10,3,8,4,11,3,1,3,5,1,5,10,2,4,5,9,1,11,9,1,18,2,4,11,7,3,17,1,9,8,3,4,2,6,15,7,2,21,18,
7,3,9,2,6,3,7,5,10,2,7,14,9,3,9,3,22,3,2,1,5,9,9,6,1,12,5,1,5,4,5,1,21,5,3,7,11,3,4,6,2,9,19,2,34,
14,4,11,12,22,8,3,4,12,5,9,1,8,3,10,2,3,10,3,11,1,14,4,5,16,9,6,5,3,3,12,7,9,9,3,3,6,5,3,6,9,10,5,6,
10,14,6,4,3,3,9,6,2,9,3,1,15,2,3,9,7,8,21,10,9,2,3,1,9,2,6,7,18,2,1,11,1,8,9,27,3,10,2,10,8,10,11,1,
5,1,5,39,3,7,11,3,21,4,15,2,7,2,10,5,13,17,3,6,1,11,7,3,2,1,11,1,2,6,1,6,8,6,13,2,13,6,6,6,3,2,9,3,
15,3,4,5,1,8,4,8,3,10,11,13,3,2,3,9,1,2,1,6,6,3,5,4,5,6,27,12,6,7,5,4,3,3,8,7,8,7,9,3,2,4,5,9,3,22,
5,3,3,16,8,13,2,13,3,2,9,10,3,21,9,2,16,17,7,21,2,10,2,6,7,6,5,1,20,9,4,3,5,3,6,1,3,9,2,4,21,14,1,9,
5,1,18,5,6,1,6,5,13,9,20,3,3,9,15,1,5,1,6,2,7,11,9,4,2,4,9,9,12,20,15,9,6,1,5,13,6,8,15,3,12,1,5,9,
1,2,9,1,15,8,4,3,9,5,10,11,4,20,1,8,4,2,1,8,6,18,3,7,5,15,15,6,7,3,6,11,3,6,4,5,6,4,9,2,9,4,11,1,5,
4,15,2,9,24,4,3,9,11,3,1,6,2,1,2,10,17,6,15,10,11,6,9,3,3,3,10,11,1,2,7,6,2,6,12,9,4,5,7,5,4,5,9,4,
12,6,8,1,6,2,7,26,3,9,1,2,4,11,3,4,6,11,3,1,6,14,1,6,2,16,5,7,3,11,4,12,12,11,6,4,2,4,3,2,9,1,6,3,2,
3,9,10,2,6,10,3,5,4,12,6,5,3,1,6,9,11,7,2,3,3,9,10,11,13,11,9,12,4,9,2,7,12,5,4,5,7,2,7,3,2,1,3,6,9,
6,5,6,15,10,2,1,9,6,9,3,12,5,6,16,5,1,2,12,13,2,15,16,2,1,5,15,15,6,3,7,14,4,3,5,7,15,8,3,1,15,9,5,
4,11,7,8,4,12,8,10,3,2,1,5,7,3,5,1,8,13,18,2,10,3,2,9,6,7,8,3,1,5,3,15,6,7,2,13,8,7,3,6,9,12,2,6,6,
1,2,7,11,7,3,2,3,7,8,3,6,4,21,3,11,6,15,1,12,2,9,6,1,17,7,21,3,15,6,5,3,3,3,4,2,1,8,1,9,9,2,1,3,11,
16,3,2,9,10,8,18,7,6,5,16,3,23,7,3,2,1,6,9,6,21,3,9,2,1,17,6,10,20,9,1,2,3,9,6,1,11,7,3,9,3,11,1,3,
3,5,4,5,1,8,6,9,6,15,4,9,5,1,6,5,3,6,1,21,2,13,9,6,12,8,7,3,2,1,15,12,5,3,9,22,3,11,15,7,20,4,14,15,
1,8,3,28,2,19,5,4,5,4,5,6,1,3,6,11,13,3,5,3,1,20,13,15,5,1,6,14,1,8,12,1,2,12,15,1,3,14,10,6,5,1,3,
3,14,15,1,2,6,4,11,4,2,1,3,6,11,10,9,5,3,21,1,5,1,8,1,6,5,15,7,8,7,8,13,12,9,8,10,2,18,1,11,3,7,3,
18,3,5,9,1,9,2,1,18,12,3,14,27,1,2,1,6,8,10,5,3,4,6,8,7,9,9,2,15,3,1,6,2,12,9,6,6,3,6,4,9,3,2,15,3,
25,18,5,4,17,6,7,3,18,12,18,14,7,5,3,6,4,2,1,3,9,2,1,2,3,4,9,17,9,4,15,11,9,12,9,3,7,3,2,4,24,2,4,5,
6,1,2,3,10,5,10,8,7,9,3,2,6,10,9,3,5,16,2,12,10,6,5,6,4,2,4,3,11,1,21,3,5,1,9,2,7,30,3,5,9,3,3,12,7,
9,14,7,5,1,2,10,6,2,3,4,6,9,15,8,7,2,3,12,6,33,6,18,3,4,14,9,15,1,20,4,3,12,5,7,3,11,7,2,12,1,8,6,9,
1,6,2,3,4,30,5,4,9,3,3,6,20,1,14,1,5,4,21,2,37,3,2,9,7,2,6,1,5,1,9,3,18,2,3,22,8,3,9,1,6,5,1,5,3,1,
8,3,7,2,4,17,13,6,3,6,11,19,2,18,1,6,14,3,1,6,3,2,3,3,3,4,5,6,7,3,5,1,15,6,8,6,19,6,8,1,14,7,3,2,1,
3,6,9,6,24,2,7,5,3,15,4,11,12,6,1,6,3,2,7,2,3,6,4,2,13,6,21,3,8,3,4,12,5,4,2,3,9,3,7,3,5,15,4,9,2,3,
9,1,14,1,5,21,3,3,7,3,3,17,4,9,2,3,9,3,3,1,9,5,1,5,3,1,11,10,5,16,14,19,9,2,1,8,16,5,1,9,3,3,8,9,3,
7,5,6,10,5,6,3,28,2,7,5,1,3,17,7,2,3,1,5,15,4,26,16,3,2,6,13,11,4,14,3,9,15,1,8,4,15,2,4,14,10,8,7,
5,7,3,3,3,6,5,6,3,7,8,4,6,5,9,3,12,1,6,3,8,18,7,8,1,8,13,3,5,21,3,10,3,14,3,6,7,5,7,11,15,4,5,1,6,3,
2,9,15,1,6,9,9,11,1,5,3,7,8,7,2,3,19,3,3,2,3,7,5,6,1,8,13,8,1,6,12,2,6,9,10,9,11,4,6,15,8,3,9,6,12,
12,6,4,3,26,16,3,3,15,5,7,2,1,2,7,9,2,4,8,13,14,9,4,2,10,5,9,4,12,8,13,8,1,20,10,5,6,4,18,3,3,6,14,
4,3,2,7,3,2,16,12,15,3,14,1,3,9,5,7,11,3,6,4,12,2,1,2,3,4,5,10,6,2,22,5,1,6,9,12,9,5,4,11,3,6,4,11,
16,14,10,2,9,4,11,3,10,8,3,4,8,7,3,32,1,9,2,1,2,6,1,20,3,3,3,21,1,2,1,6,23,1,6,5,1,14,1,5,12,6,4,3,
15,5,9,3,3,10,9,3,2,3,15,1,2,3,7,2,13,8,6,21,3,1,8,6,4,2,1,9,5,15,30,3,3,18,4,18,2,6,1,8,1,20,4,2,6,
7,3,3,11,6,13,2,4,5,9,9,1,6,3,3,2,10,2,1,5,24,3,13,12,3,3,12,2,15,27,3,12,4,2,4,11,4,15,6,2,10,3,2,
3,3,1,14,24,13,5,4,24,9,15,8,28,5,7,5,13,5,15,6,15,6,3,6,10,11,3,10,6,5,1,17,3,3,16,3,2,1,8,6,10,3,
5,1,5,7,3,11,4,6,6,9,5,10,3,8,13,14,7,3,6,6,21,3,2,3,6,1,33,15,9,3,2,3,12,6,1,5,15,1,8,21,1,3,6,5,
10,9,2,19,5,1,14,10,3,6,14,10,6,2,3,9,7,8,7,9,2,3,1,3,3,29,1,9,9,2,10,5,10,23,1,14,12,3,4,3,3,2,4,3,
2,3,1,6,6,15,8,10,11,3,6,1,9,2,9,1,2,1,2,12,16,9,5,15,1,2,3,4,3,18,5,19,5,10,6,5,7,3,11,3,3,7,2,10,
5,1,12,3,2,3,18,37,5,3,16,6,3,5,7,5,12,1,5,4,5,13,2,1,5,22,5,3,6,6,3,4,3,3,30,6,3,2,1,2,1,5,22,14,9,
9,3,7,5,16,9,2,4,15,2,7,11,7,3,11,4,11,16,2,1,2,3,4,12,5,3,7,3,3,8,24,1,6,9,2,3,9,21,1,5,3,1,6,11,9,
4,9,6,11,4,17,3,15,1,5,6,10,5,3,15,24,13,2,1,11,1,2,21,6,3,3,4,18,3,2,1,9,5,7,6,3,14,13,15,5,3,10,2,
15,13,21,3,2,10,8,3,3,1,6,9,6,15,2,1,2,7,2,3,1,5,4,3,5,3,1,5,3,1,12,2,1,6,20,1,15,2,3,15,3,10,27,2,
1,14,10,2,1,3,14,10,2,9,1,8,1,9,17,6,3,4,3,2,3,7,2,1,8,4,2,6,13,2,3,4,5,6,4,3,3,11,1,2,12,3,3,4,5,4,
24,5,3,7,8,4,5,1,8,1,11,4,5,6,7,11,10,6,15,8,10,18,2,3,7,5,18,3,16,11,25,2,7,5,3,6,1,5,3,10,3,3,14,
3,9,4,9,8,3,4,3,2,13,8,1,3,2,1,27,3,2,16,2,3,1,8,15,1,11,3,1,17,3,1,5,19,2,4,11,13,6,6,2,25,3,9,11,
10,5,4,3,2,10,6,2,6,1,6,15,8,1,5,6,4,5,1,3,9,6,9,11,4,17,10,5,3,1,30,11,10,3,11,7,5,3,4,11,1,5,3,1,
5,6,10,5,1,8,7,3,6,3,11,1,3,8,4,3,11,1,6,15,15,3,15,6,3,6,5,16,8,18,9,1,23,4,3,2,1,17,3,1,3,8,3,4,3,
3,12,3,6,3,3,5,22,3,5,15,18,1,3,5,1,6,14,6,3,3,3,10,14,12,9,7,2,3,9,16,2,13,2,3,15,3,16,5,4,2,3,4,8,
7,3,3,14,1,2,4,21,12,6,14,1,6,6,2,7,8,7,5,3,1,5,1,3,2,13,3,8,9,12,6,7,6,14,6,15,1,3,2,6,3,7,5,7,8,4,
8,6,7,9,8,18,4,5,1,8,4,6,9,17,19,5,7,2,1,6,5,21,4,3,18,17,13,5,3,7,3,11,1,8,6,34,2,13,5,4,17,3,6,1,
5,3,3,4,8,7,11,7,3,3,2,7,5,3,10,2,1,5,6,4,5,6,4,12,9,5,4,5,6,3,10,5,13,15,2,1,6,11,3,1,8,25,12,15,
11,7,23,3,1,6,5,7,3,3,2,7,12,5,10,3,3,8,15,6,25,9,5,16,15,14,15,1,14,4,11,1,3,3,8,6,1,14,3,15,1,6,5,
4,11,6,4,3,2,9,19,8,12,10,18,2,13,3,5,6,9,6,1,5,9,3,16,2,4,6,2,6,7,2,13,8,6,3,7,5,9,10,2,7,2,3,7,11,
13,6,5,1,2,10,2,3,6,7,12,8,12,1,6,6,2,3,9,4,6,5,4,2,10,12,2,4,15,2,4,3,11,4,6,11,1,8,1,8,10,5,3,10,
24,3,6,2,13,5,7,8,1,15,20,4,5,4,2,13,11,9,6,1,3,11,10,2,4,20,13,2,4,11,6,7,6,2,9,4,14,6,1,26,3,7,2,
1,6,15,20,1,2,6,9,13,2,7,5,1,5,7,2,3,7,8,3,3,12,13,5,12,3,19,2,13,2,3,1,17,3,1,11,7,3,2,12,3,6,6,15,
6,3,4,6,9,2,4,2,3,24,6,19,2,6,4,5,1,3,9,2,10,11,7,27,6,2,1,6,3,5,6,1,3,6,9,3,5,19,20,15,1,5,4,3,5,6,
6,6,22,6,6,6,5,10,15,5,7,5,10,6,11,13,15,5,1,2,3,7,2,6,9,6,1,3,5,3,10,3,9,6,2,9,3,1,9,5,1,11,3,1,5,
6,1,5,7,8,3,6,15,1,3,2,9,3,10,5,15,7,6,5,3,1,5,9,15,7,2,7,5,3,1,6,9,5,6,16,3,2,4,5,6,4,14,6,1,3,11,
24,6,1,15,5,3,7,5,15,3,4,8,19,6,9,3,3,18,2,7,2,6,3,6,4,9,2,4,6,8,6,1,8,12,4,6,11,3,1,5,1,2,12,1,17,
1,11,3,1,15,2,4,3,18,3,5,4,3,2,3,10,15,2,1,9,2,6,13,2,4,6,20,12,10,2,9,6,1,5,7,6,6,9,2,9,10,33,3,3,
12,2,3,7,11,9,6,1,20,1,12,5,7,5,1,14,1,9,3,5,1,2,4,9,15,11,9,4,5,13,20,12,1,2,3,16,5,1,17,3,7,5,6,1,
5,9,10,14,18,3,4,5,7,15,3,17,13,6,6,5,18,15,1,11,3,1,6,6,5,7,8,19,3,2,9,19,23,3,12,4,6,5,13,9,8,7,3,
2,6,1,3,5,1,5,12,18,6,4,2,3,7,12,6,15,12,2,7,5,3,1,6,3,3,8,7,8,4,5,3,9,3,1,6,3,3,9,5,4,26,1,2,25,2,
1,12,5,1,6,6,15,8,1,8,6,6,1,2,3,3,4,2,16,2,15,1,5,1,3,3,3,5,6,3,16,2,9,6,3,22,9,3,12,3,3,3,9,20,1,2,
7,2,3,13,5,10,12,6,2,3,16,3,3,3,12,15,2,6,6,1,14,1,14,9,10,5,7,3,6,5,10,5,15,4,2,27,3,4,6,2,10,5,6,
7,8,1,3,17,1,12,5,7,9,2,10,3,26,1,5,3,4,5,10,15,5,3,9,10,11,9,4,11,1,2,1,21,9,17,4,14,4,3,2,7,3,3,3,
6,6,12,8,3,1,5,15,3,7,8,1,2,13,15,5,6,3,25,11,9,3,13,2,15,13,5,7,9,3,17,15,1,12,5,6,9,10,20,1,9,8,4,
6,3,12,3,2,7,6,15,12,14,3,1,2,3,19,2,1,12,5,30,3,4,9,14,12,1,8,1,9,21,5,6,13,2,12,7,15,6,5,3,6,9,6,
10,8,13,2,22,15,3,2,3,7,3,2,4,2,7,2,1,2,1,6,11,18,1,3,11,1,11,3,4,3,5,3,15,4,3,2,18,7,3,2,1,5,15,7,
5,7,11,4,3,5,3,6,10,5,10,14,15,6,3,1,12,2,18,3,4,8,7,8,3,12,12,1,11,9,6,1,5,4,6,12,5,7,8,13,12,2,4,
11,3,12,1,15,5,3,4,21,2,4,3,6,6,3,2,4,5,16,6,5,4,11,7,3,2,3,9,4,2,3,12,10,8,9,7,5,19,5,6,1,3,2,7,42,
20,9,4,15,5,15,10,6,6,21,5,3,9,6,1,14,10,9,20,10,11,1,5,13,5,7,3,6,5,7,3,9,11,15,6,16,3,11,3,18,7,8,
4,8,3,4,9,5,6,9,1,6,23,4,11,4,2,1,3,11,10,18,5,1,11,3,1,5,1,21,14,1,12,2,10,18,3,2,1,5,1,5,18,3,18,
6,3,3,7,6,6,3,3,2,7,21,2,1,6,11,7,6,5,6,10,11,4,6,2,1,6,5,4,27,2,7,3,11,9,1,2,4,8,3,4,6,12,3,2,21,4,
5,6,1,11,7,8,15,4,3,3,2,3,9,19,14,6,1,3,3,32,1,12,3,11,3,1,6,9,2,19,18,2,1,2,10,5,1,2,7,8,7,2,10,6,
2,12,1,2,7,20,1,14,10,8,1,2,4,6,9,6,5,25,18,2,33,6,1,2,6,7,5,4,6,5,22,3,2,3,19,9,5,4,3,3,6,9,5,6,1,
2,10,2,16,3,11,4,14,3,4,41,3,7,15,3,2,4,5,4,2,10,3,5,4,6,12,3,2,9,3,16,9,5,1,9,8,4,3,15,11,1,5,1,2,
1,6,15,11,3,4,2,1,12,11,1,8,10,21,20,1,18,17,3,3,3,1,6,3,2,3,15,6,1,9,15,6,3,11,18,3,7,5,10,5,6,12,
4,14,1,3,11,9,16,6,15,6,23,1,3,8,3,4,2,4,2,3,4,8,4,3,5,3,4,3,5,10,2,10,5,3,21,1,11,10,2,3,9,3,25,11,
6,1,2,13,8,4,2,28,15,3,3,9,2,15,1,2,3,4,8,6,22,2,3,7,15,3,8,9,6,6,4,11,13,2,16,3,17,12,1,6,5,3,12,4,
6,14,10,2,7,8,7,2,6,4,6,2,3,3,10,5,1,8,12,13,2,6,9,4,9,5,6,12,3,7,3,6,9,11,1,8,4,6,24,2,3,13,9,8,7,
9,2,3,1,5,1,2,13,12,3,9,15,6,9,3,3,2,1,14,6,1,3,5,3,13,9,5,7,3,23,3,6,9,21,3,6,4,17,3,10,5,1,5,7,5,
10,2,1,6,6,2,1,9,8,4,9,17,7,5,1,5,4,6,5,4,6,11,6,3,9,6,1,3,23,12,1,2,4,9,2,9,1,3,12,5,3,7,5,4,3,6,2,
3,4,2,13,8,24,1,3,5,1,8,12,21,3,7,20,4,11,4,21,12,3,5,9,9,7,5,4,9,14,3,3,4,12,14,19,8,13,27,2,3,3,6,
15,9,21,1,8,6,15,4,2,4,3,5,7,6,9,5,3,1,12,8,1,9,9,5,21,7,2,1,6,3,3,14,4,9,8,3,1,11,7,5,21,4,11,7,3,
12,3,6,5,15,4,11,3,1,2,4,8,18,3,1,5,10,6,9,8,3,13,2,10,3,20,4,6,5,1,8,12,4,14,7,6,8,16,9,15,6,5,9,
10,2,24,1,29,4,5,1,14,7,8,6,1,2,7,3,3,12,2,15,4,2,9,13,5,1,14,13,12,2,9,1,21,3,6,3,8,4,8,16,12,3,2,
4,8,3,7,3,12,2,3,1,15,2,7,11,4,2,4,5,6,4,6,3,2,9,1,6,5,7,3,5,42,7,6,3,5,1,15,14,10,9,2,3,1,2,7,3,5,
3,1,9,5,1,5,3,3,3,4,33,3,9,5,3,4,6,3,9,6,15,2,3,16,3,3,15,17,6,7,14,3,15,1,5,16,5,15,3,1,2,12,3,15,
4,3,3,8,10,9,2,3,3,7,3,3,2,3,6,18,1,9,12,5,3,7,8,3,3,16,6,20,7,8,7,12,3,11,9,1,9,3,15,5,3,6,10,5,3,
10,6,12,2,6,1,6,5,4,6,15,5,7,3,5,4,5,13,17,3,25,2,1,5,3,6,4,9,2,6,4,3,2,6,3,1,3,6,6,5,1,14,18,12,1,
8,6,6,13,2,18,6,9,7,2,1,6,14,4,20,1,2,4,11,12,6,4,2,4,6,26,4,9,5,6,15,6,3,7,5,13,15,6,3,8,7,20,12,4,
5,12,7,2,1,2,12,6,7,3,9,3,8,10,9,5,13,6,2,13,12,2,7,8,16,14,1,2,4,3,8,4,3,3,8,7,2,16,2,9,13,15,2,3,
12,3,7,8,6,1,6,17,7,8,16,11,3,15,16,2,3,7,30,8,1,6,14,1,2,7,5,9,9,3,7,3,3,12,9,8,3,7,8,7,6,6,8,1,2,
7,3,24,11,9,1,5,3,15,4,2,3,1,11,13,3,2,1,5,1,8,1,12,3,11,1,12,15,3,2,7,9,6,24,5,1,5,4,2,10,9,18,3,2,
12,4,5,1,3,3,14,9,12,9,1,2,7,3,8,7,2,4,11,3,3,7,3,8,7,14,3,6,7,14,1,14,18,1,14,10,3,23,4,5,3,15,15,
12,1,5,1,3,8,3,4,2,3,6,16,6,2,7,5,21,9,4,5,1,8,3,7,2,1,9,6,9,5,6,3,4,11,7,3,9,5,18,4,5,16,24,3,8,3,
9,7,8,1,12,2,1,6,5,4,15,9,18,3,5,12,7,2,3,1,2,7,5,6,1,21,2,3,4,11,4,5,6,3,16,3,18,2,1,11,15,13,12,9,
5,6,6,4,14,1,8,6,1,3,5,1,20,7,18,12,9,11,4,15,3,5,1,6,5,1,2,6,27,7,3,3,11,6,3,1,8,3,7,6,6,5,3,1,2,3,
1,5,1,9,3,2,1,5,19,3,6,14,6,4,3,3,14,1,5,4,3,5,7,6,5,6,18,3,3,7,5,24,15,3,3,10,5,3,4,6,9,5,6,1,6,9,
6,3,14,6,1,5,9,7,5,7,2,1,32,1,5,1,3,18,8,6,1,5,9,9,4,5,1,20,1,3,3,14,3,15,7,3,15,2,6,3,9,3,15,4,3,
12,9,12,12,2,9,6,4,2,3,7,14,13,8,7,5,1,6,5,28,3,3,2,9,1,14,3,1,14,10,3,3,5,10,17,3,6,4,2,7,2,18,6,4,
5,7,3,2,3,6,7,3,9,8,3,7,3,9,8,4,5,16,8,10,6,9,9,2,6,3,15,9,10,11,1,14,6,3,6,21,1,2,7,20,4,11,4,6,6,
5,18,6,1,5,4,11,7,2,6,19,3,11,7,3,2,18,22,5,10,12,5,7,11,3,1,9,2,10,15,2,1,21,9,9,2,6,9,4,6,6,2,3,3,
6,1,9,9,2,10,8,1,6,5,10,12,5,7,6,2,3,3,7,2,1,12,2,25,15,2,3,15,1,5,10,5,1,9,6,8,1,5,6,3,12,1,20,7,8,
18,9,1,5,1,14,9,6,1,5,19,2,4,9,2,7,3,2,7,14,6,3,1,2,7,8,15,3,7,2,7,3,11,9,15,6,6,6,4,5,1,2,10,3,8,6,
3,1,6,5,10,8,6,4,12,5,13,2,9,1,6,3,9,3,14,4,5,10,5,7,2,13,5,10,20,7,2,3,1,6,5,4,36,11,4,3,3,12,2,1,
3,14,16,6,6,2,3,4,5,4,6,11,3,1,11,9,18,7,3,5,1,2,13,5,21,1,2,1,5,1,8,13,12,3,9,3,5,7,3,3,5,4,3,3,2,
13,8,4,3,18,2,12,3,13,15,2,3,1,9,6,8,1,2,7,5,6,4,2,15,1,2,3,4,8,3,3,7,2,6,1,21,3,11,1,8,10,5,19,2,3,
3,3,1,11,4,26,3,1,20,9,7,3,6,8,15,6,1,5,1,2,1,6,8,7,3,8,15,3,19,5,13,3,20,6,4,5,1,3,2,24,7,9,9,2,4,
3,3,2,3,4,8,15,1,11,19,5,4,5,1,2,9,6,7,3,32,3,10,2,3,7,6,14,1,9,2,10,3,21,6,6,20,3,4,3,5,7,3,20,4,
15,14,6,4,2,4,8,3,9,13,5,7,5,3,16,26,3,1,5,1,3,5,18,7,3,2,1,6,9,9,38,15,4,3,23,7,2,3,10,3,3,5,6,4,
11,1,3,11,3,12,1,5,9,13,8,3,4,3,3,5,1,14,9,3,10,2,7,9,5,6,1,9,9,2,7,5,1,9,5,7,6,5,12,7,5,1,14,6,12,
1,9,3,2,7,8,1,11,4,21,5,30,3,3,25,14,1,9,3,11,6,9,7,2,7,8,13,12,2,16,5,7,2,1,5,3,1,3,6,2,12,1,6,3,2,
4,2,7,6,11,1,2,1,11,1,2,1,6,5,3,12,1,20,4,11,3,1,11,7,3,9,6,2,6,12,3,10,2,10,2,7,30,5,9,6,9,6,1,8,
24,3,4,8,1,2,4,3,18,2,6,10,5,4,2,15,1,12,6,11,4,5,9,1,5,4,12,6,3,12,14,6,3,24,1,5,4,11,7,3,11,3,7,8,
6,6,9,4,8,7,11,4,11,4,20,1,5,19,2,15,1,5,4,5,4,2,3,1,9,2,3,4,2,9,6,3,3,3,4,15,2,6,7,2,15,6,3,9,1,6,
3,12,6,2,7,3,2,1,29,15,13,12,3,3,3,5,7,3,2,3,4,5,3,27,3,4,8,3,10,3,11,3,1,5,1,6,2,7,8,13,3,2,7,12,3,
8,4,8,1,9,2,1,2,21,21,9,12,15,3,1,6,8,4,6,11,1,2,1,2,4,15,5,1,5,7,5,16,2,3,1,8,15,6,6,18,12,9,7,2,1,
2,13,2,3,1,3,15,3,2,6,15,1,5,1,8,1,11,7,2,4,2,7,6,9,8,3,9,13,2,6,1,3,12,3,11,7,14,4,6,3,5,3,3,1,9,
29,7,3,17,3,10,6,9,3,8,7,14,4,9,5,7,6,14,1,2,3,15,18,6,1,23,1,6,12,6,11,1,17,13,14,3,16,12,2,12,13,
2,4,2,4,15,3,3,9,5,4,5,15,9,6,19,3,2,22,6,2,15,1,14,1,2,3,4,2,6,4,3,6,12,5,9,10,8,1,2,7,6,14,12,1,5,
4,6,8,4,15,2,3,1,6,8,15,1,12,2,12,13,2,4,2,3,16,3,2,4,21,6,3,5,6,3,7,3,5,12,6,33,15,7,3,12,2,1,5,1,
15,5,4,9,2,3,10,11,7,2,6,7,8,9,1,9,5,31,2,12,10,3,2,7,6,3,14,1,11,6,3,15,4,3,2,3,15,7,6,6,6,3,6,6,2,
6,6,9,1,3,6,5,9,7,24,2,3,9,1,6,5,1,5,3,4,5,3,9,4,9,3,3,2,12,1,5,7,9,3,2,9,6,1,2,10,3,8,6,4,2,7,2,6,
9,6,3,1,9,11,9,1,15,21,8,6,18,7,6,2,3,3,10,6,6,5,40,5,22,3,12,5,1,5,7,2,6,6,15,4,24,11,1,14,1,20,3,
12,1,12,2,1,15,3,6,11,3,9,1,6,15,5,3,6,6,1,2,6,6,13,3,9,11,3,4,3,3,2,4,14,6,1,3,11,1,5,30,7,11,4,12,
14,12,4,3,2,3,6,4,2,6,10,2,1,15,14,1,2,12,7,8,1,6,3,2,9,1,5,9,4,27,3,6,9,3,14,9,4,5,7,11,12,7,5,4,
14,10,11,1,5,6,3,7,8,4,15,2,6,15,3,4,5,1,9,17,6,10,8,10,15,2,4,3,2,3,3,4,6,2,13,2,6,10,2,4,14,4,35,
16,20,6,1,2,1,17,3,7,5,9,1,3,2,4,5,9,1,3,5,3,9,4,5,1,5,15,1,12,17,15,3,6,7,2,6,4,3,8,22,5,3,7,5,9,3,
7,3,5,3,3,24,7,5,9,1,6,2,3,9,1,8,7,3,11,6,7,3,5,3,7,14,1,9,3,2,3,13,20,18,1,8,1,6,14,1,9,2,9,6,18,4,
15,20,1,2,4,8,1,6,5,10,11,9,4,21,3,6,12,2,3,3,25,2,3,15,1,5,9,6,3,1,6,3,6,6,18,2,10,5,1,9,8,10,11,6,
4,9,8,3,7,3,5,9,25,8,3,1,3,2,4,2,3,9,3,4,5,3,3,4,23,1,5,12,3,1,29,6,1,3,24,3,2,3,12,1,12,5,10,5,3,1,
14,16,3,6,9,5,10,2,3,1,11,4,17,15,3,19,5,6,1,18,17,3,6,7,27,12,3,5,3,12,3,9,10,5,4,2,12,10,27,5,4,5,
4,12,3,6,12,15,8,12,15,4,11,3,1,9,2,3,9,6,1,9,2,15,3,4,6,9,2,1,2,21,7,3,5,7,2,12,3,6,4,5,7,3,3,3,12,
5,13,5,1,3,8,13,5,22,2,10,6,14,7,3,2,3,3,4,8,16,5,6,1,2,10,11,6,1,5,10,3,2,7,2,4,12,3,11,1,2,6,7,27,
11,4,5,3,12,3,3,1,6,2,3,3,1,5,3,12,6,9,9,4,6,5,4,2,6,13,2,12,22,15,3,2,1,5,7,3,3,5,9,1,11,4,2,12,3,
7,3,30,5,7,6,5,12,4,14,4,8,4,9,5,6,3,3,3,6,10,3,17,13,6,6,8,13,3,5,10,6,18,8,3,9,1,17,4,3,11,9,12,1,
2,6,1,3,3,14,6,7,3,9,14,1,3,3,2,1,5,1,3,2,9,12,12,3,4,3,2,1,15,2,1,14,1,12,8,9,13,5,3,1,5,6,3,1,3,2,
1,12,2,1,17,1,2,4,3,8,7,6,6,8,3,10,2,27,10,5,3,22,3,12,5,1,5,12,7,18,3,3,9,8,3,4,12,3,6,6,9,9,5,6,
21,1,5,19,3,8,10,3,6,6,15,5,3,4,2,13,6,2,4,5,4,14,3,3,1,20,6,19,18,2,1,2,1,20,7,3,9,12,5,1,2,1,2,3,
6,21,9,10,9,2,3,7,12,3,3,6,9,5,16,6,12,12,8,3,3,10,6,5,4,6,9,2,15,7,2,19,9,2,3,10,6,2,9,3,13,15,2,3,
13,2,9,3,1,14,1,2,7,6,5,1,5,1,2,6,12,4,3,11,1,9,2,3,21,3,10,6,11,10,5,3,7,3,12,21,5,22,11,1,5,1,9,9,
26,6,3,6,3,7,35,1,2,1,12,2,7,15,5,15,6,7,2,4,2,24,4,6,6,3,9,21,14,15,3,3,1,3,5,1,9,11,6,4,6,5,3,3,
22,2,15,6,12,6,9,1,5,1,9,12,15,3,12,2,3,4,5,4,14,13,8,12,10,5,9,6,9,4,6,5,4,2,4,3,3,12,5,6,6,4,5,4,
17,6,3,6,1,3,9,5,1,2,4,18,3,3,11,4,9,2,3,3,3,1,11,12,3,7,2,16,5,7,3,2,1,12,8,9,3,10,3,2,12,3,4,5,9,
16,5,1,9,6,3,5,12,7,17,3,1,9,11,7,2,6,10,17,7,2,3,6,1,3,6,5,9,36,1,3,2,1,9,6,14,9,4,6,2,12,15,1,9,5,
1,11,1,2,18,3,7,9,14,6,6,4,5,3,3,7,6,5,4,11,1,20,13,8,7,2,1,2,3,34,3,3,2,1,15,12,12,2,15,4,6,9,2,7,
3,3,14,6,6,1,2,12,1,2,16,5,6,1,12,2,10,8,15,15,1,5,7,5,9,4,5,4,2,6,9,10,8,6,15,1,5,13,17,9,4,2,3,16,
6,6,2,1,2,13,14,1,9,12,3,8,15,18,4,3,5,7,5,6,6,1,2,1,9,3,2,6,21,6,15,4,20,19,9,8,4,3,3,3,9,2,6,9,4,
5,1,3,3,2,6,6,4,20,1,5,3,3,4,5,6,10,5,15,3,4,5,1,2,28,2,9,13,17,1,3,15,24,2,4,5,1,8,10,15,8,3,6,1,
27,5,1,6,6,2,13,3,14,3,15,10,5,18,1,6,2,6,6,9,1,6,5,7,33,3,2,13,6,3,5,6,6,4,5,19,2,6,7,6,9,8,4,3,2,
4,5,1,11,10,2,1,12,17,3,4,3,6,9,2,3,3,7,8,3,4,3,5,4,8,13,2,3,18,4,17,10,3,5,18,10,2,6,1,9,11,1,12,
11,4,3,5,7,8,3,15,1,3,2,1,3,5,6,3,1,11,10,5,16,2,12,10,6,3,11,3,22,3,5,21,4,2,4,21,3,6,5,1,5,21,9,9,
4,3,14,6,18,9,1,2,19,11,10,8,1,5,4,2,12,3,4,5,3,3,4,8,10,3,8,15,7,8,1,3,15,3,5,22,3,2,12,18,1,9,2,
10,14,21,18,6,1,5,4,5,7,12,5,21,6,1,5,4,8,7,8,1,2,3,9,7,5,1,8,6,16,8,7,3,2,18,4,15,5,6,1,5,6,3,1,24,
2,9,3,16,21,6,29,9,4,20,1,9,2,18,12,10,20,1,9,5,6,13,14,6,4,6,5,6,3,1,12,2,7,3,5,6,7,12,3,2,12,3,6,
1,8,7,15,6,9,3,3,2,13,3,15,2,7,2,4,6,3,6,6,6,15,3,2,15,3,1,3,2,1,14,3,7,21,3,5,1,20,3,10,3,2,10,2,1,
3,5,10,14,6,16,5,4,17,24,1,8,4,3,3,2,12,1,2,3,7,3,6,3,3,14,1,2,7,5,3,3,3,10,2,3,4,5,10,2,9,4,17,1,
14,15,1,2,6,4,3,24,5,4,9,3,3,2,4,3,11,6,1,12,30,12,18,8,3,9,1,20,1,15,9,2,12,10,2,3,3,7,5,6,1,6,2,1,
5,1,15,14,4,3,8,7,2,1,11,3,16,12,9,8,1,5,1,6,5,18,9,7,5,3,1,9,11,6,1,3,24,11,1,18,2,6,4,9,9,3,2,6,4,
2,1,2,6,12,19,5,1,3,12,3,2,7,6,12,9,8,15,12,16,12,2,3,7,15,3,5,3,7,12,6,5,9,1,9,9,2,10,3,2,7,11,1,8,
1,2,3,10,14,3,7,8,4,5,9,4,3,9,3,2,4,5,24,13,5,9,1,9,5,19,20,12,12,16,2,3,7,2,12,1,12,6,14,1,2,10,8,
4,2,4,12,5,10,15,5,3,9,1,2,4,3,2,10,3,5,6,4,2,4,5,1,6,2,1,11,10,24,6,11,3,7,9,3,12,9,17,3,6,9,6,3,1,
6,24,9,2,3,1,5,9,3,3,15,1,11,10,2,3,15,4,11,4,3,11,6,1,24,6,3,11,3,1,17,3,4,3,35,10,8,6,6,10,2,3,7,
5,1,5,4,27,5,13,2,3,12,4,5,4,3,17,10,3,2,13,9,8,13,2,10,2,1,29,3,3,3,4,12,5,9,6,13,8,3,7,5,7,6,6,8,
3,10,9,8,1,5,6,1,2,13,2,21,4,8,7,15,6,2,3,1,8,12,1,3,2,3,19,2,4,5,4,23,4,9,6,14,7,12,5,3,10,3,5,12,
13,5,1,8,1,2,3,4,3,14,9,1,8,7,3,2,13,20,3,4,6,2,3,24,16,12,2,6,24,3,7,6,2,1,2,12,1,6,14,1,8,6,7,8,9,
21,10,15,5,9,7,3,8,3,1,18,17,3,1,17,3,4,2,16,2,10,3,5,25,2,12,10,3,5,7,26,15,3,10,5,9,3,7,27,3,2,10,
5,6,3,15,10,11,4,11,3,1,5,1,9,2,4,6,3,11,6,3,1,3,8,3,1,6,8,4,42,8,6,7,9,5,3,10,2,4,14,1,17,3,7,9,5,
16,8,1,8,16,11,3,1,6,23,7,8,1,11,3,1,2,7,3,2,3,4,3,3,12,2,6,4,5,4,15,5,4,2,4,11,4,26,18,3,4,9,5,1,3,
5,6,1,6,2,1,17,9,1,8,1,6,8,6,1,3,9,2,3,6,7,3,12,24,3,11,1,5,18,7,3,6,12,3,2,4,3,3,17,1,12,5,9,1,14,
15,3,10,11,4,3,15,3,6,6,2,3,3,10,2,7,6,15,6,11,4,5,10,9,2,19,3,2,4,2,3,6,1,5,4,21,2,3,9,15,1,8,4,2,
1,18,11,1,12,6,2,4,9,14,6,6,9,9,16,2,3,21,3,3,7,5,1,5,6,1,24,3,3,5,3,12,13,11,9,10,5,4,6,6,18,2,1,
14,9,6,18,7,6,12,18,3,11,1,2,7,18,3,2,3,4,5,4,2,4,29,6,1,3,6,6,14,9,4,12,26,7,6,5,6,6,4,5,6,7,15,2,
1,2,1,9,11,9,3,10,9,11,10,2,3,3,1,3,3,29,3,1,2,3,4,6,2,12,1,11,1,3,11,9,6,19,2,9,6,13,6,3,18,3,5,6,
3,6,1,3,3,8,4,5,10,5,7,6,2,1,5,22,2,3,7,2,6,4,3,6,14,3,4,3,11,15,4,6,15,5,7,2,13,3,5,12,18,4,15,3,2,
1,5,1,5,3,6,1,14,1,11,3,4,2,4,9,6,2,19,5,15,13,3,5,4,3,8,9,1,9,15,3,3,3,11,1,2,13,5,3,12,3,4,2,16,2,
15,1,6,14,9,12,1,2,6,1,6,2,21,9,3,7,8,3,7,2,1,5,6,1,17,7,6,5,4,6,8,6,18,1,5,12,18,1,9,5,6,9,22,2,28,
9,3,5,16,9,2,1,8,4,2,16,3,30,2,3,1,6,2,15,1,9,3,33,9,2,9,1,9,2,3,7,17,1,5,19,11,4,15,11,4,5,1,14,7,
8,1,9,2,3,7,5,34,6,3,5,10,3,8,7,2,15,10,8,9,4,9,8,3,16,5,1,9,8,6,4,5,6,4,2,1,3,9,8,12,1,15,5,4,12,5,
1,3,9,2,1,2,3,9,13,3,3,6,14,24,1,5,6,4,6,11,3,6,4,14,1,29,1,2,7,2,9,1,5,1,5,4,8,7,6,5,3,21,6,4,9,11,
1,2,18,3,6,10,5,4,5,4,5,1,2,7,8,3,1,6,30,2,1,5,25,2,10,2,1,21,6,9,9,17,7,2,3,10,2,16,5,7,30,5,16,5,
6,1,5,3,6,4,2,7,3,14,10,11,3,4,2,19,12,5,3,4,11,4,5,10,5,6,1,3,6,5,22,14,10,6,8,6,3,3,7,6,2,4,8,6,1,
3,2,1,14,1,2,3,9,9,4,6,12,9,8,18,3,24,13,8,4,11,6,1,3,2,7,6,5,4,3,2,6,10,15,2,4,6,8,12,7,2,1,2,10,5,
15,13,9,9,6,3,3,2,3,3,4,2,1,14,3,1,21,6,5,7,11,6,1,9,5,6,13,2,28,6,8,1,11,3,16,2,3,1,6,14,13,5,3,4,
3,6,9,12,15,5,3,6,1,3,8,15,3,7,20,15,9,10,41,7,3,2,1,2,13,2,4,15,3,17,1,17,6,1,6,18,6,8,10,3,2,1,5,
4,12,9,5,1,29,4,2,1,2,10,2,33,15,3,4,5,6,3,7,20,12,6,4,3,18,5,1,5,9,4,18,3,2,3,6,10,5,3,6,1,9,2,3,7,
17,6,4,15,6,2,9,4,11,4,5,9,1,15,5,7,5,7,11,4,2,9,4,2,18,6,1,11,10,8,6,4,9,2,19,9,3,9,5,3,16,5,1,3,6,
5,6,3,1,2,40,2,7,3,11,7,3,5,21,1,2,7,5,1,2,3,18,10,17,15,7,6,6,6,2,10,15,2,1,5,3,16,11,4,6,2,1,20,
16,5,6,7,11,16,3,2,4,2,3,4,3,38,1,5,3,18,12,1,2,4,11,4,9,14,7,11,9,3,7,14,6,3,10,2,3,6,1,9,5,6,3,7,
5,1,3,2,12,37,3,5,3,7,5,1,5,4,6,20,4,2,3,18,45,3,4,2,9,1,6,2,3,10,5,3,6,6,9,21,18,1,5,4,5,1,6,3,12,
2,6,4,17,1,3,6,3,2,3,13,3,2,4,6,15,3,5,1,8,10,3,17,3,4,9,14,3,7,5,1,6,9,5,9,3,3,19,2,1,5,18,22,3,6,
6,5,25,3,9,2,10,3,18,12,11,9,3,7,3,15,12,2,1,12,11,1,20,1,9,5,3,1,17,9,13,6,2,4,8,6,4,3,5,3,4,17,9,
6,1,14,6,12,12,3,3,3,1,30,9,12,9,3,2,15,6,9,4,9,6,6,6,2,7,6,2,7,3,8,3,4,6,5,6,13,6,14,1,2,4,5,1,8,
10,2,18,6,4,2,3,12,7,12,3,11,1,5,3,12,3,3,12,3,4,5,1,3,11,21,10,3,5,1,6,8,6,10,11,3,4,6,5,7,2,3,9,9,
4,20,6,1,9,17,3,7,15,3,2,15,4,11,9,3,6,10,5,6,16,5,3,7,2,7,18,3,12,6,14,3,9,1,18,2,7,6,11,4,6,8,27,
3,10,2,1,9,5,28,5,1,2,19,5,10,8,1,12,2,3,9,1,5,7,3,9,9,2,18,1,6,14,13,12,11,13,2,7,5,6,16,3,3,9,6,8,
1,5,3,7,9,9,8,7,5,13,2,1,2,9,4,12,9,3,11,4,3,12,8,13,5,1,6,12,2,1,3,15,2,10,9,9,5,7,2,18,3,9,12,1,2,
15,6,7,2,3,4,3,3,5,9,6,4,8,1,2,7,3,3,6,6,2,1,6,9,11,15,15,15,16,8,1,3,5,6,15,1,3,3,2,13,8,6,3,12,4,
6,8,6,4,2,15,3,1,2,4,11,3,7,5,10,3,32,3,7,2,1,14,6,12,4,3,15,5,7,14,7,12,5,12,6,7,2,1,5,10,5,3,4,6,
9,18,5,7,5,7,9,2,15,4,3,2,34,5,1,9,2,4,5,15,3,13,5,9,13,5,7,3,8,3,4,6,2,9,16,5,4,11,3,1,3,2,6,3,6,1,
5,9,3,7,6,5,3,6,3,13,3,5,19,2,1,8,4,12,26,7,17,1,8,4,11,4,2,40,3,8,27,6,7,9,5,1,20,12,6,9,7,3,5,6,6,
1,3,11,9,19,12,5,6,3,4,5,7,3,3,15,5,7,8,7,3,14,6,15,13,2,7,17,4,2,9,3,6,4,3,3,9,2,13,6,5,4,5,6,4,11,
6,1,3,2,12,12,9,9,1,6,8,3,3,1,3,21,5,12,4,6,9,21,17,7,24,14,3,24,1,5,15,9,16,3,6,3,6,14,1,9,8,13,14,
7,5,13,5,3,18,1,21,14,1,5,7,2,3,12,24,1,6,2,15,10,11,1,3,2,13,2,1,9,8,1,14,1,5,6,4,5,7,3,2,12,6,4,
11,7,14,3,1,9,6,2,4,6,3,11,1,15,15,8,16,14,9,1,5,9,7,6,2,3,4,3,3,9,11,3,6,3,3,4,18,6,2,3,4,5,6,6,16,
8,6,4,5,4,5,7,5,16,5,4,3,5,1,11,1,9,3,3,5,3,1,3,17,1,2,1,2,7,6,9,6,15,5,9,15,7,11,3,9,1,6,3,2,21,7,
3,3,6,15,3,2,6,3,1,9,9,3,12,2,10,18,2,1,2,15,6,1,6,8,19,3,18,12,8,1,5,4,5,16,3,3,5,9,6,9,6,27,3,19,
8,3,3,1,5,1,2,10,6,11,1,2,1,9,2,3,6,7,8,1,9,11,1,2,18,18,4,23,3,4,3,12,3,3,6,6,2,22,9,12,18,5,12,4,
6,2,1,14,6,12,4,14,7,12,5,3,3,4,6,12,15,5,7,2,9,4,2,4,5,4,2,18,3,3,1,18,2,4,12,3,11,15,9,7,2,22,11,
3,1,8,1,29,7,3,8,7,6,2,7,8,3,4,3,3,2,12,6,10,5,1,6,5,7,32,3,3,4,11,4,3,5,21,1,11,4,9,9,3,14,4,12,2,
10,6,11,3,15,6,4,8,3,10,2,9,21,3,1,3,6,5,7,3,9,5,3,3,7,27,5,6,4,6,12,2,7,9,12,15,17,1,9,2,4,6,6,2,
12,15,9,4,2,9,1,3,6,14,7,3,5,1,12,2,7,5,9,7,8,9,7,3,2,15,3,1,6,3,5,6,4,17,3,6,1,14,7,5,3,6,9,6,18,6,
10,9,12,11,9,1,2,3,9,9,21,6,7,8,4,3,2,1,2,1,6,18,2,6,3,7,12,2,3,3,12,1,14,1,11,4,6,5,3,1,9,21,9,6,
11,4,5,1,23,12,1,2,1,2,3,1,15,3,2,9,12,4,3,20,7,3,5,1,6,6,2,12,24,6,3,12,4,2,4,18,6,14,1,6,15,6,5,3,
4,5,1,2,22,3,9,6,2,21,7,8,21,3,1,6,5,4,2,18,1,3,5,13,2,3,4,5,1,2,3,4,3,3,3,11,4,14,10,3,2,15,7,5,13,
15,2,4,2,15,7,26,1,3,2,1,8,1,11,3,4,11,1,5,6,3,12,9,3,3,19,9,11,9,4,3,2,7,5,1,5,3,4,15,2,9,4,3,8,1,
3,5,6,10,11,3,3,3,1,11,9,10,3,2,6,7,3,5,7,2,3,1,5,21,19,11,1,3,32,4,8,6,7,12,8,4,9,2,13,11,6,3,4,17,
3,18,12,3,4,3,27,5,4,5,1,3,12,6,2,13,2,1,2,4,6,8,7,14,1,12,2,4,5,7,2,1,11,3,6,10,2,4,3,11,4,21,2,4,
11,3,1,9,6,20,1,8,1,5,6,10,18,2,9,6,7,8,7,2,10,8,7,14,4,2,4,9,3,17,1,6,9,15,32,13,2,7,5,3,12,6,7,3,
5,1,35,13,6,12,2,3,4,3,5,16,2,3,4,5,1,6,23,10,3,35,7,3,2,10,27,11,15,15,4,5,6,3,1,3,3,3,5,4,17,9,6,
1,2,3,7,2,4,11,3,1,27,8,4,6,5,7,2,7,5,1,2,3,15,9,4,2,4,9,2,10,8,9,7,5,15,1,14,1,5,3,6,15,3,7,15,8,1,
6,8,13,5,7,3,3,2,12,10,2,18,12,1,2,6,22,8,1,6,8,9,10,6,5,1,14,1,5,15,1,15,9,11,9,10,3,2,4,2,12,1,2,
4,6,17,28,14,1,3,9,5,1,5,15,7,9,5,3,1,5,19,3,14,6,4,14,1,6,5,13,11,13,5,12,1,3,12,5,4,5,3,1,2,3,16,
5,1,35,3,4,2,13,3,3,6,3,5,1,2,3,10,11,1,2,6,1,8,3,4,3,21,2,3,6,1,5,15,4,3,6,2,3,1,3,5,7,15,3,2,9,10,
5,7,17,1,6,3,17,3,6,10,2,4,6,5,3,10,2,3,4,6,6,3,12,8,12,9,1,11,3,1,6,2,3,4,5,1,3,2,12,1,14,1,5,1,8,
10,18,5,3,19,6,24,8,15,4,3,6,5,6,3,3,3,4,15,2,1,5,3,4,3,12,2,10,6,5,12,13,8,1,11,10,3,12,3,11,9,1,8,
6,7,2,7,6,2,12,1,2,3,3,19,3,12,12,3,11,6,3,7,18,5,7,11,7,2,1,20,4,3,8,9,4,5,7,5,7,2,16,14,18,3,12,6,
10,11,13,8,9,9,6,6,9,3,3,28,5,1,5,13,5,3,9,13,8,4,14,4,6,15,17,3,1,11,18,4,17,16,2,7,3,5,6,1,6,5,4,
5,1,15,3,11,1,2,7,9,2,15,9,1,2,13,14,3,10,2,4,5,4,2,6,19,14,1,8,12,1,3,2,3,7,8,10,11,3,42,1,17,1,2,
7,3,5,3,1,3,27,9,9,15,11,15,27,7,8,4,5,4,6,3,8,3,9,15,1,9,3,2,12,4,2,10,3,20,4,5,3,4,8,7,6,8,1,5,6,
10,3,5,4,2,3,3,4,3,8,12,3,10,8,12,7,3,9,9,11,3,7,3,6,5,9,1,5,7,8,9,7,11,4,5,1,15,3,9,2,4,15,12,8,6,
4,2,7,2,9,1,5,15,3,18,12,1,2,7,6,6,5,9,6,3,6,4,15,5,1,2,12,3,7,3,2,6,4,11,7,3,5,7,2,3,3,1,3,11,9,3,
15,13,9,3,3,11,4,2,3,1,5,10,3,2,9,6,3,3,15,15,3,7,3,5,1,6,8,1,5,16,8,7,2,1,15,12,17,1,6,9,2,15,18,4,
3,2,3,7,2,3,3,4,3,3,9,3,2,3,21,1,3,3,5,9,1,14,1,5,22,5,7,5,9,9,1,11,1,2,3,3,7,5,28,5,1,3,3,2,15,1,6,
6,2,12,3,7,5,4,17,7,6,6,18,12,6,14,21,24,3,10,11,1,3,6,5,1,5,1,5,4,8,3,4,3,2,4,2,10,5,15,3,16,5,3,6,
9,1,20,1,18,3,2,10,18,3,2,3,15,6,1,3,2,4,5,3,6,4,6,11,1,5,15,22,2,15,9,4,2,1,2,6,15,7,2,10,12,18,2,
1,20,3,1,6,2,3,9,4,9,6,11,9,4,5,3,3,7,9,8,12,40,5,10,29,1,9,2,3,4,12,3,11,7,2,1,2,12,3,3,16,8,12,1,
9,15,6,15,2,1,6,3,2,3,1,9,6,9,2,3,7,9,11,6,3,1,6,5,12,10,12,9,6,6,9,5,1,23,15,9,3,4,11,3,4,18,8,9,3,
3,4,2,10,5,9,6,1,5,9,3,1,17,9,9,12,4,8,6,4,3,5,15,7,5,10,20,1,14,3,7,15,2,4,2,10,12,5,3,15,10,3,11,
4,5,1,3,3,5,25,2,3,13,15,2,4,3,5,6,6,4,2,12,7,6,12,5,7,3,8,3,9,3,3,15,6,10,18,6,2,3,16,3,5,3,4,3,3,
12,3,24,5,1,9,3,2,1,5,3,10,9,12,24,20,4,5,12,1,8,10,9,6,5,1,6,8,7,18,6,15,18,12,8,3,12,3,7,2,3,16,9,
8,7,2,4,11,4,2,7,15,3,2,3,4,5,10,11,12,7,9,21,8,13,8,1,5,1,8,7,3,5,6,9,6,1,3,2,22,2,3,1,2,7,11,1,3,
12,6,2,3,4,6,8,1,11,10,5,9,4,12,8,1,6,3,14,1,14,10,2,4,9,2,3,15,6,7,14,9,7,3,11,9,4,21,2,9,6,4,6,3,
2,4,3,26,1,5,9,4,17,15,9,4,6,9,6,36,5,4,5,6,10,5,4,20,4,11,1,5,9,7,5,9,1,3,12,2,15,1,12,5,4,14,1,15,
5,13,3,5,3,4,15,6,6,3,3,14,3,1,5,6,3,6,6,1,9,6,12,3,2,15,13,2,3,4,3,18,2,6,7,5,4,5,4,2,15,18,1,24,
12,2,1,6,8,3,10,8,31,8,1,2,7,3,3,6,6,2,1,9,2,9,15,7,2,3,13,5,12,4,3,2,1,8,1,8,6,1,8,3,7,8,13,2,4,8,
3,12,10,2,4,6,26,7,8,10,2,1,9,5,3,12,6,9,22,6,2,3,10,14,15,3,10,3,2,6,10,20,7,23,12,7,2,10,3,15,2,1,
3,6,8,3,3,7,14,6,24,9,12,4,8,1,12,3,2,22,18,3,21,11,7,20,1,11,1,9,3,18,5,4,3,2,33,1,14,1,11,1,8,6,4,
11,1,2,12,4,9,3,15,15,20,4,3,8,3,6,1,17,1,5,1,6,5,13,17,12,6,4,8,7,27,8,6,1,3,2,18,1,5,7,8,4,6,11,4,
14,1,2,3,1,3,6,5,4,5,1,5,7,2,6,9,3,7,2,1,5,7,3,3,2,4,24,9,5,1,5,1,6,2,7,14,1,9,2,7,2,1,2,1,2,7,21,5,
10,5,1,5,6,3,1,5,1,15,8,6,3,16,6,3,11,1,5,10,5,9,4,5,3,3,10,2,9,3,12,9,1,3,6,14,15,1,14,3,10,3,9,15,
11,9,13,18,2,9,1,8,1,3,11,7,2,10,5,7,6,5,4,5,9,10,6,5,3,6,7,12,12,3,6,2,4,6,3,5,1,3,11,7,9,5,1,5,3,
7,24,21,5,4,14,7,8,4,5,18,9,1,12,11,12,9,3,1,11,1,5,12,3,4,3,2,4,5,16,8,6,1,3,5,13,14,1,2,1,9,11,1,
9,2,13,2,7,11,1,11,7,3,3,12,5,3,4,5,10,2,13,3,9,9,2,3,9,7,23,3,12,6,1,3,2,6,9,3,7,21,2,1,9,3,2,6,1,
9,9,3,5,3,4,2,1,12,6,17,7,3,2,12,9,6,3,10,8,4,3,6,11,1,2,1,6,9,9,5,1,11,4,5,1,11,3,1,6,2,7,11,13,14,
13,15,3,11,6,3,16,3,15,2,3,10,2,4,2,4,6,9,14,6,4,2,3,1,3,5,3,15,10,3,2,12,6,1,6,3,2,4,5,18,6,7,9,5,
1,3,11,1,5,19,3,5,7,5,1,8,9,3,3,7,8,12,10,2,1,9,2,10,14,21,4,2,18,6,1,3,5,4,2,3,15,13,3,12,3,26,1,
12,3,3,2,3,6,10,3,2,6,13,6,5,3,6,6,1,15,9,20,10,11,3,4,3,3,6,14,1,5,1,9,5,6,3,1,3,2,4,24,12,8,6,1,9,
5,21,13,2,9,9,1,14,3,4,9,2,13,6,9,24,11,9,10,11,1,6,5,3,7,3,12,2,12,13,2,4,2,3,4,17,4,2,3,1,11,13,6,
5,4,17,9,6,12,7,11,12,3,7,5,6,1,11,3,1,5,6,18,16,3,5,1,6,9,5,4,6,5,6,9,6,10,5,1,14,1,2,16,5,7,3,6,8,
15,13,2,12,1,14,4,9,2,16,3,2,9,1,9,11,9,6,10,3,2,3,4,21,14,3,9,1,3,5,15,6,3,6,7,20,4,3,11,15,1,5,4,
5,6,1,2,3,3,7,5,7,18,17,3,7,18,2,12,4,6,6,9,18,2,1,5,4,5,6,18,9,7,5,1,14,16,3,9,2,19,2,4,6,3,5,1,14,
1,11,4,26,10,5,4,9,9,3,8,9,1,11,3,25,2,6,9,6,7,53,7,3,8,21,10,3,11,1,8,3,7,2,9,16,3,2,9,12,12,1,6,9,
5,10,2,7,5,13,3,11,1,8,1,5,6,13,2,12,1,2,3,4,3,3,2,9,3,6,7,8,15,1,3,3,8,10,9,12,3,3,2,1,6,8,7,6,5,3,
4,5,3,9,1,8,4,30,3,12,2,18,6,7,2,6,1,5,6,13,2,4,11,4,8,1,6,3,2,4,17,3,12,3,6,6,3,12,4,5,16,2,10,2,3,
16,11,1,2,10,2,6,10,3,2,15,7,6,6,5,10,15,6,14,1,32,13,2,3,7,5,12,1,2,1,6,3,15,3,3,5,6,6,7,15,47,10,
3,3,3,9,8,13,5,7,9,9,12,15,8,4,6,2,9,4,11,3,6,7,2,1,6,5,1,3,14,3,18,1,3,2,6,13,6,3,5,3,10,3,11,4,11,
1,8,1,3,18,5,9,3,3,4,11,4,14,6,10,6,9,8,6,1,3,2,9,4,17,3,7,3,18,3,21,3,15,2,4,2,3,6,3,7,18,3,3,2,3,
6,4,11,3,3,10,2,28,2,7,8,1,6,3,5,3,9,1,20,7,5,3,7,2,6,40,3,5,1,5,1,8,6,3,1,2,7,5,28,5,4,8,3,4,9,2,4,
5,1,9,9,6,6,2,6,6,4,5,4,6,6,9,14,7,3,2,4,5,7,14,6,4,6,5,12,10,11,1,6,8,15,1,6,9,33,6,6,3,8,3,4,11,7,
8,6,9,1,3,2,6,4,3,2,4,2,3,30,12,7,6,15,9,3,23,4,3,5,13,2,4,6,5,24,3,1,14,12,19,9,2,3,3,3,9,1,9,11,7,
5,3,4,2,10,3,21,2,7,6,6,6,5,10,2,1,12,3,9,2,9,15,6,10,3,8,12,1,15,5,7,3,20,1,5,6,10,2,12,3,1,2,3,1,
8,1,6,3,2,3,7,5,1,5,10,12,6,5,7,3,9,2,3,6,25,5,7,14,1,2,21,16,8,3,4,3,8,4,3,3,2,7,15,3,2,19,9,3,2,1,
2,22,5,15,7,8,3,19,6,3,9,5,1,11,4,2,3,7,2,1,2,3,4,6,5,1,5,4,11,1,9,23,1,14,10,3,5,12,7,6,3,2,4,11,3,
12,9,1,17,1,15,20,9,6,1,14,4,11,4,5,1,9,2,6,3,7,5,3,4,5,6,7,9,3,23,9,10,3,6,2,3,9,1,11,3,6,1,9,9,2,
6,10,3,12,14,3,1,12,9,8,1,26,3,7,3,2,4,5,6,10,3,5,1,6,15,5,9,7,2,6,7,2,10,8,3,10,6,8,1,2,15,9,3,1,
24,5,3,13,2,7,26,24,1,11,3,18,3,6,4,5,7,3,14,6,4,5,3,4,6,2,13,8,1,5,1,5,13,29,1,21,3,12,6,5,4,3,2,1,
2,3,4,6,14,1,14,6,10,2,3,3,4,26,6,3,7,14,4,6,2,9,6,10,2,10,11,1,5,10,3,8,3,6,6,3,4,23,4,8,10,2,1,3,
14,13,2,10,3,5,3,4,5,1,6,3,15,3,8,1,3,2,1,3,12,3,5,7,15,14,1,2,3,4,3,5,1,2,3,4,3,3,6,5,10,8,1,2,22,
18,2,1,24,5,13,2,1,11,6,12,28,2,3,18,1,3,11,4,11,6,6,3,4,12,3,2,9,9,10,2,6,12,3,3,1,5,10,21,2,6,1,9,
2,9,1,14,9,15,1,9,5,7,5,30,7,6,6,11,3,1,11,4,9,6,5,4,6,3,2,3,3,3,6,15,18,10,3,3,2,9,10,8,6,7,12,3,
17,7,21,3,9,11,1,9,6,5,1,9,9,2,7,15,2,6,7,3,8,9,6,19,2,1,5,3,1,3,18,2,1,11,3,13,12,6,15,2,3,4,8,15,
3,12,7,2,9,10,11,3,13,2,1,5,1,6,5,3,6,1,3,2,7,5,3,4,5,6,3,4,5,7,3,2,30,3,6,6,1,3,11,1,3,14,6,12,3,6,
16,3,6,5,9,7,3,12,2,3,7,5,16,2,3,16,6,2,3,3,7,2,30,1,6,5,3,3,7,8,4,6,2,7,8,7,8,3,4,20,6,7,15,12,6,8,
7,2,12,6,4,3,15,5,10,2,3,3,7,3,8,1,5,1,2,6,6,13,2,19,15,2,9,16,5,3,1,5,4,5,6,1,3,12,27,2,3,3,13,2,3,
12,3,6,3,1,6,5,3,7,6,14,1,5,7,6,9,8,3,1,3,5,15,1,5,16,3,2,1,12,20,1,6,5,10,6,3,6,3,3,14,4,5,7,8,12,
3,7,17,6,4,8,4,3,3,2,1,11,9,7,2,30,1,9,6,12,3,11,1,9,15,5,10,5,9,6,3,15,6,9,6,9,13,12,17,1,5,3,16,
11,4,3,3,2,6,25,2,7,3,2,6,21,4,2,4,5,10,3,11,6,3,1,5,7,24,3,21,17,7,3,14,4,6,5,1,5,7,2,1,23,6,10,8,
13,2,10,12,9,2,4,3,8,9,4,9,3,2,7,5,6,19,3,2,10,6,2,6,6,1,5,10,3,21,3,2,9,4,6,5,7,9,8,1,11,3,3,13,2,
7,6,6,8,1,14,7,9,5,7,2,7,29,9,10,5,1,14,1,2,12,1,11,3,1,11,6,9,9,4,5,1,14,1,2,7,15,2,9,6,1,3,6,5,3,
3,3,1,9,14,3,4,8,13,9,5,1,9,6,8,4,2,1,8,21,4,2,7,11,10,6,6,3,6,23,3,4,26,12,7,8,13,15,5,7,11,7,3,14,
10,2,4,6,8,1,5,4,5,12,24,6,4,5,6,4,2,9,4,12,9,3,11,1,11,4,15,3,2,6,3,9,12,21,3,1,29,6,15,1,3,14,1,2,
9,13,3,17,6,10,2,4,3,2,1,12,6,2,3,10,6,3,18,8,4,11,22,2,3,7,3,3,11,3,1,6,14,9,6,27,3,6,6,4,3,2,1,3,
12,18,2,13,6,5,1,2,1,24,2,6,3,1,14,10,6,8,1,2,3,12,3,6,1,2,1,21,3,5,6,6,6,9,1,3,2,12,3,10,5,3,1,5,1,
2,7,11,9,10,6,5,7,5,1,20,4,3,8,21,3,12,6,3,4,11,12,4,11,13,9,2,19,2,7,11,4,18,2,1,15,15,12,3,27,2,3,
7,6,12,3,2,7,5,1,9,5,7,3,2,1,2,1,12,9,5,10,3,2,9,9,3,18,4,5,1,14,7,9,6,24,5,21,3,7,14,6,9,10,2,10,8,
15,4,3,23,12,25,2,1,14,10,6,9,2,6,13,2,3,7,9,3,5,13,2,21,7,3,5,4,2,1,17,3,4,18,3,17,1,5,21,9,16,11,
4,3,11,6,16,2,1,14,12,4,9,17,3,6,1,6,5,3,1,8,6,7,3,11,16,3,15,11,9,1,3,3,2,1,5,6,1,2,1,12,2,7,8,10,
3,8,6,1,2,3,7,12,6,2,6,1,3,12,5,1,2,6,4,2,10,3,6,11,6,9,3,3,3,10,9,2,4,12,9,3,3,2,3,7,2,16,5,4,21,2,
13,3,5,1,6,9,5,9,4,2,16,2,10,8,7,5,6,4,3,2,1,17,4,6,2,3,28,15,2,7,21,11,4,11,10,9,2,3,4,8,7,41,6,1,
2,1,14,16,17,4,3,20,3,4,14,6,6,9,9,1,6,5,9,1,2,1,9,11,1,23,7,9,2,3,6,1,2,40,2,9,4,11,4,2,3,6,9,7,5,
19,2,9,10,8,6,12,10,2,6,10,2,9,10,9,5,4,2,25,15,8,15,6,12,7,2,21,7,27,14,1,6,17,12,15,4,11,3,1,6,8,
10,6,12,2,6,4,11,1,5,9,6,4,2,12,1,5,19,3,2,7,5,3,7,5,6,4,3,11,4,2,10,5,3,7,8,1,11,1,3,5,10,5,1,3,15,
15,17,13,3,3,2,7,2,4,5,6,6,4,5,6,3,10,14,7,5,16,2,10,3,3,6,5,3,25,3,3,5,10,6,8,1,12,2,3,7,17,1,8,4,
23,3,4,2,1,3,30,11,10,5,10,6,2,3,18,4,3,3,11,3,6,10,11,4,5,15,4,3,2,3,9,1,17,1,41,3,6,7,2,3,4,6,2,6,
12,22,6,6,3,6,2,4,8,1,12,5,3,4,2,16,3,12,17,3,3,7,8,1,9,6,5,3,6,6,1,18,2,3,10,15,5,9,1,5,1,5,9,15,9,
3,13,11,6,13,12,2,13,2,7,6,5,12,7,14,4,2,1,5,4,5,6,10,9,20,1,5,12,13,33,15,6,5,4,14,3,3,12,15,3,12,
4,3,2,10,3,5,1,11,9,1,8,1,12,9,6,3,2,7,8,4,8,1,9,15,11,6,1,2,1,12,5,4,20,4,6,5,3,18,4,3,3,2,6,1,14,
4,33,5,9,4,6,9,2,3,6,15,10,5,6,13,2,7,5,3,7,6,6,3,6,5,7,9,8,3,3,1,6,5,9,4,5,6,1,5,7,2,16,2,3,4,23,3,
7,2,3,10,2,6,7,8,7,6,6,8,3,10,9,20,13,3,14,1,3,2,12,6,4,12,5,10,18,5,6,6,1,5,19,3,26,1,8,1,17,4,5,
10,14,7,2,3,7,2,18,1,2,3,1,6,18,11,1,5,7,15,3,9,23,1,2,3,6,3,6,7,2,10,3,8,1,11,3,4,2,1,9,3,12,3,3,5,
3,4,2,3,12,1,3,2,3,1,15,5,1,33,5,1,8,7,3,3,2,1,14,1,9,8,3,7,5,30,3,1,8,3,10,3,5,9,12,1,2,6,12,15,12,
3,10,5,12,12,4,5,12,3,1,9,9,5,1,6,5,4,2,18,1,5,3,13,8,12,10,8,7,3,9,6,6,3,5,3,12,1,15,6,5,3,3,3,1,
14,4,27,3,3,14,10,6,8,4,3,2,12,9,9,3,4,30,23,7,3,5,3,4,3,3,3,9,2,15,4,5,19,3,2,6,1,8,12,13,2,13,17,
9,1,3,17,3,1,5,1,5,13,8,3,6,4,9,2,18,3,10,2,1,2,3,4,18,33,5,4,2,1,2,3,9,21,12,1,14,1,2,10,5,4,5,1,3,
9,12,5,13,3,8,7,3,5,1,18,8,3,1,5,1,5,13,9,8,3,1,8,7,6,2,6,6,9,7,12,3,8,24,6,7,5,9,3,12,10,3,5,6,1,6,
3,9,6,11,3,1,5,9,3,3,6,1,15,2,1,9,3,8,1,6,12,3,3,27,2,12,16,8,1,18,11,12,13,5,16,5,4,6,6,30,5,3,7,3,
9,8,4,3,5,6,4,2,4,5,6,10,3,8,7,2,1,12,3,3,2,9,3,3,3,9,12,9,7,15,2,3,9,6,19,8,3,13,5,4,3,8,10,5,4,2,
1,2,6,4,11,4,3,9,30,8,1,5,7,2,3,3,1,14,4,6,9,2,1,12,8,7,8,12,1,11,3,36,4,5,1,11,3,3,3,7,2,7,14,6,15,
1,5,4,5,1,3,9,2,1,3,21,23,6,10,5,4,5,3,4,3,2,16,2,3,4,11,7,6,2,4,9,21,3,3,2,6,6,4,17,12,3,3,1,6,3,5,
4,3,23,1,3,12,6,8,6,1,38,1,6,9,8,3,3,9,6,1,3,8,7,12,8,1,12,2,10,2,4,15,9,3,9,3,3,3,5,25,6,3,12,5,10,
11,4,3,3,12,8,3,16,3,5,6,9,1,5,1,20,1,9,3,2,1,5,4,9,2,13,6,8,7,8,6,4,2,3,7,9,2,4,18,3,3,12,2,18,4,8,
1,5,6,9,7,15,9,33,8,3,7,5,7,3,18,2,4,5,6,9,13,21,6,3,5,3,3,1,6,3,6,6,5,3,1,15,6,3,14,1,21,6,5,7,2,3,
1,11,3,3,3,9,3,15,10,9,3,2,3,25,6,5,9,1,5,9,3,10,3,2,9,3,16,5,1,8,3,37,5,6,4,3,8,4,3,2,3,7,2,4,5,15,
9,1,11,4,9,21,2,3,6,1,5,13,14,10,2,9,6,9,6,1,8,1,3,11,19,12,9,14,1,11,1,2,6,12,3,10,2,7,8,4,9,12,8,
4,2,31,2,10,6,9,12,11,12,1,9,2,1,8,21,1,8,15,4,3,2,15,13,5,3,9,7,11,3,1,3,21,2,3,6,1,2,1,11,4,9,8,3,
7,2,7,14,19,2,15,3,10,5,7,3,12,6,15,12,18,45,2,1,11,1,8,1,8,1,2,4,5,3,13,18,14,6,4,11,1,23,1,5,9,3,
3,1,11,7,6,2,4,5,3,7,3,8,18,1,9,2,7,8,9,9,19,2,3,6,4,5,1,2,4,15,9,11,3,18,9,1,2,22,3,15,6,5,7,3,2,7,
2,1,8,6,4,12,17,3,7,8,19,5,1,5,4,6,8,1,5,4,5,4,8,7,18,23,6,1,2,13,2,12,15,1,3,14,6,12,3,1,5,1,3,20,
1,3,2,15,4,15,2,49,5,1,9,3,2,3,3,7,3,17,3,15,3,7,2,12,4,11,4,11,6,9,4,2,3,12,4,5,4,5,7,12,3,20,3,12,
3,1,3,17,4,9,20,1,6,3,6,6,14,19,8,22,2,4,2,4,15,5,1,8,10,5,4,3,5,4,9,2,7,2,1,3,11,3,7,3,3,2,3,3,7,8,
16,24,2,3,6,1,5,7,2,3,1,5,1,6,8,1,15,11,3,1,5,13,3,12,3,12,15,8,3,1,5,15,1,12,17,1,8,6,3,25,11,9,6,
16,6,12,6,2,7,2,15,4,20,7,2,1,15,2,7,2,9,1,9,5,7,23,1,14,1,5,10,5,16,2,3,10,3,5,4,12,5,6,10,2,1,2,
13,17,4,21,5,10,2,1,15,5,10,2,10,3,17,9,13,8,7,15,11,7,2,3,3,10,6,6,2,7,6,9,5,9,4,3,3,6,9,5,1,21,3,
14,1,2,4,3,2,1,8,1,5,6,15,9,3,13,12,3,2,6,9,6,6,1,8,21,3,12,10,8,13,18,2,4,3,21,11,6,7,5,1,6,9,12,2,
7,9,9,11,15,7,18,2,3,4,6,11,18,3,25,3,2,3,9,12,3,6,9,12,10,11,18,1,3,3,5,10,5,9,6,10,3,6,5,3,1,6,5,
13,3,5,3,4,11,7,3,9,11,1,6,12,3,8,6,4,2,3,4,18,8,7,2,7,11,7,5,7,5,15,1,2,6,9,13,20,7,15,5,1,5,6,1,2,
6,6,4,6,11,4,6,5,9,18,1,9,8,3,4,11,6,1,15,8,1,6,5,7,21,6,6,3,2,4,6,2,1,15,5,1,5,3,3,9,9,16,9,9,6,12,
2,1,27,9,5,1,18,15,2,10,5,9,1,2,13,8,4,2,1,14,6,3,12,12,1,36,6,8,19,3,3,11,6,4,3,18,5,18,19,2,21,9,
13,8,3,1,8,10,12,8,3,3,1,20,13,2,10,5,4,2,3,10,5,6,40,5,4,9,3,3,2,7,2,16,5,3,1,3,2,1,2,1,5,7,3,2,4,
8,6,4,2,15,3,7,8,3,7,11,10,6,9,2,4,8,3,13,2,7,5,7,14,7,2,1,2,10,8,1,6,2,1,2,9,1,12,2,15,4,6,14,4,11,
4,3,2,7,5,1,3,2,18,4,2,25,3,2,4,2,4,11,4,8,1,15,14,6,1,3,11,10,17,13,11,1,23,4,3,9,5,19,6,3,5,16,5,
4,20,1,5,6,28,2,3,21,15,6,1,14,1,2,7,8,6,10,9,5,25,8,18,6,3,3,7,11,6,16,3,11,4,9,8,7,2,3,7,6,8,1,3,
5,3,4,6,32,1,9,5,6,21,6,4,8,3,4,3,2,4,5,4,5,10,8,3,1,35,10,3,3,2,12,1,8,6,3,1,2,13,12,12,17,4,6,6,
15,3,2,7,15,6,9,3,5,3,6,3,6,10,5,6,3,3,4,3,6,9,2,10,9,5,24,6,10,2,3,12,7,20,1,11,3,7,6,2,1,12,14,4,
2,3,1,18,2,13,3,5,4,11,7,11,1,5,4,12,2,6,6,1,2,6,7,3,26,4,20,1,6,17,3,4,3,2,1,12,21,11,4,6,3,5,7,9,
12,3,11,9,1,3,2,6,7,8,7,6,2,3,1,8,3,3,4,3,20,7,5,7,3,2,1,3,15,6,3,6,5,4,8,7,17,10,3,5,3,3,7,3,12,14,
3,6,4,5,1,12,3,6,6,2,3,4,18,8,7,5,3,15,3,7,3,5,1,6,2,7,5,1,14,1,5,18,9,16,6,6,3,2,4,9,5,6,1,3,6,8,7,
6,8,4,5,3,13,14,27,6,3,1,15,11,15,9,3,3,3,12,3,4,17,3,1,6,11,3,1,14,4,2,1,9,3,20,3,27,13,2,10,3,12,
8,4,3,11,1,36,8,4,3,2,31,17,3,1,3,3,3,2,7,5,15,13,9,3,2,1,5,9,1,3,21,8,12,3,13,2,10,2,19,5,4,2,3,7,
3,11,4,3,5,13,5,7,12,3,2,7,3,3,8,6,4,2,7,2,3,1,6,3,5,16,14,3,3,9,13,14,4,6,8,1,2,10,2,12,3,7,11,10,
2,6,4,6,2,13,2,19,3,17,4,11,1,3,5,4,11,6,19,2,9,10,15,23,3,22,6,2,3,4,2,34,2,3,15,7,2,3,12,7,3,3,3,
2,12,12,3,1,6,6,2,6,7,3,5,16,5,10,9,9,3,18,2,12,1,6,5,1,2,6,1,11,15,3,6,1,27,8,7,8,9,9,15,1,14,7,12,
3,2,7,8,10,11,1,8,7,8,1,17,4,5,13,2,3,10,11,1,9,5,16,6,5,3,4,8,15,9,3,28,2,1,12,8,6,3,6,4,2,19,14,1,
20,4,12,3,2,1,2,1,5,1,11,3,15,4,2,1,3,12,44,1,3,6,5,4,2,18,1,3,6,2,3,4,3,5,4,3,2,3,10,6,2,3,6,1,2,1,
17,3,4,5,6,6,15,3,7,23,6,1,9,6,5,10,3,3,2,10,3,5,12,1,9,8,10,2,1,11,1,2,13,9,11,7,2,6,7,12,11,7,3,2,
3,19,9,5,1,5,10,3,2,9,7,9,3,6,2,12,1,12,17,10,11,7,17,7,3,8,10,3,2,3,4,11,6,10,14,6,4,2,9,1,3,2,7,5,
3,4,3,3,8,7,17,3,3,1,8,3,3,6,6,10,12,6,20,1,6,14,4,9,11,6,9,6,3,7,14,1,14,1,5,1,8,9,1,5,6,1,9,20,1,
2,1,6,9,2,13,15,12,8,4,5,10,2,13,17,3,6,16,6,3,11,13,5,3,7,15,2,6,4,11,4,3,5,3,9,10,11,3,6,3,6,4,15,
2,3,3,4,5,16,3,5,1,5,9,9,3,7,2,1,2,6,7,5,10,3,2,15,3,12,7,2,4,15,11,1,2,7,3,8,9,3,18,15,4,8,7,5,3,
10,2,9,7,5,3,4,2,18,6,7,17,1,5,1,14,1,5,1,8,6,6,10,17,1,21,6,2,12,1,3,9,8,13,14,3,4,5,18,3,7,2,16,8,
6,1,23,6,28,5,1,11,1,15,5,4,8,6,6,4,5,24,3,4,6,2,6,15,1,8,10,17,9,6,3,7,3,6,14,3,3,1,3,12,14,4,5,3,
3,4,17,4,2,4,18,3,8,7,2,1,5,7,3,6,6,5,3,12,12,1,6,8,7,14,10,11,4,12,2,16,11,18,3,12,1,14,13,5,4,8,7,
6,12,3,2,1,6,3,2,10,3,5,6,9,7,5,3,3,12,3,10,3,17,7,5,3,3,1,11,3,10,12,2,7,6,14,13,2,1,17,1,2,3,7,9,
3,3,2,1,5,6,4,9,2,1,14,9,9,1,9,5,6,12,4,6,23,4,2,3,7,5,19,2,4,5,3,7,3,3,5,18,1,8,1,21,3,6,14,3,9,3,
6,1,6,3,15,32,13,2,3,7,5,4,8,1,9,3,9,9,11,3,3,22,3,15,5,4,5,6,4,3,11,4,2,1,2,6,6,1,5,3,4,11,1,5,9,7,
3,9,2,9,9,1,6,5,1,9,9,2,7,23,3,4,5,1,9,2,3,10,5,3,4,3,2,4,6,5,6,4,3,8,3,15,4,2,1,5,9,4,6,3,3,2,6,4,
5,6,9,7,5,1,9,3,3,5,19,9,2,3,7,32,3,4,5,13,3,3,2,12,7,11,4,3,12,3,11,1,8,1,6,5,1,5,4,9,5,6,1,2,1,9,
8,3,12,4,15,5,6,3,12,3,6,16,12,11,1,3,6,2,4,14,7,12,2,3,7,5,36,3,1,6,3,2,7,2,16,17,18,10,12,21,2,3,
6,1,3,11,9,9,3,4,5,6,12,7,8,1,2,3,4,5,3,3,6,9,6,9,21,9,21,4,2,4,3,6,6,6,3,5,15,19,2,6,7,6,6,3,2,18,
6,1,3,6,5,1,11,9,3,6,4,18,2,1,2,4,3,2,3,3,25,3,11,1,23,4,2,1,8,9,1,11,13,3,9,20,9,1,24,2,30,12,12,
10,5,3,1,5,6,13,6,5,10,2,4,3,6,6,6,8,7,3,5,1,6,2,3,3,1,20,1,14,3,7,8,13,3,2,4,3,12,5,3,3,30,3,4,5,
25,12,6,3,15,12,5,4,5,1,14,6,13,2,7,5,10,2,1,8,7,2,1,5,9,3,3,4,11,12,7,5,13,5,3,6,16,3,11,3,10,3,3,
5,4,2,21,12,1,9,3,8,9,12,1,20,3,9,3,28,2,7,5,13,8,1,3,8,4,5,13,6,2,7,5,6,9,1,5,16,9,6,11,3,10,2,33,
4,6,6,5,3,6,7,5,7,8,3,4,11,4,2,1,2,1,11,16,5,9,4,6,5,1,5,3,1,3,3,8,10,5,7,3,9,8,10,14,3,12,4,2,25,
20,9,9,7,2,22,5,1,2,1,6,20,9,4,5,1,6,3,2,18,1,2,4,20,6,7,5,3,4,11,7,8,33,1,3,5,1,27,9,5,15,3,3,4,9,
5,10,5,1,5,3,6,9,1,9,11,4,2,1,12,6,9,5,6,1,3,3,2,1,15,11,25,3,6,11,3,3,4,29,4,2,4,6,6,15,2,7,3,3,8,
6,1,9,5,3,1,15,2,10,2,7,11,4,21,12,2,1,5,12,3,7,11,4,3,2,13,14,3,6,1,3,11,6,4,9,23,3,10,15,2,3,34,2,
4,2,4,9,6,3,11,9,1,5,6,1,2,1,14,3,10,5,3,12,9,10,3,17,3,6,10,6,6,12,20,3,4,5,13,5,7,3,3,9,6,5,9,1,5,
3,4,17,4,6,3,6,2,12,1,2,4,3,12,14,1,3,8,4,5,6,10,2,3,18,21,3,12,4,26,1,3,9,2,4,2,18,1,3,3,5,28,5,1,
3,12,5,1,5,3,4,17,9,12,25,3,11,3,10,2,6,7,20,3,3,10,2,4,9,6,5,9,7,2,12,4,15,11,13,12,6,3,6,5,1,5,7,
5,10,27,3,2,13,5,1,5,1,5,4,5,6,1,2,1,9,8,3,6,13,2,18,16,14,13,12,2,6,3,19,6,11,13,8,4,3,2,3,6,7,2,7,
3,12,3,3,14,1,2,1,2,15,3,39,1,2,4,5,1,2,13,18,14,3,7,3,2,6,7,17,13,5,9,4,2,3,7,2,1,11,6,4,6,15,8,21,
10,3,15,3,5,4,5,4,12,8,10,11,1,9,21,3,12,12,2,3,13,3,12,9,15,5,9,1,5,1,14,1,2,1,2,12,7,39,17,3,15,4,
8,4,8,1,6,6,14,1,17,10,2,3,6,1,9,2,19,3,2,9,12,3,6,1,3,21,11,4,11,9,1,9,3,5,6,4,3,14,3,6,6,3,1,11,
13,6,12,9,5,6,3,4,5,1,5,4,6,6,9,11,6,9,1,8,4,21,2,4,3,11,6,3,6,10,2,3,6,1,5,4,14,9,16,2,4,3,8,3,15,
1,9,2,15,9,4,5,16,3,11,4,8,10,3,12,9,14,12,3,4,5,15,27,1,9,8,1,9,2,1,2,10,15,6,2,7,6,6,20,4,5,6,13,
3,2,12,4,9,3,2,12,3,3,3,7,12,11,1,6,2,3,3,1,6,8,4,15,6,14,6,7,3,2,3,6,4,17,3,1,5,10,11,3,12,4,3,5,
13,5,7,2,15,1,8,19,8,15,15,4,3,5,7,3,3,2,7,6,8,7,23,6,4,2,12,13,3,5,1,3,12,5,3,12,1,14,4,2,12,15,6,
4,3,2,7,8,21,1,5,9,6,13,3,2,1,17,13,5,4,5,15,3,7,3,5,13,9,3,2,1,6,5,10,3,6,2,7,3,2,15,7,20,28,6,14,
3,7,3,3,11,4,5,4,3,8,6,1,3,11,19,2,3,1,8,7,8,7,8,7,3,3,5,3,1,5,6,3,16,21,8,7,2,12,9,1,6,8,19,5,3,7,
8,3,1,9,5,9,7,6,5,4,5,9,1,3,3,8,4,2,3,3,7,2,3,1,12,3,2,12,25,8,3,1,3,8,12,15,7,9,2,19,6,2,6,4,17,9,
6,1,5,4,9,5,10,5,1,3,2,3,1,12,5,7,18,3,12,5,4,18,5,6,6,3,6,7,3,2,4,3,2,6,9,4,14,31,9,11,1,11,3,7,5,
10,14,1,3,2,9,3,1,2,12,1,2,3,1,3,21,2,3,7,5,3,1,3,20,12,4,14,10,2,1,8,1,6,3,5,19,2,4,14,28,9,3,11,7,
2,21,4,3,3,2,3,7,9,3,11,9,7,6,2,1,5,1,9,2,3,4,2,6,7,8,7,3,3,6,3,2,6,4,9,6,24,9,2,1,2,3,13,12,5,19,9,
2,4,5,3,6,7,2,10,15,8,7,6,9,5,1,14,7,20,3,3,7,2,15,1,8,6,1,2,3,12,7,14,4,2,4,14,1,2,3,7,2,7,3,2,1,5,
9,3,7,3,2,9,4,5,10,3,8,6,1,2,18,3,19,6,2,9,6,7,3,3,14,13,2,1,6,6,8,1,5,4,39,3,12,3,9,5,1,14,3,6,4,
11,6,1,5,4,15,3,8,7,17,9,1,11,3,1,14,4,2,1,2,31,20,1,6,2,7,6,2,18,3,6,3,10,6,2,4,6,15,24,6,5,7,27,
21,12,2,1,2,1,21,5,1,2,3,15,7,3,5,4,5,3,1,5,1,6,8,4,2,9,6,9,4,17,6,9,24,9,1,5,1,3,3,17,1,9,3,2,7,3,
2,13,15,11,10,2,4,8,1,14,3,7,11,7,12,2,1,12,11,7,5,9,1,9,5,3,1,2,9,9,1,5,1,14,10,3,2,3,1,27,2,6,16,
6,2,6,1,6,12,2,10,3,27,3,2,10,5,4,9,5,3,37,5,6,7,3,2,3,7,3,5,1,5,9,6,1,12,3,17,18,10,3,2,4,5,4,6,6,
2,3,4,18,6,5,4,2,1,5,13,2,3,7,3,11,1,17,6,12,13,11,4,2,7,6,9,5,3,3,4,11,6,1,5,3,12,3,1,5,1,5,3,9,10,
5,1,5,1,18,11,22,5,4,6,24,5,4,5,4,12,3,20,1,14,7,6,5,10,2,3,7,5,1,14,3,10,2,27,3,6,7,3,2,7,2,24,1,
30,20,3,6,4,3,3,5,4,3,9,3,5,3,3,7,18,12,3,12,2,7,6,14,4,9,6,6,8,3,7,3,2,6,1,5,3,3,3,4,3,2,7,14,19,2,
3,10,3,2,12,4,6,6,3,2,7,11,1,11,13,9,2,16,8,1,3,3,2,6,10,6,3,2,3,10,11,6,18,7,9,5,16,15,8,6,1,11,12,
3,4,14,1,24,14,1,11,16,8,4,12,5,13,8,10,2,1,20,1,5,9,10,9,2,1,12,2,3,16,26,3,13,5,4,11,3,7,12,2,19,
9,2,3,12,9,4,11,6,13,3,3,11,9,4,11,1,3,2,9,1,6,2,3,3,7,2,12,1,3,5,12,9,4,5,9,1,15,6,5,3,10,18,3,5,9,
15,1,5,1,3,5,3,9,4,6,20,1,8,1,6,3,12,2,3,7,5,7,11,3,1,3,17,6,3,1,3,5,6,4,2,4,5,6,1,38,1,8,1,5,9,13,
2,3,7,6,2,3,4,5,1,2,7,23,3,1,8,6,10,2,22,17,10,8,1,12,2,1,11,3,7,6,3,9,8,4,3,6,5,16,3,2,16,3,9,26,1,
5,3,21,9,7,3,5,13,2,7,6,2,7,6,12,2,1,15,8,6,3,12,4,2,4,9,2,10,3,6,20,3,12,6,7,3,3,11,13,8,7,18,8,1,
5,1,35,7,5,1,12,2,3,4,3,2,1,2,6,1,11,15,3,4,17,3,1,2,13,6,3,8,4,6,14,4,6,3,2,3,6,7,17,16,6,6,3,6,3,
11,1,5,31,3,5,9,12,18,6,6,1,8,6,10,18,6,11,18,6,9,10,3,2,6,1,8,1,2,10,20,7,2,10,11,3,4,12,14,1,9,2,
7,3,5,10,8,9,1,6,5,3,7,11,12,1,6,6,3,9,2,1,15,14,1,3,6,15,8,1,5,4,3,2,1,5,6,9,7,12,2,4,5,6,13,15,3,
5,4,6,14,3,3,10,18,11,4,9,12,9,15,5,6,4,2,4,3,12,5,1,12,3,12,6,6,6,8,4,2,4,11,3,1,6,6,8,6,6,7,26,12,
7,2,3,13,3,6,11,7,6,15,2,12,1,5,9,7,5,1,9,5,1,2,6,1,3,2,15,6,3,4,2,28,5,1,5,4,6,11,9,4,3,2,13,8,7,
17,16,5,1,5,4,5,7,24,11,3,10,9,2,16,14,15,3,3,4,3,5,3,13,2,3,4,3,3,9,5,7,8,1,21,5,10,3,5,12,13,6,2,
4,9,6,6,5,13,12,2,1,2,9,3,16,2,13,11,6,3,15,15,1,6,8,7,5,7,2,1,5,12,10,5,3,15,3,4,18,5,10,5,4,3,2,9,
4,2,1,9,3,2,6,19,6,2,1,5,9,1,9,11,1,14,4,8,4,9,2,13,2,4,5,3,6,22,27,2,1,20,3,1,15,5,1,8,12,9,9,6,1,
15,3,2,12,7,9,2,3,7,15,12,2,10,3,3,14,6,4,15,14,4,2,4,14,10,2,1,9,3,3,3,14,1,2,9,13,5,10,3,3,5,1,8,
3,18,1,5,4,9,12,5,3,1,14,12,15,1,2,7,6,8,1,9,2,12,3,4,3,5,15,7,35,13,17,4,15,2,7,3,3,6,21,2,1,6,3,3,
8,40,2,3,1,6,5,3,6,1,9,5,4,6,15,3,2,13,6,21,3,5,6,4,5,21,6,6,13,2,13,9,5,1,15,2,9,18,7,5,9,4,2,18,1,
6,3,11,7,3,9,5,1,20,1,6,9,20,1,9,5,4,2,3,1,8,1,27,2,3,3,12,10,15,12,5,1,5,1,21,18,2,12,3,7,2,1,3,2,
9,10,8,6,10,20,6,1,2,6,4,2,9,4,3,15,2,3,4,23,7,3,3,2,1,6,5,9,9,3,3,4,2,4,9,15,5,1,2,3,4,11,9,1,12,9,
8,3,3,15,9,22,3,12,8,1,6,9,24,6,15,2,4,8,16,11,3,1,26,10,3,8,3,6,3,3,9,13,8,10,2,6,1,6,3,2,4,11,10,
5,9,3,15,1,6,8,6,9,6,1,14,1,3,3,9,11,9,1,17,1,2,4,8,3,7,2,9,6,15,1,5,7,23,12,1,6,11,4,5,4,5,10,14,
12,21,9,4,15,2,4,3,5,13,12,11,12,3,6,3,1,20,4,11,7,2,1,14,3,4,3,15,8,3,7,27,26,10,11,3,6,1,3,6,14,3,
7,2,3,6,1,3,5,7,8,1,6,15,3,8,7,2,1,12,2,1,3,15,2,7,3,3,5,6,4,24,5,6,6,6,3,7,3,6,3,11,7,3,5,7,3,12,8,
12,3,4,27,8,3,13,15,11,3,6,4,2,21,10,27,3,5,9,4,5,1,5,1,2,3,3,7,20,3,6,3,12,4,5,9,27,1,12,2,13,3,15,
3,6,3,2,19,6,14,10,5,1,11,3,15,7,2,1,14,6,4,3,3,5,15,6,1,8,1,3,8,3,6,6,7,5,3,4,3,12,6,5,4,6,9,8,6,6,
3,7,11,12,1,9,5,22,29,15,6,1,3,2,10,5,4,11,3,4,8,9,16,2,3,22,2,4,2,3,10,29,3,10,8,6,1,5,10,18,5,10,
11,4,15,5,4,3,2,1,6,8,3,7,2,9,4,11,9,3,15,4,14,1,5,4,6,5,4,12,5,7,2,4,9,8,12,18,3,4,5,12,1,2,3,7,2,
3,21,6,4,17,3,9,1,2,28,26,1,14,4,2,4,8,3,3,4,5,3,3,4,3,2,7,29,10,2,7,5,16,24,5,12,10,3,11,1,5,9,7,9,
3,2,4,2,15,10,2,21,1,6,8,1,30,8,3,7,3,2,10,3,8,12,12,7,5,13,2,4,11,10,3,11,1,20,1,3,9,8,3,6,1,3,5,4,
5,7,11,12,3,3,1,6,3,5,1,5,4,2,3,6,16,8,9,30,3,7,11,1,6,8,1,6,12,6,12,14,4,5,10,14,13,3,14,6,6,13,2,
1,9,3,8,7,6,5,16,11,7,5,3,10,8,10,6,9,6,9,6,20,1,2,13,5,18,6,1,5,4,23,15,1,6,23,10,17,4,2,4,8,1,2,
18,7,3,20,6,10,3,15,3,23,19,5,12,13,5,6,4,2,1,8,12,7,5,1,5,4,3,23,9,1,5,4,3,5,3,6,6,7,3,2,7,9,2,7,3,
3,20,12,24,4,2,9,13,2,9,4,11,7,2,13,5,3,1,5,21,9,10,3,6,2,4,3,6,5,7,3,15,2,7,15,6,2,9,3,3,12,3,4,8,
13,8,6,3,6,9,16,5,7,5,7,2,3,16,9,21,2,4,5,1,5,4,5,6,3,6,3,1,2,4,5,9,9,7,14,36,16,3,11,13,3,3,2,18,7,
2,7,3,2,1,5,7,6,26,6,7,6,5,4,12,8,1,2,3,6,6,4,6,8,4,8,7,6,5,1,3,21,6,5,4,5,4,30,3,12,11,16,9,11,3,
12,3,6,36,21,10,3,5,7,12,2,9,1,18,2,1,2,3,12,6,10,12,2,7,9,5,9,6,10,5,9,1,2,13,5,9,1,2,19,15,8,6,4,
3,5,12,7,23,7,20,4,2,9,30,3,3,7,2,4,9,12,5,18,6,1,3,8,4,6,5,3,7,5,27,6,1,8,25,5,6,12,10,3,2,12,3,4,
9,6,6,9,5,4,5,7,5,3,6,9,4,2,3,12,13,5,3,7,6,24,5,10,3,3,9,2,13,11,9,3,7,3,2,15,6,1,8,12,13,5,1,15,9,
3,5,3,1,14,1,5,10,6,12,3,3,21,8,6,7,3,12,8,1,8,1,5,1,8,13,5,10,2,12,6,3,4,8,7,2,9,6,9,15,31,9,5,4,3,
2,1,2,3,1,8,6,1,9,9,3,8,12,9,4,24,6,2,9,3,1,36,3,15,3,12,5,3,3,1,8,1,6,6,14,1,2,1,2,7,3,9,6,3,5,9,
10,6,14,6,6,3,1,11,1,2,27,13,6,2,4,8,10,17,9,1,11,4,11,3,21,4,2,7,2,6,10,17,6,6,1,14,3,3,3,7,15,2,1,
2,9,4,9,3,2,1,5,4,6,6,9,2,4,3,2,10,3,6,5,4,5,3,7,8,7,3,17,7,5,1,5,25,8,6,3,3,12,3,4,21,8,1,14,12,7,
2,4,11,3,7,5,4,12,5,4,9,6,8,7,6,12,2,13,3,2,1,2,15,3,4,15,2,15,9,21,1,14,4,11,3,3,7,3,3,5,9,16,2,4,
3,3,9,3,11,4,2,1,2,10,6,9,5,1,2,4,6,15,8,9,6,1,3,3,8,4,3,9,3,5,6,10,2,4,5,1,15,3,12,14,6,3,6,15,13,
6,9,5,6,24,6,6,9,6,1,17,6,9,7,6,2,7,5,3,10,2,1,5,4,3,2,6,24,10,3,5,1,2,9,10,14,4,2,16,3,9,5,1,2,4,5,
4,2,4,15,15,6,8,4,15,8,10,2,7,3,2,9,4,8,3,4,11,1,8,12,6,4,9,17,12,7,11,4,3,3,2,7,5,6,3,6,6,3,15,7,
17,3,3,7,12,3,8,1,8,1,2,3,1,6,2,12,9,4,3,3,9,26,4,11,9,12,9,7,5,7,5,1,2,4,3,2,18,6,9,16,2,10,9,6,12,
2,3,3,12,6,10,5,16,6,8,1,5,9,10,5,4,12,3,5,7,6,2,1,6,3,3,17,1,5,6,16,8,7,2,18,3,1,3,5,1,12,3,12,8,
12,13,5,4,20,6,4,3,3,11,9,9,1,2,43,2,4,11,12,1,9,2,9,7,12,2,13,18,18,12,2,30,1,5,1,11,3,4,3,12,2,6,
4,5,4,15,9,11,7,2,6,1,8,3,4,5,1,8,31,6,9,3,6,11,4,2,7,8,3,4,8,9,3,1,9,2,4,12,5,12,1,6,5,6,7,5,6,4,3,
5,10,2,3,4,3,6,2,7,3,3,6,5,1,2,12,4,6,8,3,3,7,14,4,14,1,2,3,4,6,11,21,3,4,5,3,10,12,2,1,2,3,13,6,6,
2,12,28,15,2,6,3,4,3,2,16,6,11,3,6,19,2,9,1,14,16,3,2,7,2,3,3,4,3,8,7,6,14,13,23,16,5,13,5,6,9,1,5,
1,5,13,2,3,3,7,2,13,3,27,8,4,5,10,6,8,4,3,2,3,7,23,12,1,6,6,9,8,7,9,2,15,4,9,9,2,4,11,6,3,4,17,4,12,
3,21,5,1,5,9,4,2,18,1,6,29,10,5,9,1,6,3,9,15,18,12,2,15,4,9,2,1,2,3,15,3,4,21,6,11,10,2,6,6,3,1,6,3,
21,14,15,3,3,10,2,3,1,3,3,8,12,7,2,3,6,4,3,5,10,2,1,2,7,2,10,3,3,2,1,5,1,5,3,1,6,9,2,3,6,9,1,3,2,1,
14,18,1,6,15,3,11,24,12,16,18,5,1,3,26,9,3,7,3,5,3,12,9,6,7,26,1,3,5,42,4,12,17,3,3,10,5,6,3,6,7,9,
6,2,3,7,2,1,8,7,3,27,2,3,7,5,13,8,6,1,5,13,5,10,6,9,2,3,4,8,3,6,16,2,13,2,12,1,8,4,2,19,5,37,3,2,4,
15,3,8,3,4,3,3,15,2,10,2,3,4,5,3,1,15,2,4,15,5,6,3,4,20,21,1,5,3,12,1,9,5,1,15,5,22,5,10,11,6,16,8,
4,5,6,4,3,17,16,14,1,6,8,16,5,1,5,6,3,4,2,4,14,33,10,8,1,11,19,6,5,3,7,5,7,12,3,8,7,2,1,15,5,4,8,6,
1,6,12,3,3,11,3,6,4,6,6,5,9,1,8,3,18,10,2,9,6,7,5,13,5,9,4,5,6,4,9,3,5,13,15,6,8,1,9,3,2,12,3,13,8,
1,14,1,6,3,11,3,12,19,9,5,1,5,6,9,1,18,3,8,6,4,9,2,6,15,25,2,1,2,15,4,9,2,7,3,2,40,3,2,6,9,12,9,1,6,
12,5,3,18,1,11,3,9,1,5,10,6,5,1,8,7,3,12,5,7,6,2,3,9,1,5,1,5,3,6,15,4,5,21,7,5,12,1,17,3,1,24,2,22,
11,19,18,2,12,1,3,15,12,2,21,7,14,3,1,2,3,9,1,2,10,3,12,5,7,3,5,4,9,5,21,3,3,3,4,3,2,1,5,1,3,3,2,1,
12,2,13,18,2,19,11,7,3,8,4,2,15,6,4,8,6,25,17,4,3,5,6,6,9,6,3,1,5,1,6,9,11,7,3,12,2,6,10,2,1,15,5,9,
15,16,11,4,2,4,3,5,1,5,4,3,8,7,9,8,1,6,15,6,5,7,3,2,7,5,3,31,5,1,9,2,12,10,3,15,2,1,6,5,9,1,3,3,12,
5,15,22,5,4,2,9,1,14,4,5,4,12,6,8,1,6,3,11,6,7,2,1,8,4,2,1,14,13,6,2,3,6,1,2,7,5,10,3,2,3,12,4,30,9,
3,5,27,3,24,1,14,1,5,4,3,5,3,4,30,15,3,11,1,9,2,3,4,8,13,14,12,3,13,3,11,3,21,4,6,2,28,9,6,5,12,9,1,
5,3,25,14,16,2,4,3,12,5,3,12,3,6,7,3,12,2,1,2,9,4,2,4,35,4,5,12,7,3,3,2,9,3,3,13,12,2,13,2,7,6,3,9,
3,9,11,9,1,2,1,15,6,8,1,15,6,9,9,2,1,2,10,2,6,3,7,5,9,10,3,11,6,1,24,11,10,3,24,2,4,6,11,3,1,8,6,9,
3,3,1,5,1,12,3,14,1,24,3,8,10,9,5,4,5,19,2,1,3,2,7,5,10,6,2,3,9,6,1,3,6,11,1,3,5,4,2,10,21,2,3,4,11,
3,15,1,5,15,1,9,8,10,8,7,8,13,9,6,6,6,15,5,12,10,21,2,12,3,4,14,1,8,12,6,3,7,5,3,19,2,18,10,20,1,6,
9,12,2,3,4,11,19,5,9,1,3,3,2,1,9,2,1,2,1,6,5,16,14,4,5,6,15,4,5,4,12,8,6,15,1,3,15,11,19,6,2,4,9,11,
19,17,3,1,5,13,3,14,4,9,15,2,1,18,5,1,6,5,9,1,3,14,1,6,15,3,8,3,1,3,11,1,8,7,3,5,3,9,1,3,2,3,9,1,9,
11,1,3,12,5,1,15,2,1,5,6,3,12,1,17,3,12,1,5,4,8,9,16,3,9,2,3,6,6,6,10,2,7,5,3,6,4,5,6,1,6,8,7,2,3,3,
27,9,10,3,6,2,33,1,6,3,41,6,9,6,4,3,8,13,11,4,14,6,6,1,12,6,2,4,5,3,7,3,8,4,8,25,2,3,13,5,15,4,3,20,
1,12,3,12,3,26,13,2,4,11,6,3,1,14,7,8,16,3,15,2,1,8,10,14,13,3,9,2,3,7,11,18,1,3,11,16,5,4,2,19,6,3,
21,5,1,2,16,11,1,2,1,17,10,2,6,7,2,6,12,3,4,5,3,3,4,2,4,11,3,3,28,6,15,5,1,8,1,35,18,6,4,8,3,10,17,
9,1,18,5,7,2,16,5,4,8,7,20,22,3,2,1,5,9,19,12,8,1,8,6,6,1,12,11,12,24,3,7,3,3,2,15,13,5,7,15,15,8,9,
13,5,1,5,4,5,1,5,7,3,9,2,1,5,10,8,6,25,8,1,11,15,3,7,11,10,5,3,16,3,2,4,5,4,5,3,4,24,2,3,1,6,9,3,8,
3,6,3,18,3,7,3,14,1,6,8,1,5,7,2,10,2,1,18,15,2,10,29,1,3,5,16,5,25,14,1,6,2,7,5,1,17,6,4,2,9,10,2,7,
15,2,3,6,9,28,2,42,1,5,15,4,9,2,3,10,24,5,6,4,23,7,11,10,5,9,6,1,5,13,5,3,4,6,15,14,6,3,7,8,1,3,17,
4,2,7,5,3,4,3,2,4,9,2,3,3,4,8,15,13,9,26,3,10,11,6,9,3,3,4,3,3,8,6,15,4,5,6,6,7,11,4,2,1,2,7,11,10,
3,2,7,6,20,7,5,7,3,5,7,8,4,15,8,3,3,1,6,3,5,1,6,2,10,2,9,15,4,17,30,3,6,9,3,10,15,5,3,7,3,2,7,5,10,
11,6,4,5,6,1,2,13,15,5,9,6,4,8,1,6,9,5,4,20,1,5,4,2,9,24,1,2,9,13,5,3,19,5,1,12,2,6,3,1,3,6,5,16,9,
6,6,2,7,23,1,11,13,6,11,1,2,3,12,1,14,1,5,1,3,2,9,6,10,3,3,5,10,15,5,4,3,2,13,21,5,1,6,5,9,13,11,7,
3,9,12,14,6,3,13,3,5,4,11,6,15,4,2,9,3,3,4,3,5,1,9,12,11,3,4,2,10,9,5,4,3,3,2,9,9,7,5,3,4,6,12,9,5,
13,15,5,1,6,5,6,15,7,11,19,8,3,6,1,3,2,10,9,5,6,3,9,1,2,4,3,6,21,3,5,10,11,7,3,11,6,3,4,6,6,5,3,12,
1,17,6,7,14,1,12,2,4,12,30,2,12,3,3,10,5,3,24,7,8,15,1,11,4,2,3,4,11,1,5,6,3,4,8,7,5,7,14,1,35,13,8,
3,6,4,2,12,3,3,10,9,2,3,36,1,6,12,3,20,3,4,3,2,1,11,15,10,3,2,9,4,2,4,9,3,2,3,7,5,10,5,3,3,1,8,1,20,
1,3,8,3,4,20,12,4,9,11,21,1,9,5,9,12,3,4,21,5,7,14,1,2,6,1,5,3,3,4,8,7,14,16,3,11,4,3,2,6,1,15,8,1,
6,5,1,12,2,6,9,10,9,14,15,6,1,9,12,2,3,3,1,18,15,8,7,26,16,5,3,3,3,6,1,48,9,3,2,7,11,4,3,3,2,7,9,5,
10,2,18,1,3,5,6,9,1,6,6,5,40,2,7,9,2,4,3,5,6,6,15,30,1,18,14,3,3,9,1,2,7,2,1,14,3,6,16,3,2,1,14,6,7,
5,6,9,1,15,11,4,2,10,5,9,9,4,12,3,18,3,2,7,2,4,11,1,8,9,3,3,19,3,3,2,4,5,3,1,14,3,9,3,1,5,1,6,2,1,
12,8,21,1,3,2,7,8,7,3,15,8,6,1,8,7,20,12,1,2,9,6,4,11,3,4,5,6,6,4,2,9,10,5,1,5,12,12,6,3,1,8,1,9,20,
6,7,8,6,6,3,9,10,8,3,1,6,3,9,3,8,15,1,6,15,17,1,2,4,8,1,9,15,12,6,5,4,8,6,10,9,2,13,5,27,25,11,13,9,
2,10,14,1,14,15,9,1,11,3,16,12,2,1,2,13,17,3,1,5,3,6,1,21,2,6,1,5,4,9,8,7,8,7,3,17,6,7,5,4,5,1,20,
10,12,2,6,4,6,3,2,39,3,6,4,3,14,1,2,1,6,11,10,2,3,3,4,2,4,6,5,1,2,1,2,3,4,5,16,2,9,4,6,3,2,4,5,1,6,
2,6,4,3,9,6,3,5,1,5,15,4,14,3,12,3,4,11,7,5,12,21,3,6,13,6,6,8,6,12,9,1,17,6,4,8,10,5,13,6,3,5,1,24,
5,6,10,11,6,10,3,11,3,3,7,2,3,1,21,6,9,8,1,5,9,3,3,10,11,4,9,11,4,3,3,6,5,4,6,5,3,7,5,6,15,3,19,11,
1,3,5,10,2,16,2,12,3,6,1,6,15,12,2,4,5,16,3,2,3,1,6,5,9,1,11,9,1,5,3,16,21,3,5,1,3,6,5,1,6,9,26,3,4,
2,3,1,2,15,4,8,3,7,11,1,9,12,5,13,5,6,1,5,4,9,2,19,5,15,1,9,3,3,9,18,12,9,5,10,2,7,5,1,5,6,6,12,12,
6,12,1,6,11,3,7,2,3,3,4,3,14,4,6,5,6,3,1,5,4,2,12,7,8,13,2,13,14,9,1,6,5,9,1,5,12,3,4,8,3,22,2,3,1,
5,6,4,6,14,22,9,3,2,6,7,6,6,5,1,17,3,3,1,3,5,21,6,3,1,9,2,3,1,6,6,14,10,9,2,28,2,3,6,1,17,6,7,2,6,4,
17,3,1,12,2,6,6,1,17,3,15,4,8,6,21,3,25,3,12,3,3,2,4,5,4,9,5,6,1,3,12,21,8,1,9,9,3,12,12,18,6,6,5,1,
3,2,9,6,9,4,12,2,25,3,3,5,15,1,5,1,14,13,3,5,9,6,7,2,4,6,18,2,9,24,10,6,14,7,3,5,3,3,40,9,2,1,14,1,
32,1,2,19,3,2,1,29,10,3,2,13,3,2,3,4,11,22,2,3,15,7,5,3,6,1,5,13,2,4,2,7,5,3,4,11,19,8,6,4,3,5,3,12,
3,7,3,11,4,9,5,3,4,5,3,1,14,6,4,8,24,6,7,21,2,4,5,4,5,6,3,6,7,12,8,28,15,11,4,11,1,9,15,3,2,4,5,6,
13,11,9,1,12,15,2,10,3,5,4,11,7,3,12,2,3,7,6,2,10,6,6,9,2,3,6,13,15,2,39,1,5,9,22,2,3,7,15,2,10,18,
8,9,4,17,3,1,18,15,2,4,11,3,28,3,6,8,3,3,4,2,10,11,10,14,4,5,1,18,5,6,1,18,2,1,5,3,15,7,2,3,4,3,6,2,
3,1,9,6,9,5,6,3,7,3,2,9,7,5,7,12,5,3,6,12,4,8,6,19,2,1,2,25,3,17,1,5,9,3,10,2,1,6,6,2,10,8,7,3,3,2,
7,5,3,4,3,8,3,21,1,3,6,5,3,12,1,15,5,3,12,18,4,17,9,6,6,7,8,4,9,5,7,3,6,11,3,4,3,3,5,4,3,2,6,6,1,2,
7,5,13,6,2,3,10,11,3,3,4,6,2,10,2,3,12,1,14,3,12,1,12,21,15,5,4,12,5,4,5,7,9,6,8,4,3,14,13,5,1,20,1,
5,9,1,8,7,23,3,7,2,4,5,7,2,13,2,6,7,3,6,11,22,21,6,18,2,4,11,6,12,6,12,10,12,11,7,3,2,7,11,10,14,27,
1,5,15,3,4,5,7,3,2,19,11,3,3,7,2,9,4,5,3,12,10,6,2,3,1,8,13,2,3,7,2,3,3,4,3,3,8,7,18,2,10,2,6,6,1,3,
11,1,2,1,5,7,8,6,16,18,5,10,2,3,1,3,2,1,14,6,7,3,2,3,4,14,19,6,14,10,2,1,14,1,3,9,2,13,6,2,3,9,1,11,
18,3,18,1,11,3,1,14,19,20,1,12,3,5,4,17,10,11,3,1,6,8,6,6,7,6,20,4,5,1,5,12,3,1,5,6,4,3,2,1,12,2,3,
1,11,13,12,3,3,8,9,3,3,12,15,3,4,2,1,3,6,5,3,6,1,6,2,12,10,14,15,4,2,13,5,1,2,7,2,3,7,14,1,3,3,15,9,
5,1,2,12,4,9,5,12,3,6,7,12,2,3,15,3,10,12,6,2,3,4,2,1,2,10,2,3,6,4,3,5,3,7,14,4,6,11,9,6,3,19,6,9,6,
21,9,2,10,8,24,16,9,5,1,2,4,6,3,12,5,12,6,7,3,2,3,4,6,6,18,3,3,5,4,5,13,9,15,11,13,2,12,6,7,12,3,14,
4,6,8,6,4,23,4,5,6,7,3,2,1,11,16,23,4,3,5,12,1,2,9,9,1,11,9,9,9,1,11,6,4,3,11,16,3,2,9,4,3,8,15,6,1,
9,6,9,11,3,6,1,9,3,5,1,14,1,14,1,6,5,13,2,3,3,3,1,5,30,4,5,1,21,18,5,1,14,6,6,12,7,3,11,9,3,18,1,9,
5,6,6,4,3,3,12,3,5,7,12,8,16,14,1,17,4,9,9,2,28,6,2,3,24,1,9,2,9,4,6,2,3,10,6,11,3,1,3,12,14,1,5,6,
10,5,10,3,2,19,3,20,7,5,1,2,6,1,9,12,2,28,2,7,5,3,16,6,5,1,3,6,5,21,7,17,4,11,6,4,9,2,4,9,5,12,7,3,
9,3,15,2,1,3,2,18,1,11,9,1,2,7,5,6,9,6,18,10,6,9,6,3,3,2,3,7,5,1,5,1,8,25,20,12,3,1,12,2,1,2,4,6,20,
3,1,3,2,1,8,15,4,6,2,18,4,6,2,4,3,2,3,13,2,7,6,29,1,5,7,6,2,4,14,1,3,11,7,8,4,11,1,14,4,5,10,2,25,5,
3,13,3,2,7,18,5,12,15,6,1,6,2,1,2,4,6,3,15,9,3,2,6,6,1,33,24,6,5,7,9,14,1,3,2,15,1,14,3,13,12,12,18,
2,24,19,2,9,1,6,2,10,5,18,3,1,3,3,2,10,6,17,4,11,12,7,3,6,5,12,3,4,3,2,3,3,4,3,3,12,18,5,1,8,16,6,5,
1,5,9,1,2,3,4,5,1,3,5,19,5,1,9,18,8,12,3,1,15,5,6,7,3,12,5,3,19,6,3,6,5,3,1,12,8,1,3,11,4,8,4,8,3,4,
3,3,8,7,2,12,24,6,18,1,11,6,7,8,7,2,1,2,16,2,3,1,5,1,9,9,5,4,2,3,3,13,12,2,6,7,2,1,6,5,3,3,18,4,3,
14,3,16,6,3,6,2,3,1,3,2,10,11,7,2,9,6,1,3,5,10,2,9,10,9,9,2,1,9,6,2,6,9,3,10,3,2,9,10,23,21,6,6,4,3,
2,1,2,6,1,9,21,3,2,9,7,5,3,7,3,5,1,6,3,2,28,17,4,8,18,3,4,2,3,12,3,1,12,5,3,12,7,27,3,3,2,21,16,11,
4,9,9,2,4,2,9,10,8,6,1,9,14,1,5,12,10,8,7,9,14,1,6,2,15,7,8,1,17,4,3,11,7,5,4,3,5,13,3,2,4,3,2,19,6,
3,11,6,1,12,8,13,12,2,10,3,2,15,3,4,6,14,9,4,2,4,14,7,8,1,5,22,3,5,9,3,4,3,6,29,6,7,2,13,3,11,1,2,3,
18,6,16,9,5,3,3,3,9,3,3,1,3,3,2,18,3,9,7,9,11,4,9,8,19,3,3,2,12,1,3,6,8,7,11,3,6,18,3,3,4,3,2,12,1,
8,1,6,5,10,2,6,6,13,3,17,1,2,4,11,7,17,3,13,2,16,9,6,2,4,9,6,20,1,20,4,6,14,1,5,7,20,25,6,5,1,15,3,
2,6,3,4,8,9,15,6,10,9,6,2,6,9,3,4,6,9,3,2,16,5,4,15,3,6,11,4,11,4,5,4,3,2,3,9,15,13,2,4,2,4,15,6,8,
7,9,3,2,3,6,1,3,2,1,3,15,9,6,5,1,3,5,1,5,34,5,7,23,3,13,5,1,9,9,2,4,12,5,9,10,23,1,2,7,2,4,5,9,1,11,
3,6,9,7,3,3,5,7,2,1,5,7,6,6,21,3,9,2,9,6,1,3,12,5,3,1,9,5,10,11,6,10,2,3,4,5,10,5,18,3,3,24,1,6,8,7,
8,7,8,1,21,3,5,3,7,3,3,2,3,27,12,1,5,7,9,8,6,1,21,3,9,2,4,6,9,2,10,9,3,3,3,11,6,4,6,5,7,3,8,6,1,2,1,
20,7,2,7,3,5,1,15,6,11,4,5,39,4,6,9,6,14,6,1,5,3,3,10,3,35,31,8,3,7,2,3,3,9,1,5,3,7,2,1,9,2,10,11,3,
1,5,10,6,2,1,24,6,5,4,2,3,15,1,20,7,9,5,13,11,1,5,4,2,9,1,5,12,7,11,3,1,3,2,1,17,3,4,6,8,4,17,1,3,6,
3,21,14,1,12,5,4,3,3,14,4,2,3,9,7,5,3,18,10,18,5,1,6,2,6,7,3,9,12,15,3,12,5,10,8,1,11,1,8,4,6,17,13,
9,11,9,12,1,2,6,7,5,10,5,9,4,6,5,6,7,12,24,20,4,2,19,9,2,4,2,19,15,9,2,7,11,6,1,15,24,3,8,3,10,11,4,
5,1,24,11,4,11,13,20,7,6,20,3,7,3,2,12,21,4,3,5,13,11,4,5,1,20,18,10,5,16,2,10,8,1,6,3,2,3,7,9,5,16,
9,3,8,4,8,1,5,9,6,1,14,12,7,3,3,5,4,2,6,7,6,2,3,16,8,13,2,1,11,3,3,7,2,4,5,4,6,17,7,3,3,2,7,5,6,7,5,
10,12,3,14,4,14,3,19,3,2,18,6,12,4,3,17,10,5,9,7,14,4,5,7,8,1,5,3,10,11,4,12,5,6,3,4,8,4,3,20,6,16,
3,2,9,4,3,12,11,9,1,2,7,6,6,5,9,1,11,3,1,6,5,3,7,12,5,25,5,1,12,8,4,5,16,11,1,17,1,5,9,21,10,6,8,3,
4,5,21,7,6,12,2,12,4,11,3,10,11,12,3,6,1,5,4,15,6,5,3,7,8,7,2,6,9,6,1,23,7,11,7,11,1,8,25,5,3,9,4,
12,9,5,3,3,3,4,5,13,17,1,17,7,2,15,1,3,6,3,2,9,9,1,12,2,6,1,6,17,12,16,9,5,3,1,2,4,3,11,6,15,4,2,4,
6,18,5,4,6,2,4,3,11,9,12,9,6,36,7,2,6,4,3,6,2,19,3,3,9,6,5,4,11,4,3,2,1,3,2,9,19,2,25,2,1,5,1,8,10,
2,28,5,15,1,12,5,7,2,4,11,3,1,6,11,9,4,9,8,7,2,3,3,3,4,3,5,12,13,2,15,7,3,3,3,2,10,2,3,9,3,15,6,1,5,
3,12,4,14,13,39,3,3,3,5,1,5,9,1,6,3,2,19,5,18,7,5,3,6,4,8,19,14,1,3,5,7,11,10,23,9,6,6,3,15,3,10,5,
9,4,9,8,7,15,3,8,1,3,11,1,6,9,6,2,10,3,3,9,17,13,11,9,1,20,6,1,2,18,3,4,2,15,9,4,5,10,3,9,5,4,12,2,
3,9,1,17,7,9,9,8,3,9,12,1,3,6,3,3,20,9,1,9,3,2,6,12,31,2,7,3,2,7,3,3,12,6,6,11,3,1,9,2,3,6,1,2,13,9,
6,8,19,2,10,5,4,2,12,1,11,1,9,9,5,1,6,8,4,2,6,10,5,12,7,6,9,5,10,8,1,5,4,23,3,7,9,3,6,9,3,2,12,9,1,
11,3,4,2,1,2,6,7,14,3,10,5,3,7,5,1,5,4,2,10,6,5,7,11,6,6,9,1,12,5,25,5,13,2,1,2,10,5,4,5,4,12,9,3,2,
3,18,3,7,8,6,4,5,4,11,4,2,1,3,14,15,30,13,5,3,7,15,3,14,10,2,16,3,15,6,8,1,2,3,7,5,9,6,37,3,9,3,5,1,
6,11,3,4,2,13,17,4,17,3,1,8,3,18,1,8,6,6,1,12,15,3,2,3,15,24,19,9,11,1,6,20,4,8,3,4,6,2,6,6,16,3,2,
19,3,3,5,12,3,7,12,6,9,5,1,3,12,9,8,3,4,5,9,16,9,2,12,1,12,3,11,1,15,9,3,2,6,13,6,8,7,3,15,2,3,7,15,
14,1,3,2,4,15,6,3,6,5,4,6,5,6,9,7,5,4,3,5,6,4,6,2,3,6,25,15,6,2,7,9,6,5,9,6,13,2,1,2,1,14,1,2,27,6,
7,8,15,10,2,7,12,3,6,2,7,6,2,3,6,1,14,3,3,3,6,3,7,6,5,12,3,13,6,6,9,3,11,16,5,6,3,4,6,14,1,14,6,1,9,
9,6,11,3,1,2,7,8,10,18,6,5,3,6,10,14,21,1,6,5,4,6,12,2,4,6,3,15,6,2,4,3,3,2,6,7,5,7,2,31,2,3,7,5,6,
1,6,2,1,2,19,29,1,6,3,5,6,1,12,20,6,1,3,2,15,4,11,1,12,3,5,3,9,1,9,8,3,25,17,3,7,2,3,4,5,1,14,15,13,
5,1,5,4,2,4,6,15,5,1,8,10,2,7,3,5,19,11,4,3,5,12,4,2,3,1,3,2,13,6,9,2,4,6,8,13,2,6,9,15,7,3,3,5,3,4,
3,3,2,10,2,3,4,3,2,19,2,3,4,23,3,1,8,3,4,6,17,1,21,8,15,6,6,1,2,13,14,1,3,5,24,13,3,6,5,1,8,6,13,3,
2,3,15,3,4,17,3,1,5,1,11,18,7,8,9,3,3,1,6,3,2,9,1,2,7,14,1,6,3,6,8,7,6,2,3,3,9,6,7,12,3,14,9,10,2,3,
10,17,9,3,12,6,7,8,13,2,4,11,4,5,10,5,6,3,9,6,27,9,3,7,3,5,13,2,1,11,1,2,13,2,10,17,1,9,8,1,2,13,5,
6,1,14,4,6,8,7,20,3,3,15,3,1,21,3,6,9,14,3,13,11,6,4,5,3,1,2,13,2,3,24,1,14,3,3,10,5,21,4,24,2,1,3,
12,2,1,11,6,15,3,6,6,4,5,6,7,11,1,3,3,3,5,7,5,18,36,10,6,12,3,2,6,16,3,8,7,23,9,3,1,5,1,21,8,16,3,
11,7,3,2,7,8,9,3,1,2,3,10,11,21,4,3,8,3,4,6,5,4,2,15,13,3,9,5,1,3,6,11,12,10,6,12,17,16,2,9,46,5,3,
9,1,6,15,8,3,12,1,11,13,3,2,12,4,5,7,3,17,3,10,5,7,9,5,1,3,9,5,21,9,3,4,3,2,10,6,8,10,5,7,9,6,2,16,
5,6,18,7,6,3,15,5,7,2,6,4,2,1,2,6,12,3,7,2,1,17,4,6,2,6,4,23,3,6,6,9,6,7,15,20,10,3,2,7,6,3,5,1,5,
10,23,21,7,2,10,6,5,10,2,15,3,4,2,13,3,2,10,5,1,2,3,16,3,3,14,9,1,6,20,9,1,3,15,2,4,6,3,12,2,13,3,
14,6,21,19,9,3,14,3,12,4,5,1,8,6,15,9,3,4,8,1,6,3,5,1,2,18,1,5,3,1,11,10,3,8,9,1,3,20,4,11,1,15,11,
10,2,12,1,3,15,6,5,3,1,12,3,27,3,6,3,3,39,5,6,7,6,6,3,3,3,5,1,20,15,1,3,12,2,1,29,3,9,4,45,9,5,3,7,
6,2,12,3,9,3,6,1,5,4,12,9,3,11,12,4,5,3,6,1,11,10,8,7,2,1,5,4,2,1,8,4,11,4,5,1,29,13,9,5,6,10,5,3,1,
5,1,20,4,3,11,4,3,14,15,3,10,2,3,7,11,10,3,2,13,5,9,1,2,4,33,3,18,2,7,2,4,2,7,2,9,9,6,6,4,14,3,12,7,
3,11,9,25,3,2,3,13,6,5,1,14,10,9,2,3,24,3,4,9,6,5,1,14,3,3,4,6,2,3,4,6,5,3,10,15,5,7,9,3,11,16,3,8,
7,6,2,3,19,11,4,11,10,12,5,9,1,5,3,4,15,2,1,14,6,10,3,5,4,5,6,1,11,4,5,3,6,7,3,11,1,3,9,8,10,2,6,4,
5,1,12,2,1,2,4,5,13,2,4,9,5,7,3,6,2,7,12,6,14,3,6,6,1,8,1,3,6,9,3,17,6,16,5,9,21,3,3,10,27,18,5,3,7,
17,6,4,3,2,27,1,2,1,6,9,6,6,9,3,12,20,9,6,9,4,6,2,9,3,7,8,40,11,1,23,7,11,4,15,3,12,5,1,23,10,2,12,
12,4,5,4,6,5,6,9,7,12,11,1,6,14,6,9,4,9,3,3,5,6,9,1,9,9,2,21,13,2,7,8,3,1,6,2,15,6,7,3,5,9,3,9,1,3,
5,4,5,1,29,1,5,1,3,17,4,17,4,6,15,9,15,3,5,3,10,8,10};

