% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_ra.R
\name{declare_ra}
\alias{declare_ra}
\title{Declare a random assignment procedure.}
\usage{
declare_ra(N = NULL, prob = NULL, num_arms = NULL, prob_each = NULL,
  m = NULL, m_each = NULL, block_var = NULL, block_m = NULL,
  clust_var = NULL, condition_names = NULL, simple = FALSE)
}
\arguments{
\item{N}{The total number of units in the experimental sample.}

\item{prob}{The probability of assignment to treatment. If specified, a two-group design is assumed.}

\item{num_arms}{The total number of treatment arms. If unspecified, will be determined from the number of columns of block_m, the length of prob_each, the length of m_each, or the length of condition_names.}

\item{prob_each}{A numeric vector giving the probability of assignment to each treatment arm. Must sum to 1. Please note that due to rounding, these probabilities are approximate. For finer control, please use m_each.}

\item{m}{If specified, a two-group design is assumed. m is the total number of units to be assigned to treatment. Should only be specified for a two group design in which exactly m of N units are assigned to treatment. If not specified (and no other arguments are specified), half of the sample (N/2) will be assigned to treatment (if N is odd, m will be set to either floor(N/2) or ceiling(N/2) with equal probability). m is NULL by default.}

\item{m_each}{A numeric vector giving the size of each treatment group. Must sum to N. If unspecified, equally sized (rounded) groups will be assumed.}

\item{block_var}{A vector of length N indicating which block each unit belongs to.}

\item{block_m}{A matrix of arm sizes with blocks in the rows and treatment conditions in the columns. The rows should respect the alphabetical ordering of the blocks as determined by sort(unique(block_var)). The columns should be in the order of condition_names, if specified.}

\item{clust_var}{A vector of length N that indicates which cluster each unit belongs to.}

\item{condition_names}{A character vector giving the names of the treatment groups. If unspecified, the treatment groups will be names T1, T2, T3, etc.}

\item{simple}{A logical indicating if simple random assignment is intended. Is FALSE by default.}
}
\value{
A random assignment declaration
}
\description{
Declare a random assignment procedure.
}
\examples{

# The declare_ra function is used in three ways:

# 1. To obtain some basic facts about a randomization:
declaration <- declare_ra(N=100, m_each=c(30, 30, 40))
declaration

# 2. To conduct a random assignment:

Z <- conduct_ra(declaration)
table(Z)

# 3. To obtain observed condition probabilities

probs <- obtain_condition_probabilities(declaration, Z)
table(probs, Z)

# Simple Random Assignment Declarations

declare_ra(N=100, simple = TRUE)
declare_ra(N=100, prob = .4, simple = TRUE)
declare_ra(N=100, prob_each=c(0.3, 0.3, 0.4), 
           condition_names=c("control", "placebo", "treatment"), simple=TRUE)

# Complete Random Assignment Declarations
 
declare_ra(N=100)  
declare_ra(N=100, m_each = c(30, 70), 
           condition_names = c("control", "treatment"))
declare_ra(N=100, m_each=c(30, 30, 40))
  
  
# Block Random Assignment Declarations 

block_var <- rep(c("A", "B","C"), times=c(50, 100, 200))

block_m <- rbind(c(10, 40),
                 c(30, 70),
                 c(50, 150))
declare_ra(block_var=block_var, block_m=block_m)


# Cluster Random Assignment Declarations

clust_var <- rep(letters, times=1:26)
declare_ra(clust_var=clust_var)
declare_ra(clust_var=clust_var, m_each=c(7, 7, 12))

# Blocked and Clustered Random Assignment Declarations 

clust_var <- rep(letters, times=1:26)
block_var <- rep(NA, length(clust_var))
block_var[clust_var \%in\% letters[1:5]] <- "block_1"
block_var[clust_var \%in\% letters[6:10]] <- "block_2"
block_var[clust_var \%in\% letters[11:15]] <- "block_3"
block_var[clust_var \%in\% letters[16:20]] <- "block_4"
block_var[clust_var \%in\% letters[21:26]] <- "block_5"

table(block_var, clust_var)

declare_ra(clust_var = clust_var, block_var = block_var)
declare_ra(clust_var = clust_var, block_var = block_var, prob_each = c(.2, .5, .3))
  
}

