## ----echo=FALSE----------------------------------------------------------
library("knitr")
hook_output <- knitr::knit_hooks$get("output")
knitr::knit_hooks$set(output = function(x, options) {
   lines <- options$output.lines
   if (is.null(lines)) {
     return(hook_output(x, options))  # pass to default hook
   }
   x <- unlist(strsplit(x, "\n"))
   more <- "..."
   if (length(lines)==1) {        # first n lines
     if (length(x) > lines) {
       # truncate the output, but add ....
       x <- c(head(x, lines), more)
     }
   } else {
     x <- c(if (abs(lines[1])>1) more else NULL,
            x[lines],
            if (length(x)>lines[abs(length(lines))]) more else NULL
           )
   }
   # paste these lines together
   x <- paste(c(x, ""), collapse = "\n")
   hook_output(x, options)
 })

knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE----------------------------------------------------------
#  install.packages("randgeo")

## ----eval=FALSE----------------------------------------------------------
#  devtools::install_github("ropensci/randgeo")

## ------------------------------------------------------------------------
library("randgeo")

## ------------------------------------------------------------------------
rg_position()

## ------------------------------------------------------------------------
rg_position(10)

## ------------------------------------------------------------------------
rg_position(bbox = c(50, 50, 60, 60))

## ------------------------------------------------------------------------
wkt_point()

## ------------------------------------------------------------------------
wkt_point(count = 10)

## ------------------------------------------------------------------------
wkt_point(bbox = c(50, 50, 60, 60))

## ------------------------------------------------------------------------
wkt_point()
wkt_point(fmt = 10)

## ------------------------------------------------------------------------
wkt_polygon()

## ------------------------------------------------------------------------
wkt_polygon(num_vertices = 4)

## ------------------------------------------------------------------------
wkt_polygon(max_radial_length = 5)

## ------------------------------------------------------------------------
wkt_polygon(bbox = c(-130, 50, -120, 60))

## ------------------------------------------------------------------------
geo_point()

## ----output.lines=1:10---------------------------------------------------
geo_point(count = 10)

## ------------------------------------------------------------------------
geo_point(bbox = c(50, 50, 60, 60))

## ------------------------------------------------------------------------
geo_polygon()

## ------------------------------------------------------------------------
geo_polygon(num_vertices = 4)

## ------------------------------------------------------------------------
geo_polygon(max_radial_length = 5)

## ------------------------------------------------------------------------
geo_polygon(bbox = c(-130, 50, -120, 60))

