% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rake_functions.R
\name{weight}
\alias{weight}
\title{weight}
\usage{
weight(cons, inds, vars = NULL, iterations = 10)
}
\arguments{
\item{cons}{A data frame containing all the constraints. This
should be in the format of one row per zone, one column per constraint
category. The first column should be a zone code; all other columns must be
numeric counts.}

\item{inds}{A data frame containing individual--level (survey) data. This
should be in the format of one row per individual, one column per
constraint. The first column should be an individual ID.}

\item{vars}{A character vector of variables that constrain the simulation
(i.e. independent variables)}

\item{iterations}{The number of iterations the algorithm should complete.
Defaults to 10}
}
\value{
A data frame of fractional weights for each individual in each zone
with zone codes recorded in column names and individual id recorded in row
names.
}
\description{
Produces fractional weights using the iterative proportional fitting
algorithm.
}
\details{
The first column of each data frame should be an ID. The first column of
\code{cons} should contain the zone codes. The first column of \code{inds}
should contain the individual unique identifier.

Both data frames should only contain:
\itemize{
  \item an ID column (zone ID \code{cons} or individual ID \code{inds}).
  \item constraints \code{inds} or constraint category \code{cons}.
  \item \code{inds} can optionally contain additional dependent variables
  that do not influence the weighting process.
}

No other columns should be present (the user can merge these back in later).

It is essential that the levels in each \code{inds} constraint (i.e. column)
match exactly with the column names in \code{cons}. In the example below see
how the column names in cons (\code{'a0_49', 'f', ...}) match exactly the
levels in \code{inds} variables.

The columns in \code{cons} must be in alphabetical order because these are
created alphabetically when they are 'spread' in the individual--level data.
}
\examples{
# SimpleWorld
cons <- data.frame(
"zone"   = letters[1:3],
"a0_49"  = c(8, 2, 7),
"a_gt50" = c(4, 8, 4),
"f"      = c(6, 6, 8),
"m"      = c(6, 4, 3),
stringsAsFactors = FALSE
)
inds <- data.frame(
"id"     = LETTERS[1:5],
"age"    = c("a_gt50", "a_gt50", "a0_49", "a_gt50", "a0_49"),
"sex"    = c("m", "m", "m", "f", "f"),
"income" = c(2868, 2474, 2231, 3152, 2473),
stringsAsFactors = FALSE
)
# Set variables to constrain over
vars <- c("age", "sex")
weights <- weight(cons = cons, inds = inds, vars = vars)
print(weights)
}
