% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rags2ridges.R
\name{symm}
\alias{symm}
\title{Symmetrize matrix}
\usage{
symm(M)
}
\arguments{
\item{M}{(In numeric ideality symmetric) square \code{matrix}.}
}
\value{
A symmetric \code{matrix}.
}
\description{
Function that symmetrizes matrices.
}
\details{
Large objects that are symmetric sometimes fail to be recognized as such by
R due to rounding under machine precision. This function symmetrizes for
computational purposes matrices that are symmetric in numeric ideality.
}
\examples{

## Obtain some (high-dimensional) data
p = 25
n = 10
set.seed(333)
X = matrix(rnorm(n*p), nrow = n, ncol = p)
colnames(X)[1:25] = letters[1:25]

## Obtain regularized precision under optimal penalty
OPT <- optPenalty.LOOCV(X, 10, 30, 10, target = diag(diag(1/covML(X))))

## Check symmetry
## OPT$optPrec is symmetric by definition
## But is not recognized as such due to rounding peculiarities
isSymmetric(OPT$optPrec)

## Symmetrize
symm(OPT$optPrec)

}
\author{
Carel F.W. Peeters <carel.peeters@wur.nl>, Wessel N. van Wieringen
}
