% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{mutate_ext}
\alias{mutate_ext}
\title{Add tranformed variables to a data frame (NSE)}
\usage{
mutate_ext(.tbl, .funs, ..., .ext = "")
}
\arguments{
\item{.tbl}{Data frame to add transformed variables to}

\item{.funs}{Function(s) to apply (e.g., funs(log))}

\item{...}{Variables to transform}

\item{.ext}{Extension to add for each variable}
}
\description{
Add tranformed variables to a data frame (NSE)
}
\details{
Wrapper for dplyr::mutate_at that allows custom variable name extensions
}
\examples{
mutate_ext(mtcars, funs(log), mpg, cyl, .ext = "_log")
mutate_ext(mtcars, funs(log), .ext = "_log")

}
