% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{hapDendo}
\alias{hapDendo}
\title{Hierarchical clustering of haplotypes graphical output}
\usage{
hapDendo(
  hap_table,
  chain = c("IGH", "IGK", "IGL"),
  gene_sort = c("name", "position"),
  removeIGH = TRUE,
  mark_low_lk = TRUE,
  lk_cutoff = 1
)
}
\arguments{
\item{hap_table}{haplotype summary table. See details.}

\item{chain}{the IG chain: IGH,IGK,IGL. Default is IGH.}

\item{gene_sort}{if by 'name' the genes in the output are ordered lexicographically,
if by 'position' only functional genes are used and are ordered by their chromosomal location. Default is 'position'.}

\item{removeIGH}{if TRUE, 'IGH'\'IGK'\'IGL' prefix is removed from gene names. Defualt is TRUE.}

\item{mark_low_lk}{if TRUE, a texture is add for low lK values. Defualt is TRUE.}

\item{lk_cutoff}{the lK cutoff value to be considerd low for texture layer. Defualt is lK<1.}
}
\value{
A multitple samples visualization of the distances between haplotypes.
}
\description{
The \code{hapDendo} function generates a graphical output of an hierarchical clustering based on the Jaccard distance between multiple samples' haplotypes.
}
\details{
A \code{data.frame} created by \code{createFullHaplotype}.
}
\examples{
# Plotting haplotype hierarchical clustering based on the Jaccard distance
\donttest{hapDendo(samplesHaplotype)}

}
