\name{t_mult}
\alias{t_mult}
\title{Tensor Multiplication (T-MULT)}
\usage{
  t_mult(x, y)
}
\arguments{
  \item{x}{a 3-tensor}

  \item{y}{another 3-tensor}
}
\value{
  tensor product between \code{x} and \code{y}
}
\description{
  Implements T-MULT based on block circulant matrices
  (Kilmer et al. 2013) for 3-tensors.
}
\details{
  Uses the Fast Fourier Transform (FFT) speed up suggested
  by Kilmer et al. 2013 instead of explicitly constructing
  the block circulant matrix. For the mathematical details
  of T-MULT, see Kilmer et al. (2013).
}
\note{
  This only works (so far) between 3-Tensors.
}
\examples{
tnsr <- new("Tensor",3L,c(3L,4L,5L),data=runif(60))
tnsr2 <- new("Tensor",3L,c(4L,3L,5L),data=runif(60))
t_mult(tnsr, tnsr2)
}
\references{
  M. Kilmer, K. Braman, N. Hao, and R. Hoover, "Third-order
  tensors as operators on matrices: a theoretical and
  computational framework with applications in imaging".
  SIAM Journal on Matrix Analysis and Applications 2013.
}

