% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_segment.R
\name{compile_segment}
\alias{compile_segment}
\title{Compile information on a segment}
\usage{
compile_segment(seglist)
}
\arguments{
\item{seglist}{a Strava segment list returned by \code{\link{get_segment}}}
}
\value{
dataframe of all information given in a call from \code{\link{get_segment}}
}
\description{
Compile generation information on a segment
}
\details{
compiles information for a segment
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

# compile segment info
get_segment(stoken, id = 229781) \%>\% compile_segment

# compile top ten leaderboard for the segment
get_segment(stoken, id = 229781, request = "leaderboard") \%>\% compile_segment

# compile all efforts for the authenticated user on the segment
get_segment(stoken, id = 4483903, request = 'all_efforts') \%>\% compile_segment

# compile the starred segments for the user
get_segment(stoken, request = 'starred') \%>\% compile_segment
}
}
\concept{token}
