% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSARP.r
\name{bestsearch}
\alias{bestsearch}
\title{\code{bestsearch} - Optimization of Search for Fixed Number of Searchers}
\usage{
bestsearch(AvailablePeeps = 25, sdirectory = "Sensitivity", FTt = c(1, 2,
  3, 4, 5), STitle = "Search Name", graphs = 2)
}
\arguments{
\item{AvailablePeeps}{- expected headcount of searchers for this operational period}

\item{sdirectory}{- the sub directory within the search directory where the results will be stored for this 'sensitivity' analysis.  Defaults to the "Sensistivity" subdirectory. The function will create a new subdirectory if one doesn't already exist.}

\item{FTt}{- vector of Fast to Thorough parameters to search for this solution. FTt is a parametric version of the relative spacing between team members. Defaults to range of integers 1 thru 5. 1 represents a very Loose Grid search. 5 represents a tight grid approaching.}

\item{STitle}{- string representing the name of the search for use as a title on the graphic output}

\item{graphs}{- integer that controls the level of output from the searchme function - enter 1 for everything, 2 to get everything but the sector graphs, and 3 to skip all but the console output}
}
\value{
This function returns a pdf file containing two graphs in the R working directory.
The first graph shows the area covered and POS achieved as a function of the FtT used to plan the search.
The second graph shows the average spacing for the area covered, the average AMDR used for the plan, and the average inflated AMDR. The average inflated AMDR
is the amount the AMDR would have to increase to increase the POS achieved to the highest observed value in the analysis.
}
\description{
\code{bestsearch()} This function takes a fixed number of searchers and reports the area and POS that could be covered by them.
}
\details{
bestsearch() is an optimization function which is designed to examine the ways that a limited number of searchers can be used to search a given search field. The function repeatedly runs \code{searchme()} and captures the results graphically, displaying the area covered, the maximum POS available, the average AMDR, average team spacing used on the field, and an inflated AMDR value.
The inflated AMDR value is the value the measured AMDR would need to climb to in order to return the highest observed POS for the search plan. This becomes a measure of the 'risk' of missing the subject if a faster search method is used. The AMDR, which is a strictly visual measure of optimal team spacing, can be inflated if the subject can be assumed to be responsive or mobile. This function helps the management team identify the best plan to use for a limited number of searchers.  It becomes the discussion vehicle for how fast to search in a search plan. The function creates a graph displaying the expected search area covered and POS returned for searches across a span of searcher spacings and sector headcounts.
}
\examples{
\dontrun{bestsearch(AvailablePeeps=84, STitle="HighTurnout Alternatives", graphs= 3)}
}
\author{
John F. Hutcheson
}

