% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/show-pref.r
\name{show.pref}
\alias{as.character.preference}
\alias{eval.pref}
\alias{pref.str}
\alias{show.pref}
\title{Partial evaluation and string output of preferences}
\usage{
show.pref(p, df = NULL)

pref.str(p, df = NULL)

eval.pref(p, df = NULL)

\method{as.character}{preference}(x, ...)
}
\arguments{
\item{p,x}{The preference to be shown or partially evaluated.}

\item{df}{(Optional) A dataframe on which the preference operates.}

\item{...}{Optional arguments passed to \code{as.character}.}
}
\description{
Functions to substitute variables and functions in preferences which can be calculated before the preference is evaluated on a dataframe.
This is especially used for string output of preferences.
}
\details{
The function \code{pref.str} (or \code{as.character(p)} for a preference \code{p}) returns the preference string
while \code{show.pref} outputs it directly to the console, preceded by \code{'[Preference]'}.
If \code{df} is specified, then a partial evaluation of the preference is done before converting it to a string.

The function \code{eval.pref} (with given dataframe \code{df}) partially evaluates the internal preference expression and
returns again a preference object. All expressions in \code{p} are evaluated in the environment
where \code{p} was defined, except the the column names in \code{df} (which are potential attributes in \code{p}).
The content of the dataframe \code{df} does not matter; only \code{names(df)} is used to get the "free variables" in \code{p}.
}
\section{Partial evaluation before string output}{


The functions \code{show.pref} and \code{pref.str} have the optinal paramter \code{df}.
If this paramter is given, these functions call \code{eval.pref} before they output/return the preference string.
The following equalities hold:

\itemize{
  \item \code{as.character(eval.pref(p, df)) == pref.str(p, df)}
  \item \code{show(eval.pref(p, df))} produces the same console output as \code{show.pref(p, df)}
}
}
\examples{
f <- function(x) 2*x
p <- true(cyl == f(1))

# prints 'cyl == f(x)'
p

# prints 'cyl == 2'
show.pref(p, mtcars)
eval.pref(p, mtcars)
}

