\name{borderPoint}
\alias{borderPoint}
\title{
Border in the experimental units
}
\description{
Generates the spectral information of the edge of the EUs for analysis of the border effect, it requires the spectral image, the distance of the border and the segmentation of the EUs generated by imageField. 
}
\usage{
borderPoint(r,Rbook,distance,plotting=TRUE,...)
}
\arguments{
  \item{r}{spectral image}
  \item{Rbook}{Object generated by imageField}
  \item{distance}{distance defining the border of the exterior to the experimental plot}
  \item{plotting}{Logic value to display the image of the border effect around the EUs}
  \item{...}{plot parameter to document the image as main, axis, etc}
}
\details{
Set the border in terms of distance in units measured in the field
}
\value{
\item{Qborder}{Border bounds matrix} 
\item{border}{dataframe spectral border and that is expressed in the image.}
}

\author{
Felipe de Mendiburu
}
\seealso{\code{\link{cassava}}, \code{\link{fourPoint}}, \code{\link{imageField}} 
}

\examples{
# use cassava crop information
library(rPAex)
data(cassava)
r <- terra::rast(cassava,type="xyz")
# cassava area
# Apply locator(3) to generate 3 points in the area
p<-list(x=c(287689.4, 287702.8, 287706.2),y=c(8664210, 8664214, 8664179))
# Generate the fourth points of the area
q<-fourPoint(p)
op<-par(mfrow=c(1,2))
terra::image(r,axes=FALSE, main="Image crop")
axis(1); axis(2)
# The area is divided into 3x2 plots of 11x6 meters per experimental unit
Rbook<-imageField(r,q,3,2,11,6,plotting=TRUE)
out<-borderPoint(r,Rbook,distance=1, main="Border Points",axes=FALSE)
axis(1); axis(2)
par(op)
# NDVI in border
op<-par(mfrow=c(1,1))
ndvi<-with(out$Border, (L1-L2)/(L1+L2))
# NDVI > 0.5 more probability of vegetation
plt<-out$Border[ndvi>0.5,1:2]
w<-terra::rast(out$Border)
terra::image(w,main="Vegetation on the boundary (NDVI > 0.5)",axes=FALSE)
axis(1); axis(2)
points(plt,cex=0.2,col=colors()[51],pch=20)
par(op)
}
\keyword{ design }
\keyword{ dplot }

