% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cv}
\alias{cv}
\title{Calculate coefficient of variation (CV)}
\usage{
cv(x, times, overall = TRUE, interval = 1)
}
\arguments{
\item{x}{vector of glucose readings}

\item{times}{vector of corresponding times, in minutes}

\item{overall}{a logical, equal to TRUE you want the CV for the entire dataset, or equal to FALSE if you would prefer many CV values over a moving window}

\item{interval}{size (in hours) of the moving window to be used if overall is false. Null value is 1.}
}
\value{
Either a numeric coefficient of variation over the entire dataset or a vector of CV values over windows of the data.
}
\description{
Calculate coefficient of variation (CV)
}
\examples{
cv(x=c(rep(100, 10), rep(120, 10), 105, 85), times=seq(0, 1260, 60), overall=TRUE)
}
