% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.points.R
\name{ena.plot.points}
\alias{ena.plot.points}
\title{Plot points on an ENAplot}
\usage{
ena.plot.points(enaplot, points = NULL, point.size = 5, labels = NULL,
  label.offset = NULL, label.group = "Points", label.font.size = NULL,
  label.font.color = NULL, label.font.family = NULL, shape = c("circle",
  "square", "triangle-up", "diamond"), colors = default.colors[1],
  confidence.interval.values = NULL, confidence.interval = c("none",
  "crosshairs", "box"), outlier.interval.values = NULL,
  outlier.interval = c("none", "crosshairs", "box"), show.legend = T, ...)
}
\arguments{
\item{enaplot}{\code{\link{ENAplot}} object to use for plotting}

\item{points}{A dataframe of matrix where the first two column are X and Y coordinates}

\item{point.size}{A data.frame or matrix where the first two column are X and Y coordinates of points to plot in a projected ENA space defined in ENAplot}

\item{labels}{A character vector of point labels, length nrow(points); default: NULL}

\item{label.offset}{numeric vector - x and y value to offset labels from the coordinates of the points}

\item{label.group}{A character vector used to group the labels in the legend}

\item{label.font.size}{An integer which determines the font size for point labels, default: enaplot$font.size}

\item{label.font.color}{A character which determines the color of label font, default: enaplot$font.color}

\item{label.font.family}{A character which determines label font type, choices: Arial, Courier New, Times New Roman, default: enaplot$font.family}

\item{shape}{A character which determines the shape of point markers, choices:   square, triangle, diamond, circle, default: circle}

\item{colors}{A character vector of the point marker colors; if one given it is used for all, otherwise must be same length as points; default: black}

\item{confidence.interval.values}{A matrix/dataframe where columns are CI x and y values for each point}

\item{confidence.interval}{A character determining markings to use for confidence intervals, choices: none, box, crosshair, default: none}

\item{outlier.interval.values}{A matrix/dataframe where columns are OI x and y values for each point}

\item{outlier.interval}{A character determining markings to use for outlier interval, choices: none, box, crosshair, default: none}

\item{show.legend}{Logical indicating whether to show the point labels in the in legend}

\item{...}{additional parameters addressed in inner function}
}
\value{
\code{\link{ENAplot}} The ENAplot provided to the function, with its plot updated to include the new points.
}
\description{
Plot all or a subset of the points of an ENAplot using the plotly plotting library
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum,
  rotation.by = ena.rotate.by.mean,
  rotation.params = list(
      accum$metadata$Condition=="FirstGame",
      accum$metadata$Condition=="SecondGame"
  )
)

plot = ena.plot(set)

group1.points = set$points.rotated[set$enadata$units$Condition == "FirstGame",]
group2.points = set$points.rotated[set$enadata$units$Condition == "SecondGame",]
plot = ena.plot.points(plot, points = group1.points);
plot = ena.plot.points(plot, points = group2.points);
print(plot);

}
\seealso{
\code{\link{ena.plot}}, \code{\link{ENAplot}}, \code{\link{ena.plot.group}}
}
\keyword{ENA,}
\keyword{plot,}
\keyword{points}

