% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.als.R
\name{sim.als}
\alias{sim.als}
\title{Simulate Allele Frequencies}
\usage{
sim.als(n = 500, nrun = 10000, res = 0.001, plot = TRUE)
}
\arguments{
\item{n}{desired populations size (set this value same as your actual
population size for an accurate simulation)}

\item{nrun}{number of simulations to run on each allele frequency.
The higher this number, the closer the simulations will be to the
theoretical values (at the cost of computer power); 10000 is an optimal value.}

\item{res}{desired resolution of the theoretical allele frequency}

\item{plot}{logical. whether to plot the simulation}
}
\value{
A list of two matrices:
\enumerate{
\item allele_freqs: theoretical allele frequency
\item simulated_freqs: simulated frequencies at different confidence intervals
}
}
\description{
This function simulates allele frequencies of a desired population size
under HWE
}
\examples{
\dontrun{alleles <- sim.als(n=200,nrun=1000,res=0.001,plot=TRUE)}

}
\author{
Piyal Karunarathne, Pascal Milesi
}
