/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.CSVParser;
import com.opencsv.CSVReader;
import java.io.Reader;

public class CSVReaderBuilder {
    private final Reader reader;
    private int skipLines = 0;
    private CSVParser csvParser = null;
    private boolean keepCR;
    private boolean verifyReader = true;

    public CSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        this.reader = reader;
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected int getSkipLines() {
        return this.skipLines;
    }

    protected CSVParser getCsvParser() {
        return this.csvParser;
    }

    public CSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    public CSVReaderBuilder withCSVParser(CSVParser csvParser) {
        this.csvParser = csvParser;
        return this;
    }

    public CSVReader build() {
        CSVParser parser = this.csvParser != null ? this.csvParser : new CSVParser();
        return new CSVReader(this.reader, this.skipLines, parser, this.keepCR, this.verifyReader);
    }

    public CSVReaderBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    protected boolean keepCarriageReturn() {
        return this.keepCR;
    }

    public CSVReaderBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }
}

