% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amPieChart.R
\name{amPieChart}
\alias{amPieChart}
\title{HTML widget displaying a pie chart}
\usage{
amPieChart(
  data,
  category,
  value,
  innerRadius = 0,
  threeD = FALSE,
  depth = ifelse(variableDepth, 100, 10),
  colorStep = 3,
  variableRadius = FALSE,
  variableDepth = FALSE,
  chartTitle = NULL,
  theme = NULL,
  backgroundColor = NULL,
  legend = TRUE,
  caption = NULL,
  image = NULL,
  width = NULL,
  height = NULL,
  export = FALSE,
  chartId = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{a dataframe}

\item{category}{name of the column of \code{data} to be used as the
category}

\item{value}{name of the column of \code{data} to be used as the value}

\item{innerRadius}{the inner radius of the pie chart in percent}

\item{threeD}{whether to render a 3D pie chart}

\item{depth}{for a 3D chart, this parameter controls the height of the
slices}

\item{colorStep}{the step in the color palette}

\item{variableRadius}{whether to render slices with variable radius}

\item{variableDepth}{for a 3D chart, whether to render slices with
variable depth}

\item{chartTitle}{chart title, it can be \code{NULL} or \code{FALSE} for no
title, a character string,
a list of settings created with \code{\link{amText}}, or a list with two
fields: \code{text}, a list of settings created with \code{\link{amText}},
and \code{align}, can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{theme}{theme, \code{NULL} or one of \code{"dataviz"},
\code{"material"}, \code{"kelly"}, \code{"dark"}, \code{"moonrisekingdom"},
\code{"frozen"}, \code{"spiritedaway"}, \code{"patterns"},
\code{"microchart"}}

\item{backgroundColor}{a color for the chart background; it can be
given by the name of a R color, the name of a CSS color, e.g.
\code{"lime"} or \code{"olive"}, an HEX code like
\code{"#ff009a"}, a RGB code like \code{"rgb(255,100,39)"}, or a HSL code
like \code{"hsl(360,11,255)"}}

\item{legend}{either a logical value, whether to display the legend, or
a list of settings for the legend created with \code{\link{amLegend}}}

\item{caption}{\code{NULL} or \code{FALSE} for no caption, a formatted
text created with \code{\link{amText}}, or a list with two fields:
\code{text}, a list created with \code{\link{amText}}, and \code{align},
can be \code{"left"}, \code{"right"} or \code{"center"}}

\item{image}{option to include an image at a corner of the chart;
\code{NULL} or \code{FALSE} for no image, otherwise a named list with four
possible fields: the field \code{image} (required) is a list created with
\code{\link{amImage}},
the field \code{position} can be \code{"topleft"}, \code{"topright"},
\code{"bottomleft"} or \code{"bottomright"}, the field \code{hjust}
defines the horizontal adjustment, and the field \code{vjust} defines
the vertical adjustment}

\item{width}{the width of the chart, e.g. \code{"600px"} or \code{"80\%"};
ignored if the chart is displayed in Shiny, in which case the width is
given in \code{\link{amChart4Output}}}

\item{height}{the height of the chart, e.g. \code{"400px"};
ignored if the chart is displayed in Shiny, in which case the height is
given in \code{\link{amChart4Output}}}

\item{export}{logical, whether to enable the export menu}

\item{chartId}{a HTML id for the chart}

\item{elementId}{a HTML id for the container of the chart; ignored if the
chart is displayed in Shiny, in which case the id is given by the Shiny id}
}
\description{
Create a HTML widget displaying a pie chart.
}
\examples{
library(rAmCharts4)
dat <- data.frame(
  country = c(
    "Lithuania", "Czechia", "Ireland", "Germany", "Australia", "Austria"
  ),
  value = c(260, 230, 200, 165, 139, 128)
)
amPieChart(
  data = dat,
  category = "country",
  value = "value",
  variableRadius = TRUE
)

# shiny app demonstrating the options ####
library(rAmCharts4)
library(shiny)

dat <- data.frame(
  country = c(
    "Lithuania", "Czechia", "Ireland", "Germany", "Australia", "Austria"
  ),
  value = c(260, 230, 200, 165, 139, 128)
)

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      sliderInput(
        "innerRadius", "Inner radius", min = 0, max = 60, value = 0, step = 20
      ),
      checkboxInput("variableRadius", "Variable radius", TRUE),
      checkboxInput("threeD", "3D"),
      conditionalPanel(
        "input.threeD",
        checkboxInput("variableDepth", "Variable depth")
      )
    ),
    mainPanel(
      amChart4Output("piechart", height = "500px")
    )
  )
)

server <- function(input, output, session){

  piechart <- reactive({
    amPieChart(
      data = dat,
      category = "country",
      value = "value",
      innerRadius = input[["innerRadius"]],
      threeD = input[["threeD"]],
      variableDepth = input[["variableDepth"]],
      depth = ifelse(input[["variableDepth"]], 300, 10),
      variableRadius = input[["variableRadius"]],
      theme = "dark"
    )
  })

  output[["piechart"]] <- renderAmChart4({
    piechart()
  })
}

if(interactive()){
  shinyApp(ui, server)
}
}
