% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_modules_timeSeries.R
\name{getCurrentStockData}
\alias{getCurrentStockData}
\title{Get data in shiny module}
\usage{
getCurrentStockData(data, col_date, col_series, zoom = NULL,
  maxPoints = 1000, tz = "UTC", ts = c("5 min", "10 min", "30 min",
  "hour", "3 hour", "12 hour", "day", "week", "month", "year"),
  fun_aggr = "mean", treat_missing = FALSE, maxgap = Inf,
  type_aggr = "first")
}
\arguments{
\item{data}{: data.frame to transform}

\item{col_date}{: Date column name, default to "date".
Must be "POSIXct" or "CET24" colum}

\item{col_series}{: Column name of quantitative variable(s) to be
transformed. Default to setdiff(colnames(data), "date")}

\item{zoom}{: List for init subset. NULL to keep all}

\item{maxPoints}{: Maximal number of rows in results}

\item{tz}{: Timezone of result. Defaut to "UTC".}

\item{ts}{: Increment of the sequence. Default to "10 min".
Can be a number, in seconds, or a character string
containing one of "min", "hour", "day".
This can optionally be preceded by a positive integer
and a space}

\item{fun_aggr}{: Aggregation function to use ("min", "max", "sum", "mean", "first", "last").
Default to "mean".}

\item{treat_missing}{: Boolean. Default to FALSE
Whether or not to interpolate missing values ?
see \code{na.approx}}

\item{maxgap}{: When interpolate missing values with \code{na.approx}.
Maximum number of consecutive NAs to fill. Defaut to Inf.}

\item{type_aggr}{: Character. Type of aggregation
\itemize{
 \item{"first"}{ : Date/Time result is equal to minimum of sequence, and this minimum is included in aggregation}
 \item{"last"}{ : Date/Time result is equal to maximum of sequence, and this maximum is included in aggregation}
}}
}
\description{
Get data in shiny module
}
