% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_ChartScrollbar.R,
%   R/class_ChartScrollbar_setters.R
\name{initialize,ChartScrollbar-method}
\alias{initialize,ChartScrollbar-method}
\alias{chartScrollbar}
\alias{chartScrollbarSettings}
\alias{setGraph,ChartScrollbar,AmGraphOrCharacterOrMissing-method}
\alias{setEnabled}
\alias{setEnabled,ChartScrollbar,logical-method}
\title{Initializes a ChartScrollbar}
\usage{
\S4method{initialize}{ChartScrollbar}(.Object, graph, enabled, ...)

chartScrollbar(graph, enabled = TRUE, ...)

chartScrollbarSettings(graph, enabled = TRUE, ...)

\S4method{setGraph}{ChartScrollbar,AmGraphOrCharacterOrMissing}(.Object, graph = NULL, ...)

setEnabled(.Object, enabled)

\S4method{setEnabled}{ChartScrollbar,logical}(.Object, enabled)
}
\arguments{
\item{.Object}{\linkS4class{ChartScrollbar}.}

\item{graph}{\linkS4class{AmGraph}.
Specifies which graph will be displayed in the scrollbar.}

\item{enabled}{\code{logical}, 
specifies if the chart should be updated while dragging/resizing the scrollbar
or only when user releases mouse button.}

\item{...}{other properties of ChartScrollbar.
Run : api("ChartScrollbar") for more information.}
}
\description{
ChartScrollbarSettings sets settings for chart scrollbar.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method.
If there is no default value specified, default value of ChartScrollbar class will be used.
Run \code{api("ChartScrollbarSettings")} for more informations.
}
\examples{
new("ChartScrollbar", graph = "g1")
new("ChartScrollbar", graph = amGraph(test = 1))
chartScrollbar()
chartScrollbar(enabled = TRUE)
chartScrollbar()
chartScrollbar(enabled = TRUE)
# chartScrollbar with default graph
setGraph(.Object = chartScrollbar())

# example with arguments
setGraph(.Object = chartScrollbar(), id = "graph1", balloonText = "performance")
# equivalent to:
graph_obj <- amGraph(id = "graph1", balloonText = "performance")
(chartScrollbar_obj <- setGraph(.Object = chartScrollbar(), graph = graph_obj))
# or, iff graph_obj has alreadey been added to the chart:
setGraph(.Object = chartScrollbar(), graph = "graph1")
\dontshow{
print(chartScrollbar_obj)
}
# ---
setEnabled(.Object = chartScrollbar(), enabled = TRUE)
}
