% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_StockPanel.R, R/class_StockPanel_setters.R
\docType{methods}
\name{initialize,StockPanel-method}
\alias{addStockGraph}
\alias{addStockGraph,StockPanel,AmGraphOrMissing-method}
\alias{initialize,StockPanel-method}
\alias{panel}
\alias{setDrawOnAxis}
\alias{setDrawOnAxis,StockPanel,ValueAxisOrCharacterOrMissing-method}
\alias{setStockGraphs}
\alias{setStockGraphs,StockPanel,list-method}
\alias{setStockLegend}
\alias{setStockLegend,StockPanel,AmLegendOrMissing-method}
\alias{stockPanel}
\title{Initialize a StockPanel}
\usage{
\S4method{initialize}{StockPanel}(.Object, drawOnAxis, stockGraphs, stockLegend,
  ...)

stockPanel(drawOnAxis, stockGraphs, stockLegend, ...)

panel(drawOnAxis, stockGraphs, stockLegend, ...)

setDrawOnAxis(.Object, valueAxis = NULL, ...)

\S4method{setDrawOnAxis}{StockPanel,ValueAxisOrCharacterOrMissing}(.Object,
  valueAxis = NULL, ...)

setStockGraphs(.Object, stockGraphs)

\S4method{setStockGraphs}{StockPanel,list}(.Object, stockGraphs)

addStockGraph(.Object, stockGraph = NULL, ...)

\S4method{addStockGraph}{StockPanel,AmGraphOrMissing}(.Object,
  stockGraph = NULL, ...)

setStockLegend(.Object, stockLegend = NULL, ...)

\S4method{setStockLegend}{StockPanel,AmLegendOrMissing}(.Object,
  stockLegend = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{StockPanel}.}

\item{drawOnAxis}{\linkS4class{ValueAxis}.
Specifies on which value axis user can draw trend lines.
Set drawingIconsEnabled to true if you want drawing icons to be visible.
First value axis will be used if not set here.
You can use a reference to the value axis object or id of value axis.}

\item{stockGraphs}{\code{list} of \linkS4class{AmGraph}.
Each element must be have been created with stockGraph(*)}

\item{stockLegend}{\code{list} of \linkS4class{AmLegend}.
Each element must be have been created with stockLegend(*)}

\item{...}{other properties of StockPanel.}

\item{valueAxis}{(optional) \linkS4class{ValueAxis}.
Argument for method \code{setDrawOnAxis}.}

\item{stockGraph}{\linkS4class{AmGraph}, created with stockGraph(...).
Argument for method \code{addStockGraph}.}
}
\value{
(updated) \linkS4class{StockPanel} with given properties.
}
\description{
Use the constructor to create the object
or update an existing one with the setters.
}
\examples{
new("StockPanel")
stockPanel()
panel()
valueAxis_obj <- valueAxis(id = "valueAxis1")
setDrawOnAxis(.Object = stockPanel(), valueAxis = valueAxis_obj)
setDrawOnAxis(.Object = stockPanel(), valueAxis = "valueAxis1")
# ---
stockGraphs <- list(stockGraph(comparable = TRUE), stockGraph(comparable = FALSE)) 
setStockGraphs(.Object =  stockPanel(), stockGraphs = stockGraphs)
stockPanel(stockGraphs = stockGraphs)
# ---
addStockGraph(.Object = stockPanel(), comparable = FALSE)
addStockGraph(.Object = stockPanel(), stockGraph = stockGraph(comparable = FALSE))
# ---
setStockLegend(.Object = stockPanel(), valueTextRegular = "[[value]]")
# equivalent to:
stockLegend_obj <- stockLegend(valueTextRegular = "[[value]]")
setStockLegend(.Object = stockPanel(), stockLegend = stockLegend_obj)
# ---
}

