% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmObject.R
\docType{methods}
\name{addListener}
\alias{addListener}
\alias{addListener,AmObject,character,character-method}
\alias{setProperties}
\alias{setProperties,AmObject-method}
\title{Methods of AmObject}
\usage{
addListener(.Object, name, expression)

\S4method{addListener}{AmObject,character,character}(.Object, name, expression)

setProperties(.Object, list, ...)

\S4method{setProperties}{AmObject}(.Object, list, ...)
}
\arguments{
\item{.Object}{\code{\linkS4class{AmObject}}.}

\item{name}{\code{character} containing the name of the listener.}

\item{expression}{\code{character} containing the associated function event.}

\item{list}{(Optional) \code{list} containing properties to set.
The former properties will be overwritten.}

\item{...}{Other properties}
}
\value{
The updated object of class \code{\linkS4class{AmChart}}.
}
\description{
Methods of AmObject
}
\details{
If the property is a class property, it will be overwritten if the attribute is non NULL
}
\examples{
addListener(.Object = amPieChart(),
            name = "clickSlice" ,
            expression = "function(event){ alert('ok !'); }")

addListener(.Object = amLegend(),
            name = "select",
            expression = paste0("function onSelect (properties) {",
                                "alert('selected nodes: ' + properties.nodes);",
                                "}"))
library(pipeR)
# For an AmChart
ls <- list(categoryAxis = list(gridPosition = "start"), test = 1)
amPieChart() \%>>\% setProperties(list = ls) \%>>\% setProperties(fontSize = 15)
}

