% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmStockChart.R
\docType{methods}
\name{initialize,AmStockChart-method}
\alias{addComparedDataSet}
\alias{addComparedDataSet,AmStockChart-method}
\alias{addDataSet}
\alias{addDataSet,AmStockChart-method}
\alias{addPanel}
\alias{addPanel,AmStockChart-method}
\alias{amStockChart}
\alias{initialize,AmStockChart-method}
\alias{setCategoryAxesSettings}
\alias{setCategoryAxesSettings,AmStockChart-method}
\alias{setChartCursorSettings}
\alias{setChartCursorSettings,AmStockChart-method}
\alias{setChartScrollbarSettings}
\alias{setChartScrollbarSettings,AmStockChart-method}
\alias{setComparedDataSets}
\alias{setComparedDataSets,AmStockChart-method}
\alias{setDataSetSelector}
\alias{setDataSetSelector,AmStockChart-method}
\alias{setDataSets}
\alias{setDataSets,AmStockChart-method}
\alias{setLegendSettings}
\alias{setLegendSettings,AmStockChart-method}
\alias{setMainDataSet}
\alias{setMainDataSet,AmStockChart-method}
\alias{setPanels}
\alias{setPanels,AmStockChart,list-method}
\alias{setPanelsSettings}
\alias{setPanelsSettings,AmStockChart-method}
\alias{setPeriodSelector}
\alias{setPeriodSelector,AmStockChart-method}
\alias{setStockEventsSettings}
\alias{setStockEventsSettings,AmStockChart-method}
\alias{setValueAxesSettings}
\alias{setValueAxesSettings,AmStockChart-method}
\title{Initialize an AmStockChart}
\usage{
\S4method{initialize}{AmStockChart}(.Object, categoryAxesSettings,
  chartCursorSettings, chartScrollbarSettings, comparedDataSets, dataSets,
  dataSetSelector, legendSettings, mainDataSet, panels, panelsSettings,
  periodSelector, stockEventsSettings, theme, valueAxesSettings,
  pathToImages = "http://www.amcharts.com/lib/3/images/", ...)

amStockChart(categoryAxesSettings, chartCursorSettings, chartScrollbarSettings,
  comparedDataSets, dataSets, dataSetSelector, legendSettings, mainDataSet,
  panels, panelsSettings, periodSelector, stockEventsSettings, theme,
  valueAxesSettings, ...)

setCategoryAxesSettings(.Object, categoryAxesSettings = NULL, ...)

\S4method{setCategoryAxesSettings}{AmStockChart}(.Object,
  categoryAxesSettings = NULL, ...)

setChartCursorSettings(.Object, chartCursorSettings = NULL, ...)

\S4method{setChartCursorSettings}{AmStockChart}(.Object,
  chartCursorSettings = NULL, ...)

setChartScrollbarSettings(.Object, chartScrollbarSettings = NULL, ...)

\S4method{setChartScrollbarSettings}{AmStockChart}(.Object,
  chartScrollbarSettings = NULL, ...)

setComparedDataSets(.Object, comparedDataSets)

\S4method{setComparedDataSets}{AmStockChart}(.Object, comparedDataSets)

addComparedDataSet(.Object, dataSet = NULL, ...)

\S4method{addComparedDataSet}{AmStockChart}(.Object, dataSet = NULL, ...)

setDataSets(.Object, dataSets)

\S4method{setDataSets}{AmStockChart}(.Object, dataSets)

addDataSet(.Object, dataSet = NULL, ...)

\S4method{addDataSet}{AmStockChart}(.Object, dataSet = NULL, ...)

setDataSetSelector(.Object, ...)

\S4method{setDataSetSelector}{AmStockChart}(.Object, ...)

setLegendSettings(.Object, ...)

\S4method{setLegendSettings}{AmStockChart}(.Object, ...)

setMainDataSet(.Object, dataSet = NULL, ...)

\S4method{setMainDataSet}{AmStockChart}(.Object, dataSet = NULL, ...)

setPanels(.Object, panels)

\S4method{setPanels}{AmStockChart,list}(.Object, panels)

addPanel(.Object, panel = NULL, ...)

\S4method{addPanel}{AmStockChart}(.Object, panel = NULL, ...)

setPanelsSettings(.Object, ...)

\S4method{setPanelsSettings}{AmStockChart}(.Object, ...)

setPeriodSelector(.Object, periodSelector = NULL, ...)

\S4method{setPeriodSelector}{AmStockChart}(.Object, periodSelector = NULL,
  ...)

setStockEventsSettings(.Object, ...)

\S4method{setStockEventsSettings}{AmStockChart}(.Object, ...)

setValueAxesSettings(.Object, valueAxesSettings = NULL, ...)

\S4method{setValueAxesSettings}{AmStockChart}(.Object,
  valueAxesSettings = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{AmStockChart}.}

\item{categoryAxesSettings}{\code{list} of \linkS4class{CategoryAxis}.
CategoryAxesSettings settings set's settings common for all CategoryAxes of StockPanels.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method in order for it to work.
If there is no default value specified, default value of CategoryAxis class will be used.
you should get this axis from the chart and set properties to this object.}

\item{chartCursorSettings}{\code{list} of \linkS4class{ChartCursor}.
ChartCursorSettings settings set's settings for chart cursor.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method in order for it to work.
If there is no default value specified, default value of ChartCursor class will be used.}

\item{chartScrollbarSettings}{\code{list} of \linkS4class{ChartScrollbar}.
ChartScrollbarSettings settings set's settings for chart scrollbar.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method in order for it to work.
If there is no default value specified, default value of ChartScrollbar class will be used.}

\item{comparedDataSets}{\linkS4class{DataSet}. Data sets selected for comparing.}

\item{dataSets}{\code{list} of \linkS4class{DataSet}.}

\item{dataSetSelector}{\code{"list"}. DataSetSelector properties.
You can add it if you have more than one data set and want users to be able to select/compare them.}

\item{legendSettings}{\code{list}. Legend settings.}

\item{mainDataSet}{\code{list}. Data set selected as main.}

\item{panels}{\code{list} of \linkS4class{StockPanel}.}

\item{panelsSettings}{\code{list}. Settings for stock panels.}

\item{periodSelector}{\linkS4class{PeriodSelector}.
You can add it if you want user's to be able to enter
date ranges or zoom chart with predefined period buttons.}

\item{stockEventsSettings}{\code{list}. Settings for stock events.}

\item{theme}{\code{character}}

\item{valueAxesSettings}{\code{list}. Settings for value axes.}

\item{pathToImages}{\code{character}}

\item{...}{Other properties...}

\item{dataSet}{\linkS4class{DataSet}.}

\item{panel}{\linkS4class{StockPanel}.}
}
\value{
An object of class \linkS4class{AmStockChart}.
}
\description{
Method for initializing any S4 class provided by the package.

amStockChart is a shortcut constructor
for instantiating AmChart of type \code{stock}

Setter for PanelsSettings.
}
\section{Functions}{
\itemize{
\item \code{amStockChart}: 
}}
\examples{
new("AmStockChart", theme = "dark")
amStockChart()
setCategoryAxesSettings(.Object = amStockChart(), gridPosition = "start")
setChartCursorSettings(.Object = amStockChart(), oneBallOnly = TRUE)
setChartCursorSettings(.Object = amStockChart(), chartCursorSettings = chartCursor())
\dontrun{
setChartCursorSettings(.Object = amStockChart(), chartCursorSettings = "foo")
}
setChartScrollbarSettings(.Object = amStockChart(), chartScrollbarSettings = chartScrollbar())
library(pipeR)
amStockChart() \%>>\% setComparedDataSets(list(dataSet(compared = TRUE), dataSet(compared = TRUE)))
addComparedDataSet(.Object = amStockChart(), compared = TRUE)
library(pipeR)
amStockChart() \%>>\% setDataSets(list(dataSet(compared = FALSE), dataSet(compared = FALSE)))
library(pipeR)
amStockChart() \%>>\% addDataSet(compared = FALSE) \%>>\% addDataSet(dataSet())
setDataSetSelector(.Object = amStockChart(), width = 180)
setLegendSettings(.Object = amStockChart(), equalWidths = TRUE)
setMainDataSet(.Object = amStockChart(), showInCompare = TRUE)
panels <- list(stockPanel(compared = TRUE), stockPanel(compared = TRUE))
setPanels(.Object = amStockChart(), panels = panels)
addPanel(.Object = amStockChart(), allowTurningOff = TRUE)
setPanelsSettings(.Object = amStockChart(), backgroundAlpha = 0)
setPeriodSelector(.Object = amStockChart(), dateFormat = "DD-MM-YYYY")
setStockEventsSettings(.Object = amStockChart(), backgroundAlpha = 1)
setValueAxesSettings(.Object = amStockChart(), autoGridCount = "TRUE")
}
\seealso{
\code{\linkS4class{AmChart}} S4 class

\code{\linkS4class{CategoryAxis}} S4 class

\code{\linkS4class{ChartCursor}} S4 class

\code{\linkS4class{ChartScrollbar}} S4 class

\code{\linkS4class{DataSet}} S4 class

\code{\linkS4class{DataSet}} S4 class

\code{\linkS4class{DataSet}} S4 class
}

