% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assemble.R
\name{assemble_rtf}
\alias{assemble_rtf}
\title{Assemble Multiple RTF Table Listing and Figure Into One RTF Document}
\usage{
assemble_rtf(input, output, landscape = FALSE)
}
\arguments{
\item{input}{Character vector of file path.}

\item{output}{Character string to the output file path.}

\item{landscape}{Logical value to determine page direction.}
}
\description{
The function assemble multiple RTF table, listing, and figures into
one document as RTF file.
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Read individual RTF files.
    \item Insert into one RTF file.
  }
}
\if{html}{
The contents of this section are shown in PDF user manual only.
}
}

\examples{

library(magrittr)

file <- replicate(2, tempfile(fileext = ".rtf"))
file1 <- head(iris) \%>\% rtf_body() \%>\% rtf_encode() \%>\% write_rtf(file[1])
file2 <- head(cars) \%>\% rtf_page(orientation = "landscape") \%>\%
              rtf_body() \%>\% rtf_encode() \%>\% write_rtf(file[2])
output <- tempfile(fileext = ".rtf")

assemble_rtf(
  input = file,
  output = output
)

}
