/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RStringVector;

public abstract class RVector<E>
extends RExp
implements Iterable<E> {
    public RVector(RPair attributes) {
        super(attributes);
    }

    public abstract DataType getDataType();

    public abstract int size();

    public abstract E getValue(int var1);

    public abstract List<E> getValues();

    @Override
    public Iterator<E> iterator() {
        List<E> values = this.getValues();
        return values.iterator();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void checkSize(int size) {
        List<E> values = this.getValues();
        if (values.size() != size) {
            throw new IllegalArgumentException("Expected " + size + " element(s), got " + values.size() + " element(s)");
        }
    }

    public void checkMinSize(int size) {
        List<E> values = this.getValues();
        if (values.size() < size) {
            throw new IllegalArgumentException("Expected " + size + " or more element(s), got " + values.size() + " element(s)");
        }
    }

    public E asScalar() {
        List<E> values = this.getValues();
        if (values.size() != 1) {
            throw new IllegalStateException();
        }
        return values.get(0);
    }

    public int indexOf(E value) {
        List<E> values = this.getValues();
        return values.indexOf(value);
    }

    public E getElement(String name) {
        return this.getElement(name, true);
    }

    public E getElement(String name, boolean required) {
        return this.findElement(name, required);
    }

    public boolean hasElement(String name) {
        if (this.isEmpty()) {
            return false;
        }
        RStringVector names = this.names();
        List<String> values = names.getDequotedValues();
        int index = values.indexOf(name);
        return index > -1;
    }

    private E findElement(String name, boolean required) {
        if (this.isEmpty()) {
            return null;
        }
        RStringVector names = this.names();
        List<String> values = names.getDequotedValues();
        int index = values.indexOf(name);
        if (index > -1) {
            return this.getValue(index);
        }
        if (required) {
            throw new IllegalArgumentException("Missing '" + name + "' element");
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getValues());
    }
}

