% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteractionClassification.R
\name{InteractionClassification}
\alias{InteractionClassification}
\title{Interaction Classification for Viral Load and CD4 Differences}
\usage{
InteractionClassification(vl_diff, cd_diff, k = 4, ns = 100, seed = 123)
}
\arguments{
\item{vl_diff}{A numeric vector of viral load differences.}

\item{cd_diff}{A numeric vector of CD4 count differences.}

\item{k}{An integer specifying the number of clusters (default is 4).}

\item{ns}{An integer specifying the number of random starts for the
k-means algorithm (default is 100).}

\item{seed}{An integer seed for reproducibility of the clustering
results (default is 123).}
}
\value{
An S3 object of class \code{InteractionClassification}, containing:
\item{data}{A data frame with the original differences and their
corresponding cluster classifications.}
\item{kmeans_result}{The result of the k-means clustering, including
cluster centers and within-cluster sum of squares.}
\item{centers}{A matrix of the cluster centers.}
\item{k}{The number of clusters used in the clustering.}
}
\description{
This function performs k-means clustering on viral load and CD4 count
differences to classify interactions into distinct groups. It returns
an S3 object containing the clustering results and means for each
cluster.
}
\examples{
data(vl_3)
data(cd_3)
interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)
}
