% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frame.R
\name{data_frame_of}
\alias{data_frame_of}
\title{Data frame generator with randomized columns}
\usage{
data_frame_of(..., rows = c(1L, 10L), cols = c(1L, 10L))
}
\arguments{
\item{...}{A set of unnamed generators. The generated data frames will be
built with random combinations of these generators.}

\item{rows}{Number of rows of the generated data frame.
If \code{rows} is a single number all data frames will have
this number of rows. If \code{rows} is a numeric vector of
length 2 it will produce data frames with rows between
a minimum and maximum, inclusive. For example
\code{rows = c(1L, 10L)} would produce data frames with rows
between 1 and 10. To produce empty tibbles set \code{rows = 0L}
or a range like \code{rows = c(0L, 10L)}.}

\item{cols}{Number of columns of the generated data frame.
If \code{cols} is a single number all data frames will have
this number of columns. If \code{cols} is a numeric vector
of length 2 it will produce data frames with columns
between a minimum and maximum, inclusive. For example
\code{cols = c(1L, 10L)} would produce data frames with
columns between 1 and 10. To produce empty tibbles
set \code{cols = 0L} or a range like \code{cols = c(0L, 10L)}.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Data frame generator with randomized columns
}
\examples{
data_frame_of(logical_(), date_()) \%>\% show_example()
data_frame_of(any_atomic(), rows = 10L, cols = 5L) \%>\% show_example()
}
