% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{as_hedgehog}
\alias{as_hedgehog}
\title{Convert a quickcheck generator to a hedgehog generator}
\usage{
as_hedgehog(generator)
}
\arguments{
\item{generator}{A \code{quickcheck_generator} object.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Convert a quickcheck generator to a hedgehog generator
}
\examples{
is_even <-
  function(a) a \%\% 2L == 0L
gen_powers_of_two <-
  integer_bounded(1L, 10L, len = 1L) \%>\%
    as_hedgehog() \%>\%
    hedgehog::gen.with(function(a) 2 ^ a)
for_all(
  a = from_hedgehog(gen_powers_of_two),
  property = function(a) is_even(a) \%>\% testthat::expect_true()
)
}
