% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate_view.R
\name{plate_view}
\alias{plate_view}
\title{Real-Time Plate View}
\usage{
plate_view(df, meta, plate = 96)
}
\arguments{
\item{df}{Real-time dataframe}

\item{meta}{Dataframe containing well IDs and Sample IDs to title each facet.}

\item{plate}{Integer either 96 or 384 to denote microplate type.}
}
\value{
A ggplot object
}
\description{
Converts the real-time data into a ggplot figure. The layout is either 8x12
or 16x24 for 96- and 384-well plates, respectively.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
"extdata/input_files",
file = "test.xlsx",
package = "quicR"
)

tab <- organize_tables(file)
IDs <- quicR::convert_tables(tab)[["Sample IDs"]] |>
na.omit()

# Get the real-time data.
df_ <- get_real(file, ordered = FALSE)[[1]]

# Set the time column as the df index.
rownames(df_) <- df_[, 1]

# Remove the time column and ID row.
df_ <- df_[, -1]

# Get the wells used in the run.
wells <- get_wells(file)

# Take the metadata and apply it into a dataframe for the plate_view function.
sample_locations <- cbind(wells, IDs) |>
  stats::na.omit()

# Wrap the text if it is too long.
sample_locations <- sample_locations |>
  dplyr::mutate(IDs = ifelse(stringr::str_length(IDs) > 12, gsub(" ", "\n", IDs), IDs))

# Make the plate view figure.
plate_view(df_, sample_locations, plate = 96)
}


}
