% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{prop}
\alias{prop}
\alias{prop_table}
\alias{prop.data.frame}
\alias{prop.matrix}
\alias{prop.tabyl}
\title{Global percentages of a cross-tabulation table (2 dimensions or more).}
\usage{
prop(tab, ...)

prop_table(
  tab,
  digits = 1,
  total = TRUE,
  percent = FALSE,
  drop = TRUE,
  n = FALSE,
  ...
)

\method{prop}{data.frame}(
  tab,
  digits = 1,
  total = TRUE,
  percent = FALSE,
  drop = TRUE,
  n = FALSE,
  ...
)

\method{prop}{matrix}(
  tab,
  digits = 1,
  total = TRUE,
  percent = FALSE,
  drop = TRUE,
  n = FALSE,
  ...
)

\method{prop}{tabyl}(tab, digits = 1, total = TRUE, percent = FALSE, n = FALSE, ...)
}
\arguments{
\item{tab}{frequency table}

\item{...}{parameters passed to other methods}

\item{digits}{number of digits to display}

\item{total}{if \code{TRUE}, add a column with the sum of percentages and a row with global percentages}

\item{percent}{if \code{TRUE}, add a percent sign after the values when printing}

\item{drop}{if \code{TRUE}, lines or columns with a sum of zero, which would generate \code{NaN} percentages, are dropped. Unused for tables of 3 dimensions or more (always `FALSE`).}

\item{n}{if \code{TRUE}, display number of observations per row and per column.}
}
\value{
The result is an object of class \code{table} and \code{proptab}.
}
\description{
Return the percentages of a cross-tabulation table (2 dimensions or more) with formatting and printing options.
}
\examples{
## Sample table
data(Titanic)
tab <- apply(Titanic, c(1,4), sum)
## Percentages
prop(tab)
## Percentages with custom display
prop(tab, digits=2, percent=TRUE, total=FALSE, n=TRUE)
## Could be applied to a table of 3 dimensions or more
prop(Titanic)
}
\seealso{
\code{\link[questionr]{rprop}}, \code{\link[questionr]{cprop}}, \code{\link{table}}, \code{\link{prop.table}}
}
