% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{revalid}
\alias{revalid}
\title{Recode Invalid Values from a Vector}
\usage{
revalid(x, valid, undefined = NA)
}
\arguments{
\item{x}{atomic vector.}

\item{valid}{atomic vector of valid values for \code{x}.}

\item{undefined}{atomic vector of length 1 specifying what the invalid values
should be recoded to.}
}
\value{
atomic vector with the same typeof as \code{x} where any values not
  present in \code{valid} have been recoded to \code{undefined}.
}
\description{
\code{revalid} recodes invalid data to specified values. For example,
sometimes invalid values are present in a vector of data (e.g., age = -1).
This function allows you to specify which values are possible and will then
recode any impossible values to \code{undefined}. This function is a useful
wrapper for the function \code{car::recode}, tailored for the specific use of
recoding invalid values.
}
\examples{
revalid(x = attitude[[1]], valid = 25:75, undefined = NA) # numeric vector
revalid(x = as.character(ToothGrowth[["supp"]]), valid = c('VC'),
   undefined = NA) # character vector
revalid(x = ToothGrowth[["supp"]], valid = c('VC'),
   undefined = NA) # factor
}
\seealso{
\code{\link{revalids}}
   \code{\link{valid_test}}
   \code{\link{valids_test}}
}
