% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{mean_compare}
\alias{mean_compare}
\title{Mean differences for a single variable across 3+ independent groups (one-way
ANOVA)}
\usage{
mean_compare(
  x,
  nom,
  lvl = levels(as.factor(nom)),
  var.equal = TRUE,
  r2.ci.type = "Fdist",
  ci.level = 0.95,
  rtn.table = TRUE,
  check = TRUE
)
}
\arguments{
\item{x}{numeric vector.}

\item{nom}{atomic vector (e.g., factor) the same length as \code{x} that is a
nominal variable. It identifies the 3+ groups with 3+ unique values (other
than missing values).}

\item{lvl}{character vector with length 3+ specifying the unique values for
the 3+ groups. If \code{nom} is a factor, then \code{lvl} should be the
factor levels rather than the underlying integer codes. This argument
allows you to specify the order of the descriptive statistics in the return
object, which will be opposite the order of \code{lvl} for consistency with
\code{\link{mean_diff}} and \code{\link{mean_change}}.}

\item{var.equal}{logical vector of length 1 specifying whether the variances
of the groups are assumed to be equal (TRUE) or not (FALSE). If TRUE, a
traditional one-way ANOVA is computed; if FALSE, Welch's ANOVA is computed.
These two tests differ by their denominator degrees of freedom, F-value,
and p-value.}

\item{r2.ci.type}{character vector with length 1 specifying the type of
confidence intervals to compute for the variance explained (i.e., R^2 aka
eta^2). There are currently two options: 1) "Fdist" which calculates a
non-symmetrical confidence interval based on the non-central F distribution
(pg. 38, Smithson, 2003), 2) "classic" which calculates the confidence
interval based on a large-sample theory standard error (eq. 3.6.3 in Cohen,
Cohen, West, & Aiken, 2003), which is taken from Olkin & Finn (1995) - just
above eq. 10. The confidence intervals for R^2-adjusted use the same
formula as R^2, but replace R^2 with R^2 adjusted. Technically, the R^2
adjusted confidence intervals can have poor coverage (pg. 54, Smithson,
2003)}

\item{ci.level}{numeric vector of length 1 specifying the confidence level.
\code{ci.level} must range from 0 to 1.}

\item{rtn.table}{logical vector of length 1 specifying whether the traditional
ANOVA table should be returned as the last element of the return object.}

\item{check}{logical vector of length 1 specifying whether the input
arguments should be checked for errors. For example, if \code{nom} has
length different than the length of \code{x}. This is a tradeoff between
computational efficiency (FALSE) and more useful error messages (TRUE).}
}
\value{
list of numeric vectors containing statistical information about the
  mean comparison: 1) nhst = one-way ANOVA stat info in a numeric vector,
  2) desc = descriptive statistics stat info in a numeric vector,
  3) std = standardized effect sizes stat info in a numeric vector,
  4) anova = traditional ANOVA table in a numeric matrix (only returned
  if rtn.table = TRUE).

1) nhst = one-way ANOVA stat info in a numeric vector

\describe{
   \item{diff_avg}{average mean difference across group pairs}
   \item{se}{NA to remind the user there is no standard error for the average mean difference}
   \item{F}{F-value}
   \item{df_num}{numerator degrees of freedom}
   \item{df_den}{denominator degrees of freedom}
   \item{p}{two-sided p-value}
}

2) desc = descriptive statistics stat info in a numeric vector (note there
could be more than 3 groups - groups i, j, and k are just provided as an example)

\describe{
   \item{mean_`lvl[k]`}{mean of group k}
   \item{mean_`lvl[j]`}{mean of group j}
   \item{mean_`lvl[i]`}{mean of group i}
   \item{sd_`lvl[k]`}{standard deviation of group k}
   \item{sd_`lvl[j]`}{standard deviation of group j}
   \item{sd_`lvl[i]`}{standard deviation of group i}
   \item{n_`lvl[k]`}{sample size of group k}
   \item{n_`lvl[j]`}{sample size of group j}
   \item{n_`lvl[i]`}{sample size of group i}
}

3) std = standardized effect sizes stat info in a numeric vector

\describe{
   \item{r2_reg_est}{R^2 estimate}
   \item{r2_reg_se}{R^2 standard error (only available if \code{r2.ci.type} = "classic")}
   \item{r2_reg_lwr}{R^2 lower bound of the confidence interval}
   \item{r2_reg_upr}{R^2 upper bound of the confidence interval}
   \item{r2_adj_est}{R^2-adjusted estimate}
   \item{r2_adj_se}{R^2-adjusted standard error (only available if \code{r2.ci.type} = "classic")}
   \item{r2_adj_lwr}{R^2-adjusted lower bound of the confidence interval}
   \item{r2_adj_upr}{R^2-adjusted upper bound of the confidence interval}
}

4) anova = traditional ANOVA table in a numeric matrix (only returned
if rtn.table = TRUE).

The dimlabels of the matrix was "effect" for the rows
and "info" for the columns. There are two rows with rownames 1. "nom" and 2.
"Residuals" where "nom" refers to the between-group effect of the nominal
variable and "Residuals" refers to the within-group residual errors. There
are 5 columns with colnames 1. "SS" = sum of squares, 2. "df" = degrees of
freedom, 3. "MS" = mean squares, 4. "F" = F-value. and 5. "p" = p-value. Note
the F-value and p-value will differ from the "nhst" returned vector if
\code{var.equal} = FALSE because the traditional ANOVA table always assumes
variances are equal (i.e. \code{var.equal} = TRUE).
}
\description{
\code{mean_compare} compares means across 3+ independent groups with a
one-way ANOVA. The function also calculates the descriptive statistics for
each group and the variance explained (i.e., R^2 aka eta^2) by the nominal
grouping variable. \code{mean_compare} is simply a wrapper for
\code{\link[stats]{oneway.test}} plus some extra calculations.
\code{mean_compare} will work with 2 independent groups; however it arguably
makes more sense to use \code{\link{mean_diff}} in that case.
}
\examples{

mean_compare(x = mtcars$"mpg", nom = mtcars$"gear")
mean_compare(x = mtcars$"mpg", nom = mtcars$"gear", var.equal = FALSE)
mean_compare(x = mtcars$"mpg", nom = mtcars$"gear", rtn.table = FALSE)
mean_compare(x = mtcars$"mpg", nom = mtcars$"gear", r2.ci.type = "classic")

}
\references{
Cohen, J., Cohen, P., West, A. G., & Aiken, L. S. (2003). Applied Multiple
   Regression/Correlation Analysis for the Behavioral Science - third edition.
   New York, NY: Routledge.

   Olkin, I., & Finn, J. D. (1995). Correlations redux. Psychological Bulletin, 118(1), 155-164.

   Smithson, M. (2003). Confidence intervals. Thousand Oaks, CA: Sage Publications.
}
\seealso{
\code{\link[stats]{oneway.test}} the workhorse for \code{mean_compare},
   \code{\link{means_compare}} for multiple variables across the same 3+ groups,
   \code{\link[MBESS]{ci.R2}} for confidence intervals of the variance explained,
   \code{\link{mean_diff}} for a single variable across only 2 groups,
}
