% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_references.R
\name{column_references}
\alias{column_references}
\title{Return the column references in a parsed SQL query}
\usage{
column_references(tree, from = TRUE)
}
\arguments{
\item{tree}{a list returned by \code{\link{parse_query}} containing named
elements representing the clauses of a SQL \code{SELECT} statement}

\item{from}{a logical value indicating whether to include the column
references from the join conditions in the \code{FROM} clause}
}
\value{
A character vector containing all the unique column references found
  in the \code{SELECT}, \code{FROM} (if \code{from = TRUE}), \code{WHERE},
  \code{GROUP BY}, \code{HAVING}, and \code{ORDER BY} clauses of the
  \code{SELECT} statement
}
\description{
Returns a character vector containing all the column references
  in the clauses of a parsed SQL \code{SELECT} statement
}
\details{
The returned character vector includes only \emph{column}
  references, not table references. Column aliases assigned in the
  \code{SELECT} list are not included unless they are used in other clauses.
}
\examples{
my_query <- "SELECT f.flight,
    manufacturer, p.model
  FROM flights f
    JOIN planes p USING (tailnum);"

column_references(parse_query(my_query), from = FALSE)
}
\seealso{
\code{\link{parse_query}}
}
