% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-projects.R
\name{find_project_root}
\alias{find_project_root}
\title{Find the root of a Quarto project}
\usage{
find_project_root(path = ".")
}
\arguments{
\item{path}{Character. Path to check for Quarto project files. Defaults to
current working directory.}
}
\value{
Character Path of the project root directory if found, or \code{NULL}
}
\description{
This function checks if the current working directory is within a Quarto
project by looking for Quarto project files (\verb{_quarto.yml} or \verb{_quarto.yaml}).
Unlike \code{\link[=get_running_project_root]{get_running_project_root()}}, this works both during rendering and
interactive sessions.
}
\examples{
\dontshow{if (quarto_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tmpdir <- tempfile()
dir.create(tmpdir)
find_project_root(tmpdir)
quarto_create_project("test-proj", type = "blog", dir = tmpdir, no_prompt = TRUE, quiet = TRUE)
blog_post_dir <- file.path(tmpdir, "test-proj", "posts", "welcome")
find_project_root(blog_post_dir)

xfun::in_dir(blog_post_dir, {
  # Check if current directory is a Quarto project or in one
  !is.null(find_project_root())
})

# clean up
unlink(tmpdir, recursive = TRUE)

\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_running_project_root]{get_running_project_root()}} for detecting active Quarto rendering
}
