% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagEstimator.R
\docType{methods}
\name{getValues-LagEstimator}
\alias{getValues,LagEstimator-method}
\alias{getValues-LagEstimator}
\title{Get values from a lag-window type estimator.}
\usage{
\S4method{getValues}{LagEstimator}(object, frequencies = 2 * pi *
  (0:(length(object@Y) - 1))/length(object@Y), levels.1 = getLevels(object,
  1), levels.2 = getLevels(object, 2))
}
\arguments{
\item{object}{\code{LagEstimator} of which to get the values}

\item{frequencies}{a vector of frequencies for which to get the values}

\item{levels.1}{the first vector of levels for which to get the values}

\item{levels.2}{the second vector of levels for which to get the values}
}
\value{
Returns data from the array \code{values} that's a slot of
         \code{object}.
}
\description{
The returned array of \code{values} is of dimension \code{[J,K1,K2]},
where \code{J=length(frequencies)}, \code{K1=length(levels.1)} and
\code{K2=length(levels.2))}. At position \code{(j,k1,k2)}
the returned value is the one corresponding to \code{frequencies[j]},
\code{levels.1[k1]} and \code{levels.2[k2]} that are closest to the
\code{frequencies}, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\seealso{
An example on how to use this function is analogously to the example given in
\code{\link{getValues-QuantilePG}}.
}
\keyword{Access-functions}

