% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-IntegrQuantileSD.R
\docType{methods}
\name{getValues-IntegrQuantileSD}
\alias{getValues,IntegrQuantileSD-method}
\alias{getValues-IntegrQuantileSD}
\title{Get values from a simulated integrated quantile spectral density kernel}
\usage{
\S4method{getValues}{IntegrQuantileSD}(object, frequencies = 2 * pi *
  (0:(getN(object@qsd) - 1))/getN(object@qsd), levels.1 = getLevels(object,
  1), levels.2 = getLevels(object, 2))
}
\arguments{
\item{object}{\code{IntegrQuantileSD} of which to get the values}

\item{frequencies}{a vector of frequencies for which to get the values}

\item{levels.1}{the first vector of levels for which to get the values}

\item{levels.2}{the second vector of levels for which to get the values}
}
\value{
Returns data from the array \code{values} that's a slot of
         \code{object}.
}
\description{
If none of the optional parameters is specified then the values are returned
for all Fourier frequencies in \eqn{[0,2\pi)}{[0,2pi)} (base given by slot
\code{N}) and all levels available. The frequencies and levels can be freely
specified. The returned array then has, at position \code{(j,k1,k2,b)},
the value corresponding to the \code{frequencies[j]},
\code{levels.1[k1]} and \code{levels.2[k2]} that are closest to the
\code{frequencies}, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\seealso{
For examples on how to use this function go to \code{\link{IntegrQuantileSD}}.
}
\keyword{Access-functions}

