% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{cbind.quantities}
\alias{cbind.quantities}
\alias{rbind.quantities}
\title{Combine R Objects by Rows or Columns}
\usage{
\method{cbind}{quantities}(..., deparse.level = 1)

\method{rbind}{quantities}(..., deparse.level = 1)
}
\arguments{
\item{...}{(generalized) vectors or matrices.  These can be given as named
    arguments.  Other \R objects may be coerced as appropriate, or S4
    methods may be used: see sections \sQuote{Details} and
    \sQuote{Value}.  (For the \code{"data.frame"} method of \code{cbind}
    these can be further arguments to \code{\link[base]{data.frame}} such as
    \code{stringsAsFactors}.)}

\item{deparse.level}{integer controlling the construction of labels in
    the case of non-matrix-like arguments (for the default method):\cr
    \code{deparse.level = 0} constructs no labels; the default,\cr
    \code{deparse.level = 1 or 2} constructs labels from the argument
    names, see the \sQuote{Value} section below.}
}
\description{
S3 methods for \code{quantities} objects (see \code{\link[base]{cbind}}).
}
\examples{
x <- set_quantities(1, m/s, 0.1)
y <- set_quantities(1:3, m/s, 0.2)
z <- set_quantities(8:10, m/s, 0.1)
(m <- cbind(x, y)) # the '1' (= shorter vector) is recycled
(m <- cbind(m, z)[, c(1, 3, 2)]) # insert a column
(m <- rbind(m, z)) # insert a row

}
\seealso{
\code{\link{c.quantities}}
}
