% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic.R
\name{kwic}
\alias{kwic}
\alias{is.kwic}
\alias{as.tokens.kwic}
\title{locate keywords-in-context}
\usage{
kwic(x, pattern, window = 5, valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, join = FALSE, ...)

is.kwic(x)

\method{as.tokens}{kwic}(x, ...)
}
\arguments{
\item{x}{a character, \link{corpus}, or \link{tokens} object}

\item{pattern}{a character vector, list of character vectors, \link{dictionary},
\link{collocations}, or \link{dfm}. See \link{pattern} for details.}

\item{window}{the number of context words to be displayed around the keyword.}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{match without respect to case if \code{TRUE}}

\item{join}{join adjacent keywords in the concordance view if \code{TRUE}}

\item{...}{additional arguments passed to \link{tokens}, for applicable 
object types}
}
\value{
A \code{kwic} classed data.frame, with the document name 
  (\code{docname}), the token index positions (\code{from} and \code{to}, 
  which will be the same for single-word patterns, or a sequence equal in 
  length to the number of elements for multi-word phrases), the context 
  before (\code{pre}), the keyword in its original format (\code{keyword}, 
  preserving case and attached punctuation), and the context after 
  (\code{post}).  The return object has its own \code{print} method, plus
  some special attributes that are hidden in the print view.  If you want to
  turn this into a simple data.frame, simply wrap the result in
  \code{data.frame}.

\code{as.tokens.kwic} converts the kwic object into a \link{tokens}
  object, with each new "document" consisting of one keyword match, and the
  contents of the \code{pre}, \code{keyword}, and \code{post} fields forming
  the tokens.  This is one way to save the output for subsequent usage;
  another way is to form a \link[=corpus.kwic]{corpus} from the return
  object.
}
\description{
For a text or a collection of texts (in a quanteda corpus object), return a 
list of a keyword supplied by the user in its immediate context, identifying 
the source text and the word index number within the source text.  (Not the 
line number, since the text may or may not be segmented using end-of-line 
delimiters.)
}
\note{
\code{pattern} will be a keyword pattern or phrase, possibly multiple 
  patterns, that may include punctuation.  If a pattern contains whitespace, 
  it is best to wrap it in \code{\link{phrase}} to make this explicit. 
  However if \code{pattern} is a \link[=textstat_collocations]{collocations} 
  or \link{dictionary} object, then the collocations or multi-word dictionary
  keys will automatically be considered phrases where each 
  whitespace-separated element matches a token in sequence.
}
\examples{
head(kwic(data_corpus_inaugural, "secure*", window = 3, valuetype = "glob"))
head(kwic(data_corpus_inaugural, "secur", window = 3, valuetype = "regex"))
head(kwic(data_corpus_inaugural, "security", window = 3, valuetype = "fixed"))

toks <- tokens(data_corpus_inaugural)
kwic(data_corpus_inaugural, phrase("war against"))
kwic(data_corpus_inaugural, phrase("war against"), valuetype = "regex")

mykwic <- kwic(data_corpus_inaugural, "provident*")
is.kwic(mykwic)
is.kwic("Not a kwic")
}
\author{
Kenneth Benoit and Kohei Watanabe
}
