% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel-NB.R
\name{predict.textmodel_NB_fitted}
\alias{predict.textmodel_NB_fitted}
\title{prediction method for Naive Bayes classifier objects}
\usage{
\method{predict}{textmodel_NB_fitted}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a fitted Naive Bayes textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{...}{not used}
}
\value{
A list of two data frames, named \code{docs} and \code{words} corresponding
to word- and document-level predicted quantities

\item{docs}{data frame with document-level predictive quantities: 
nb.predicted, ws.predicted, bs.predicted, PcGw, wordscore.doc, bayesscore.doc, 
posterior.diff, posterior.logdiff.  Note that the diff quantities are currently 
implemented only for two-class solutions.}

\item{words}{data-frame with word-level predictive quantities: 
wordscore.word, bayesscore.word}
}
\description{
implements class predictions using trained Naive Bayes examples
}
\examples{
(nbfit <- textmodel_NB(LBGexample, c("A", "A", "B", "C", "C", NA)))
(nbpred <- predict(nbfit))
}
\author{
Kenneth Benoit
}

