% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatures.R
\name{removeFeatures}
\alias{removeFeatures}
\title{remove features from an object}
\usage{
removeFeatures(x, features, ...)
}
\arguments{
\item{x}{object from which stopwords will be removed}

\item{features}{character vector of features to remove}

\item{...}{additional arguments passed to \code{\link{selectFeatures}}}
}
\value{
an object with matching features removed
}
\description{
Removes features from a variety of objects, such as text, a
dfm, or a list of collocations.  The most common usage for
\code{removeFeatures} will be to eliminate stop words from a text or
text-based object.  This function simply provides a convenience wrapper for
\code{\link{selectFeatures}} where \code{selection = "remove"}.
}
\examples{
## for tokenized texts 
txt <- c(wash1 <- "Fellow citizens, I am again called upon by the voice of my country to 
                   execute the functions of its Chief Magistrate.",
         wash2 <- "When the occasion proper for it shall arrive, I shall endeavor to express
                   the high sense I entertain of this distinguished honor.")
removeFeatures(tokenize(txt, removePunct = TRUE), stopwords("english"))

itText <- tokenize("Ecco alcuni di testo contenente le parole che vogliamo rimuovere.", 
                   removePunct = TRUE)
removeFeatures(itText, stopwords("italian"), case_insensitive = TRUE)

## example for dfm objects
mydfm <- dfm(ukimmigTexts, verbose=FALSE)
removeFeatures(mydfm, stopwords("english"))

## example for collocations
(myCollocs <- collocations(inaugTexts[1:3], n=20))
removeFeatures(myCollocs, stopwords("english"))
removeFeatures(myCollocs, stopwords("english"), pos = 2)
}
\author{
Kenneth Benoit
}
\seealso{
\link{stopwords}
}

