% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/textmodel-wordscores.R
\docType{methods}
\name{textmodel_wordscores}
\alias{predict.textmodel_wordscores_fitted}
\alias{print.textmodel_wordscores_fitted}
\alias{print.textmodel_wordscores_predicted}
\alias{show,textmodel_wordscores_fitted-method}
\alias{show,textmodel_wordscores_predicted-method}
\alias{textmodel_wordscores}
\title{Wordscores text model}
\usage{
textmodel_wordscores(data, scores, scale = c("linear", "logit"), smooth = 0)

\method{predict}{textmodel_wordscores_fitted}(object, newdata = NULL,
  rescaling = "none", level = 0.95, verbose = TRUE, ...)

\method{print}{textmodel_wordscores_fitted}(x, n = 30L, digits = 2, ...)

\S4method{show}{textmodel_wordscores_fitted}(object)

\S4method{show}{textmodel_wordscores_predicted}(object)

\method{print}{textmodel_wordscores_predicted}(x, ...)
}
\arguments{
\item{data}{the dfm on which the model will be fit.  Does not need to contain
only the training documents, since the index of these will be matched
automatically.}

\item{scores}{vector of training scores associated with each document
identified in \code{refData}}

\item{scale}{classic LBG linear posterior weighted word class differences, or
logit scale of log posterior differences}

\item{smooth}{a smoothing parameter for word counts; defaults to zero for the
to match the LBG (2003) method.}

\item{object}{the fitted wordscores textmodel on which prediction will be
made}

\item{newdata}{dfm on which prediction should be made}

\item{rescaling}{\code{none} for "raw" scores; \code{lbg} for LBG (2003)
rescaling; or \code{mv} for the rescaling proposed by Martin and Vanberg
(2007).  (Note to authors: Provide full details here in documentation.)}

\item{level}{probability level for confidence interval width}

\item{verbose}{If \code{TRUE}, output status messages}

\item{...}{additional arguments passed to other functions}

\item{x}{for print method, the object to be printed}

\item{n}{max rows of dfm to print}

\item{digits}{number of decimal places to print for print methods}
}
\value{
The \code{predict} method for a wordscores fitted object returns a
  data.frame whose rows are the documents fitted and whose columns contain
  the scored textvalues, with the number of columns depending on the options
  called (for instance, how many rescaled scores, and whether standard errors
  were requested.)  (Note: We may very well change this soon so that it is a
  list similar to other existing fitted objects.)
}
\description{
\code{textmodel_wordscores} implements Laver, Benoit and Garry's (2003)
wordscores method for scaling of a single dimension.  This can be called
directly, but the recommended method is through \code{\link{textmodel}}.
}
\details{
Fitting a \code{textmodel_wordscores} results in an object of class
\code{textmodel_wordscores_fitted} containing the
following slots:
}
\section{Slots}{

\describe{
\item{\code{scale}}{\code{linear} or \code{logit}, according to the value of \code{scale}}

\item{\code{Sw}}{the scores computed for each word in the training set}

\item{\code{x}}{the dfm on which the wordscores model was called}

\item{\code{y}}{the reference scores}

\item{\code{call}}{the function call that fitted the model}

\item{\code{method}}{takes a value of \code{wordscores} for this model}
}}
\examples{
(ws <- textmodel(LBGexample, c(seq(-1.5, 1.5, .75), NA), model="wordscores"))
predict(ws)
predict(ws, rescaling="mv")
predict(ws, rescaling="lbg")

# same as:
(ws2 <- textmodel_wordscores(LBGexample, c(seq(-1.5, 1.5, .75), NA)))
predict(ws2)
}
\author{
Kenneth Benoit
}
\references{
Laver, Michael, Kenneth R Benoit, and John Garry. 2003.
"Extracting Policy Positions From Political Texts Using Words as Data."
American Political Science Review 97(02): 311-31

Beauchamp, N. 2012. "Using Text to Scale Legislatures with Uninformative
Voting." New York University Mimeo.

Martin, L W, and G Vanberg. 2007. "A
Robust Transformation Procedure for Interpreting Political Text." Political
Analysis 16(1): 93-100.

Laver, Michael, Kenneth R Benoit, and John Garry. 2003.
"Extracting Policy Positions From Political Texts Using Words as Data."
\emph{American Political Science Review} 97(02): 311-31.

Martin, L W, and G Vanberg. 2007. "A Robust Transformation Procedure for
Interpreting Political Text." \emph{Political Analysis} 16(1): 93-100.
}

