% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadmesh.r
\name{quadmesh}
\alias{quadmesh}
\title{Create a quad-type mesh for use in rgl}
\usage{
quadmesh(x, z = x, na.rm = FALSE)
}
\arguments{
\item{x}{raster object for mesh structure}

\item{z}{raster object for height values}

\item{na.rm}{remove quads where missing values?}
}
\value{
mesh3d
}
\description{
Convert a \code{\link[raster]{raster}} to a \code{\link[rgl]{mesh3d}} quadrangle mesh.
}
\examples{
library(raster)
data(volcano)
r <- setExtent(raster(volcano), extent(0, 100, 0, 200))
qm <- quadmesh(r)
}

