% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_genes.R
\name{ggplot_genes}
\alias{ggplot_genes}
\alias{autoplot.genes}
\title{Plot gene locations for a genomic interval}
\usage{
ggplot_genes(
  genes,
  xlim = NULL,
  minrow = 4,
  padding = 0.2,
  colors = c("black", "red3", "green4", "blue3", "orange"),
  ...
)

\method{autoplot}{genes}(x, ...)
}
\arguments{
\item{genes}{Data frame containing \code{start} and \code{stop} in
bp, \code{strand} (as \code{"-"}, \code{"+"}, or \code{NA}), and
\code{Name}.}

\item{xlim}{x-axis limits (in Mbp)}

\item{minrow}{Minimum number of rows of genes}

\item{padding}{Proportion to pad with white space around the genes}

\item{colors}{Vectors of colors, used sequentially and then re-used.}

\item{...}{Optional arguments passed to \code{\link[graphics]{plot}}.}

\item{x}{Object of class \code{genes}}
}
\value{
None.
}
\description{
Plot gene locations for a genomic interval, as rectangles with gene
symbol (and arrow indicating strand/direction) below.
}
\examples{
genes <- data.frame(chr = c("6", "6", "6", "6", "6", "6", "6", "6"),
                    start = c(139.988753, 140.680185, 141.708118, 142.234227, 142.587862,
                              143.232344, 144.398099, 144.993835),
                    stop  = c(140.041457, 140.826797, 141.773810, 142.322981, 142.702315,
                              143.260627, 144.399821, 145.076184),
                    strand = c("-", "+", "-", "-", "-", NA, "+", "-"),
                    Name = c("Plcz1", "Gm30215", "Gm5724", "Slco1a5", "Abcc9",
                             "4930407I02Rik", "Gm31777", "Bcat1"),
                    stringsAsFactors=FALSE)
ggplot_genes(genes, xlim=c(140, 146))
}
\keyword{hgraphics}
