% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_serialize}
\alias{qd_serialize}
\title{qd_serialize}
\usage{
qd_serialize(object,
         compress_level = qopt("compress_level"),
         shuffle = qopt("shuffle"),
         warn_unsupported_types = qopt("warn_unsupported_types"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{object}{The object to save.}

\item{compress_level}{The compression level used (the initial value is 3L).

The maximum and minimum possible values depend on the version of the ZSTD library used.
As of ZSTD 1.5.6 the maximum compression level is 22, and the minimum is -131072.
Usually, values in the low positive range offer very good performance in terms
of speed and compression.}

\item{shuffle}{Whether to allow byte shuffling when compressing data (the initial value is TRUE).}

\item{warn_unsupported_types}{Whether to warn when saving an object with an unsupported type (the initial value is TRUE).}

\item{nthreads}{The number of threads to use when compressing data (the initial value is 1L). When TBB is not available, values greater than 1 emit a warning and fall back to 1.}
}
\value{
The serialized object as a raw vector.
}
\description{
Serializes an object to a raw vector using the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
xserialized <- qd_serialize(x)
x2 <- qd_deserialize(xserialized)
identical(x, x2) # returns TRUE
}
