% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-run-algorithm.R
\name{qgis_run_algorithm}
\alias{qgis_run_algorithm}
\title{Run an algorithm using 'qgis_process'}
\usage{
qgis_run_algorithm(
  algorithm,
  ...,
  PROJECT_PATH = NULL,
  ELLIPSOID = NULL,
  .raw_json_input = NULL,
  .quiet = TRUE
)
}
\arguments{
\item{algorithm}{A qualified algorithm name (e.g., \code{"native:buffer"}) or
a path to a QGIS model file.}

\item{...}{Named key-value pairs as arguments for the algorithm. Features of
\code{\link[rlang:list2]{rlang::list2()}} are supported. These arguments
are converted to strings using \code{\link[=as_qgis_argument]{as_qgis_argument()}}.}

\item{PROJECT_PATH, ELLIPSOID}{Global values for QGIS project file and
ellipsoid name for distance calculations.}

\item{.raw_json_input}{The raw JSON to use as input in place of \code{...}.}

\item{.quiet}{Use \code{FALSE} to get extra output from 'qgis_process'.
This can be useful in debugging.}
}
\value{
A \code{qgis_result} object.
}
\description{
Runs an algorithm using 'qgis_process'.
See the \href{https://docs.qgis.org/latest/en/docs/user_manual/processing_algs/}{QGIS docs}
for a detailed description of the algorithms provided
'out of the box' on QGIS.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_run_algorithm(
  "native:buffer",
  INPUT = system.file("longlake/longlake_depth.gpkg", package = "qgisprocess"),
  DISTANCE = 10
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions to run one geoprocessing algorithm: 
\code{\link{qgis_run_algorithm_p}()}
}
\concept{functions to run one geoprocessing algorithm}
